/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStreamWriterWrapper
implements XMLStreamWriter {
    protected static Logger log = LoggerFactory.getLogger(XMLStreamWriterWrapper.class);
    XMLStreamWriter underlying;
    JaxbXmlPart part;

    public XMLStreamWriterWrapper(JaxbXmlPart part, XMLStreamWriter underlying) {
        this.part = part;
        this.underlying = underlying;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.underlying.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.underlying.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.underlying.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.underlying.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.underlying.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.underlying.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.underlying.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.underlying.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.underlying.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.underlying.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.underlying.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.underlying.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.underlying.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (namespaceURI == null) {
            log.debug("Dropping null for prefix '" + prefix + "'");
        } else if (namespaceURI.trim().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping empty for prefix '" + prefix + "'");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Writing {}={}", (Object)prefix, (Object)namespaceURI);
            }
            this.underlying.writeNamespace(prefix, namespaceURI);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (namespaceURI == null) {
            log.debug("Dropping null ");
        } else if (namespaceURI.trim().isEmpty()) {
            log.debug("Dropping empty ");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Writing {}", (Object)namespaceURI);
            }
            this.underlying.writeDefaultNamespace(namespaceURI);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.underlying.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.underlying.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.underlying.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.underlying.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.underlying.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.underlying.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        log.debug("writeStartDocument ");
        this.writeStartDocument("UTF-8", "1.0");
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        log.debug("writeStartDocument " + version);
        this.writeStartDocument("UTF-8", version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        log.debug("writeStartDocument " + encoding);
        this.underlying.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.underlying.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.underlying.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.underlying.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.underlying.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.underlying.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.underlying.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.underlying.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.underlying.getProperty(name);
    }
}

