/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;
import org.docx4j.org.apache.xerces.util.EncodingMap;
import org.merlin.io.OutputEngine;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DOMSerializerEngine
implements OutputEngine {
    private NodeIterator iterator;
    private String encoding;
    private OutputStreamWriter writer;
    private boolean elementOpened;
    private LinkedList elements = new LinkedList();

    public DOMSerializerEngine(Node root) {
        this(root, "UTF-8");
    }

    public DOMSerializerEngine(Node root, String encoding) {
        this(DOMSerializerEngine.getIterator(root), encoding);
    }

    private static NodeIterator getIterator(Node node) {
        DocumentTraversal dt = (DocumentTraversal)((Object)(node instanceof DocumentTraversal ? node : node.getOwnerDocument()));
        return dt.createNodeIterator(node, -1, null, false);
    }

    public DOMSerializerEngine(NodeIterator iterator, String encoding) {
        this.iterator = iterator;
        this.encoding = encoding;
    }

    @Override
    public void initialize(OutputStream out) throws IOException {
        if (this.writer != null) {
            throw new IOException("Already initialized");
        }
        this.writer = new OutputStreamWriter(out, this.encoding);
    }

    @Override
    public void execute() throws IOException {
        if (this.writer == null) {
            throw new IOException("Not yet initialized");
        }
        Node node = this.iterator.nextNode();
        this.closeElements(node);
        if (node == null) {
            this.writer.close();
        } else {
            this.writeNode(node);
            this.writer.flush();
        }
    }

    @Override
    public void finish() throws IOException {
    }

    private void closeElements(Node node) throws IOException {
        Node prev;
        Node node2 = prev = node == null ? null : node.getPreviousSibling();
        if (node == null && !this.elements.isEmpty() || prev != null && prev.getNodeType() == 1) {
            Node next;
            Iterator i = this.elements.iterator();
            do {
                next = (Node)i.next();
                i.remove();
                if (this.elementOpened) {
                    this.writer.write(" />");
                    this.elementOpened = false;
                    continue;
                }
                this.writer.write("</" + next.getNodeName() + ">");
            } while (i.hasNext() && next != prev);
        } else if (this.elementOpened && node.getNodeType() != 2) {
            this.writer.write(">");
            this.elementOpened = false;
        }
    }

    private void writeNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                String javaEncoding = this.writer.getEncoding();
                String ianaEncoding = EncodingMap.getJava2IANAMapping(javaEncoding);
                this.writer.write("<?xml version=\"1.0\" encoding=\"" + ianaEncoding + "\"?>\n");
                break;
            }
            case 11: {
                break;
            }
            case 10: {
                String internalSubset;
                DocumentType dt = (DocumentType)node;
                this.writer.write("<!DOCTYPE " + dt.getName());
                String systemID = dt.getSystemId();
                if (systemID != null) {
                    String publicID = dt.getPublicId();
                    if (publicID != null) {
                        this.writer.write(" PUBLIC '" + publicID + "' '");
                    } else {
                        this.writer.write(" SYSTEM '");
                    }
                    this.writer.write(systemID + "'");
                }
                if ((internalSubset = dt.getInternalSubset()) != null) {
                    this.writer.write(" [\n" + internalSubset + "]");
                }
                this.writer.write(">\n");
                break;
            }
            case 1: {
                this.writer.write("<" + node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.writeNode(attributes.item(i));
                }
                this.elementOpened = true;
                this.elements.addFirst(node);
                break;
            }
            case 2: {
                this.writer.write(" " + node.getNodeName() + "=\"" + DOMSerializerEngine.escape(node.getNodeValue()) + "\"");
                break;
            }
            case 3: {
                this.writer.write(DOMSerializerEngine.escape(node.getNodeValue()));
                break;
            }
            case 4: {
                this.writer.write("<![CDATA[" + node.getNodeValue() + "]]>");
                break;
            }
            case 8: {
                this.writer.write("<!--" + DOMSerializerEngine.escape(node.getNodeValue()) + "-->");
                break;
            }
            case 7: {
                this.writer.write("<?" + node.getNodeName());
                String value = node.getNodeValue();
                if (value != null && value.length() > 0) {
                    this.writer.write(" " + value);
                }
                this.writer.write("?>");
                break;
            }
            case 5: {
                this.writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 6: {
                throw new IOException("Cannot serialize entity node");
            }
            case 12: {
                throw new IOException("Cannot serialize notation node");
            }
        }
    }

    private static String escape(String value) {
        StringBuffer buffer = new StringBuffer();
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

