/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.merlin.io.OutputEngine;

public class ReaderWriterEngine
implements OutputEngine {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Reader reader;
    private String encoding;
    private char[] buffer;
    private Writer writer;

    public ReaderWriterEngine(Reader in, String encoding) {
        this(in, encoding, 8192);
    }

    public ReaderWriterEngine(Reader reader, String encoding, int bufferSize) {
        this.reader = reader;
        this.encoding = encoding;
        this.buffer = new char[bufferSize];
    }

    @Override
    public void initialize(OutputStream out) throws IOException {
        if (this.writer != null) {
            throw new IOException("Already initialized");
        }
        this.writer = new OutputStreamWriter(out, this.encoding);
    }

    @Override
    public void execute() throws IOException {
        if (this.writer == null) {
            throw new IOException("Not yet initialized");
        }
        int amount = this.reader.read(this.buffer);
        if (amount < 0) {
            this.writer.close();
        } else {
            this.writer.write(this.buffer, 0, amount);
        }
    }

    @Override
    public void finish() throws IOException {
        this.reader.close();
    }
}

