/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractSimpleWriter;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModel;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModelCell;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.table.AbstractBorder;
import org.docx4j.model.properties.table.BorderBottom;
import org.docx4j.model.properties.table.BorderLeft;
import org.docx4j.model.properties.table.BorderRight;
import org.docx4j.model.properties.table.BorderTop;
import org.docx4j.model.properties.table.CellMarginBottom;
import org.docx4j.model.properties.table.CellMarginLeft;
import org.docx4j.model.properties.table.CellMarginRight;
import org.docx4j.model.properties.table.CellMarginTop;
import org.docx4j.model.properties.table.tc.Shading;
import org.docx4j.model.properties.table.tc.TextAlignmentVertical;
import org.docx4j.model.properties.table.tr.TrCantSplit;
import org.docx4j.model.properties.table.tr.TrHeight;
import org.docx4j.model.table.TableModelCell;
import org.docx4j.model.table.TableModelRow;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblPrEx;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STShd;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractTableWriter
extends AbstractSimpleWriter {
    private static Logger log = LoggerFactory.getLogger(AbstractTableWriter.class);
    public static final String WRITER_ID = "w:tbl";
    protected static final int NODE_TABLE = 0;
    protected static final int NODE_TABLE_COLUMN_GROUP = 1;
    protected static final int NODE_TABLE_COLUMN = 2;
    protected static final int NODE_TABLE_HEADER = 3;
    protected static final int NODE_TABLE_HEADER_ROW = 4;
    protected static final int NODE_TABLE_HEADER_CELL = 5;
    protected static final int NODE_TABLE_BODY = 6;
    protected static final int NODE_TABLE_BODY_ROW = 7;
    protected static final int NODE_TABLE_BODY_CELL = 8;
    protected static final Map<String, Integer> PATTERN_PERCENTAGES = new TreeMap<String, Integer>();

    protected AbstractTableWriter() {
        super(WRITER_ID);
    }

    @Override
    public Writer.TransformState createTransformState() {
        return new TableModelTransformState();
    }

    @Override
    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node content, Writer.TransformState transformState, Document doc) throws TransformerException {
        Node ret = null;
        AbstractTableWriterModel table = new AbstractTableWriterModel();
        table.build(context, unmarshalledNode, content);
        if (log.isDebugEnabled()) {
            log.debug("Table asXML:\n" + table.debugStr());
        }
        if (!table.getRows().isEmpty()) {
            ret = this.toNode(context, table, transformState, doc);
        }
        return ret;
    }

    protected Node toNode(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Document doc) throws TransformerException {
        DocumentFragment docfrag = doc.createDocumentFragment();
        Element tableRoot = this.createNode(doc, null, 0);
        ArrayList<Property> rowProperties = new ArrayList<Property>();
        int rowPropertiesTableSize = -1;
        ArrayList<Property> cellProperties = new ArrayList<Property>();
        int cellPropertiesTableSize = -1;
        int cellPropertiesRowSize = -1;
        boolean inHeader = table.getHeaderMaxRow() > -1;
        TableModelRow rowModel = null;
        Element rowContainer = null;
        Element row = null;
        Element cellNode = null;
        this.createRowProperties(rowProperties, table.getEffectiveTableStyle().getTrPr(), true);
        rowPropertiesTableSize = rowProperties.size();
        this.createCellProperties(cellProperties, table.getEffectiveTableStyle().getTrPr());
        this.createCellProperties(cellProperties, table.getEffectiveTableStyle().getTcPr());
        this.createCellProperties(cellProperties, table.getEffectiveTableStyle().getTblPr());
        cellPropertiesTableSize = cellProperties.size();
        docfrag.appendChild(tableRoot);
        this.applyTableStyles(context, table, transformState, tableRoot);
        this.createColumns(context, table, transformState, doc, tableRoot);
        rowContainer = this.createNode(doc, tableRoot, inHeader ? 3 : 6);
        tableRoot.appendChild(rowContainer);
        this.applyTableRowContainerCustomAttributes(context, table, transformState, rowContainer, inHeader);
        for (int rowIndex = 0; rowIndex < table.getRows().size(); ++rowIndex) {
            rowModel = table.getRows().get(rowIndex);
            if (inHeader && rowIndex > table.getHeaderMaxRow()) {
                rowContainer = this.createNode(doc, tableRoot, 6);
                tableRoot.appendChild(rowContainer);
                inHeader = false;
                this.applyTableRowContainerCustomAttributes(context, table, transformState, rowContainer, inHeader);
            }
            row = this.createNode(doc, rowContainer, inHeader ? 4 : 7);
            TrPr trPr = rowModel.getRowProperties();
            CTTblPrEx tblPrEx = rowModel.getRowPropertiesExceptions();
            this.createRowProperties(rowProperties, trPr, false);
            this.processAttributes(context, rowProperties, row);
            this.applyTableRowCustomAttributes(context, table, transformState, row, rowIndex, inHeader);
            this.createCellProperties(cellProperties, trPr);
            this.createCellProperties(cellProperties, tblPrEx);
            cellPropertiesRowSize = cellProperties.size();
            for (TableModelCell cell : rowModel.getRowContents()) {
                if (cell.isDummy()) {
                    if (cell.isVMerged() || !cell.isDummyBefore() && !cell.isDummyAfter()) continue;
                    cellNode = this.createNode(doc, row, inHeader ? 5 : 8);
                    row.appendChild(cellNode);
                    this.applyTableCellCustomAttributes(context, table, transformState, cell, cellNode, inHeader, true);
                    continue;
                }
                cellNode = this.createNode(doc, row, inHeader ? 5 : 8);
                row.appendChild(cellNode);
                this.createCellProperties(cellProperties, cell.getTcPr());
                this.processAttributes(context, cellProperties, cellNode);
                this.applyTableCellCustomAttributes(context, table, transformState, cell, cellNode, inHeader, false);
                this.resetProperties(cellProperties, cellPropertiesRowSize);
                if (((AbstractTableWriterModelCell)cell).getContent() == null) {
                    log.warn("model cell had no contents!");
                    continue;
                }
                log.debug("copying cell contents..");
                cellNode = this.interposeBlockContainer(doc, cellNode, cell.getTcPr());
                XmlUtils.treeCopy(((AbstractTableWriterModelCell)cell).getContent().getChildNodes(), (Node)cellNode);
            }
            this.resetProperties(cellProperties, cellPropertiesTableSize);
            this.resetProperties(rowProperties, rowPropertiesTableSize);
        }
        return docfrag;
    }

    protected Element interposeBlockContainer(Document doc, Element cellNode, TcPr tcPr) {
        return cellNode;
    }

    protected Element createNode(Document doc, Element parent, int nodeType) {
        Element ret = this.createNode(doc, nodeType);
        if (ret != null && parent != null) {
            parent.appendChild(ret);
        }
        return ret != null ? ret : parent;
    }

    protected void createColumns(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Document doc, Element tableRoot) throws DOMException {
        List<TblGridCol> gridCols = table.getTblGrid() != null ? table.getTblGrid().getGridCol() : null;
        Element columnGroup = this.createNode(doc, tableRoot, 1);
        Element column = null;
        this.applyColumnGroupCustomAttributes(context, table, transformState, columnGroup);
        if (gridCols != null && !gridCols.isEmpty()) {
            for (int i = 0; i < gridCols.size(); ++i) {
                column = this.createNode(doc, columnGroup, 2);
                this.applyColumnCustomAttributes(context, table, transformState, column, i, gridCols.get(i).getW().intValue());
            }
        } else {
            for (int i = 0; i < table.getColCount(); ++i) {
                column = this.createNode(doc, columnGroup, 2);
                this.applyColumnCustomAttributes(context, table, transformState, column, i, -1);
            }
        }
    }

    protected void applyTableStyles(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element tableRoot) {
        List<Property> tableProperties = null;
        if (table.getEffectiveTableStyle().getTblPr() == null) {
            log.warn("table.getEffectiveTableStyle().getTblPr() is null, but should never be");
            return;
        }
        tableProperties = PropertyFactory.createProperties(table.getEffectiveTableStyle().getTblPr());
        if (table.getEffectiveTableStyle().getTcPr() != null) {
            PropertyFactory.createPropertiesTable(tableProperties, table.getEffectiveTableStyle().getTcPr());
        }
        if (table.getEffectiveTableStyle().getTcPr() == null || table.getEffectiveTableStyle().getTcPr().getVAlign() == null) {
            tableProperties.add(new TextAlignmentVertical());
        }
        if (!table.isDrawTableBorders()) {
            for (int i = tableProperties.size() - 1; i >= 0; --i) {
                if (!(tableProperties.get(i) instanceof Shading) && !(tableProperties.get(i) instanceof AbstractBorder)) continue;
                tableProperties.remove(i);
            }
            this.appendNoneBordersAndShading(tableProperties);
        }
        this.processAttributes(context, tableProperties, tableRoot);
        this.applyTableCustomAttributes(context, table, transformState, tableRoot);
    }

    protected void appendNoneBordersAndShading(List<Property> tableProperties) {
        CTBorder ctBrdr = null;
        CTShd shd = Context.getWmlObjectFactory().createCTShd();
        ctBrdr = Context.getWmlObjectFactory().createCTBorder();
        ctBrdr.setVal(STBorder.NONE);
        tableProperties.add(new BorderLeft(ctBrdr));
        ctBrdr = Context.getWmlObjectFactory().createCTBorder();
        ctBrdr.setVal(STBorder.NONE);
        tableProperties.add(new BorderRight(ctBrdr));
        ctBrdr = Context.getWmlObjectFactory().createCTBorder();
        ctBrdr.setVal(STBorder.NONE);
        tableProperties.add(new BorderTop(ctBrdr));
        ctBrdr = Context.getWmlObjectFactory().createCTBorder();
        ctBrdr.setVal(STBorder.NONE);
        tableProperties.add(new BorderBottom(ctBrdr));
        shd.setColor("auto");
        shd.setFill("auto");
        shd.setVal(STShd.CLEAR);
        tableProperties.add(new Shading(shd));
    }

    protected void createRowProperties(List<Property> properties, TrPr trPr, boolean includeDefaultHeight) {
        BooleanDefaultTrue val;
        JAXBElement<?> cantSplit;
        JAXBElement<?> trHeight;
        JAXBElement<?> jAXBElement = trHeight = trPr != null ? this.getElement(trPr.getCnfStyleOrDivIdOrGridBefore(), "trHeight") : null;
        if (trHeight != null) {
            properties.add(new TrHeight((CTHeight)trHeight.getValue()));
        }
        if (trPr != null && (cantSplit = XmlUtils.getListItemByQName(trPr.getCnfStyleOrDivIdOrGridBefore(), new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "cantSplit"))) != null && (val = (BooleanDefaultTrue)XmlUtils.unwrap(cantSplit)).isVal()) {
            properties.add(new TrCantSplit(cantSplit));
        }
    }

    protected void createCellProperties(List<Property> properties, TrPr trPr) {
    }

    protected void createCellProperties(List<Property> properties, CTTblPrBase tblPr) {
        if (tblPr == null) {
            log.warn("table.getEffectiveTableStyle().getTblPr() is null, but should never be");
            return;
        }
        TblBorders tblBorders = tblPr.getTblBorders();
        CTTblCellMar tblCellMargin = tblPr.getTblCellMar();
        if (tblBorders != null) {
            if (tblBorders.getInsideH() != null) {
                properties.add(new BorderTop(tblBorders.getTop()));
                properties.add(new BorderBottom(tblBorders.getBottom()));
            }
            if (tblBorders.getInsideV() != null) {
                properties.add(new BorderRight(tblBorders.getRight()));
                properties.add(new BorderLeft(tblBorders.getLeft()));
            }
        }
        if (tblCellMargin != null) {
            if (tblCellMargin.getTop() != null) {
                properties.add(new CellMarginTop(tblCellMargin.getTop()));
            }
            if (tblCellMargin.getBottom() != null) {
                properties.add(new CellMarginBottom(tblCellMargin.getBottom()));
            }
            if (tblCellMargin.getLeft() != null) {
                properties.add(new CellMarginLeft(tblCellMargin.getLeft()));
            }
            if (tblCellMargin.getRight() != null) {
                properties.add(new CellMarginRight(tblCellMargin.getRight()));
            }
        }
    }

    protected void createCellProperties(List<Property> properties, TcPr tcPr) {
        if (tcPr != null) {
            PropertyFactory.createProperties(properties, tcPr);
        }
    }

    protected void createCellProperties(List<Property> properties, CTTblPrEx tblPrEx) {
    }

    protected JAXBElement<?> getElement(List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore, String localName) {
        JAXBElement<?> element = null;
        if (cnfStyleOrDivIdOrGridBefore != null && !cnfStyleOrDivIdOrGridBefore.isEmpty()) {
            for (int i = 0; i < cnfStyleOrDivIdOrGridBefore.size(); ++i) {
                element = cnfStyleOrDivIdOrGridBefore.get(i);
                if (!localName.equals(element.getName().getLocalPart())) continue;
                return element;
            }
        }
        return null;
    }

    protected void processAttributes(AbstractWmlConversionContext context, List<Property> properties, Element element) {
        CTShd shd = null;
        int bgColor = 0xFFFFFF;
        int fgColor = 0;
        int pctPattern = -1;
        for (int i = 0; i < properties.size(); ++i) {
            if (!(properties.get(i) instanceof Shading)) continue;
            shd = (CTShd)properties.get(i).getObject();
            fgColor = this.extractColor(shd.getColor(), 0);
            if (shd.getVal() != null && "clear".equals(shd.getVal().value()) && "auto".equals(shd.getFill())) {
                bgColor = 0xFFFFFF;
                pctPattern = -2;
                continue;
            }
            pctPattern = shd.getVal() != null ? this.extractPattern(shd.getVal().value()) : -1;
            bgColor = this.extractColor(shd.getFill(), bgColor);
        }
        if (pctPattern == -1) {
            this.applyAttributes(context, properties, element);
        } else {
            properties.add(this.createShading(fgColor, bgColor, pctPattern));
            this.applyAttributes(context, properties, element);
            properties.remove(properties.size() - 1);
        }
    }

    protected int extractPattern(String pattern) {
        return pattern != null && PATTERN_PERCENTAGES.containsKey(pattern) ? PATTERN_PERCENTAGES.get(pattern) : -1;
    }

    protected int extractColor(String value, int defaultColor) {
        int ret = defaultColor;
        if (value != null && !"auto".equals(value)) {
            try {
                ret = Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    protected Property createShading(int fgColor, int bgColor, int pctFg) {
        CTShd shd = null;
        int resColor = UnitsOfMeasurement.combineColors(fgColor, bgColor, pctFg);
        shd = Context.getWmlObjectFactory().createCTShd();
        shd.setVal(STShd.CLEAR);
        shd.setFill(this.calcHexColor(resColor));
        return new Shading(shd);
    }

    protected String calcHexColor(int value) {
        String ret = Integer.toHexString(value).toUpperCase();
        return ret.length() < 6 ? "000000".substring(0, 6 - ret.length()) + ret : ret;
    }

    protected void resetProperties(List<Property> properties, int size) {
        while (properties.size() > size) {
            properties.remove(properties.size() - 1);
        }
    }

    protected abstract Element createNode(Document var1, int var2);

    protected abstract void applyAttributes(AbstractWmlConversionContext var1, List<Property> var2, Element var3);

    protected void applyTableCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element tableRoot) {
    }

    protected void applyColumnGroupCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element columnGroup) {
    }

    protected void applyColumnCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element column, int columnIndex, int columnWidth) {
    }

    protected void applyTableRowContainerCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element rowContainer, boolean isHeader) {
    }

    protected void applyTableRowCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element row, int rowIndex, boolean isHeader) {
    }

    protected void applyTableCellCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, TableModelCell tableCell, Element cellNode, boolean isHeader, boolean isDummyCell) {
    }

    static {
        PATTERN_PERCENTAGES.put("diagCross", 50);
        PATTERN_PERCENTAGES.put("horzCross", 50);
        PATTERN_PERCENTAGES.put("thinDiagCross", 25);
        PATTERN_PERCENTAGES.put("thinHorzCross", 25);
        PATTERN_PERCENTAGES.put("pct5", 5);
        PATTERN_PERCENTAGES.put("pct10", 10);
        PATTERN_PERCENTAGES.put("pct12", 12);
        PATTERN_PERCENTAGES.put("pct15", 15);
        PATTERN_PERCENTAGES.put("pct20", 20);
        PATTERN_PERCENTAGES.put("pct25", 25);
        PATTERN_PERCENTAGES.put("pct30", 30);
        PATTERN_PERCENTAGES.put("pct35", 35);
        PATTERN_PERCENTAGES.put("pct37", 37);
        PATTERN_PERCENTAGES.put("pct40", 40);
        PATTERN_PERCENTAGES.put("pct45", 45);
        PATTERN_PERCENTAGES.put("pct50", 50);
        PATTERN_PERCENTAGES.put("pct55", 55);
        PATTERN_PERCENTAGES.put("pct60", 60);
        PATTERN_PERCENTAGES.put("pct62", 62);
        PATTERN_PERCENTAGES.put("pct65", 65);
        PATTERN_PERCENTAGES.put("pct70", 70);
        PATTERN_PERCENTAGES.put("pct75", 75);
        PATTERN_PERCENTAGES.put("pct80", 80);
        PATTERN_PERCENTAGES.put("pct85", 85);
        PATTERN_PERCENTAGES.put("pct87", 87);
        PATTERN_PERCENTAGES.put("pct90", 90);
        PATTERN_PERCENTAGES.put("pct95", 95);
        PATTERN_PERCENTAGES.put("solid", 100);
    }

    protected static class TableModelTransformState
    implements Writer.TransformState {
        int idx = 0;

        protected TableModelTransformState() {
        }

        public int getIdx() {
            return this.idx;
        }

        public void incrementIdx() {
            ++this.idx;
        }
    }
}

