/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.xmlgraphics.util.ClasspathResource;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontAdder;
import org.docx4j.fonts.fop.fonts.FontDetector;
import org.docx4j.fonts.fop.fonts.FontEventListener;
import org.docx4j.fonts.fop.fonts.FontManager;
import org.docx4j.fonts.fop.fonts.autodetect.FontFileFinder;
import org.docx4j.fonts.fop.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontDetectorFactory {
    private FontDetectorFactory() {
    }

    public static FontDetector createDefault() {
        return new DefaultFontDetector();
    }

    public static FontDetector createDisabled() {
        return new DisabledFontDetector();
    }

    private static class DefaultFontDetector
    implements FontDetector {
        private static Logger log = LoggerFactory.getLogger(DefaultFontDetector.class);
        private static final String[] FONT_MIMETYPES = new String[]{"application/x-font", "application/x-font-truetype"};

        private DefaultFontDetector() {
        }

        @Override
        public void detect(FontManager fontManager, FontAdder fontAdder, boolean strict, FontEventListener eventListener, List<EmbedFontInfo> fontInfoList) throws FOPException {
            try {
                FontFileFinder fontFileFinder = new FontFileFinder(eventListener);
                URI fontBaseURI = fontManager.getResourceResolver().getBaseURI();
                File fontBase = FileUtils.toFile(fontBaseURI.toURL());
                if (fontBase != null) {
                    List<URL> fontURLList = fontFileFinder.find(fontBase.getAbsolutePath());
                    fontAdder.add(fontURLList, fontInfoList);
                }
                List<URL> systemFontList = fontFileFinder.find();
                fontAdder.add(systemFontList, fontInfoList);
                ClasspathResource resource = ClasspathResource.getInstance();
                for (String mimeTypes : FONT_MIMETYPES) {
                    fontAdder.add(resource.listResourcesOfMimeType(mimeTypes), fontInfoList);
                }
            }
            catch (IOException e) {
                LogUtil.handleException(log, e, strict);
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(log, use, strict);
            }
        }
    }

    private static class DisabledFontDetector
    implements FontDetector {
        private DisabledFontDetector() {
        }

        @Override
        public void detect(FontManager fontManager, FontAdder fontAdder, boolean strict, FontEventListener eventListener, List<EmbedFontInfo> fontInfoList) throws FOPException {
        }
    }
}

