/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.math.BigInteger;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.BindingTraverserXSLT;
import org.docx4j.model.datastorage.ValueInserterPlainTextImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class ValueInserterPlainTextForOpenAPI3
extends ValueInserterPlainTextImpl {
    private static Logger log = LoggerFactory.getLogger(ValueInserterPlainTextForOpenAPI3.class);
    private static final String COMPONENT_SCHEMAS = "local-name(/yaml/components[1]/schemas[1]/";

    @Override
    public DocumentFragment toOpenXml(Xpaths.Xpath.DataBinding dataBinding, RPr rPr, boolean multiLine, BindingTraverserXSLT.BookmarkCounter bookmarkCounter, String val, JaxbXmlPart sourcePart) throws Docx4JException {
        try {
            if (val == null || val.equals("")) {
                return BindingTraverserXSLT.createPlaceholder(rPr, "p");
            }
        }
        catch (Exception e) {
            throw new Docx4JException(e.getMessage(), e);
        }
        String bookmarkName = this.getBookmarkName(dataBinding.getXpath(), val);
        if (bookmarkName == null) {
            return super.toOpenXml(dataBinding, rPr, multiLine, bookmarkCounter, val, sourcePart);
        }
        Document docContainer = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = docContainer.createDocumentFragment();
        int id = bookmarkCounter.bookmarkId.get();
        this.addBookmarkStart(bookmarkName, id, docfrag);
        this.addRun(val, docfrag);
        this.addBookmarkEnd(id, docfrag);
        bookmarkCounter.bookmarkId.getAndIncrement();
        return docfrag;
    }

    private void addRun(String val, DocumentFragment docfrag) {
        R r = new R();
        Text t = new Text();
        t.setValue(val);
        r.getContent().add(t);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(r);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private void addBookmarkStart(String bookmarkName, int id, DocumentFragment docfrag) {
        CTBookmark bookmark = Context.getWmlObjectFactory().createCTBookmark();
        JAXBElement<CTBookmark> bookmarkWrapped = Context.getWmlObjectFactory().createPBookmarkStart(bookmark);
        bookmark.setName(bookmarkName);
        bookmark.setId(BigInteger.valueOf(id));
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(bookmark);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private void addBookmarkEnd(int id, DocumentFragment docfrag) {
        CTMarkupRange markuprange = Context.getWmlObjectFactory().createCTMarkupRange();
        markuprange.setId(BigInteger.valueOf(id));
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(markuprange);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private String getBookmarkName(String xpath, String val) {
        String substring;
        if (xpath.startsWith(COMPONENT_SCHEMAS) && (substring = xpath.substring(COMPONENT_SCHEMAS.length())).length() > 0 && !substring.contains("/")) {
            return "components_schemas_" + val;
        }
        return null;
    }

    @Override
    protected void addHyperlinkToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String url) throws Docx4JException {
        if (url.startsWith("http") || url.startsWith("mailto")) {
            super.addHyperlinkToDocFrag(sourcePart, docfrag, url);
        } else {
            String bookmarkName = this.refToBookmarkName(url);
            try {
                Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(BindingHandler.getHyperlinkResolver().generateHyperlink(bookmarkName, url));
                XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
            }
            catch (JAXBException e) {
                throw new Docx4JException(e.getMessage(), e);
            }
        }
    }

    private String refToBookmarkName(String ref) {
        return ref.substring(2).replace("/", "_");
    }
}

