/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.table.tr;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.model.properties.table.tr.AbstractTrProperty;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.STHeightRule;
import org.docx4j.wml.TrPr;
import org.w3c.dom.Element;

public class TrHeight
extends AbstractTrProperty {
    public static final String CSS_NAME = "height";
    public static final String FO_NAME = "height";
    protected static final BigInteger DEFAULT_TWIPS_HEIGHT = BigInteger.valueOf(UnitsOfMeasurement.mmToTwip(5.0f));
    protected static final QName TRHEIGHT_NAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "trHeight");

    public TrHeight() {
        CTHeight defHeight = new CTHeight();
        defHeight.setVal(DEFAULT_TWIPS_HEIGHT);
        defHeight.setHRule(STHeightRule.AT_LEAST);
        this.setObject(defHeight);
    }

    public TrHeight(CTHeight val) {
        this.setObject(val);
    }

    @Override
    public void set(TrPr trPr) {
        JAXBElement<CTHeight> jbHeight = null;
        CTHeight ctHeight = (CTHeight)this.getObject();
        if (ctHeight != null && ctHeight.getVal() != null) {
            jbHeight = new JAXBElement<CTHeight>(TRHEIGHT_NAME, CTHeight.class, (CTHeight)this.getObject());
            JAXBElement<?> existing = XmlUtils.getListItemByQName(trPr.getCnfStyleOrDivIdOrGridBefore(), jbHeight.getName());
            if (existing == null) {
                trPr.getCnfStyleOrDivIdOrGridBefore().add(jbHeight);
            } else {
                trPr.getCnfStyleOrDivIdOrGridBefore().remove(existing);
                trPr.getCnfStyleOrDivIdOrGridBefore().add(jbHeight);
            }
        }
    }

    @Override
    public String getCssProperty() {
        String ret = null;
        CTHeight ctHeight = (CTHeight)this.getObject();
        if (ctHeight != null && ctHeight.getVal() != null) {
            ret = TrHeight.composeCss(this.getCssName(), UnitsOfMeasurement.twipToBest(ctHeight.getVal().intValue()));
        }
        return ret;
    }

    @Override
    public String getCssName() {
        return "height";
    }

    @Override
    public void setXslFO(Element foElement) {
        CTHeight ctHeight = (CTHeight)this.getObject();
        if (ctHeight != null && ctHeight.getVal() != null) {
            foElement.setAttribute("height", UnitsOfMeasurement.twipToBest(ctHeight.getVal().intValue()));
        }
    }
}

