/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.org.apache.xpath.CachedXPathAPI;
import org.docx4j.org.apache.xpath.XPathException;
import org.docx4j.org.apache.xpath.objects.XObject;
import org.docx4j.utils.XPathFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public abstract class XmlPart
extends Part {
    protected static Logger log = LoggerFactory.getLogger(XmlPart.class);
    protected Document doc;
    private static XPath xPath = XPathFactoryUtil.newXPath();
    private NamespacePrefixMappings nsContext;
    private CachedXPathAPI cachedXPathAPI = null;
    private String cachedPrefixMappings = null;

    public XmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public XmlPart() throws InvalidFormatException {
    }

    private NamespacePrefixMappings getNamespaceContext() {
        if (this.nsContext == null) {
            this.nsContext = new NamespacePrefixMappings();
            xPath.setNamespaceContext(this.nsContext);
        }
        return this.nsContext;
    }

    public void setDocument(InputStream is) throws Docx4JException {
        try {
            DocumentBuilder documentBuilder = XmlUtils.getNewDocumentBuilder();
            this.doc = documentBuilder.parse(is);
        }
        catch (Exception e) {
            throw new Docx4JException("Problems parsing InputStream for part " + this.getPartName().getName(), e);
        }
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public abstract Document getDocument() throws Docx4JException;

    public String getXML() throws Docx4JException {
        return XmlUtils.w3CDomNodeToString(this.getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String xpathGetString(String xpathString, String prefixMappings) throws Docx4JException {
        try {
            String result;
            XPath xPath = XmlPart.xPath;
            synchronized (xPath) {
                this.getNamespaceContext();
                NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
                result = XmlPart.xPath.evaluate(xpathString, this.doc);
            }
            if (result.equals("") && log.isWarnEnabled()) {
                NodeList nl = (NodeList)XmlPart.xPath.evaluate(xpathString, this.doc, XPathConstants.NODESET);
                if (nl.getLength() == 0) {
                    log.warn("No match for " + xpathString + " so result is empty string");
                } else {
                    log.debug(xpathString + " ---> '" + result + "'");
                }
            } else {
                log.debug(xpathString + " ---> '" + result + "'");
            }
            return result;
        }
        catch (Exception e) {
            throw new Docx4JException("Problems evaluating xpath '" + xpathString + "'", e);
        }
    }

    public String cachedXPathGetString(String xpath, String prefixMappings) throws Docx4JException {
        if (xPath.getClass().getName().equals("net.sf.saxon.xpath.XPathEvaluator")) {
            return this.xpathGetString(xpath, prefixMappings);
        }
        if (this.cachedXPathAPI == null) {
            this.cachedXPathAPI = new CachedXPathAPI();
        }
        if (this.cachedPrefixMappings == null && prefixMappings != null) {
            this.cachedPrefixMappings = prefixMappings;
            this.getNamespaceContext();
            NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
        }
        if (prefixMappings != null && !prefixMappings.equals(this.cachedPrefixMappings)) {
            this.getNamespaceContext();
            NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
        }
        try {
            XObject xo = this.cachedXPathAPI.eval((Node)this.doc, xpath, this.getNamespaceContext());
            if (Docx4jProperties.getProperty("docx4j.openpackaging.parts.XmlPart.cachedXPathGetString.heuristic", true)) {
                String trimmedXPath = xpath.trim();
                if (trimmedXPath.startsWith("boolean") || trimmedXPath.startsWith("not")) {
                    try {
                        if (xo.bool(this.cachedXPathAPI.getXPathContext())) {
                            return "true";
                        }
                        return "false";
                    }
                    catch (XPathException e) {
                        log.debug(e.getMessage());
                    }
                } else if (trimmedXPath.startsWith("count(")) {
                    if (xpath.contains("=") || xpath.contains(">") || xpath.contains("<")) {
                        log.debug("complex path detected: " + xpath);
                    } else {
                        try {
                            double d = xo.num(this.cachedXPathAPI.getXPathContext());
                            if (xpath.trim().startsWith("count(") && d == Math.rint(d)) {
                                return "" + Math.round(d);
                            }
                            return "" + d;
                        }
                        catch (XPathException e) {
                            log.debug(e.getMessage());
                        }
                    }
                }
            }
            try {
                Node result;
                if (log.isDebugEnabled()) {
                    NodeIterator ni = xo.nodeset();
                    result = ni.nextNode();
                    Node nextNode = ni.nextNode();
                    if (nextNode != null) {
                        log.debug(xpath + " returned multiple results. Did you intend that?");
                    }
                } else {
                    result = xo.nodeset().nextNode();
                }
                if (result == null) {
                    log.debug(xpath + " returned null; returning empty string");
                    return "";
                }
                return result.getTextContent();
            }
            catch (XPathException e) {
                if (e.getMessage().contains("#BOOLEAN")) {
                    log.debug("Fallback handling XPath of form: " + xpath + " in case of " + e.getMessage());
                    if (xo.bool(this.cachedXPathAPI.getXPathContext())) {
                        return "true";
                    }
                    return "false";
                }
                if (e.getMessage().contains("#NUMBER")) {
                    log.debug("Fallback handling XPath of form: " + xpath + " in case of " + e.getMessage());
                    double d = xo.num(this.cachedXPathAPI.getXPathContext());
                    if (xpath.trim().startsWith("count(") && d == Math.rint(d)) {
                        return "" + Math.round(d);
                    }
                    return "" + d;
                }
                if (e.getMessage().contains("#STRING")) {
                    log.debug("Fallback handling XPath of form: " + xpath + " in case of " + e.getMessage());
                    return xo.xstr(this.cachedXPathAPI.getXPathContext()).toString();
                }
                log.error(e.getMessage());
                log.error("Handle XPath of form: " + xpath);
                throw e;
            }
        }
        catch (TransformerException e) {
            log.error(System.getProperty("java.vendor"));
            log.error(System.getProperty("java.version"));
            log.error(Locale.getDefault().toString());
            throw new Docx4JException("Exception executing " + xpath, e);
        }
    }

    public void discardCacheXPathObject() {
        this.cachedXPathAPI = null;
        this.cachedPrefixMappings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> xpathGetNodes(String xpathString, String prefixMappings) {
        XPath xPath = XmlPart.xPath;
        synchronized (xPath) {
            this.getNamespaceContext();
            NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
            return XmlUtils.xpath(this.doc, xpathString, this.getNamespaceContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNodeValueAtXPath(String xpath, String value, String prefixMappings) throws Docx4JException {
        try {
            Node n;
            XPath xPath = XmlPart.xPath;
            synchronized (xPath) {
                this.getNamespaceContext();
                NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
                n = (Node)XmlPart.xPath.evaluate(xpath, this.doc, XPathConstants.NODE);
            }
            if (n == null) {
                log.debug("xpath returned null");
                return false;
            }
            log.debug(n.getClass().getName());
            if (n.getChildNodes() != null && n.getChildNodes().getLength() > 0) {
                NodeList nodes = n.getChildNodes();
                for (int i = nodes.getLength(); i > 0; --i) {
                    n.removeChild(nodes.item(i - 1));
                }
            }
            Text t = n.getOwnerDocument().createTextNode(value);
            n.appendChild(t);
            return true;
        }
        catch (Exception e) {
            throw new Docx4JException("Problem setting value at xpath " + xpath);
        }
    }

    @Override
    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof XmlPart)) {
            return false;
        }
        Document doc1 = this.getDocument();
        Document doc2 = ((XmlPart)other).getDocument();
        return doc1.isEqualNode(doc2);
    }
}

