/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.hpsf.wellknown;

import java.util.HashMap;
import org.docx4j.org.apache.poi.hpsf.wellknown.PropertyIDMap;

public class SectionIDMap
extends HashMap {
    public static final byte[] SUMMARY_INFORMATION_ID = new byte[]{-14, -97, -123, -32, 79, -7, 16, 104, -85, -111, 8, 0, 43, 39, -77, -39};
    public static final byte[][] DOCUMENT_SUMMARY_INFORMATION_ID = new byte[][]{{-43, -51, -43, 2, 46, -100, 16, 27, -109, -105, 8, 0, 43, 44, -7, -82}, {-43, -51, -43, 5, 46, -100, 16, 27, -109, -105, 8, 0, 43, 44, -7, -82}};
    public static final String UNDEFINED = "[undefined]";
    private static SectionIDMap defaultMap;

    public static SectionIDMap getInstance() {
        if (defaultMap == null) {
            SectionIDMap m3 = new SectionIDMap();
            m3.put(SUMMARY_INFORMATION_ID, PropertyIDMap.getSummaryInformationProperties());
            m3.put(DOCUMENT_SUMMARY_INFORMATION_ID[0], PropertyIDMap.getDocumentSummaryInformationProperties());
            defaultMap = m3;
        }
        return defaultMap;
    }

    public static String getPIDString(byte[] sectionFormatID, long pid) {
        PropertyIDMap m3 = SectionIDMap.getInstance().get(sectionFormatID);
        if (m3 == null) {
            return UNDEFINED;
        }
        String s2 = (String)m3.get(pid);
        if (s2 == null) {
            return UNDEFINED;
        }
        return s2;
    }

    public PropertyIDMap get(byte[] sectionFormatID) {
        return (PropertyIDMap)super.get(new String(sectionFormatID));
    }

    @Override
    public Object get(Object sectionFormatID) {
        return this.get((byte[])sectionFormatID);
    }

    @Override
    public Object put(byte[] sectionFormatID, PropertyIDMap propertyIDMap) {
        return super.put(new String(sectionFormatID), propertyIDMap);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put((byte[])key, (PropertyIDMap)value);
    }
}

