/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import org.camunda.feel.datatype.ZonedTime;
import org.camunda.feel.datatype.ZonedTime$;
import org.camunda.feel.interpreter.Compareable;
import org.camunda.feel.interpreter.Compareable$;
import org.camunda.feel.interpreter.CompositeContext$;
import org.camunda.feel.interpreter.Context;
import org.camunda.feel.interpreter.DefaultContext;
import org.camunda.feel.interpreter.DefaultContext$;
import org.camunda.feel.interpreter.JavaClassMapper$;
import org.camunda.feel.interpreter.RootContext$;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValBoolean$;
import org.camunda.feel.interpreter.ValContext;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValFunction$;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValNumber$;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.interpreter.ValueMapper;
import org.camunda.feel.package$;
import org.camunda.feel.parser.Addition;
import org.camunda.feel.parser.ArithmeticNegation;
import org.camunda.feel.parser.AtLeastOne;
import org.camunda.feel.parser.ClosedIntervalBoundary;
import org.camunda.feel.parser.Conjunction;
import org.camunda.feel.parser.ConstBool;
import org.camunda.feel.parser.ConstContext;
import org.camunda.feel.parser.ConstDate;
import org.camunda.feel.parser.ConstDateTime;
import org.camunda.feel.parser.ConstDayTimeDuration;
import org.camunda.feel.parser.ConstInputValue$;
import org.camunda.feel.parser.ConstList;
import org.camunda.feel.parser.ConstLocalDateTime;
import org.camunda.feel.parser.ConstLocalTime;
import org.camunda.feel.parser.ConstNull$;
import org.camunda.feel.parser.ConstNumber;
import org.camunda.feel.parser.ConstString;
import org.camunda.feel.parser.ConstTime;
import org.camunda.feel.parser.ConstYearMonthDuration;
import org.camunda.feel.parser.Disjunction;
import org.camunda.feel.parser.Division;
import org.camunda.feel.parser.Equal;
import org.camunda.feel.parser.EveryItem;
import org.camunda.feel.parser.Exp;
import org.camunda.feel.parser.Exponentiation;
import org.camunda.feel.parser.Filter;
import org.camunda.feel.parser.For;
import org.camunda.feel.parser.FunctionDefinition;
import org.camunda.feel.parser.FunctionInvocation;
import org.camunda.feel.parser.FunctionParameters;
import org.camunda.feel.parser.GreaterOrEqual;
import org.camunda.feel.parser.GreaterThan;
import org.camunda.feel.parser.If;
import org.camunda.feel.parser.In;
import org.camunda.feel.parser.InputEqualTo;
import org.camunda.feel.parser.InputGreaterOrEqual;
import org.camunda.feel.parser.InputGreaterThan;
import org.camunda.feel.parser.InputLessOrEqual;
import org.camunda.feel.parser.InputLessThan;
import org.camunda.feel.parser.InstanceOf;
import org.camunda.feel.parser.Interval;
import org.camunda.feel.parser.IntervalBoundary;
import org.camunda.feel.parser.JavaFunctionInvocation;
import org.camunda.feel.parser.LessOrEqual;
import org.camunda.feel.parser.LessThan;
import org.camunda.feel.parser.Multiplication;
import org.camunda.feel.parser.NamedFunctionParameters;
import org.camunda.feel.parser.Not;
import org.camunda.feel.parser.OpenIntervalBoundary;
import org.camunda.feel.parser.PathExpression;
import org.camunda.feel.parser.PositionalFunctionParameters;
import org.camunda.feel.parser.QualifiedFunctionInvocation;
import org.camunda.feel.parser.Ref;
import org.camunda.feel.parser.SomeItem;
import org.camunda.feel.parser.Subtraction;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011=f\u0001B\u0001\u0003\u0001-\u0011qBR3fY&sG/\u001a:qe\u0016$XM\u001d\u0006\u0003\u0007\u0011\t1\"\u001b8uKJ\u0004(/\u001a;fe*\u0011QAB\u0001\u0005M\u0016,GN\u0003\u0002\b\u0011\u000591-Y7v]\u0012\f'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!)\u0001\u0004\u0001C\u00013\u0005!QM^1m)\tQ2\u0005\u0006\u0002\u001c=A\u0011a\u0003H\u0005\u0003;\t\u00111AV1m\u0011\u0015yr\u0003q\u0001!\u0003\u001d\u0019wN\u001c;fqR\u0004\"AF\u0011\n\u0005\t\u0012!aB\"p]R,\u0007\u0010\u001e\u0005\u0006I]\u0001\r!J\u0001\u000bKb\u0004(/Z:tS>t\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0005\u0003\u0019\u0001\u0018M]:fe&\u0011!f\n\u0002\u0004\u000bb\u0004\b\"\u0002\u0017\u0001\t\u0013i\u0013!B3se>\u0014Hc\u0001\u00182gA\u0011acL\u0005\u0003a\t\u0011\u0001BV1m\u000bJ\u0014xN\u001d\u0005\u0006e-\u0002\raG\u0001\u0002q\")Ag\u000ba\u0001k\u00059Q.Z:tC\u001e,\u0007C\u0001\u001c>\u001d\t94\b\u0005\u00029\u001d5\t\u0011H\u0003\u0002;\u0015\u00051AH]8pizJ!\u0001\u0010\b\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y9AQ!\u0011\u0001\u0005\n\t\u000bQb^5uQZ\u000bGn\u0014:Ok2dGCA\u000eD\u0011\u0015\u0011\u0004\t1\u0001\u001c\u0011\u0015)\u0005\u0001\"\u0003G\u0003))h.\u0019:z\u001fB\fe.\u001f\u000b\u0005\u000f&SU\u000b\u0006\u0002\u001c\u0011\")q\u0004\u0012a\u0002A!)!\u0007\u0012a\u00017!)1\n\u0012a\u0001\u0019\u0006\t1\rE\u0003\u000e\u001b>{%+\u0003\u0002O\u001d\tIa)\u001e8di&|gN\r\t\u0003\u001bAK!!\u0015\b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u000e'&\u0011AK\u0004\u0002\b\u0005>|G.Z1o\u0011\u00151F\t1\u0001X\u0003\u00051\u0007\u0003B\u0007Y%nI!!\u0017\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B.\u0001\t\u0013a\u0016aB;oCJLx\n\u001d\u000b\u0005;~\u00037\u000f\u0006\u0002\u001c=\")qD\u0017a\u0002A!)!G\u0017a\u00017!)1J\u0017a\u0001CB)Q\"\u00142o%B\u00121\r\u001b\t\u0004-\u00114\u0017BA3\u0003\u0005-\u0019u.\u001c9be\u0016\f'\r\\3\u0011\u0005\u001dDG\u0002\u0001\u0003\nS\u0002\f\t\u0011!A\u0003\u0002)\u00141a\u0018\u00132#\tYw\n\u0005\u0002\u000eY&\u0011QN\u0004\u0002\b\u001d>$\b.\u001b8ha\ty\u0017\u000fE\u0002\u0017IB\u0004\"aZ9\u0005\u0013I\u0004\u0017\u0011!A\u0001\u0006\u0003Q'aA0%e!)aK\u0017a\u0001/\")Q\u000f\u0001C\u0005m\u0006YQO\\1ss>\u0003H)^1m)\u00199\u0018P\u001f?\u0002 Q\u00111\u0004\u001f\u0005\u0006?Q\u0004\u001d\u0001\t\u0005\u0006eQ\u0004\ra\u0007\u0005\u0006wR\u0004\raG\u0001\u0002s\")1\n\u001ea\u0001{BIQB`A\u0001\u0003\u0017\t)BU\u0005\u0003\u007f:\u0011\u0011BR;oGRLwN\\\u001a1\t\u0005\r\u0011q\u0001\t\u0005-\u0011\f)\u0001E\u0002h\u0003\u000f!!\"!\u0003}\u0003\u0003\u0005\tQ!\u0001k\u0005\ryFe\r\u0019\u0005\u0003\u001b\t\t\u0002\u0005\u0003\u0017I\u0006=\u0001cA4\u0002\u0012\u0011Q\u00111\u0003?\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\u0007}#C\u0007\r\u0003\u0002\u0018\u0005m\u0001\u0003\u0002\fe\u00033\u00012aZA\u000e\t)\ti\u0002`A\u0001\u0002\u0003\u0015\tA\u001b\u0002\u0004?\u0012*\u0004\"\u0002,u\u0001\u00049\u0006bBA\u0012\u0001\u0011%\u0011QE\u0001\fo&$\bNT;nE\u0016\u00148\u000fF\u0004\u001c\u0003O\tI#a\u000b\t\rI\n\t\u00031\u0001\u001c\u0011\u0019Y\u0018\u0011\u0005a\u00017!9a+!\tA\u0002\u00055\u0002cB\u0007N\u0003_\tyc\u0007\t\u0005\u0003c\t\u0019E\u0004\u0003\u00024\u0005}b\u0002BA\u001b\u0003{qA!a\u000e\u0002<9\u0019\u0001(!\u000f\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011bAA!\t\u00059\u0001/Y2lC\u001e,\u0017\u0002BA#\u0003\u000f\u0012aAT;nE\u0016\u0014(bAA!\t!9\u00111\n\u0001\u0005\n\u00055\u0013AC<ji\"tU/\u001c2feR)1$a\u0014\u0002R!1!'!\u0013A\u0002mAqAVA%\u0001\u0004\t\u0019\u0006E\u0003\u000e1\u0006=2\u0004C\u0004\u0002X\u0001!I!!\u0017\u0002\u0017]LG\u000f\u001b\"p_2,\u0017M\u001c\u000b\u00067\u0005m\u0013Q\f\u0005\u0007e\u0005U\u0003\u0019A\u000e\t\rY\u000b)\u00061\u0001X\u0011\u001d\t\t\u0007\u0001C\u0005\u0003G\n\u0011c^5uQ\n{w\u000e\\3b]>\u0013h*\u001e7m)\u0015Y\u0012QMA4\u0011\u0019\u0011\u0014q\fa\u00017!1a+a\u0018A\u0002]Cq!a\u001b\u0001\t\u0013\ti'\u0001\nxSRD'i\\8mK\u0006twJ\u001d$bYN,G#B\u000e\u0002p\u0005E\u0004B\u0002\u001a\u0002j\u0001\u00071\u0004\u0003\u0004W\u0003S\u0002\ra\u0016\u0005\b\u0003k\u0002A\u0011BA<\u0003)9\u0018\u000e\u001e5TiJLgn\u001a\u000b\u00067\u0005e\u00141\u0010\u0005\u0007e\u0005M\u0004\u0019A\u000e\t\u000fY\u000b\u0019\b1\u0001\u0002~A!Q\u0002W\u001b\u001c\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b\u0011b^5uQ\u0012\u000bG/Z:\u0015\u000fm\t))a\"\u0002\n\"1!'a A\u0002mAaa_A@\u0001\u0004Y\u0002b\u0002,\u0002\u0000\u0001\u0007\u00111\u0012\t\b\u001b5\u000bi)!$\u001c!\u0011\t\t$a$\n\t\u0005E\u0015q\t\u0002\u0005\t\u0006$X\rC\u0004\u0002\u0016\u0002!I!a&\u0002\u0011]LG\u000f\u001b#bi\u0016$RaGAM\u00037CaAMAJ\u0001\u0004Y\u0002b\u0002,\u0002\u0014\u0002\u0007\u0011Q\u0014\t\u0006\u001ba\u000bii\u0007\u0005\b\u0003C\u0003A\u0011BAR\u0003%9\u0018\u000e\u001e5US6,7\u000fF\u0004\u001c\u0003K\u000b9+!+\t\rI\ny\n1\u0001\u001c\u0011\u0019Y\u0018q\u0014a\u00017!9a+a(A\u0002\u0005-\u0006cB\u0007N\u0003[\u000bik\u0007\t\u0005\u0003c\ty+\u0003\u0003\u00022\u0006\u001d#\u0001\u0002+j[\u0016Dq!!.\u0001\t\u0013\t9,\u0001\bxSRDGj\\2bYRKW.Z:\u0015\u000fm\tI,a/\u0002>\"1!'a-A\u0002mAaa_AZ\u0001\u0004Y\u0002b\u0002,\u00024\u0002\u0007\u0011q\u0018\t\b\u001b5\u000b\t-!1\u001c!\u0011\t\t$a1\n\t\u0005\u0015\u0017q\t\u0002\n\u0019>\u001c\u0017\r\u001c+j[\u0016Dq!!3\u0001\t\u0013\tY-A\u0007xSRDGj\\2bYRKW.\u001a\u000b\u00067\u00055\u0017q\u001a\u0005\u0007e\u0005\u001d\u0007\u0019A\u000e\t\u000fY\u000b9\r1\u0001\u0002RB)Q\u0002WAa7!9\u0011Q\u001b\u0001\u0005\n\u0005]\u0017\u0001C<ji\"$\u0016.\\3\u0015\u000bm\tI.a7\t\rI\n\u0019\u000e1\u0001\u001c\u0011\u001d1\u00161\u001ba\u0001\u0003;\u0004R!\u0004-\u0002.nAq!!9\u0001\t\u0013\t\u0019/A\u0007xSRDG)\u0019;f)&lWm\u001d\u000b\b7\u0005\u0015\u0018q]Au\u0011\u0019\u0011\u0014q\u001ca\u00017!110a8A\u0002mAqAVAp\u0001\u0004\tY\u000fE\u0004\u000e\u001b\u00065\u0018Q^\u000e\u0011\t\u0005E\u0012q^\u0005\u0005\u0003c\f9E\u0001\u0005ECR,G+[7f\u0011\u001d\t)\u0010\u0001C\u0005\u0003o\f!c^5uQ2{7-\u00197ECR,G+[7fgR91$!?\u0002|\u0006u\bB\u0002\u001a\u0002t\u0002\u00071\u0004\u0003\u0004|\u0003g\u0004\ra\u0007\u0005\b-\u0006M\b\u0019AA\u0000!\u001diQJ!\u0001\u0003\u0002m\u0001B!!\r\u0003\u0004%!!QAA$\u00055aunY1m\t\u0006$X\rV5nK\"9!\u0011\u0002\u0001\u0005\n\t-\u0011\u0001D<ji\"$\u0015\r^3US6,G#B\u000e\u0003\u000e\t=\u0001B\u0002\u001a\u0003\b\u0001\u00071\u0004C\u0004W\u0005\u000f\u0001\rA!\u0005\u0011\u000b5A\u0016Q^\u000e\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\u0005\tr/\u001b;i\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\u0015\u000bm\u0011IBa\u0007\t\rI\u0012\u0019\u00021\u0001\u001c\u0011\u001d1&1\u0003a\u0001\u0005;\u0001R!\u0004-\u0003\u0002mAqA!\t\u0001\t\u0013\u0011\u0019#\u0001\fxSRD\u0017,Z1s\u001b>tG\u000f\u001b#ve\u0006$\u0018n\u001c8t)\u001dY\"Q\u0005B\u0014\u0005SAaA\rB\u0010\u0001\u0004Y\u0002BB>\u0003 \u0001\u00071\u0004C\u0004W\u0005?\u0001\rAa\u000b\u0011\u000f5i%Q\u0006B\u00177A!\u0011\u0011\u0007B\u0018\u0013\u0011\u0011\t$a\u0012\u0003#e+\u0017M]'p]RDG)\u001e:bi&|g\u000eC\u0004\u00036\u0001!IAa\u000e\u0002)]LG\u000f\u001b#bsRKW.\u001a#ve\u0006$\u0018n\u001c8t)\u001dY\"\u0011\bB\u001e\u0005{AaA\rB\u001a\u0001\u0004Y\u0002BB>\u00034\u0001\u00071\u0004C\u0004W\u0005g\u0001\rAa\u0010\u0011\u000f5i%\u0011\tB!7A!\u0011\u0011\u0007B\"\u0013\u0011\u0011)%a\u0012\u0003\u001f\u0011\u000b\u0017\u0010V5nK\u0012+(/\u0019;j_:DqA!\u0013\u0001\t\u0013\u0011Y%A\u000bxSRD\u0017,Z1s\u001b>tG\u000f\u001b#ve\u0006$\u0018n\u001c8\u0015\u000bm\u0011iEa\u0014\t\rI\u00129\u00051\u0001\u001c\u0011\u001d1&q\ta\u0001\u0005#\u0002R!\u0004-\u0003.mAqA!\u0016\u0001\t\u0013\u00119&A\nxSRDG)Y=US6,G)\u001e:bi&|g\u000eF\u0003\u001c\u00053\u0012Y\u0006\u0003\u00043\u0005'\u0002\ra\u0007\u0005\b-\nM\u0003\u0019\u0001B/!\u0015i\u0001L!\u0011\u001c\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005G\nqa^5uQZ\u000bG\u000eF\u0003\u001c\u0005K\u00129\u0007\u0003\u00043\u0005?\u0002\ra\u0007\u0005\b-\n}\u0003\u0019\u0001B5!\u0011i\u0001lG\u000e\t\u000f\t5\u0004\u0001\"\u0003\u0003p\u0005a\u0011n]%o\u0013:$XM\u001d<bYR!!\u0011\u000fBI!%iaPa\u001d\u0003~\t\u001d%\u000b\r\u0003\u0003v\te\u0004\u0003\u0002\fe\u0005o\u00022a\u001aB=\t-\u0011YHa\u001b\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\u0007}#c\u0007\r\u0003\u0003\u0000\t\r\u0005\u0003\u0002\fe\u0005\u0003\u00032a\u001aBB\t-\u0011)Ia\u001b\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\u0007}#s\u0007\r\u0003\u0003\n\n5\u0005\u0003\u0002\fe\u0005\u0017\u00032a\u001aBG\t-\u0011yIa\u001b\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\u0007}#\u0003\b\u0003\u0005\u0003\u0014\n-\u0004\u0019\u0001BK\u0003!Ig\u000e^3sm\u0006d\u0007c\u0001\u0014\u0003\u0018&\u0019!\u0011T\u0014\u0003\u0011%sG/\u001a:wC2DqA!(\u0001\t\u0013\u0011y*\u0001\u0006bi2+\u0017m\u001d;P]\u0016$bA!)\u0003&\neFcA\u000e\u0003$\"1qDa'A\u0004\u0001B\u0001Ba*\u0003\u001c\u0002\u0007!\u0011V\u0001\u0003qN\u0004RAa+\u00034\u0016rAA!,\u00032:\u0019\u0001Ha,\n\u0003=I1!!\u0011\u000f\u0013\u0011\u0011)La.\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0003r\u0001B\u0002,\u0003\u001c\u0002\u0007q\u000bC\u0004\u0003\u001e\u0002!IA!0\u0015\u000bm\u0011yL!3\t\u0011\t\u001d&1\u0018a\u0001\u0005\u0003\u0004bAa+\u00034\n\r\u0007\u0003B\u0007\u0003FnI1Aa2\u000f\u0005%1UO\\2uS>t\u0007\u0007\u0003\u0004W\u0005w\u0003\ra\u0016\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0003\r\tG\u000e\u001c\u000b\u0007\u0005#\u0014)Na6\u0015\u0007m\u0011\u0019\u000e\u0003\u0004 \u0005\u0017\u0004\u001d\u0001\t\u0005\t\u0005O\u0013Y\r1\u0001\u0003*\"1aKa3A\u0002]CqA!4\u0001\t\u0013\u0011Y\u000eF\u0003\u001c\u0005;\u0014y\u000e\u0003\u0005\u0003(\ne\u0007\u0019\u0001Ba\u0011\u00191&\u0011\u001ca\u0001/\"9!1\u001d\u0001\u0005\n\t\u0015\u0018\u0001C5oaV$8*Z=\u0015\u0007U\u00129\u000f\u0003\u0004 \u0005C\u0004\u001d\u0001\t\u0005\b\u0005W\u0004A\u0011\u0002Bw\u0003\u0015Ig\u000e];u)\rY\"q\u001e\u0005\u0007?\t%\b9\u0001\u0011\t\u000f\tM\b\u0001\"\u0003\u0003v\u0006iA-^1m\u001dVlWM]5d\u001fB$\"Ba>\u0003|\nu(q`B\u0003)\rY\"\u0011 \u0005\u0007?\tE\b9\u0001\u0011\t\rI\u0012\t\u00101\u0001\u001c\u0011\u0019Y(\u0011\u001fa\u00017!A1\u0011\u0001By\u0001\u0004\u0019\u0019!\u0001\u0002paBAQ\"TA\u0018\u0003_\ty\u0003C\u0004W\u0005c\u0004\r!a\u0015\t\u000f\r%\u0001\u0001\"\u0003\u0004\f\u0005IA-^1m\u001fB\fe.\u001f\u000b\u000b\u0007\u001b\u0019\tba\u0005\u0004\u0016\r]AcA\u000e\u0004\u0010!1qda\u0002A\u0004\u0001BaAMB\u0004\u0001\u0004Y\u0002BB>\u0004\b\u0001\u00071\u0004\u0003\u0004L\u0007\u000f\u0001\r\u0001\u0014\u0005\u0007-\u000e\u001d\u0001\u0019A,\t\u000f\rm\u0001\u0001\"\u0003\u0004\u001e\u00051A-^1m\u001fB$\"ba\b\u0004$\r\u00152qEB )\rY2\u0011\u0005\u0005\u0007?\re\u00019\u0001\u0011\t\rI\u001aI\u00021\u0001\u001c\u0011\u0019Y8\u0011\u0004a\u00017!91j!\u0007A\u0002\r%\u0002cB\u0007N\u0007W\u0019)D\u0015\u0019\u0005\u0007[\u0019\t\u0004\u0005\u0003\u0017I\u000e=\u0002cA4\u00042\u0011Y11GB\u0014\u0003\u0003\u0005\tQ!\u0001k\u0005\ryF%\u000f\u0019\u0005\u0007o\u0019Y\u0004\u0005\u0003\u0017I\u000ee\u0002cA4\u0004<\u0011Y1QHB\u0014\u0003\u0003\u0005\tQ!\u0001k\u0005\u0011yF%\r\u0019\t\rY\u001bI\u00021\u0001X\u0011\u001d\u0019\u0019\u0005\u0001C\u0005\u0007\u000b\nQ!\u00193e\u001fB$RaGB$\u0007\u0013BaAMB!\u0001\u0004Y\u0002BB>\u0004B\u0001\u00071\u0004C\u0004\u0004N\u0001!Iaa\u0014\u0002\u000bM,(m\u00149\u0015\u000bm\u0019\tfa\u0015\t\rI\u001aY\u00051\u0001\u001c\u0011\u0019Y81\na\u00017!91q\u000b\u0001\u0005\n\re\u0013!B7vY>\u0003H#B\u000e\u0004\\\ru\u0003B\u0002\u001a\u0004V\u0001\u00071\u0004\u0003\u0004|\u0007+\u0002\ra\u0007\u0005\b\u0007C\u0002A\u0011BB2\u0003\u0015!\u0017N^(q)\u0015Y2QMB4\u0011\u0019\u00114q\fa\u00017!11pa\u0018A\u0002mAqaa\u001b\u0001\t\u0013\u0019i'\u0001\u0007xSRDg)\u001e8di&|g\u000eF\u0003\u001c\u0007_\u001a\t\b\u0003\u00043\u0007S\u0002\ra\u0007\u0005\b-\u000e%\u0004\u0019AB:!\u0015i\u0001l!\u001e\u001c!\r12qO\u0005\u0004\u0007s\u0012!a\u0003,bY\u001a+hn\u0019;j_:Dqa! \u0001\t\u0013\u0019y(\u0001\bj]Z|7.\u001a$v]\u000e$\u0018n\u001c8\u0015\r\r\u00055QQBE)\rY21\u0011\u0005\u0007?\rm\u00049\u0001\u0011\t\u0011\r\u001d51\u0010a\u0001\u0007k\n\u0001BZ;oGRLwN\u001c\u0005\t\u0007\u0017\u001bY\b1\u0001\u0004\u000e\u00061\u0001/\u0019:b[N\u00042AJBH\u0013\r\u0019\tj\n\u0002\u0013\rVt7\r^5p]B\u000b'/Y7fi\u0016\u00148\u000fC\u0004\u0004\u0016\u0002!Iaa&\u0002\u0019\u0019Lg\u000e\u001a$v]\u000e$\u0018n\u001c8\u0015\u000fm\u0019Ij!(\u0004\"\"911TBJ\u0001\u0004\u0001\u0013aA2uq\"91qTBJ\u0001\u0004)\u0014\u0001\u00028b[\u0016D\u0001ba#\u0004\u0014\u0002\u00071Q\u0012\u0005\b\u0007K\u0003A\u0011BBT\u0003-\tG\r\u001a$v]\u000e$\u0018n\u001c8\u0015\u0011\r%6\u0011WB[\u0007o\u0003bANBVk\r=\u0016bABW\u007f\t\u0019Q*\u00199\u0011\r\t-&1WB;\u0011!\u0019\u0019la)A\u0002\r%\u0016!\u00034v]\u000e$\u0018n\u001c8t\u0011\u001d\u0019yja)A\u0002UBqAVBR\u0001\u0004\u0019)\bC\u0004\u0004<\u0002!Ia!0\u0002\u0011]LG\u000f\u001b+za\u0016$RaGB`\u0007\u0003DaAMB]\u0001\u0004Y\u0002b\u0002,\u0004:\u0002\u000711\u0019\t\u0006\u001ba+4Q\u0019\t\u0004-\r\u001d\u0017bABe\u0005\tQa+\u00197C_>dW-\u00198\t\u000f\r5\u0007\u0001\"\u0003\u0004P\u0006Aq/\u001b;i\u0019&\u001cH\u000fF\u0003\u001c\u0007#\u001c\u0019\u000e\u0003\u00043\u0007\u0017\u0004\ra\u0007\u0005\b-\u000e-\u0007\u0019ABk!\u0015i\u0001la6\u001c!\r12\u0011\\\u0005\u0004\u00077\u0014!a\u0002,bY2K7\u000f\u001e\u0005\b\u0007?\u0004A\u0011BBq\u0003%9\u0018\u000e\u001e5MSN$8\u000f\u0006\u0004\u0004d\u000e\u001d81\u001f\u000b\u00047\r\u0015\bBB\u0010\u0004^\u0002\u000f\u0001\u0005\u0003\u0005\u0004j\u000eu\u0007\u0019ABv\u0003\u0015a\u0017n\u001d;t!\u0019\u0011YKa-\u0004nB)Qba<67%\u00191\u0011\u001f\b\u0003\rQ+\b\u000f\\33\u0011\u001d16Q\u001ca\u0001\u0007k\u0004R!\u0004-\u0004xn\u0001bAa+\u00034\u000ee\bCB\u0007\u0004pV\u001a9\u000eC\u0004\u0004~\u0002!Iaa@\u0002)]LG\u000f[\"beR,7/[1o!J|G-^2u)\u0019!\t\u0001\"\u0002\u0005\u000eQ\u00191\u0004b\u0001\t\r}\u0019Y\u0010q\u0001!\u0011!!9aa?A\u0002\u0011%\u0011!C5uKJ\fGo\u001c:t!\u0019\u0011YKa-\u0005\fA)Qba<6K!9aka?A\u0002\u0011=\u0001#B\u0007Y\t#Y\u0002C\u0002BV\u0005g#\u0019\u0002E\u00037\u0007W+4\u0004C\u0004\u0005\u0018\u0001!I\u0001\"\u0007\u0002%\u0019d\u0017\r\u001e;f]\u0006sGMW5q\u0019&\u001cHo\u001d\u000b\u0005\t#!Y\u0002\u0003\u0005\u0004j\u0012U\u0001\u0019AB|\u0011\u001d!y\u0002\u0001C\u0005\tC\t!BZ5mi\u0016\u0014H*[:u)\u0015YB1\u0005C\u0015\u0011!!)\u0003\"\bA\u0002\u0011\u001d\u0012\u0001\u00027jgR\u0004RAa+\u00034nA\u0001\u0002b\u000b\u0005\u001e\u0001\u0007!\u0011N\u0001\u0007M&dG/\u001a:\t\u000f\u0011}\u0001\u0001\"\u0003\u00050Q)1\u0004\"\r\u00054!AAQ\u0005C\u0017\u0001\u0004!9\u0003\u0003\u0005\u00056\u00115\u0002\u0019AA\u0018\u0003\u0015Ig\u000eZ3y\u0011\u001d!I\u0004\u0001C\u0005\tw\t1b^5uQ\u000e{g\u000e^3yiR)1\u0004\"\u0010\u0005@!1!\u0007b\u000eA\u0002mAqA\u0016C\u001c\u0001\u0004!\t\u0005E\u0003\u000e1\u0012\r3\u0004E\u0002\u0017\t\u000bJ1\u0001b\u0012\u0003\u0005)1\u0016\r\\\"p]R,\u0007\u0010\u001e\u0005\b\t\u0017\u0002A\u0011\u0002C'\u000351\u0017\u000e\u001c;fe\u000e{g\u000e^3yiR!Aq\nC*)\r\u0001C\u0011\u000b\u0005\u0007?\u0011%\u00039\u0001\u0011\t\rI\"I\u00051\u0001\u001c\u0011\u001d!9\u0006\u0001C\u0005\t3\n1A]3g)\u0019!Y\u0006b\u0018\u0005bQ\u00191\u0004\"\u0018\t\r}!)\u0006q\u0001!\u0011\u0019\u0011DQ\u000ba\u00017!AA1\rC+\u0001\u0004!)'A\u0003oC6,7\u000fE\u0003\u0003,\nMV\u0007C\u0004\u0005j\u0001!I\u0001b\u001b\u0002\tA\fG\u000f\u001b\u000b\u00067\u00115D\u0011\u000f\u0005\b\t_\"9\u00071\u0001\u001c\u0003\u00051\bb\u0002C:\tO\u0002\r!N\u0001\u0004W\u0016L\bb\u0002C<\u0001\u0011%A\u0011P\u0001\fQ\u0006\u001cH+[7f5>tW\rF\u0002S\twB\u0001\u0002\" \u0005v\u0001\u0007\u0011Q^\u0001\tI\u0006$X\rV5nK\"9A\u0011\u0011\u0001\u0005\n\u0011\r\u0015\u0001E3wC2\u001cuN\u001c;fqR,e\u000e\u001e:z)\u0019!)\t\"#\u0005\fR\u00191\u0004b\"\t\r}!y\bq\u0001!\u0011\u001d!\u0019\bb A\u0002UBq\u0001\"$\u0005\u0000\u0001\u0007Q%A\u0002fqBDq\u0001\"%\u0001\t\u0013!\u0019*\u0001\nj]Z|7.\u001a&bm\u00064UO\\2uS>tGcC\u000e\u0005\u0016\u0012eEQ\u0014CQ\tKCq\u0001b&\u0005\u0010\u0002\u0007Q'A\u0005dY\u0006\u001c8OT1nK\"9A1\u0014CH\u0001\u0004)\u0014AC7fi\"|GMT1nK\"AAq\u0014CH\u0001\u0004!)'A\u0005be\u001e,X.\u001a8ug\"AA1\u0015CH\u0001\u0004!9#A\u0006qCJ\fWNV1mk\u0016\u001c\b\u0002\u0003CT\t\u001f\u0003\r\u0001\"+\u0002\u0017Y\fG.^3NCB\u0004XM\u001d\t\u0004-\u0011-\u0016b\u0001CW\u0005\tYa+\u00197vK6\u000b\u0007\u000f]3s\u0001")
public class FeelInterpreter {
    public Val eval(Exp expression, Context context) {
        Val val;
        Exp exp = expression;
        if (ConstNull$.MODULE$.equals(exp)) {
            val = ValNull$.MODULE$;
        } else if (ConstInputValue$.MODULE$.equals(exp)) {
            val = this.input(context);
        } else if (exp instanceof ConstNumber) {
            ConstNumber constNumber = (ConstNumber)exp;
            BigDecimal x2 = constNumber.value();
            val = new ValNumber(x2);
        } else if (exp instanceof ConstBool) {
            ConstBool constBool = (ConstBool)exp;
            boolean b = constBool.value();
            val = new ValBoolean(b);
        } else if (exp instanceof ConstString) {
            ConstString constString = (ConstString)exp;
            String s = constString.value();
            val = new ValString(s);
        } else if (exp instanceof ConstDate) {
            ConstDate constDate = (ConstDate)exp;
            LocalDate d = constDate.value();
            val = new ValDate(d);
        } else if (exp instanceof ConstLocalTime) {
            ConstLocalTime constLocalTime = (ConstLocalTime)exp;
            LocalTime t = constLocalTime.value();
            val = new ValLocalTime(t);
        } else if (exp instanceof ConstTime) {
            ConstTime constTime = (ConstTime)exp;
            ZonedTime t = constTime.value();
            val = new ValTime(t);
        } else if (exp instanceof ConstLocalDateTime) {
            ConstLocalDateTime constLocalDateTime = (ConstLocalDateTime)exp;
            LocalDateTime dt = constLocalDateTime.value();
            val = new ValLocalDateTime(dt);
        } else if (exp instanceof ConstDateTime) {
            ConstDateTime constDateTime = (ConstDateTime)exp;
            ZonedDateTime dt = constDateTime.value();
            val = new ValDateTime(dt);
        } else if (exp instanceof ConstYearMonthDuration) {
            ConstYearMonthDuration constYearMonthDuration = (ConstYearMonthDuration)exp;
            Period d = constYearMonthDuration.value();
            val = new ValYearMonthDuration(d.normalized());
        } else if (exp instanceof ConstDayTimeDuration) {
            ConstDayTimeDuration constDayTimeDuration = (ConstDayTimeDuration)exp;
            Duration d = constDayTimeDuration.value();
            val = new ValDayTimeDuration(d);
        } else if (exp instanceof ConstList) {
            ConstList constList = (ConstList)exp;
            List<Exp> items = constList.items();
            val = new ValList(items.map((Function1<Exp, Val> & Serializable & scala.Serializable)item -> this.withVal(this.eval((Exp)item, context), (Function1<Val, Val> & Serializable & scala.Serializable)x -> x), List$.MODULE$.canBuildFrom()));
        } else if (exp instanceof ConstContext) {
            ConstContext constContext = (ConstContext)exp;
            List<Tuple2<String, Exp>> entries = constContext.entries();
            DefaultContext dc = entries.foldLeft(new DefaultContext(DefaultContext$.MODULE$.apply$default$1(), DefaultContext$.MODULE$.apply$default$2(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5()), (Function2<DefaultContext, Tuple2, DefaultContext> & Serializable & scala.Serializable)(ctx, entry) -> {
                DefaultContext defaultContext;
                Val val = this.evalContextEntry((String)entry._1(), (Exp)entry._2(), CompositeContext$.MODULE$.ContextComposition(context).$plus((Context)ctx));
                if (val instanceof ValFunction) {
                    ValFunction valFunction = (ValFunction)val;
                    defaultContext = new DefaultContext(ctx.variables(), this.addFunction(ctx.functions(), (String)entry._1(), valFunction), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5());
                } else if (val != null) {
                    Val val2 = val;
                    defaultContext = new DefaultContext(ctx.variables().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry._1()), val2)), ctx.functions(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5());
                } else {
                    throw new MatchError(val);
                }
                return defaultContext;
            });
            val = new ValContext(dc);
        } else if (exp instanceof InputEqualTo) {
            InputEqualTo inputEqualTo = (InputEqualTo)exp;
            Exp x3 = inputEqualTo.x();
            val = this.unaryOpAny(this.eval(x3, context), (Function2<Object, Object, Object> & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$eval$4(x$1, x$2)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputLessThan) {
            InputLessThan inputLessThan = (InputLessThan)exp;
            Exp x4 = inputLessThan.x();
            val = this.unaryOp(this.eval(x4, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean(x$3.$less(x$4)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputLessOrEqual) {
            InputLessOrEqual inputLessOrEqual = (InputLessOrEqual)exp;
            Exp x5 = inputLessOrEqual.x();
            val = this.unaryOp(this.eval(x5, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean(x$5.$less$eq(x$6)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputGreaterThan) {
            InputGreaterThan inputGreaterThan = (InputGreaterThan)exp;
            Exp x6 = inputGreaterThan.x();
            val = this.unaryOp(this.eval(x6, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean(x$7.$greater(x$8)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputGreaterOrEqual) {
            InputGreaterOrEqual inputGreaterOrEqual = (InputGreaterOrEqual)exp;
            Exp x7 = inputGreaterOrEqual.x();
            val = this.unaryOp(this.eval(x7, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean(x$9.$greater$eq(x$10)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof Interval) {
            Interval interval = (Interval)exp;
            IntervalBoundary start = interval.start();
            IntervalBoundary end = interval.end();
            val = this.unaryOpDual(this.eval(start.value(), context), this.eval(end.value(), context), this.isInInterval(interval), ValBoolean$.MODULE$, context);
        } else if (exp instanceof Addition) {
            Addition addition = (Addition)exp;
            Exp x8 = addition.x();
            Exp y = addition.y();
            val = this.withValOrNull(this.addOp(this.eval(x8, context), this.eval(y, context)));
        } else if (exp instanceof Subtraction) {
            Subtraction subtraction = (Subtraction)exp;
            Exp x9 = subtraction.x();
            Exp y = subtraction.y();
            val = this.withValOrNull(this.subOp(this.eval(x9, context), this.eval(y, context)));
        } else if (exp instanceof Multiplication) {
            Multiplication multiplication = (Multiplication)exp;
            Exp x10 = multiplication.x();
            Exp y = multiplication.y();
            val = this.withValOrNull(this.mulOp(this.eval(x10, context), this.eval(y, context)));
        } else if (exp instanceof Division) {
            Division division = (Division)exp;
            Exp x11 = division.x();
            Exp y = division.y();
            val = this.withValOrNull(this.divOp(this.eval(x11, context), this.eval(y, context)));
        } else if (exp instanceof Exponentiation) {
            Exponentiation exponentiation = (Exponentiation)exp;
            Exp x12 = exponentiation.x();
            Exp y = exponentiation.y();
            val = this.withValOrNull(this.dualNumericOp(this.eval(x12, context), this.eval(y, context), (Function2<BigDecimal, BigDecimal, BigDecimal> & Serializable & scala.Serializable)(x$11, x$12) -> x$11.pow(x$12.toInt()), ValNumber$.MODULE$, context));
        } else if (exp instanceof ArithmeticNegation) {
            ArithmeticNegation arithmeticNegation = (ArithmeticNegation)exp;
            Exp x13 = arithmeticNegation.x();
            val = this.withValOrNull(this.withNumber(this.eval(x13, context), (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValNumber> & Serializable & scala.Serializable)x -> new ValNumber(x.unary_$minus())));
        } else if (exp instanceof Equal) {
            Equal equal = (Equal)exp;
            Exp x14 = equal.x();
            Exp y = equal.y();
            val = this.dualOpAny(this.eval(x14, context), this.eval(y, context), (Function2<Object, Object, Object> & Serializable & scala.Serializable)(x$13, x$14) -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$eval$11(x$13, x$14)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof LessThan) {
            LessThan lessThan = (LessThan)exp;
            Exp x15 = lessThan.x();
            Exp y = lessThan.y();
            val = this.dualOp(this.eval(x15, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$15, x$16) -> BoxesRunTime.boxToBoolean(x$15.$less(x$16)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof LessOrEqual) {
            LessOrEqual lessOrEqual = (LessOrEqual)exp;
            Exp x16 = lessOrEqual.x();
            Exp y = lessOrEqual.y();
            val = this.dualOp(this.eval(x16, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$17, x$18) -> BoxesRunTime.boxToBoolean(x$17.$less$eq(x$18)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)exp;
            Exp x17 = greaterThan.x();
            Exp y = greaterThan.y();
            val = this.dualOp(this.eval(x17, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$19, x$20) -> BoxesRunTime.boxToBoolean(x$19.$greater(x$20)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof GreaterOrEqual) {
            GreaterOrEqual greaterOrEqual = (GreaterOrEqual)exp;
            Exp x18 = greaterOrEqual.x();
            Exp y = greaterOrEqual.y();
            val = this.dualOp(this.eval(x18, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$21, x$22) -> BoxesRunTime.boxToBoolean(x$21.$greater$eq(x$22)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof AtLeastOne) {
            AtLeastOne atLeastOne = (AtLeastOne)exp;
            List<Exp> xs = atLeastOne.xs();
            val = this.atLeastOne(xs, ValBoolean$.MODULE$, context);
        } else if (exp instanceof Not) {
            Not not = (Not)exp;
            Exp x19 = not.x();
            val = this.withBooleanOrNull(this.eval(x19, context), (Function1<Object, Val>)(Function1<Object, ValBoolean> & Serializable & scala.Serializable)x -> FeelInterpreter.$anonfun$eval$16(BoxesRunTime.unboxToBoolean(x)));
        } else if (exp instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)exp;
            Exp x20 = disjunction.x();
            Exp y = disjunction.y();
            Exp exp2 = x20;
            Exp exp3 = y;
            val = this.atLeastOne(Nil$.MODULE$.$colon$colon(exp3).$colon$colon(exp2), ValBoolean$.MODULE$, context);
        } else if (exp instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)exp;
            Exp x21 = conjunction.x();
            Exp y = conjunction.y();
            Exp exp4 = x21;
            Exp exp5 = y;
            val = this.all(Nil$.MODULE$.$colon$colon(exp5).$colon$colon(exp4), ValBoolean$.MODULE$, context);
        } else if (exp instanceof If) {
            If if_ = (If)exp;
            Exp condition = if_.condition();
            Exp statement = if_.statement();
            Exp elseStatement = if_.elseStatement();
            val = this.withBooleanOrFalse(this.eval(condition, context), (Function1<Object, Val> & Serializable & scala.Serializable)isMet -> FeelInterpreter.$anonfun$eval$17(this, context, statement, elseStatement, BoxesRunTime.unboxToBoolean(isMet)));
        } else if (exp instanceof In) {
            In in = (In)exp;
            Exp x22 = in.x();
            Exp test = in.test();
            val = this.withVal(this.eval(x22, context), (Function1<Val, Val> & Serializable & scala.Serializable)x -> this.eval(test, CompositeContext$.MODULE$.ContextComposition(context).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.inputKey(context)), x))));
        } else if (exp instanceof InstanceOf) {
            InstanceOf instanceOf = (InstanceOf)exp;
            Exp x23 = instanceOf.x();
            String typeName = instanceOf.typeName();
            val = this.withVal(this.eval(x23, context), (Function1<Val, Val> & Serializable & scala.Serializable)x -> this.withType((Val)x, (Function1<String, ValBoolean> & Serializable & scala.Serializable)t -> {
                String string = t;
                String string2 = typeName;
                return new ValBoolean(!(string != null ? !string.equals(string2) : string2 != null));
            }));
        } else if (exp instanceof Ref) {
            Ref ref = (Ref)exp;
            List<String> names = ref.names();
            val = this.ref(context.variable(names.head()), (List)names.tail(), context);
        } else if (exp instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)exp;
            Exp exp6 = pathExpression.path();
            String key = pathExpression.key();
            val = this.withVal(this.eval(exp6, context), (Function1<Val, Val> & Serializable & scala.Serializable)v -> this.path((Val)v, key));
        } else if (exp instanceof SomeItem) {
            SomeItem someItem = (SomeItem)exp;
            List<Tuple2<String, Exp>> iterators = someItem.iterators();
            Exp condition = someItem.condition();
            val = this.withCartesianProduct(iterators, (Function1<List<Map<String, Val>>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)p -> this.atLeastOne(p.map((Function1<Map, Function0> & Serializable & scala.Serializable)vars -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval(condition, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus((Map<String, Object>)vars)), List$.MODULE$.canBuildFrom()), ValBoolean$.MODULE$), context);
        } else if (exp instanceof EveryItem) {
            EveryItem everyItem = (EveryItem)exp;
            List<Tuple2<String, Exp>> iterators = everyItem.iterators();
            Exp condition = everyItem.condition();
            val = this.withCartesianProduct(iterators, (Function1<List<Map<String, Val>>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)p -> this.all(p.map((Function1<Map, Function0> & Serializable & scala.Serializable)vars -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval(condition, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus((Map<String, Object>)vars)), List$.MODULE$.canBuildFrom()), ValBoolean$.MODULE$), context);
        } else if (exp instanceof For) {
            For for_ = (For)exp;
            List<Tuple2<String, Exp>> iterators = for_.iterators();
            Exp exp7 = for_.exp();
            val = this.withCartesianProduct(iterators, (Function1<List<Map<String, Val>>, Val>)(Function1<List, ValList> & Serializable & scala.Serializable)p -> new ValList(p.map((Function1<Map, Val> & Serializable & scala.Serializable)vars -> this.eval(exp7, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus((Map<String, Object>)vars)), List$.MODULE$.canBuildFrom())), context);
        } else if (exp instanceof Filter) {
            Filter filter = (Filter)exp;
            Exp list = filter.list();
            Exp filter2 = filter.filter();
            val = this.withList(this.eval(list, context), (Function1<ValList, Val> & Serializable & scala.Serializable)l -> {
                ArithmeticNegation arithmeticNegation;
                Exp exp;
                Val val;
                Exp exp2 = filter2;
                if (exp2 instanceof ConstNumber) {
                    ConstNumber constNumber = (ConstNumber)exp2;
                    BigDecimal index = constNumber.value();
                    val = this.filterList(l.items(), index);
                } else if (exp2 instanceof ArithmeticNegation && (exp = (arithmeticNegation = (ArithmeticNegation)exp2).x()) instanceof ConstNumber) {
                    ConstNumber constNumber = (ConstNumber)exp;
                    BigDecimal index = constNumber.value();
                    val = this.filterList(l.items(), index.unary_$minus());
                } else {
                    val = this.filterList(l.items(), (Function1<Val, Val> & Serializable & scala.Serializable)(Val item) -> this.eval(filter2, this.filterContext((Val)item, context)));
                }
                return val;
            });
        } else if (exp instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)exp;
            String name = functionInvocation.function();
            FunctionParameters params = functionInvocation.params();
            val = this.withFunction(this.findFunction(context, name, params), (Function1<ValFunction, Val> & Serializable & scala.Serializable)f -> this.invokeFunction((ValFunction)f, params, context));
        } else if (exp instanceof QualifiedFunctionInvocation) {
            QualifiedFunctionInvocation qualifiedFunctionInvocation = (QualifiedFunctionInvocation)exp;
            Exp path = qualifiedFunctionInvocation.path();
            String name = qualifiedFunctionInvocation.function();
            FunctionParameters params = qualifiedFunctionInvocation.params();
            val = this.withContext(this.eval(path, context), (Function1<ValContext, Val> & Serializable & scala.Serializable)c -> this.withFunction(this.findFunction(c.context(), name, params), (Function1<ValFunction, Val> & Serializable & scala.Serializable)f -> this.invokeFunction((ValFunction)f, params, context)));
        } else if (exp instanceof FunctionDefinition) {
            FunctionDefinition functionDefinition = (FunctionDefinition)exp;
            List<String> params = functionDefinition.parameters();
            Exp body = functionDefinition.body();
            val = new ValFunction(params, (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)paramValues -> {
                Val val;
                Exp exp = body;
                if (exp instanceof JavaFunctionInvocation) {
                    JavaFunctionInvocation javaFunctionInvocation = (JavaFunctionInvocation)exp;
                    String className = javaFunctionInvocation.className();
                    String methodName = javaFunctionInvocation.methodName();
                    List<String> arguments = javaFunctionInvocation.arguments();
                    val = this.invokeJavaFunction(className, methodName, arguments, (List<Val>)paramValues, context.valueMapper());
                } else {
                    val = this.eval(body, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus(((TraversableOnce)params.zip(paramValues, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
                }
                return val;
            }, ValFunction$.MODULE$.apply$default$3());
        } else {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported expression '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{exp})));
        }
        return val;
    }

    private ValError error(Val x, String message) {
        ValError valError;
        Val val = x;
        ValError valError2 = val instanceof ValError ? (valError = (ValError)val) : new ValError(message);
        return valError2;
    }

    private Val withValOrNull(Val x) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValError) {
            ValError valError = (ValError)val2;
            String e = valError.error();
            package$.MODULE$.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressed failure: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{e})));
            val = ValNull$.MODULE$;
        } else {
            val = x;
        }
        return val;
    }

    private Val unaryOpAny(Val x, Function2<Object, Object, Object> c, Function1<Object, Val> f, Context context) {
        return this.withVal(this.input(context), (Function1<Val, Val> & Serializable & scala.Serializable)x$27 -> {
            Val val;
            Val val2 = x$27;
            if (ValNull$.MODULE$.equals(val2)) {
                val = this.withVal(x, (Function1<Val, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(ValNull$.MODULE$, x)));
            } else {
                Val val3 = x;
                ValNull$ valNull$ = ValNull$.MODULE$;
                if (!(val3 != null ? !val3.equals(valNull$) : valNull$ != null)) {
                    val = (Val)f.apply(c.apply(val2, ValNull$.MODULE$));
                } else if (val2 instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val2;
                    BigDecimal i = valNumber.value();
                    val = this.withNumber(x, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValBoolean) {
                    ValBoolean valBoolean = (ValBoolean)val2;
                    boolean i = valBoolean.value();
                    val = this.withBoolean(x, (Function1<Object, Val> & Serializable & scala.Serializable)x -> FeelInterpreter.$anonfun$unaryOpAny$4(c, f, i, BoxesRunTime.unboxToBoolean(x)));
                } else if (val2 instanceof ValString) {
                    ValString valString = (ValString)val2;
                    String i = valString.value();
                    val = this.withString(x, (Function1<String, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValDate) {
                    ValDate valDate = (ValDate)val2;
                    LocalDate i = valDate.value();
                    val = this.withDate(x, (Function1<LocalDate, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValLocalTime) {
                    ValLocalTime valLocalTime = (ValLocalTime)val2;
                    LocalTime i = valLocalTime.value();
                    val = this.withLocalTime(x, (Function1<LocalTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValTime) {
                    ValTime valTime = (ValTime)val2;
                    ZonedTime i = valTime.value();
                    val = this.withTime(x, (Function1<ZonedTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                    LocalDateTime i = valLocalDateTime.value();
                    val = this.withLocalDateTime(x, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val2;
                    ZonedDateTime i = valDateTime.value();
                    val = this.withDateTime(x, (Function1<ZonedDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValYearMonthDuration) {
                    ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                    Period i = valYearMonthDuration.value();
                    val = this.withYearMonthDuration(x, (Function1<Period, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValDayTimeDuration) {
                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                    Duration i = valDayTimeDuration.value();
                    val = this.withDayTimeDuration(x, (Function1<Duration, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else {
                    val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Boolean, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.input(context)})));
                }
            }
            return val;
        });
    }

    private Val unaryOp(Val x, Function2<Compareable<?>, Compareable<?>, Object> c, Function1<Object, Val> f, Context context) {
        return this.withVal(this.input(context), (Function1<Val, Val> & Serializable & scala.Serializable)x$28 -> {
            Val val;
            Val val2 = x$28;
            if (val2 instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal i = valNumber.value();
                val = this.withNumber(x, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableNumber(i), Compareable$.MODULE$.CompareableNumber((BigDecimal)x))));
            } else if (val2 instanceof ValDate) {
                ValDate valDate = (ValDate)val2;
                LocalDate i = valDate.value();
                val = this.withDate(x, (Function1<LocalDate, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDate(i), Compareable$.MODULE$.CompareableDate((LocalDate)x))));
            } else if (val2 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val2;
                LocalTime i = valLocalTime.value();
                val = this.withLocalTime(x, (Function1<LocalTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalTime(i), Compareable$.MODULE$.CompareableLocalTime((LocalTime)x))));
            } else if (val2 instanceof ValTime) {
                ValTime valTime = (ValTime)val2;
                ZonedTime i = valTime.value();
                val = this.withTime(x, (Function1<ZonedTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableTime(i), Compareable$.MODULE$.CompareableTime((ZonedTime)x))));
            } else if (val2 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime i = valLocalDateTime.value();
                val = this.withLocalDateTime(x, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalDateTime(i), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)x))));
            } else if (val2 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                ZonedDateTime i = valDateTime.value();
                val = this.withDateTime(x, (Function1<ZonedDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDateTime(i), Compareable$.MODULE$.CompareableDateTime((ZonedDateTime)x))));
            } else if (val2 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period i = valYearMonthDuration.value();
                val = this.withYearMonthDuration(x, (Function1<Period, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableYearMonthDuration(i), Compareable$.MODULE$.CompareableYearMonthDuration((Period)x))));
            } else if (val2 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                Duration i = valDayTimeDuration.value();
                val = this.withDayTimeDuration(x, (Function1<Duration, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDayTimeDuration(i), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)x))));
            } else {
                val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.input(context)})));
            }
            return val;
        });
    }

    private Val unaryOpDual(Val x, Val y, Function3<Compareable<?>, Compareable<?>, Compareable<?>, Object> c, Function1<Object, Val> f, Context context) {
        return this.withVal(this.input(context), (Function1<Val, Val> & Serializable & scala.Serializable)x$29 -> {
            Val val;
            Val val2 = x$29;
            if (val2 instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal i = valNumber.value();
                val = this.withNumbers(x, y, (Function2<BigDecimal, BigDecimal, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableNumber(i), Compareable$.MODULE$.CompareableNumber((BigDecimal)x), Compareable$.MODULE$.CompareableNumber((BigDecimal)y))));
            } else if (val2 instanceof ValDate) {
                ValDate valDate = (ValDate)val2;
                LocalDate i = valDate.value();
                val = this.withDates(x, y, (Function2<LocalDate, LocalDate, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDate(i), Compareable$.MODULE$.CompareableDate((LocalDate)x), Compareable$.MODULE$.CompareableDate((LocalDate)y))));
            } else if (val2 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val2;
                LocalTime i = valLocalTime.value();
                val = this.withLocalTimes(x, y, (Function2<LocalTime, LocalTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalTime(i), Compareable$.MODULE$.CompareableLocalTime((LocalTime)x), Compareable$.MODULE$.CompareableLocalTime((LocalTime)y))));
            } else if (val2 instanceof ValTime) {
                ValTime valTime = (ValTime)val2;
                ZonedTime i = valTime.value();
                val = this.withTimes(x, y, (Function2<ZonedTime, ZonedTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableTime(i), Compareable$.MODULE$.CompareableTime((ZonedTime)x), Compareable$.MODULE$.CompareableTime((ZonedTime)y))));
            } else if (val2 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime i = valLocalDateTime.value();
                val = this.withLocalDateTimes(x, y, (Function2<LocalDateTime, LocalDateTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalDateTime(i), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)x), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)y))));
            } else if (val2 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                ZonedDateTime i = valDateTime.value();
                val = this.withDateTimes(x, y, (Function2<ZonedDateTime, ZonedDateTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDateTime(i), Compareable$.MODULE$.CompareableDateTime((ZonedDateTime)x), Compareable$.MODULE$.CompareableDateTime((ZonedDateTime)y))));
            } else if (val2 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period i = valYearMonthDuration.value();
                val = this.withYearMonthDurations(x, y, (Function2<Period, Period, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableYearMonthDuration(i), Compareable$.MODULE$.CompareableYearMonthDuration((Period)x), Compareable$.MODULE$.CompareableYearMonthDuration((Period)y))));
            } else if (val2 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                Duration i = valDayTimeDuration.value();
                val = this.withDayTimeDurations(x, y, (Function2<Duration, Duration, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDayTimeDuration(i), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)x), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)y))));
            } else {
                val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.input(context)})));
            }
            return val;
        });
    }

    private Val withNumbers(Val x2, Val y, Function2<BigDecimal, BigDecimal, Val> f) {
        return this.withNumber(x2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)x -> this.withNumber(y, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((BigDecimal)x, (BigDecimal)y)));
    }

    private Val withNumber(Val x, Function1<BigDecimal, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withBoolean(Val x, Function1<Object, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val2;
            boolean x2 = valBoolean.value();
            val = f.apply(BoxesRunTime.boxToBoolean(x2));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Boolean but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withBooleanOrNull(Val x, Function1<Object, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val2;
            boolean x2 = valBoolean.value();
            val = f.apply(BoxesRunTime.boxToBoolean(x2));
        } else {
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val withBooleanOrFalse(Val x, Function1<Object, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val2;
            boolean x2 = valBoolean.value();
            val = f.apply(BoxesRunTime.boxToBoolean(x2));
        } else {
            package$.MODULE$.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressed failure: expected Boolean but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
            val = f.apply(BoxesRunTime.boxToBoolean(false));
        }
        return val;
    }

    private Val withString(Val x, Function1<String, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValString) {
            ValString valString = (ValString)val2;
            String x2 = valString.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected String but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withDates(Val x2, Val y, Function2<LocalDate, LocalDate, Val> f) {
        return this.withDate(x2, (Function1<LocalDate, Val> & Serializable & scala.Serializable)x -> this.withDate(y, (Function1<LocalDate, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((LocalDate)x, (LocalDate)y)));
    }

    private Val withDate(Val x, Function1<LocalDate, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValDate) {
            ValDate valDate = (ValDate)val2;
            LocalDate x2 = valDate.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Date but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withTimes(Val x2, Val y, Function2<ZonedTime, ZonedTime, Val> f) {
        return this.withTime(x2, (Function1<ZonedTime, Val> & Serializable & scala.Serializable)x -> this.withTime(y, (Function1<ZonedTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((ZonedTime)x, (ZonedTime)y)));
    }

    private Val withLocalTimes(Val x2, Val y, Function2<LocalTime, LocalTime, Val> f) {
        return this.withLocalTime(x2, (Function1<LocalTime, Val> & Serializable & scala.Serializable)x -> this.withLocalTime(y, (Function1<LocalTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((LocalTime)x, (LocalTime)y)));
    }

    private Val withLocalTime(Val x, Function1<LocalTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x2 = valLocalTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Local Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withTime(Val x, Function1<ZonedTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            ZonedTime x2 = valTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withDateTimes(Val x2, Val y, Function2<ZonedDateTime, ZonedDateTime, Val> f) {
        return this.withDateTime(x2, (Function1<ZonedDateTime, Val> & Serializable & scala.Serializable)x -> this.withDateTime(y, (Function1<ZonedDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((ZonedDateTime)x, (ZonedDateTime)y)));
    }

    private Val withLocalDateTimes(Val x2, Val y, Function2<LocalDateTime, LocalDateTime, Val> f) {
        return this.withLocalDateTime(x2, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)x -> this.withLocalDateTime(y, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((LocalDateTime)x, (LocalDateTime)y)));
    }

    private Val withDateTime(Val x, Function1<ZonedDateTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val2;
            ZonedDateTime x2 = valDateTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withLocalDateTime(Val x, Function1<LocalDateTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x2 = valLocalDateTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Local Date Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withYearMonthDurations(Val x2, Val y, Function2<Period, Period, Val> f) {
        return this.withYearMonthDuration(x2, (Function1<Period, Val> & Serializable & scala.Serializable)x -> this.withYearMonthDuration(y, (Function1<Period, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((Period)x, (Period)y)));
    }

    private Val withDayTimeDurations(Val x2, Val y, Function2<Duration, Duration, Val> f) {
        return this.withDayTimeDuration(x2, (Function1<Duration, Val> & Serializable & scala.Serializable)x -> this.withDayTimeDuration(y, (Function1<Duration, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((Duration)x, (Duration)y)));
    }

    private Val withYearMonthDuration(Val x, Function1<Period, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x2 = valYearMonthDuration.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withDayTimeDuration(Val x, Function1<Duration, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x2 = valDayTimeDuration.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withVal(Val x, Function1<Val, Val> f) {
        ValError valError;
        Val val = x;
        Val val2 = val instanceof ValError ? (valError = (ValError)val) : f.apply(x);
        return val2;
    }

    private Function3<Compareable<?>, Compareable<?>, Compareable<?>, Object> isInInterval(Interval interval) {
        return (Function3<Compareable, Compareable, Compareable, Object> & Serializable & scala.Serializable)(i, x, y) -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$isInInterval$1(interval, i, x, y));
    }

    private Val atLeastOne(List<Exp> xs, Function1<Object, Val> f, Context context) {
        return this.atLeastOne(xs.map((Function1<Exp, Function0> & Serializable & scala.Serializable)x -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval((Exp)x, context), List$.MODULE$.canBuildFrom()), f);
    }

    private Val atLeastOne(List<Function0<Val>> xs, Function1<Object, Val> f) {
        Val val;
        block4: {
            List<Function0<Val>> list;
            block5: {
                Val val2;
                block6: {
                    ValBoolean valBoolean;
                    boolean bl;
                    List<Function0<Val>> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            val = f.apply(BoxesRunTime.boxToBoolean(false));
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Function0 x = (Function0)$colon$colon.head();
                        xs2 = $colon$colon.tl$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean2 = null;
                        Val val3 = (Val)x.apply();
                        if (val3 instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean2 = (ValBoolean)val3;
                            boolean bl4 = valBoolean2.value();
                            if (bl4) {
                                val2 = f.apply(BoxesRunTime.boxToBoolean(true));
                                break block6;
                            }
                        }
                        if (!bl3 || (bl2 = valBoolean2.value())) break;
                        xs = xs2;
                    }
                    Val val4 = this.atLeastOne(xs2, f);
                    Val val5 = val4 instanceof ValBoolean && true == (bl = (valBoolean = (ValBoolean)val4).value()) ? f.apply(BoxesRunTime.boxToBoolean(true)) : ValNull$.MODULE$;
                    val2 = val5;
                }
                val = val2;
                break block4;
            }
            throw new MatchError(list);
        }
        return val;
    }

    private Val all(List<Exp> xs, Function1<Object, Val> f, Context context) {
        return this.all(xs.map((Function1<Exp, Function0> & Serializable & scala.Serializable)x -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval((Exp)x, context), List$.MODULE$.canBuildFrom()), f);
    }

    private Val all(List<Function0<Val>> xs, Function1<Object, Val> f) {
        Val val;
        block4: {
            List<Function0<Val>> list;
            block5: {
                Val val2;
                block6: {
                    ValBoolean valBoolean;
                    boolean bl;
                    List<Function0<Val>> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            val = f.apply(BoxesRunTime.boxToBoolean(true));
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Function0 x = (Function0)$colon$colon.head();
                        xs2 = $colon$colon.tl$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean2 = null;
                        Val val3 = (Val)x.apply();
                        if (val3 instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean2 = (ValBoolean)val3;
                            boolean bl4 = valBoolean2.value();
                            if (!bl4) {
                                val2 = f.apply(BoxesRunTime.boxToBoolean(false));
                                break block6;
                            }
                        }
                        if (!bl3 || !(bl2 = valBoolean2.value())) break;
                        xs = xs2;
                    }
                    Val val4 = this.all(xs2, f);
                    Val val5 = val4 instanceof ValBoolean && false == (bl = (valBoolean = (ValBoolean)val4).value()) ? f.apply(BoxesRunTime.boxToBoolean(false)) : ValNull$.MODULE$;
                    val2 = val5;
                }
                val = val2;
                break block4;
            }
            throw new MatchError(list);
        }
        return val;
    }

    private String inputKey(Context context) {
        String string;
        Val val = context.variable(RootContext$.MODULE$.inputVariableKey());
        if (val instanceof ValString) {
            String inputVariableName;
            ValString valString = (ValString)val;
            string = inputVariableName = valString.value();
        } else {
            string = RootContext$.MODULE$.defaultInputVariable();
        }
        return string;
    }

    private Val input(Context context) {
        return context.variable(this.inputKey(context));
    }

    private Val dualNumericOp(Val x, Val y2, Function2<BigDecimal, BigDecimal, BigDecimal> op, Function1<BigDecimal, Val> f, Context context) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((BigDecimal)op.apply(x2, (BigDecimal)y)));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val dualOpAny(Val x, Val y2, Function2<Object, Object, Object> c, Function1<Object, Val> f, Context context) {
        Val val;
        Val val2 = x;
        if (ValNull$.MODULE$.equals(val2)) {
            val = this.withVal(y2, (Function1<Val, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(ValNull$.MODULE$, y)));
        } else {
            Val val3 = y2;
            ValNull$ valNull$ = ValNull$.MODULE$;
            if (!(val3 != null ? !val3.equals(valNull$) : valNull$ != null)) {
                val = f.apply(c.apply(val2, ValNull$.MODULE$));
            } else if (val2 instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal x2 = valNumber.value();
                val = this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x2, y)));
            } else if (val2 instanceof ValBoolean) {
                ValBoolean valBoolean = (ValBoolean)val2;
                boolean x3 = valBoolean.value();
                val = this.withBoolean(y2, (Function1<Object, Val> & Serializable & scala.Serializable)y -> FeelInterpreter.$anonfun$dualOpAny$3(c, f, x3, BoxesRunTime.unboxToBoolean(y)));
            } else if (val2 instanceof ValString) {
                ValString valString = (ValString)val2;
                String x4 = valString.value();
                val = this.withString(y2, (Function1<String, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x4, y)));
            } else if (val2 instanceof ValDate) {
                ValDate valDate = (ValDate)val2;
                LocalDate x5 = valDate.value();
                val = this.withDate(y2, (Function1<LocalDate, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x5, y)));
            } else if (val2 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val2;
                LocalTime x6 = valLocalTime.value();
                val = this.withLocalTime(y2, (Function1<LocalTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x6, y)));
            } else if (val2 instanceof ValTime) {
                ValTime valTime = (ValTime)val2;
                ZonedTime x7 = valTime.value();
                val = this.withTime(y2, (Function1<ZonedTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x7, y)));
            } else if (val2 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime x8 = valLocalDateTime.value();
                val = this.withLocalDateTime(y2, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x8, y)));
            } else if (val2 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                ZonedDateTime x9 = valDateTime.value();
                val = this.withDateTime(y2, (Function1<ZonedDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x9, y)));
            } else if (val2 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period x10 = valYearMonthDuration.value();
                val = this.withYearMonthDuration(y2, (Function1<Period, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x10, y)));
            } else if (val2 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                Duration x11 = valDayTimeDuration.value();
                val = this.withDayTimeDuration(y2, (Function1<Duration, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x11, y)));
            } else {
                val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Boolean, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
            }
        }
        return val;
    }

    private Val dualOp(Val x, Val y2, Function2<Compareable<?>, Compareable<?>, Object> c, Function1<Object, Val> f, Context context) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableNumber(x2), Compareable$.MODULE$.CompareableNumber((BigDecimal)y))));
        } else if (val2 instanceof ValDate) {
            ValDate valDate = (ValDate)val2;
            LocalDate x3 = valDate.value();
            val = this.withDate(y2, (Function1<LocalDate, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDate(x3), Compareable$.MODULE$.CompareableDate((LocalDate)y))));
        } else if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x4 = valLocalTime.value();
            val = this.withLocalTime(y2, (Function1<LocalTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalTime(x4), Compareable$.MODULE$.CompareableLocalTime((LocalTime)y))));
        } else if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            ZonedTime x5 = valTime.value();
            val = this.withTime(y2, (Function1<ZonedTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableTime(x5), Compareable$.MODULE$.CompareableTime((ZonedTime)y))));
        } else if (val2 instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x6 = valLocalDateTime.value();
            val = this.withLocalDateTime(y2, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalDateTime(x6), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)y))));
        } else if (val2 instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val2;
            ZonedDateTime x7 = valDateTime.value();
            val = this.withDateTime(y2, (Function1<ZonedDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDateTime(x7), Compareable$.MODULE$.CompareableDateTime((ZonedDateTime)y))));
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x8 = valYearMonthDuration.value();
            val = this.withYearMonthDuration(y2, (Function1<Period, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableYearMonthDuration(x8), Compareable$.MODULE$.CompareableYearMonthDuration((Period)y))));
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x9 = valDayTimeDuration.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDayTimeDuration(x9), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)y))));
        } else if (val2 instanceof ValString) {
            ValString valString = (ValString)val2;
            String x10 = valString.value();
            val = this.withString(y2, (Function1<String, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableString(x10), Compareable$.MODULE$.CompareableString((String)y))));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val addOp(Val x, Val y2) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValNumber> & Serializable & scala.Serializable)y -> new ValNumber(x2.$plus((BigDecimal)y)));
        } else if (val2 instanceof ValString) {
            ValString valString = (ValString)val2;
            String x3 = valString.value();
            val = this.withString(y2, (Function1<String, Val>)(Function1<String, ValString> & Serializable & scala.Serializable)y -> new ValString(x3 + y));
        } else if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x4 = valLocalTime.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val>)(Function1<Duration, ValLocalTime> & Serializable & scala.Serializable)y -> new ValLocalTime(x4.plus((TemporalAmount)y)));
        } else if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            ZonedTime x5 = valTime.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val>)(Function1<Duration, ValTime> & Serializable & scala.Serializable)y -> new ValTime(x5.plus((TemporalAmount)y)));
        } else if (val2 instanceof ValLocalDateTime) {
            scala.Serializable serializable;
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x6 = valLocalDateTime.value();
            Val val3 = y2;
            if (val3 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val3;
                Period y3 = valYearMonthDuration.value();
                serializable = new ValLocalDateTime(x6.plus(y3));
            } else if (val3 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val3;
                Duration y4 = valDayTimeDuration.value();
                serializable = new ValLocalDateTime(x6.plus(y4));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x6})));
            }
            val = serializable;
        } else if (val2 instanceof ValDateTime) {
            scala.Serializable serializable;
            ValDateTime valDateTime = (ValDateTime)val2;
            ZonedDateTime x7 = valDateTime.value();
            Val val4 = y2;
            if (val4 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val4;
                Period y5 = valYearMonthDuration.value();
                serializable = new ValDateTime(x7.plus(y5));
            } else if (val4 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                Duration y6 = valDayTimeDuration.value();
                serializable = new ValDateTime(x7.plus(y6));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x7})));
            }
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            scala.Serializable serializable;
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x8 = valYearMonthDuration.value();
            Val val5 = y2;
            if (val5 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration2 = (ValYearMonthDuration)val5;
                Period y7 = valYearMonthDuration2.value();
                serializable = new ValYearMonthDuration(x8.plus(y7).normalized());
            } else if (val5 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val5;
                LocalDateTime y8 = valLocalDateTime.value();
                serializable = new ValLocalDateTime(y8.plus(x8));
            } else if (val5 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val5;
                ZonedDateTime y9 = valDateTime.value();
                serializable = new ValDateTime(y9.plus(x8));
            } else if (val5 instanceof ValDate) {
                ValDate valDate = (ValDate)val5;
                LocalDate y10 = valDate.value();
                serializable = new ValDate(y10.plus(x8));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date-Time, Date, or Year-Month-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x8})));
            }
            val = serializable;
        } else if (val2 instanceof ValDayTimeDuration) {
            scala.Serializable serializable;
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x9 = valDayTimeDuration.value();
            Val val6 = y2;
            if (val6 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration2 = (ValDayTimeDuration)val6;
                Duration y11 = valDayTimeDuration2.value();
                serializable = new ValDayTimeDuration(x9.plus(y11));
            } else if (val6 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val6;
                LocalDateTime y12 = valLocalDateTime.value();
                serializable = new ValLocalDateTime(y12.plus(x9));
            } else if (val6 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val6;
                ZonedDateTime y13 = valDateTime.value();
                serializable = new ValDateTime(y13.plus(x9));
            } else if (val6 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val6;
                LocalTime y14 = valLocalTime.value();
                serializable = new ValLocalTime(y14.plus(x9));
            } else if (val6 instanceof ValTime) {
                ValTime valTime = (ValTime)val6;
                ZonedTime y15 = valTime.value();
                serializable = new ValTime(y15.plus(x9));
            } else if (val6 instanceof ValDate) {
                ValDate valDate = (ValDate)val6;
                LocalDate y16 = valDate.value();
                serializable = new ValDate(y16.atStartOfDay().plus(x9).toLocalDate());
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date-Time, Date, Time, or Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x9})));
            }
            val = serializable;
        } else if (val2 instanceof ValDate) {
            scala.Serializable serializable;
            ValDate valDate = (ValDate)val2;
            LocalDate x10 = valDate.value();
            Val val7 = y2;
            if (val7 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val7;
                Duration y17 = valDayTimeDuration.value();
                serializable = new ValDate(x10.atStartOfDay().plus(y17).toLocalDate());
            } else if (val7 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val7;
                Period y18 = valYearMonthDuration.value();
                serializable = new ValDate(x10.plus(y18));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x10})));
            }
            val = serializable;
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val subOp(Val x, Val y2) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValNumber> & Serializable & scala.Serializable)y -> new ValNumber(x2.$minus((BigDecimal)y)));
        } else if (val2 instanceof ValLocalTime) {
            scala.Serializable serializable;
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x3 = valLocalTime.value();
            Val val3 = y2;
            if (val3 instanceof ValLocalTime) {
                ValLocalTime valLocalTime2 = (ValLocalTime)val3;
                LocalTime y3 = valLocalTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y3, x3));
            } else if (val3 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val3;
                Duration y4 = valDayTimeDuration.value();
                serializable = new ValLocalTime(x3.minus(y4));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x3})));
            }
            val = serializable;
        } else if (val2 instanceof ValTime) {
            scala.Serializable serializable;
            ValTime valTime = (ValTime)val2;
            ZonedTime x4 = valTime.value();
            Val val4 = y2;
            if (val4 instanceof ValTime) {
                ValTime valTime2 = (ValTime)val4;
                ZonedTime y5 = valTime2.value();
                serializable = new ValDayTimeDuration(ZonedTime$.MODULE$.between(x4, y5));
            } else if (val4 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                Duration y6 = valDayTimeDuration.value();
                serializable = new ValTime(x4.minus(y6));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x4})));
            }
            val = serializable;
        } else if (val2 instanceof ValLocalDateTime) {
            scala.Serializable serializable;
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x5 = valLocalDateTime.value();
            Val val5 = y2;
            if (val5 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime2 = (ValLocalDateTime)val5;
                LocalDateTime y7 = valLocalDateTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y7, x5));
            } else if (val5 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val5;
                Period y8 = valYearMonthDuration.value();
                serializable = new ValLocalDateTime(x5.minus(y8));
            } else if (val5 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val5;
                Duration y9 = valDayTimeDuration.value();
                serializable = new ValLocalDateTime(x5.minus(y9));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x5})));
            }
            val = serializable;
        } else if (val2 instanceof ValDateTime) {
            scala.Serializable serializable;
            ValDateTime valDateTime = (ValDateTime)val2;
            ZonedDateTime x6 = valDateTime.value();
            Val val6 = y2;
            if (val6 instanceof ValDateTime) {
                ValDateTime valDateTime2 = (ValDateTime)val6;
                ZonedDateTime y10 = valDateTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y10, x6));
            } else if (val6 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val6;
                Period y11 = valYearMonthDuration.value();
                serializable = new ValDateTime(x6.minus(y11));
            } else if (val6 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val6;
                Duration y12 = valDayTimeDuration.value();
                serializable = new ValDateTime(x6.minus(y12));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x6})));
            }
            val = serializable;
        } else if (val2 instanceof ValDate) {
            scala.Serializable serializable;
            ValDate valDate = (ValDate)val2;
            LocalDate x7 = valDate.value();
            Val val7 = y2;
            if (val7 instanceof ValDate) {
                ValDate valDate2 = (ValDate)val7;
                LocalDate y13 = valDate2.value();
                serializable = new ValDayTimeDuration(Duration.between(y13.atStartOfDay(), x7.atStartOfDay()));
            } else if (val7 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val7;
                Period y14 = valYearMonthDuration.value();
                serializable = new ValDate(x7.minus(y14));
            } else if (val7 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val7;
                Duration y15 = valDayTimeDuration.value();
                serializable = new ValDate(x7.atStartOfDay().minus(y15).toLocalDate());
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x7})));
            }
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x8 = valYearMonthDuration.value();
            val = this.withYearMonthDuration(y2, (Function1<Period, Val>)(Function1<Period, ValYearMonthDuration> & Serializable & scala.Serializable)y -> new ValYearMonthDuration(x8.minus((TemporalAmount)y).normalized()));
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x9 = valDayTimeDuration.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val>)(Function1<Duration, ValDayTimeDuration> & Serializable & scala.Serializable)y -> new ValDayTimeDuration(x9.minus((Duration)y)));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val mulOp(Val x, Val y2) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            scala.Serializable serializable;
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            Val val3 = y2;
            if (val3 instanceof ValNumber) {
                ValNumber valNumber2 = (ValNumber)val3;
                BigDecimal y3 = valNumber2.value();
                serializable = new ValNumber(x2.$times(y3));
            } else if (val3 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val3;
                Period y4 = valYearMonthDuration.value();
                serializable = new ValYearMonthDuration(y4.multipliedBy(x2.intValue()).normalized());
            } else if (val3 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val3;
                Duration y5 = valDayTimeDuration.value();
                serializable = new ValDayTimeDuration(y5.multipliedBy(x2.intValue()));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Number, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x2})));
            }
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x3 = valYearMonthDuration.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValYearMonthDuration> & Serializable & scala.Serializable)y -> new ValYearMonthDuration(x3.multipliedBy(y.intValue()).normalized()));
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x4 = valDayTimeDuration.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValDayTimeDuration> & Serializable & scala.Serializable)y -> new ValDayTimeDuration(x4.multipliedBy(y.intValue())));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val divOp(Val x, Val y2) {
        return this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> {
            scala.Serializable serializable;
            if (BoxesRunTime.equalsNumObject(y, BoxesRunTime.boxToInteger(0))) {
                serializable = new ValError("division by zero");
            } else {
                scala.Serializable serializable2;
                Val val = x;
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal x = valNumber.value();
                    serializable2 = new ValNumber(x.$div((BigDecimal)y));
                } else if (val instanceof ValYearMonthDuration) {
                    ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val;
                    Period x = valYearMonthDuration.value();
                    serializable2 = new ValYearMonthDuration(Period.ofMonths(BigDecimal$.MODULE$.long2bigDecimal(x.toTotalMonths()).$div((BigDecimal)y).intValue()).normalized());
                } else if (val instanceof ValDayTimeDuration) {
                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
                    Duration x = valDayTimeDuration.value();
                    serializable2 = new ValDayTimeDuration(Duration.ofMillis(BigDecimal$.MODULE$.long2bigDecimal(x.toMillis()).$div((BigDecimal)y).intValue()));
                } else {
                    serializable2 = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
                }
                serializable = serializable2;
            }
            return serializable;
        });
    }

    private Val withFunction(Val x, Function1<ValFunction, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValFunction) {
            ValFunction valFunction = (ValFunction)val2;
            val = f.apply(valFunction);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Function but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    /*
     * Unable to fully structure code
     */
    private Val invokeFunction(ValFunction function, FunctionParameters params, Context context) {
        block9: {
            block4: {
                block8: {
                    block5: {
                        block7: {
                            block6: {
                                var7_4 = params;
                                if (!(var7_4 instanceof PositionalFunctionParameters)) break block4;
                                var8_5 = (PositionalFunctionParameters)var7_4;
                                params = var8_5.params();
                                if (!function.hasVarArgs() || function.params().size() <= 0) break block5;
                                size = function.params().size() - 1;
                                args = params.take(size).map((Function1<Exp, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$1(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context org.camunda.feel.parser.Exp ), (Lorg/camunda/feel/parser/Exp;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context), List$.MODULE$.canBuildFrom());
                                var13_9 = params.drop(size).map((Function1<Exp, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$2(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context org.camunda.feel.parser.Exp ), (Lorg/camunda/feel/parser/Exp;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context), List$.MODULE$.canBuildFrom());
                                if (!Nil$.MODULE$.equals(var13_9)) break block6;
                                var5_10 = new ValList(Nil$.MODULE$);
                                break block7;
                            }
                            if (!(var13_9 instanceof $colon$colon)) ** GOTO lbl-1000
                            var14_11 = ($colon$colon)var13_9;
                            var15_12 = (Val)var14_11.head();
                            var16_13 = var14_11.tl$access$1();
                            if (!(var15_12 instanceof ValList)) ** GOTO lbl-1000
                            var17_14 = (ValList)var15_12;
                            list = var17_14.items();
                            if (Nil$.MODULE$.equals(var16_13) && size == 0) {
                                var5_10 = new ValList(list);
                            } else lbl-1000:
                            // 3 sources

                            {
                                var5_10 = new ValList(var13_9);
                            }
                        }
                        varArgs = var5_10;
                        v0 = args.$colon$plus(varArgs, List$.MODULE$.canBuildFrom());
                        break block8;
                    }
                    v0 = params.map((Function1<Exp, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$3(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context org.camunda.feel.parser.Exp ), (Lorg/camunda/feel/parser/Exp;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context), List$.MODULE$.canBuildFrom());
                }
                var4_17 = v0;
                break block9;
            }
            if (var7_4 instanceof NamedFunctionParameters) {
                var19_18 = (NamedFunctionParameters)var7_4;
                params = var19_18.params();
                var4_17 = function.params().map((Function1<String, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$4(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context scala.collection.immutable.Map java.lang.String ), (Ljava/lang/String;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context, params), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(var7_4);
            }
        }
        paramList = var4_17;
        return function.invoke().apply(paramList);
    }

    private Val findFunction(Context ctx, String name, FunctionParameters params) {
        Val val;
        FunctionParameters functionParameters = params;
        if (functionParameters instanceof PositionalFunctionParameters) {
            PositionalFunctionParameters positionalFunctionParameters = (PositionalFunctionParameters)functionParameters;
            List<Exp> params2 = positionalFunctionParameters.params();
            val = ctx.function(name, params2.size());
        } else if (functionParameters instanceof NamedFunctionParameters) {
            NamedFunctionParameters namedFunctionParameters = (NamedFunctionParameters)functionParameters;
            Map<String, Exp> params3 = namedFunctionParameters.params();
            val = ctx.function(name, params3.keySet());
        } else {
            throw new MatchError(functionParameters);
        }
        return val;
    }

    private Map<String, List<ValFunction>> addFunction(Map<String, List<ValFunction>> functions, String name, ValFunction f) {
        List functionsByName = (List)functions.getOrElse(name, (Function0<List> & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        ValFunction valFunction = f;
        return functions.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), functionsByName.$colon$colon(valFunction)));
    }

    private Val withType(Val x, Function1<String, ValBoolean> f) {
        Val val = x;
        Val val2 = val instanceof ValNumber ? (Val)f.apply("number") : (val instanceof ValBoolean ? (Val)f.apply("boolean") : (val instanceof ValString ? (Val)f.apply("string") : (val instanceof ValDate ? (Val)f.apply("date") : (val instanceof ValLocalTime ? (Val)f.apply("time") : (val instanceof ValTime ? (Val)f.apply("time") : (val instanceof ValLocalDateTime ? (Val)f.apply("date time") : (val instanceof ValDateTime ? (Val)f.apply("date time") : (val instanceof ValYearMonthDuration ? (Val)f.apply("year-month-duration") : (val instanceof ValDayTimeDuration ? (Val)f.apply("day-time-duration") : (ValNull$.MODULE$.equals(val) ? (Val)f.apply("null") : (val instanceof ValList ? (Val)f.apply("list") : (val instanceof ValContext ? (Val)f.apply("context") : (val instanceof ValFunction ? (Val)f.apply("function") : this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected type '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x.getClass().getName()}))))))))))))))));
        return val2;
    }

    private Val withList(Val x, Function1<ValList, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValList) {
            ValList valList = (ValList)val2;
            val = f.apply(valList);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect List but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withLists(List<Tuple2<String, Val>> lists, Function1<List<Tuple2<String, ValList>>, Val> f, Context context) {
        Val val;
        Val e;
        Some some;
        Tuple2 tuple2;
        Option option = ((LinearSeqOptimized)lists.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Val it = (Val)tuple2._2();
            Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), this.withList(it, (Function1<ValList, Val>)(Function1<ValList, ValList> & Serializable & scala.Serializable)list -> list));
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).find((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$withLists$3(x$31)));
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null && (e = (Val)tuple2._2()) != null) {
            Val val2;
            val = val2 = e;
        } else if (None$.MODULE$.equals(option)) {
            val = f.apply(lists);
        } else {
            throw new MatchError(option);
        }
        return val;
    }

    private Val withCartesianProduct(List<Tuple2<String, Exp>> iterators, Function1<List<Map<String, Val>>, Val> f, Context context) {
        return this.withLists(iterators.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Exp it = (Exp)tuple2._2();
            Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), this.eval(it, context));
            return tuple22;
        }, List$.MODULE$.canBuildFrom()), (Function1<List<Tuple2<String, ValList>>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)lists -> (Val)f.apply(this.flattenAndZipLists((List<Tuple2<String, ValList>>)lists)), context);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private List<Map<String, Val>> flattenAndZipLists(List<Tuple2<String, ValList>> lists) {
        void var2_8;
        boolean bl = false;
        $colon$colon $colon$colon = null;
        List<Tuple2<String, ValList>> list = lists;
        if (((Object)Nil$.MODULE$).equals(list)) {
            Nil$ nil$ = Nil$.MODULE$;
            return var2_8;
        }
        if (list instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)list;
            Tuple2 tuple2 = (Tuple2)$colon$colon.head();
            List list2 = $colon$colon.tl$access$1();
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                ValList list3 = (ValList)tuple2._2();
                if (((Object)Nil$.MODULE$).equals(list2)) {
                    List list4 = list3.items().map((Function1<Val, Map> & Serializable & scala.Serializable)v -> (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), v)})), List$.MODULE$.canBuildFrom());
                    return var2_8;
                }
            }
        }
        if (!bl) throw new MatchError(list);
        Tuple2 tuple2 = (Tuple2)$colon$colon.head();
        List tail = $colon$colon.tl$access$1();
        if (tuple2 == null) throw new MatchError(list);
        String name = (String)tuple2._1();
        ValList list5 = (ValList)tuple2._2();
        List list6 = list5.items().flatMap((Function1<Val, List> & Serializable & scala.Serializable)v -> this.flattenAndZipLists(tail).map((Function1<Map, Map> & Serializable & scala.Serializable)values -> values.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), v)), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return var2_8;
    }

    private Val filterList(List<Val> list, Function1<Val, Val> filter) {
        Val val;
        List<Val> list2 = list;
        if (((Object)Nil$.MODULE$).equals(list2)) {
            val = new ValList(Nil$.MODULE$);
        } else if (list2 instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            Val x = (Val)$colon$colon.head();
            List xs = $colon$colon.tl$access$1();
            val = this.withBoolean(filter.apply(x), (Function1<Object, Val> & Serializable & scala.Serializable)x$32 -> FeelInterpreter.$anonfun$filterList$1(this, filter, x, xs, BoxesRunTime.unboxToBoolean(x$32)));
        } else {
            throw new MatchError(list2);
        }
        return val;
    }

    private Val filterList(List<Val> list, BigDecimal index) {
        BigDecimal i = index.$greater(BigDecimal$.MODULE$.int2bigDecimal(0)) ? index.$minus(BigDecimal$.MODULE$.int2bigDecimal(1)) : BigDecimal$.MODULE$.int2bigDecimal(list.size()).$plus(index);
        return i.$less(BigDecimal$.MODULE$.int2bigDecimal(0)) || i.$greater$eq(BigDecimal$.MODULE$.int2bigDecimal(list.size())) ? ValNull$.MODULE$ : list.apply(i.toInt());
    }

    private Val withContext(Val x, Function1<ValContext, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValContext) {
            ValContext valContext = (ValContext)val2;
            val = f.apply(valContext);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Context but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Context filterContext(Val x, Context context) {
        Context context2;
        ValContext valContext;
        Context ctx;
        Val val = x;
        if (val instanceof ValContext && (ctx = (valContext = (ValContext)val).context()) != null) {
            Context context3 = ctx;
            context2 = CompositeContext$.MODULE$.ContextComposition(CompositeContext$.MODULE$.ContextComposition(context).$plus(context3)).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("item"), x));
        } else {
            context2 = CompositeContext$.MODULE$.ContextComposition(context).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("item"), val));
        }
        return context2;
    }

    private Val ref(Val x, List<String> names, Context context) {
        Val val;
        List<String> list = names;
        if (((Object)Nil$.MODULE$).equals(list)) {
            val = x;
        } else if (list instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            String n = (String)$colon$colon.head();
            List ns = $colon$colon.tl$access$1();
            val = this.withContext(x, (Function1<ValContext, Val> & Serializable & scala.Serializable)x0$3 -> {
                Val val;
                ValContext valContext = x0$3;
                if (valContext != null) {
                    Val val2;
                    ValContext valContext2 = valContext;
                    Val val3 = valContext2.context().variable(n);
                    if (val3 instanceof ValError) {
                        val2 = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
                    } else if (val3 != null) {
                        Val val4 = val3;
                        val2 = this.ref(val4, ns, context);
                    } else {
                        val2 = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
                    }
                    val = val2;
                } else {
                    val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
                }
                return val;
            });
        } else {
            throw new MatchError(list);
        }
        return val;
    }

    private Val path(Val v, String key) {
        Val val;
        Val val2 = v;
        if (val2 instanceof ValContext) {
            Val val3;
            ValContext valContext = (ValContext)val2;
            Val val4 = valContext.context().variable(key);
            Val val5 = val4 instanceof ValError ? new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key}))) : (val4 != null ? (val3 = val4) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key}))));
            val = val5;
        } else if (val2 instanceof ValList) {
            ValList valList = (ValList)val2;
            List<Val> list = valList.items();
            val = new ValList(list.map((Function1<Val, Val> & Serializable & scala.Serializable)item -> this.path((Val)item, key), List$.MODULE$.canBuildFrom()));
        } else if (val2 instanceof ValDate) {
            ValDate valDate = (ValDate)val2;
            LocalDate date = valDate.value();
            String string = key;
            scala.Serializable serializable = "year".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(date.getYear())) : ("month".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(date.getMonthValue())) : ("day".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(date.getDayOfMonth())) : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the date properies {year, month, day} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string})))));
            val = serializable;
        } else if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            ZonedTime time = valTime.value();
            String string = key;
            Val val6 = "hour".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(time.getHour())) : ("minute".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(time.getMinute())) : ("second".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(time.getSecond())) : ("time_offset".equals(string) ? new ValDayTimeDuration(Duration.ofSeconds(time.getOffsetInTotalSeconds())) : ("timezone".equals(string) ? (Val)time.getZoneId().map((Function1<String, ValString> & Serializable & scala.Serializable)x$34 -> new ValString((String)x$34)).getOrElse((Function0<ValNull$> & Serializable & scala.Serializable)() -> ValNull$.MODULE$) : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the time properies {hour, minute, second, time_offset, timezone} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string})))))));
            val = val6;
        } else if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime time = valLocalTime.value();
            String string = key;
            scala.Serializable serializable = "hour".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(time.getHour())) : ("minute".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(time.getMinute())) : ("second".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(time.getSecond())) : ("time_offset".equals(string) ? ValNull$.MODULE$ : ("timezone".equals(string) ? ValNull$.MODULE$ : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the (local) time properies {hour, minute, second} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string})))))));
            val = serializable;
        } else if (val2 instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val2;
            ZonedDateTime dateTime = valDateTime.value();
            String string = key;
            scala.Serializable serializable = "year".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getYear())) : ("month".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getMonthValue())) : ("day".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getDayOfMonth())) : ("hour".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getHour())) : ("minute".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getMinute())) : ("second".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getSecond())) : ("time_offset".equals(string) ? new ValDayTimeDuration(Duration.ofSeconds(dateTime.getOffset().getTotalSeconds())) : ("timezone".equals(string) ? (this.hasTimeZone(dateTime) ? new ValString(dateTime.getZone().getId()) : ValNull$.MODULE$) : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the date-time properies {year, month, day, hour, minute, second, time_offset, timezone} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string}))))))))));
            val = serializable;
        } else if (val2 instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime dateTime = valLocalDateTime.value();
            String string = key;
            scala.Serializable serializable = "year".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getYear())) : ("month".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getMonthValue())) : ("day".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getDayOfMonth())) : ("hour".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getHour())) : ("minute".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getMinute())) : ("second".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dateTime.getSecond())) : ("time_offset".equals(string) ? ValNull$.MODULE$ : ("timezone".equals(string) ? ValNull$.MODULE$ : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the (local) date-time properies {year, month, day, hour, minute, second} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string}))))))))));
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period duration = valYearMonthDuration.value();
            String string = key;
            scala.Serializable serializable = "years".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(duration.getYears())) : ("months".equals(string) ? new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(duration.getMonths())) : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the duration properies {years, months} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string}))));
            val = serializable;
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration duration = valDayTimeDuration.value();
            String string = key;
            scala.Serializable serializable = "days".equals(string) ? new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(duration.toDays())) : ("hours".equals(string) ? new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(duration.toHours() % 24L)) : ("minutes".equals(string) ? new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(duration.toMinutes() % 60L)) : ("seconds".equals(string) ? new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(duration.getSeconds() % 60L)) : this.error(v, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected one of the duration properies {days, hours, minutes, seconds} but fount '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string}))))));
            val = serializable;
        } else {
            val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Context or List of Contextes but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val2})));
        }
        return val;
    }

    private boolean hasTimeZone(ZonedDateTime dateTime) {
        return !dateTime.getOffset().equals(dateTime.getZone());
    }

    private Val evalContextEntry(String key, Exp exp, Context context) {
        return this.withVal(this.eval(exp, context), (Function1<Val, Val> & Serializable & scala.Serializable)value -> value);
    }

    private Val invokeJavaFunction(String className2, String methodName, List<String> arguments, List<Val> paramValues, ValueMapper valueMapper) {
        Val val;
        try {
            Class<?> clazz = JavaClassMapper$.MODULE$.loadClass(className2);
            List argTypes = arguments.map((Function1<String, Class> & Serializable & scala.Serializable)className -> JavaClassMapper$.MODULE$.loadClass((String)className), List$.MODULE$.canBuildFrom());
            Method method = clazz.getDeclaredMethod(methodName, (Class[])argTypes.toArray(ClassTag$.MODULE$.apply(Class.class)));
            List<?> argValues = paramValues.map((Function1<Val, Object> & Serializable & scala.Serializable)value -> valueMapper.unpackVal((Val)value), List$.MODULE$.canBuildFrom());
            List argJavaObjects = argValues.zip(argTypes, List$.MODULE$.canBuildFrom()).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object obj = tuple2._1();
                Class clazz = (Class)tuple2._2();
                Object object = JavaClassMapper$.MODULE$.asJavaObject(obj, clazz);
                return object;
            }, List$.MODULE$.canBuildFrom());
            Object result = method.invoke(null, (Object[])argJavaObjects.toArray(ClassTag$.MODULE$.Object()));
            val = valueMapper.toVal(result);
        }
        catch (ClassNotFoundException e) {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to load class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{className2})));
        }
        catch (NoSuchMethodException e) {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to get method with name '", "' and arguments '", "' from class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{methodName, arguments, className2})));
        }
        catch (Throwable throwable) {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to invoke method with name '", "' and arguments '", "' from class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{methodName, arguments, className2})));
        }
        return val;
    }

    public static final /* synthetic */ boolean $anonfun$eval$4(Object x$1, Object x$2) {
        return BoxesRunTime.equals(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$eval$11(Object x$13, Object x$14) {
        return BoxesRunTime.equals(x$13, x$14);
    }

    public static final /* synthetic */ ValBoolean $anonfun$eval$16(boolean x) {
        return new ValBoolean(!x);
    }

    public static final /* synthetic */ Val $anonfun$eval$17(FeelInterpreter $this, Context context$1, Exp statement$1, Exp elseStatement$1, boolean isMet) {
        return isMet ? $this.eval(statement$1, context$1) : $this.eval(elseStatement$1, context$1);
    }

    public static final /* synthetic */ Val $anonfun$unaryOpAny$4(Function2 c$1, Function1 f$1, boolean i$2, boolean x) {
        return (Val)f$1.apply(c$1.apply(BoxesRunTime.boxToBoolean(i$2), BoxesRunTime.boxToBoolean(x)));
    }

    public static final /* synthetic */ boolean $anonfun$isInInterval$1(Interval interval$1, Compareable i, Compareable x, Compareable y) {
        boolean bl;
        boolean bl2;
        IntervalBoundary intervalBoundary = interval$1.start();
        if (intervalBoundary instanceof OpenIntervalBoundary) {
            bl2 = i.$greater(x);
        } else if (intervalBoundary instanceof ClosedIntervalBoundary) {
            bl2 = i.$greater$eq(x);
        } else {
            throw new MatchError(intervalBoundary);
        }
        boolean inStart = bl2;
        IntervalBoundary intervalBoundary2 = interval$1.end();
        if (intervalBoundary2 instanceof OpenIntervalBoundary) {
            bl = i.$less(y);
        } else if (intervalBoundary2 instanceof ClosedIntervalBoundary) {
            bl = i.$less$eq(y);
        } else {
            throw new MatchError(intervalBoundary2);
        }
        boolean inEnd = bl;
        return inStart && inEnd;
    }

    public static final /* synthetic */ Val $anonfun$dualOpAny$3(Function2 c$4, Function1 f$5, boolean x$41, boolean y) {
        return (Val)f$5.apply(c$4.apply(BoxesRunTime.boxToBoolean(x$41), BoxesRunTime.boxToBoolean(y)));
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$1(FeelInterpreter $this, Context context$9, Exp expression) {
        return $this.eval(expression, context$9);
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$2(FeelInterpreter $this, Context context$9, Exp expression) {
        return $this.eval(expression, context$9);
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$3(FeelInterpreter $this, Context context$9, Exp expression) {
        return $this.eval(expression, context$9);
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$4(FeelInterpreter $this, Context context$9, Map params$4, String p) {
        return (Val)params$4.get(p).map((Function1<Exp, Val> & Serializable & scala.Serializable)expression -> $this.eval((Exp)expression, context$9)).getOrElse((Function0<ValNull$> & Serializable & scala.Serializable)() -> ValNull$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$withLists$3(Tuple2 x$31) {
        return x$31._2() instanceof ValError;
    }

    public static final /* synthetic */ Val $anonfun$filterList$1(FeelInterpreter $this, Function1 filter$2, Val x$68, List xs$1, boolean x$32) {
        Val val;
        boolean bl = x$32;
        if (!bl) {
            val = $this.filterList((List<Val>)xs$1, filter$2);
        } else if (bl) {
            val = $this.withList($this.filterList((List<Val>)xs$1, filter$2), (Function1<ValList, Val>)(Function1<ValList, ValList> & Serializable & scala.Serializable)l -> {
                Val val = x$68;
                return new ValList(l.items().$colon$colon(val));
            });
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return val;
    }
}

