/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.AbstractHotspotProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;
import sun.management.HotspotRuntimeMBean;
import sun.management.counter.Counter;

public class HotspotRuntimeProfiler
extends AbstractHotspotProfiler {
    public List<Counter> getCounters() {
        return ((HotspotRuntimeMBean)AbstractHotspotProfiler.getInstance("HotspotRuntimeMBean")).getInternalRuntimeCounters();
    }

    @Override
    public String getDescription() {
        return "HotSpot (tm) runtime profiling via implementation-specific MBeans";
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        Map<String, Long> current = this.counters().getCurrent();
        return Arrays.asList(new ScalarResult("\u00b7rt.sync.fatMonitors", current.get("sun.rt._sync_MonExtant").longValue(), "monitors", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.sync.monitorInflations", current.get("sun.rt._sync_Inflations").longValue(), "monitors", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.sync.monitorDeflations", current.get("sun.rt._sync_Deflations").longValue(), "monitors", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.sync.contendedLockAttempts", current.get("sun.rt._sync_ContendedLockAttempts").longValue(), "locks", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.sync.parks", current.get("sun.rt._sync_Parks").longValue(), "counts", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.sync.notifications", current.get("sun.rt._sync_Notifications").longValue(), "counts", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.sync.futileWakeups", current.get("sun.rt._sync_FutileWakeups").longValue(), "counts", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.safepoints", current.get("sun.rt.safepoints").longValue(), "counts", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.safepointSyncTime", (double)current.get("sun.rt.safepointSyncTime").longValue() * 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L), "ms", AggregationPolicy.MAX), new ScalarResult("\u00b7rt.safepointTime", (double)current.get("sun.rt.safepointTime").longValue() * 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L), "ms", AggregationPolicy.MAX));
    }
}

