/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.runner.InfraControlL1;

abstract class InfraControlL2
extends InfraControlL1 {
    public volatile boolean isDone;
    public volatile boolean isFailing;
    public volatile boolean volatileSpoiler;
    public final CountDownLatch preSetup;
    public final CountDownLatch preTearDown;
    public final boolean lastIteration;
    public final AtomicInteger warmupVisited = new AtomicInteger();
    public final AtomicInteger warmdownVisited = new AtomicInteger();
    public volatile boolean warmupShouldWait;
    public volatile boolean warmdownShouldWait;
    public final CountDownLatch warmupDone = new CountDownLatch(1);
    public final CountDownLatch warmdownDone = new CountDownLatch(1);
    public final BenchmarkParams benchmarkParams;
    public final IterationParams iterationParams;
    public final Control notifyControl;
    private final boolean shouldSynchIterations;
    private final int threads;

    public InfraControlL2(BenchmarkParams benchmarkParams, IterationParams iterationParams, CountDownLatch preSetup, CountDownLatch preTearDown, boolean lastIteration, Control notifyControl) {
        this.shouldSynchIterations = benchmarkParams.shouldSynchIterations();
        this.threads = benchmarkParams.getThreads();
        this.warmupShouldWait = this.shouldSynchIterations;
        this.warmdownShouldWait = this.shouldSynchIterations;
        this.notifyControl = notifyControl;
        this.preSetup = preSetup;
        this.preTearDown = preTearDown;
        this.lastIteration = lastIteration;
        this.benchmarkParams = benchmarkParams;
        this.iterationParams = iterationParams;
    }

    public void announceWarmupReady() {
        if (!this.shouldSynchIterations) {
            return;
        }
        int v = this.warmupVisited.incrementAndGet();
        if (v == this.threads) {
            this.warmupShouldWait = false;
            this.warmupDone.countDown();
        }
        if (v > this.threads) {
            throw new IllegalStateException("More threads than expected");
        }
    }

    public void announceWarmdownReady() {
        if (!this.shouldSynchIterations) {
            return;
        }
        int v = this.warmdownVisited.incrementAndGet();
        if (v == this.threads) {
            this.warmdownShouldWait = false;
            this.warmdownDone.countDown();
        }
        if (v > this.threads) {
            throw new IllegalStateException("More threads than expected");
        }
    }

    public void awaitWarmupReady() {
        if (this.warmupShouldWait) {
            try {
                this.warmupDone.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void awaitWarmdownReady() {
        if (this.warmdownShouldWait) {
            try {
                this.warmdownDone.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getParam(String name) {
        String param2 = this.benchmarkParams.getParam(name);
        if (param2 == null) {
            throw new IllegalStateException("The value for the parameter \"" + name + "\" is not set.");
        }
        return param2;
    }
}

