/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.impl.builtin;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import org.camunda.feel.FeelEngineClock;
import org.camunda.feel.impl.builtin.BuiltinFunction$;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValDate;
import org.camunda.feel.syntaxtree.ValDateTime;
import org.camunda.feel.syntaxtree.ValFunction;
import org.camunda.feel.syntaxtree.ValLocalDateTime;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005M4Aa\u0003\u0007\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003D\u0001\u0011%A\tC\u0003F\u0001\u0011%A\tC\u0003G\u0001\u0011%q\tC\u0003a\u0001\u0011%\u0011\rC\u0003h\u0001\u0011%\u0001\u000eC\u0003n\u0001\u0011%a\u000eC\u0003q\u0001\u0011%\u0011O\u0001\rUK6\u0004xN]1m\u0005VLG\u000e^5o\rVt7\r^5p]NT!!\u0004\b\u0002\u000f\t,\u0018\u000e\u001c;j]*\u0011q\u0002E\u0001\u0005S6\u0004HN\u0003\u0002\u0012%\u0005!a-Z3m\u0015\t\u0019B#A\u0004dC6,h\u000eZ1\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019Gn\\2l!\t\u0001\u0013%D\u0001\u0011\u0013\t\u0011\u0003CA\bGK\u0016dWI\\4j]\u0016\u001cEn\\2l\u0003\u0019a\u0014N\\5u}Q\u0011Qe\n\t\u0003M\u0001i\u0011\u0001\u0004\u0005\u0006=\t\u0001\raH\u0001\nMVt7\r^5p]N,\u0012A\u000b\t\u0005WA\u0012$(D\u0001-\u0015\tic&A\u0005j[6,H/\u00192mK*\u0011qFG\u0001\u000bG>dG.Z2uS>t\u0017BA\u0019-\u0005\ri\u0015\r\u001d\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001\\1oO*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u0019\u0019FO]5oOB\u00191fO\u001f\n\u0005qb#\u0001\u0002'jgR\u0004\"AP!\u000e\u0003}R!\u0001\u0011\t\u0002\u0015MLh\u000e^1yiJ,W-\u0003\u0002C\u007f\tYa+\u00197Gk:\u001cG/[8o\u0003-qwn\u001e$v]\u000e$\u0018n\u001c8\u0016\u0003u\nQ\u0002^8eCf4UO\\2uS>t\u0017\u0001\u00053bi\u0016$\u0016.\\3Gk:\u001cG/[8o)\ti\u0004\nC\u0003J\r\u0001\u0007!*\u0001\u0005gk:\u001cG/[8o!\u0011I2*T/\n\u00051S\"!\u0003$v]\u000e$\u0018n\u001c82!\tq%L\u0004\u0002P1:\u0011\u0001k\u0016\b\u0003#Zs!AU+\u000e\u0003MS!\u0001\u0016\f\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA\n\u0015\u0013\t\t\"#\u0003\u0002Z!\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005\u0011!\u0015\r^3\u000b\u0005e\u0003\u0002C\u0001 _\u0013\tyvHA\u0002WC2\fAbZ3u\t\u0006LxJZ-fCJ$\"AY3\u0011\u0005y\u001a\u0017B\u00013@\u0005%1\u0016\r\u001c(v[\n,'\u000fC\u0003g\u000f\u0001\u0007Q*\u0001\u0003eCR,\u0017\u0001D4fi\u0012\u000b\u0017p\u00144XK\u0016\\GCA5m!\tq$.\u0003\u0002l\u007f\tIa+\u00197TiJLgn\u001a\u0005\u0006M\"\u0001\r!T\u0001\u000fO\u0016$Xj\u001c8uQ>3\u0017,Z1s)\tIw\u000eC\u0003g\u0013\u0001\u0007Q*A\u0007hKR<V-Z6PMf+\u0017M\u001d\u000b\u0003EJDQA\u001a\u0006A\u00025\u0003")
public class TemporalBuiltinFunctions {
    public final FeelEngineClock org$camunda$feel$impl$builtin$TemporalBuiltinFunctions$$clock;

    public Map<String, List<ValFunction>> functions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("now"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.nowFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("today"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.todayFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("day of year"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.dateTimeFunction((Function1<LocalDate, Val>)(Function1<LocalDate, ValNumber> & Serializable)date -> this.getDayOfYear((LocalDate)date))}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("day of week"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.dateTimeFunction((Function1<LocalDate, Val>)(Function1<LocalDate, ValString> & Serializable)date -> this.getDayOfWeek((LocalDate)date))}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("month of year"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.dateTimeFunction((Function1<LocalDate, Val>)(Function1<LocalDate, ValString> & Serializable)date -> this.getMonthOfYear((LocalDate)date))}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("week of year"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.dateTimeFunction((Function1<LocalDate, Val>)(Function1<LocalDate, ValNumber> & Serializable)date -> this.getWeekOfYear((LocalDate)date))})))}));
    }

    private ValFunction nowFunction() {
        return BuiltinFunction$.MODULE$.builtinFunction((List<String>)package$.MODULE$.List().empty(), (PartialFunction<List<Val>, Object>)((Object)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TemporalBuiltinFunctions $outer;

            public final <A1 extends List<Val>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                ZonedDateTime now = this.$outer.org$camunda$feel$impl$builtin$TemporalBuiltinFunctions$$clock.getCurrentTime();
                ValDateTime valDateTime = new ValDateTime(now);
                return (B1)valDateTime;
            }

            public final boolean isDefinedAt(List<Val> x1) {
                List<Val> list = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), BuiltinFunction$.MODULE$.builtinFunction$default$3());
    }

    private ValFunction todayFunction() {
        return BuiltinFunction$.MODULE$.builtinFunction((List<String>)package$.MODULE$.List().empty(), (PartialFunction<List<Val>, Object>)((Object)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TemporalBuiltinFunctions $outer;

            public final <A1 extends List<Val>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                LocalDate today = this.$outer.org$camunda$feel$impl$builtin$TemporalBuiltinFunctions$$clock.getCurrentTime().toLocalDate();
                ValDate valDate = new ValDate(today);
                return (B1)valDate;
            }

            public final boolean isDefinedAt(List<Val> x1) {
                List<Val> list = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), BuiltinFunction$.MODULE$.builtinFunction$default$3());
    }

    private ValFunction dateTimeFunction(Function1<LocalDate, Val> function) {
        return BuiltinFunction$.MODULE$.builtinFunction((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date"})), (PartialFunction<List<Val>, Object>)((Object)new Serializable(null, function){
            private static final long serialVersionUID = 0L;
            private final Function1 function$1;

            public final <A1 extends List<Val>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Val val;
                SeqOps seqOps;
                Val val2;
                SeqOps seqOps2;
                Object object;
                Val val3;
                SeqOps seqOps3;
                A1 A1 = x1;
                if (A1 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.List().unapplySeq(A1)) && new SeqFactory.UnapplySeqWrapper<A>(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValDate) {
                    ValDate valDate = (ValDate)val3;
                    LocalDate date = valDate.value();
                    object = this.function$1.apply(date);
                } else if (A1 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq(A1)) && new SeqFactory.UnapplySeqWrapper<A>(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val2;
                    ZonedDateTime date = valDateTime.value();
                    object = this.function$1.apply(date.toLocalDate());
                } else if (A1 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq(A1)) && new SeqFactory.UnapplySeqWrapper<A>(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime date = valLocalDateTime.value();
                    object = this.function$1.apply(date.toLocalDate());
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(List<Val> x1) {
                Val val;
                SeqOps seqOps;
                Val val2;
                SeqOps seqOps2;
                Val val3;
                SeqOps seqOps3;
                List<Val> list = x1;
                boolean bl = list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.List().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper<A>(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValDate ? true : (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper<A>(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValDateTime ? true : list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper<A>(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValLocalDateTime);
                return bl;
            }
            {
                this.function$1 = function$1;
            }
        }), BuiltinFunction$.MODULE$.builtinFunction$default$3());
    }

    private ValNumber getDayOfYear(LocalDate date) {
        int dayOfYear = date.getDayOfYear();
        return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(dayOfYear));
    }

    private ValString getDayOfWeek(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        String displayName = dayOfWeek.getDisplayName(TextStyle.FULL, Locale.ENGLISH);
        return new ValString(displayName);
    }

    private ValString getMonthOfYear(LocalDate date) {
        Month month = date.getMonth();
        String displayName = month.getDisplayName(TextStyle.FULL, Locale.ENGLISH);
        return new ValString(displayName);
    }

    private ValNumber getWeekOfYear(LocalDate date) {
        TemporalField temporalField = WeekFields.ISO.weekOfWeekBasedYear();
        int weekOfYear = date.get(temporalField);
        return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(weekOfYear));
    }

    public TemporalBuiltinFunctions(FeelEngineClock clock) {
        this.org$camunda$feel$impl$builtin$TemporalBuiltinFunctions$$clock = clock;
    }
}

