/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.runner.InfraControlL4;
import org.openjdk.jmh.util.Utils;

public class InfraControl
extends InfraControlL4 {
    public InfraControl(BenchmarkParams benchmarkParams, IterationParams iterationParams, CountDownLatch preSetup, CountDownLatch preTearDown, boolean lastIteration, Control notifyControl) {
        super(benchmarkParams, iterationParams, preSetup, preTearDown, lastIteration, notifyControl);
    }

    public long getDuration() {
        return this.getDuration(TimeUnit.MILLISECONDS);
    }

    public long getDuration(TimeUnit unit) {
        return this.iterationParams.getTime().convertTo(unit);
    }

    public void preSetup() {
        try {
            this.preSetup.countDown();
            this.preSetup.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void preTearDown() throws InterruptedException {
        this.preTearDown.countDown();
        this.preTearDown.await();
    }

    public void preSetupForce() {
        this.preSetup.countDown();
    }

    public void preTearDownForce() {
        this.preTearDown.countDown();
    }

    public boolean isLastIteration() {
        return this.lastIteration;
    }

    public void announceDone() {
        this.isDone = true;
        this.notifyControl.stopMeasurement = true;
    }

    static {
        Utils.check(InfraControl.class, "isDone", "isFailing");
        Utils.check(InfraControl.class, "volatileSpoiler");
        Utils.check(InfraControl.class, "preSetup", "preTearDown");
        Utils.check(InfraControl.class, "lastIteration");
        Utils.check(InfraControl.class, "warmupVisited", "warmdownVisited");
        Utils.check(InfraControl.class, "warmupShouldWait", "warmdownShouldWait");
        Utils.check(InfraControl.class, "warmupDone", "warmdownDone");
        Utils.check(InfraControl.class, "benchmarkParams", "iterationParams");
        Utils.check(InfraControl.class, "shouldSynchIterations", "threads");
    }
}

