/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.datatype;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import org.camunda.feel.datatype.ZonedTime;
import org.camunda.feel.package$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.util.Try$;

public final class ZonedTime$
implements Serializable {
    public static ZonedTime$ MODULE$;
    private final long NANOS_PER_SECOND;
    private final DateTimeFormatter offsetFormatter;

    static {
        new ZonedTime$();
    }

    public long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public DateTimeFormatter offsetFormatter() {
        return this.offsetFormatter;
    }

    public ZonedTime parse(String time) {
        TemporalAccessor temporal = package$.MODULE$.timeFormatterWithOffsetAndOptionalPrefix().parse(time);
        LocalTime localTime = LocalTime.from(temporal);
        ZoneId zoneId = ZoneId.from(temporal);
        ZoneOffset offset = (ZoneOffset)Try$.MODULE$.apply((Function0<ZoneOffset> & java.io.Serializable & Serializable)() -> ZoneOffset.from(temporal)).getOrElse((Function0<ZoneOffset> & java.io.Serializable & Serializable)() -> zoneId.getRules().getStandardOffset(Instant.now()));
        Option zone = offset.equals(zoneId) ? None$.MODULE$ : new Some<ZoneId>(zoneId);
        return new ZonedTime(localTime, offset, zone);
    }

    public ZonedTime of(LocalTime time, ZoneOffset offset) {
        return new ZonedTime(time, offset, None$.MODULE$);
    }

    public ZonedTime of(OffsetTime offsetTime) {
        LocalTime localTime = offsetTime.toLocalTime();
        ZoneOffset offset = offsetTime.getOffset();
        return new ZonedTime(localTime, offset, None$.MODULE$);
    }

    public ZonedTime of(ZonedDateTime dateTime) {
        LocalTime localTime = dateTime.toLocalTime();
        ZoneOffset offset = dateTime.getOffset();
        Option zone = dateTime.getZone().equals(offset) ? None$.MODULE$ : new Some<ZoneId>(dateTime.getZone());
        return new ZonedTime(localTime, offset, zone);
    }

    public Duration between(ZonedTime x, ZonedTime y) {
        return x.between(y);
    }

    public ZonedTime apply(LocalTime time, ZoneOffset offset, Option<ZoneId> zone) {
        return new ZonedTime(time, offset, zone);
    }

    public Option<Tuple3<LocalTime, ZoneOffset, Option<ZoneId>>> unapply(ZonedTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<LocalTime, ZoneOffset, Option<ZoneId>>>(new Tuple3<LocalTime, ZoneOffset, Option<ZoneId>>(x$0.time(), x$0.offset(), x$0.zone()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ZonedTime$() {
        MODULE$ = this;
        this.NANOS_PER_SECOND = 1000000000L;
        this.offsetFormatter = new DateTimeFormatterBuilder().appendOffsetId().toFormatter();
    }
}

