/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.dmn.standalone;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.camunda.dmn.DmnEngine;
import org.camunda.dmn.package$;
import org.camunda.dmn.standalone.DecisionRepository;
import org.camunda.dmn.standalone.DeployedDecision;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001-\u0011ACR5mKNK8\u000f^3n%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003)\u0019H/\u00198eC2|g.\u001a\u0006\u0003\u000b\u0019\t1\u0001Z7o\u0015\t9\u0001\"A\u0004dC6,h\u000eZ1\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0013\t\u0016\u001c\u0017n]5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u0019\u0003%!WN\\#oO&tW-F\u0001\u001a!\tQ2$D\u0001\u0005\u0013\taBAA\u0005E[:,enZ5oK\"Aa\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0006e[:,enZ5oK\u0002B\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\nI&\u0014Xm\u0019;pef\u0004\"AI\u0015\u000f\u0005\r:\u0003C\u0001\u0013\u000f\u001b\u0005)#B\u0001\u0014\u000b\u0003\u0019a$o\\8u}%\u0011\u0001FD\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)\u001d!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\t\u0019\u0002\u0001C\u0003\u0018Y\u0001\u0007\u0011\u0004C\u0003!Y\u0001\u0007\u0011\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\u0002\tA\fG\u000f[\u000b\u0002kA\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\u0005M&dWM\u0003\u0002;w\u0005\u0019a.[8\u000b\u0003q\nAA[1wC&\u0011ah\u000e\u0002\u0005!\u0006$\b\u000e\u0003\u0004A\u0001\u0001\u0006I!N\u0001\u0006a\u0006$\b\u000e\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003E!W\r\u001d7ps\u0016$G)Z2jg&|gn]\u000b\u0002\tB!QIS\u0011M\u001b\u00051%BA$I\u0003\u001diW\u000f^1cY\u0016T!!\u0013\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002L\r\n\u0019Q*\u00199\u0011\u0005Mi\u0015B\u0001(\u0003\u0005A!U\r\u001d7ps\u0016$G)Z2jg&|g\u000e\u0003\u0004Q\u0001\u0001\u0006I\u0001R\u0001\u0013I\u0016\u0004Hn\\=fI\u0012+7-[:j_:\u001c\b\u0005C\u0003S\u0001\u0011\u00051+\u0001\u0003j]&$X#\u0001+\u0011\u00055)\u0016B\u0001,\u000f\u0005\u0011)f.\u001b;\t\u000ba\u0003A\u0011B*\u0002\u001bM\u001c\u0017M\u001c#je\u0016\u001cGo\u001c:z\u0011\u0015Q\u0006\u0001\"\u0001\\\u000319W\r\u001e#fG&\u001c\u0018n\u001c8t+\u0005a\u0006cA/c\u0019:\u0011a\f\u0019\b\u0003I}K\u0011aD\u0005\u0003C:\tq\u0001]1dW\u0006<W-\u0003\u0002dI\n!A*[:u\u0015\t\tg\u0002C\u0003g\u0001\u0011\u0005q-A\bhKR$UmY5tS>t')_%e)\tA7\u000eE\u0002\u000eS2K!A\u001b\b\u0003\r=\u0003H/[8o\u0011\u0015aW\r1\u0001\"\u0003\tIG\rC\u0003o\u0001\u0011\u0005q.A\thKR$UmY5tS>t')\u001f(b[\u0016$\"\u0001\u001b9\t\u000bEl\u0007\u0019A\u0011\u0002\t9\fW.\u001a\u0005\u0006g\u0002!\t\u0001^\u0001\u0010S:\u001cXM\u001d;EK\u000eL7/[8ogR)Q/a\u0003\u0002\u001cA!QL\u001e=]\u0013\t9HM\u0001\u0004FSRDWM\u001d\t\u0004s\u0006\u0015ab\u0001>\u0002\u00029\u00111p \b\u0003yzt!\u0001J?\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011bAA\u0002\t\u0005IA)\u001c8F]\u001eLg.Z\u0005\u0005\u0003\u000f\tIAA\u0004GC&dWO]3\u000b\u0007\u0005\rA\u0001C\u0004\u0002\u000eI\u0004\r!a\u0004\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u001e\u0002\u0005%|\u0017\u0002BA\r\u0003'\u00111\"\u00138qkR\u001cFO]3b[\"1\u0011Q\u0004:A\u0002\u0005\n\u0001B]3t_V\u00148-\u001a\u0005\b\u0003C\u0001A\u0011BA\u0012\u0003)\u0019w\u000e]=TiJ,\u0017-\u001c\u000b\u0005\u0003K\tY\u0003\u0005\u0003\u0002\u0012\u0005\u001d\u0012\u0002BA\u0015\u0003'\u0011QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002.\u0005}\u0001\u0019AA\b\u0003\u0015Ig\u000e];u\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\taB]3n_Z,'+Z:pkJ\u001cW\rF\u0002v\u0003kAq!!\b\u00020\u0001\u0007\u0011\u0005")
public class FileSystemRepository
implements DecisionRepository {
    private final DmnEngine dmnEngine;
    private final Path path;
    private final Map<String, DeployedDecision> deployedDecisions;

    @Override
    public Either<DmnEngine.Failure, List<Tuple2<String, DeployedDecision>>> parseDecision(InputStream stream, String resource) {
        return DecisionRepository.parseDecision$(this, stream, resource);
    }

    @Override
    public DmnEngine dmnEngine() {
        return this.dmnEngine;
    }

    public Path path() {
        return this.path;
    }

    public Map<String, DeployedDecision> deployedDecisions() {
        return this.deployedDecisions;
    }

    @Override
    public void init() {
        this.scanDirectory();
    }

    private void scanDirectory() {
        package$.MODULE$.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scan directory for decisions '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.path().toAbsolutePath()})));
        this.deployedDecisions().clear();
        try {
            Files.walk(this.path(), new FileVisitOption[0]).filter(p -> ((Object)p.getFileName()).toString().endsWith(".dmn")).forEach(p -> this.parseDecision(new FileInputStream(p.toFile()), ((Object)p.getFileName()).toString()).right().map((Function1<List, Map> & Serializable & scala.Serializable)decisions -> (Map)this.deployedDecisions().$plus$plus$eq(decisions)).left().map((Function1<DmnEngine.Failure, Object> & Serializable & scala.Serializable)f -> {
                FileSystemRepository.$anonfun$scanDirectory$4(f);
                return BoxedUnit.UNIT;
            }));
        }
        catch (IOException e) {
            package$.MODULE$.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to scan directory"})).s(Nil$.MODULE$), e);
        }
    }

    @Override
    public List<DeployedDecision> getDecisions() {
        return this.deployedDecisions().values().toList();
    }

    @Override
    public Option<DeployedDecision> getDecisionById(String id) {
        return this.deployedDecisions().get(id);
    }

    @Override
    public Option<DeployedDecision> getDecisionByName(String name) {
        return this.deployedDecisions().values().find((Function1<DeployedDecision, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(FileSystemRepository.$anonfun$getDecisionByName$1(name, x$1)));
    }

    @Override
    public Either<DmnEngine.Failure, List<DeployedDecision>> insertDecisions(InputStream inputStream, String resource) {
        String resourceName = resource.endsWith(".dmn") ? resource : resource + ".dmn";
        ByteArrayOutputStream outputStream = this.copyStream(inputStream);
        ByteArrayInputStream inputStreamParse = new ByteArrayInputStream(outputStream.toByteArray());
        return this.parseDecision(inputStreamParse, resourceName).right().flatMap((Function1<List, Either> & Serializable & scala.Serializable)decisions -> {
            Either either;
            try {
                ByteArrayInputStream inputStreamCopy = new ByteArrayInputStream(outputStream.toByteArray());
                Files.copy(inputStreamCopy, this.path().resolve(resourceName), StandardCopyOption.REPLACE_EXISTING);
                either = scala.package$.MODULE$.Right().apply(decisions);
            }
            catch (Throwable t) {
                either = scala.package$.MODULE$.Left().apply(new DmnEngine.Failure(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to copy resource '", "': ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource, t}))));
            }
            return either;
        }).right().map((Function1<List, List> & Serializable & scala.Serializable)decisions -> {
            this.deployedDecisions().$plus$plus$eq(decisions);
            return decisions.map((Function1<Tuple2, DeployedDecision> & Serializable & scala.Serializable)x0$1 -> {
                DeployedDecision d;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DeployedDecision deployedDecision = d = (DeployedDecision)tuple2._2();
                return deployedDecision;
            }, List$.MODULE$.canBuildFrom());
        });
    }

    /*
     * WARNING - void declaration
     */
    private ByteArrayOutputStream copyStream(InputStream input) {
        void var2_2;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while (len > -1) {
            len = input.read(buffer);
            if (len <= 0) continue;
            output.write(buffer, 0, len);
        }
        output.flush();
        return var2_2;
    }

    @Override
    public Either<DmnEngine.Failure, List<DeployedDecision>> removeResource(String resource) {
        Iterable iterable = (Iterable)this.deployedDecisions().values().filter((Function1<DeployedDecision, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(FileSystemRepository.$anonfun$removeResource$1(resource, x$2)));
        Either either = ((Object)Nil$.MODULE$).equals(iterable) ? scala.package$.MODULE$.Left().apply(new DmnEngine.Failure(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No decisions found for resource '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource})))) : this.liftedTree1$1(resource, iterable).right().map((Function1<Iterable, List> & Serializable & scala.Serializable)decisionsToRemove -> {
            Iterable ids = decisionsToRemove.map((Function1<DeployedDecision, String> & Serializable & scala.Serializable)x$3 -> x$3.decisionId(), Iterable$.MODULE$.canBuildFrom());
            this.deployedDecisions().$minus$minus$eq(ids);
            return decisionsToRemove.toList();
        });
        return either;
    }

    public static final /* synthetic */ void $anonfun$scanDirectory$4(DmnEngine.Failure f) {
        package$.MODULE$.logger().warn(f.toString());
    }

    public static final /* synthetic */ boolean $anonfun$getDecisionByName$1(String name$1, DeployedDecision x$1) {
        String string = x$1.decisionName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeResource$1(String resource$2, DeployedDecision x$2) {
        String string = x$2.resource();
        String string2 = resource$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Either liftedTree1$1(String resource$2, Iterable x1$1) {
        Either either;
        try {
            Files.delete(this.path().resolve(resource$2));
            either = scala.package$.MODULE$.Right().apply(x1$1);
        }
        catch (Throwable t) {
            either = scala.package$.MODULE$.Left().apply(new DmnEngine.Failure(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to delete resource '", "': ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource$2, t}))));
        }
        return either;
    }

    public FileSystemRepository(DmnEngine dmnEngine, String directory) {
        this.dmnEngine = dmnEngine;
        DecisionRepository.$init$(this);
        this.path = Paths.get(directory, new String[0]);
        this.deployedDecisions = Map$.MODULE$.empty();
    }
}

