/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.dmn.standalone;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.camunda.dmn.DmnEngine;
import org.camunda.dmn.package$;
import org.camunda.dmn.standalone.DecisionRepository;
import org.camunda.dmn.standalone.DeployedDecision;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\t\u0013\u0001mA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\tY\u0001\u0011\t\u0011)A\u0005Q!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u0003:\u0001\u0011\u0005!\bC\u0004?\u0001\t\u0007I\u0011A \t\r)\u0003\u0001\u0015!\u0003A\u0011\u001dY\u0005A1A\u0005\u00021Ca\u0001\u0017\u0001!\u0002\u0013i\u0005\"B-\u0001\t\u0003Q\u0006\"\u00020\u0001\t\u0013Q\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00026\u0001\t\u0003Y\u0007\"B9\u0001\t\u0003\u0011\b\"B;\u0001\t\u00031\bbBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003c\u0001A\u0011AA\u001a\u0005Q1\u0015\u000e\\3TsN$X-\u001c*fa>\u001c\u0018\u000e^8ss*\u00111\u0003F\u0001\u000bgR\fg\u000eZ1m_:,'BA\u000b\u0017\u0003\r!WN\u001c\u0006\u0003/a\tqaY1nk:$\u0017MC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r\"S\"\u0001\n\n\u0005\u0015\u0012\"A\u0005#fG&\u001c\u0018n\u001c8SKB|7/\u001b;pef\f\u0011\u0002Z7o\u000b:<\u0017N\\3\u0016\u0003!\u0002\"!\u000b\u0016\u000e\u0003QI!a\u000b\u000b\u0003\u0013\u0011kg.\u00128hS:,\u0017A\u00033n]\u0016sw-\u001b8fA\u0005IA-\u001b:fGR|'/\u001f\t\u0003_Yr!\u0001\r\u001b\u0011\u0005ErR\"\u0001\u001a\u000b\u0005MR\u0012A\u0002\u001fs_>$h(\u0003\u00026=\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)d$\u0001\u0004=S:LGO\u0010\u000b\u0004wqj\u0004CA\u0012\u0001\u0011\u00151C\u00011\u0001)\u0011\u0015iC\u00011\u0001/\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0003\u0001\u0003\"!\u0011%\u000e\u0003\tS!a\u0011#\u0002\t\u0019LG.\u001a\u0006\u0003\u000b\u001a\u000b1A\\5p\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013\"\u0003\tA\u000bG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\u0012I\u0016\u0004Hn\\=fI\u0012+7-[:j_:\u001cX#A'\u0011\t9\u001bf&V\u0007\u0002\u001f*\u0011\u0001+U\u0001\b[V$\u0018M\u00197f\u0015\t\u0011f$\u0001\u0006d_2dWm\u0019;j_:L!\u0001V(\u0003\u00075\u000b\u0007\u000f\u0005\u0002$-&\u0011qK\u0005\u0002\u0011\t\u0016\u0004Hn\\=fI\u0012+7-[:j_:\f!\u0003Z3qY>LX\r\u001a#fG&\u001c\u0018n\u001c8tA\u0005!\u0011N\\5u+\u0005Y\u0006CA\u000f]\u0013\tifD\u0001\u0003V]&$\u0018!D:dC:$\u0015N]3di>\u0014\u00180\u0001\u0007hKR$UmY5tS>t7/F\u0001b!\r\u0011w-\u0016\b\u0003G\u0016t!!\r3\n\u0003}I!A\u001a\u0010\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002g=\u0005yq-\u001a;EK\u000eL7/[8o\u0005fLE\r\u0006\u0002m_B\u0019Q$\\+\n\u00059t\"AB(qi&|g\u000eC\u0003q\u0019\u0001\u0007a&\u0001\u0002jI\u0006\tr-\u001a;EK\u000eL7/[8o\u0005ft\u0015-\\3\u0015\u00051\u001c\b\"\u0002;\u000e\u0001\u0004q\u0013\u0001\u00028b[\u0016\fq\"\u001b8tKJ$H)Z2jg&|gn\u001d\u000b\u0006o\u0006=\u0011q\u0004\t\u0005EbT\u0018-\u0003\u0002zS\n1Q)\u001b;iKJ\u00042a_A\u0005\u001d\ra\u0018Q\u0001\b\u0004{\u0006\rab\u0001@\u0002\u00029\u0011\u0011g`\u0005\u00023%\u0011q\u0003G\u0005\u0003+YI1!a\u0002\u0015\u0003%!UN\\#oO&tW-\u0003\u0003\u0002\f\u00055!a\u0002$bS2,(/\u001a\u0006\u0004\u0003\u000f!\u0002bBA\t\u001d\u0001\u0007\u00111C\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIBR\u0001\u0003S>LA!!\b\u0002\u0018\tY\u0011J\u001c9viN#(/Z1n\u0011\u0019\t\tC\u0004a\u0001]\u0005A!/Z:pkJ\u001cW-\u0001\u0006d_BL8\u000b\u001e:fC6$B!a\n\u0002.A!\u0011QCA\u0015\u0013\u0011\tY#a\u0006\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\"9\u0011qF\bA\u0002\u0005M\u0011!B5oaV$\u0018A\u0004:f[>4XMU3t_V\u00148-\u001a\u000b\u0004o\u0006U\u0002BBA\u0011!\u0001\u0007a\u0006")
public class FileSystemRepository
implements DecisionRepository {
    private final DmnEngine dmnEngine;
    private final Path path;
    private final Map<String, DeployedDecision> deployedDecisions;

    @Override
    public Either<DmnEngine.Failure, List<Tuple2<String, DeployedDecision>>> parseDecision(InputStream stream, String resource) {
        return DecisionRepository.parseDecision$(this, stream, resource);
    }

    @Override
    public DmnEngine dmnEngine() {
        return this.dmnEngine;
    }

    public Path path() {
        return this.path;
    }

    public Map<String, DeployedDecision> deployedDecisions() {
        return this.deployedDecisions;
    }

    @Override
    public void init() {
        this.scanDirectory();
    }

    private void scanDirectory() {
        package$.MODULE$.logger().debug(new StringBuilder(31).append("Scan directory for decisions '").append(this.path().toAbsolutePath()).append("'").toString());
        this.deployedDecisions().clear();
        try {
            Files.walk(this.path(), new FileVisitOption[0]).filter(p -> ((Object)p.getFileName()).toString().endsWith(".dmn")).forEach(p -> this.parseDecision(new FileInputStream(p.toFile()), ((Object)p.getFileName()).toString()).map((Function1<List, Map> & Serializable)decisions -> (Map)this.deployedDecisions().$plus$plus$eq(decisions)).left().map((Function1<DmnEngine.Failure, Object> & Serializable)f -> {
                FileSystemRepository.$anonfun$scanDirectory$4(f);
                return BoxedUnit.UNIT;
            }));
        }
        catch (IOException e) {
            package$.MODULE$.logger().warn("Fail to scan directory", e);
        }
    }

    @Override
    public List<DeployedDecision> getDecisions() {
        return (List)this.deployedDecisions().values().toList().sortBy((Function1<DeployedDecision, String> & Serializable)decision -> decision.decisionId(), (Ordering)Ordering$String$.MODULE$);
    }

    @Override
    public Option<DeployedDecision> getDecisionById(String id) {
        return this.deployedDecisions().get(id);
    }

    @Override
    public Option<DeployedDecision> getDecisionByName(String name) {
        return this.deployedDecisions().values().find((Function1<DeployedDecision, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(FileSystemRepository.$anonfun$getDecisionByName$1(name, x$1)));
    }

    @Override
    public Either<DmnEngine.Failure, List<DeployedDecision>> insertDecisions(InputStream inputStream, String resource) {
        String resourceName = resource.endsWith(".dmn") ? resource : new StringBuilder(4).append(resource).append(".dmn").toString();
        ByteArrayOutputStream outputStream = this.copyStream(inputStream);
        ByteArrayInputStream inputStreamParse = new ByteArrayInputStream(outputStream.toByteArray());
        return this.parseDecision(inputStreamParse, resourceName).flatMap((Function1<List, Either> & Serializable)decisions -> {
            Either either;
            try {
                ByteArrayInputStream inputStreamCopy = new ByteArrayInputStream(outputStream.toByteArray());
                Files.copy(inputStreamCopy, this.path().resolve(resourceName), StandardCopyOption.REPLACE_EXISTING);
                either = scala.package$.MODULE$.Right().apply(decisions);
            }
            catch (Throwable t) {
                either = scala.package$.MODULE$.Left().apply(new DmnEngine.Failure(new StringBuilder(26).append("Fail to copy resource '").append(resource).append("': ").append(t).toString()));
            }
            return either;
        }).map((Function1<List, List> & Serializable)decisions -> {
            this.deployedDecisions().$plus$plus$eq(decisions);
            return decisions.map((Function1<Tuple2, DeployedDecision> & Serializable)x0$1 -> {
                DeployedDecision d;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DeployedDecision deployedDecision = d = (DeployedDecision)tuple2._2();
                return deployedDecision;
            });
        });
    }

    /*
     * WARNING - void declaration
     */
    private ByteArrayOutputStream copyStream(InputStream input) {
        void var2_2;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while (len > -1) {
            len = input.read(buffer);
            if (len <= 0) continue;
            output.write(buffer, 0, len);
        }
        output.flush();
        return var2_2;
    }

    @Override
    public Either<DmnEngine.Failure, List<DeployedDecision>> removeResource(String resource) {
        Either<DmnEngine.Failure, List<DeployedDecision>> either;
        List list = ((IterableOnceOps)this.deployedDecisions().values().filter((Function1<DeployedDecision, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(FileSystemRepository.$anonfun$removeResource$1(resource, x$2)))).toList();
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
            either = scala.package$.MODULE$.Left().apply(new DmnEngine.Failure(new StringBuilder(34).append("No decisions found for resource '").append(resource).append("'").toString()));
        } else {
            Right right;
            try {
                Files.delete(this.path().resolve(resource));
                right = scala.package$.MODULE$.Right().apply(list);
            }
            catch (Throwable t) {
                right = scala.package$.MODULE$.Left().apply(new DmnEngine.Failure(new StringBuilder(28).append("Fail to delete resource '").append(resource).append("': ").append(t).toString()));
            }
            either = right.map((Function1<List, List> & Serializable)decisionsToRemove -> {
                Object ids = decisionsToRemove.map((Function1<DeployedDecision, String> & Serializable)x$3 -> x$3.decisionId());
                this.deployedDecisions().$minus$minus$eq(ids);
                return decisionsToRemove.toList();
            });
        }
        return either;
    }

    public static final /* synthetic */ void $anonfun$scanDirectory$4(DmnEngine.Failure f) {
        package$.MODULE$.logger().warn(f.toString());
    }

    public static final /* synthetic */ boolean $anonfun$getDecisionByName$1(String name$1, DeployedDecision x$1) {
        String string = x$1.decisionName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeResource$1(String resource$2, DeployedDecision x$2) {
        String string = x$2.resource();
        String string2 = resource$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public FileSystemRepository(DmnEngine dmnEngine, String directory) {
        this.dmnEngine = dmnEngine;
        DecisionRepository.$init$(this);
        this.path = Paths.get(directory, new String[0]);
        this.deployedDecisions = (Map)Map$.MODULE$.empty();
    }
}

