/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable.impl;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableMapImpl
implements VariableMap,
Serializable,
VariableContext {
    private static final long serialVersionUID = 1L;
    protected Map<String, TypedValue> variables = new HashMap<String, TypedValue>();

    public VariableMapImpl(VariableMapImpl map2) {
        this.variables = new HashMap<String, TypedValue>(map2.variables);
    }

    public VariableMapImpl(Map<String, Object> map2) {
        if (map2 != null) {
            this.putAll((Map<? extends String, ? extends Object>)map2);
        }
    }

    public VariableMapImpl() {
    }

    @Override
    public VariableMap putValue(String name, Object value2) {
        this.put(name, value2);
        return this;
    }

    @Override
    public VariableMap putValueTyped(String name, TypedValue value2) {
        this.variables.put(name, value2);
        return this;
    }

    @Override
    public <T> T getValue(String name, Class<T> type) {
        Object object = this.get(name);
        if (object == null) {
            return null;
        }
        if (type.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        throw new ClassCastException("Cannot cast variable named '" + name + "' with value '" + object + "' to type '" + type + "'.");
    }

    @Override
    public <T extends TypedValue> T getValueTyped(String name) {
        return (T)this.variables.get(name);
    }

    @Override
    public int size() {
        return this.variables.size();
    }

    @Override
    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.variables.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        for (TypedValue varValue : this.variables.values()) {
            if (value2 == varValue.getValue()) {
                return true;
            }
            if (value2 == null || !value2.equals(varValue.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key2) {
        TypedValue typedValue = this.variables.get(key2);
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    @Override
    public Object put(String key2, Object value2) {
        TypedValue typedValue = Variables.untypedValue(value2);
        TypedValue prevValue = this.variables.put(key2, typedValue);
        if (prevValue != null) {
            return prevValue.getValue();
        }
        return null;
    }

    @Override
    public Object remove(Object key2) {
        TypedValue prevValue = this.variables.remove(key2);
        if (prevValue != null) {
            return prevValue.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m != null) {
            if (m instanceof VariableMapImpl) {
                this.variables.putAll(((VariableMapImpl)m).variables);
            } else {
                for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.variables.keySet();
    }

    @Override
    public Collection<Object> values() {
        return new AbstractCollection<Object>(){

            @Override
            public Iterator<Object> iterator() {
                final Iterator<TypedValue> iterator2 = VariableMapImpl.this.variables.values().iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public Object next() {
                        return ((TypedValue)iterator2.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        iterator2.remove();
                    }
                };
            }

            @Override
            public int size() {
                return VariableMapImpl.this.variables.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    final Iterator<Map.Entry<String, TypedValue>> iterator;
                    {
                        this.iterator = VariableMapImpl.this.variables.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        final Map.Entry<String, TypedValue> underlyingEntry = this.iterator.next();
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return (String)underlyingEntry.getKey();
                            }

                            @Override
                            public Object getValue() {
                                return ((TypedValue)underlyingEntry.getValue()).getValue();
                            }

                            @Override
                            public Object setValue(Object value2) {
                                TypedValue typedValue = Variables.untypedValue(value2);
                                return underlyingEntry.setValue(typedValue);
                            }

                            @Override
                            public final boolean equals(Object o) {
                                Object v2;
                                Object v1;
                                Object k2;
                                if (!(o instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry e = (Map.Entry)o;
                                String k1 = this.getKey();
                                return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
                            }

                            @Override
                            public final int hashCode() {
                                String key2 = this.getKey();
                                Object value2 = this.getValue();
                                return (key2 == null ? 0 : key2.hashCode()) ^ (value2 == null ? 0 : value2.hashCode());
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return VariableMapImpl.this.variables.size();
            }
        };
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        for (Map.Entry<String, TypedValue> variable : this.variables.entrySet()) {
            stringBuilder.append("  ");
            stringBuilder.append(variable.getKey());
            stringBuilder.append(" => ");
            stringBuilder.append(variable.getValue());
            stringBuilder.append("\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.asValueMap()).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.asValueMap()).hashCode();
    }

    public Map<String, Object> asValueMap() {
        return new HashMap<String, Object>(this);
    }

    @Override
    public TypedValue resolve(String variableName) {
        return this.getValueTyped(variableName);
    }

    @Override
    public boolean containsVariable(String variableName) {
        return this.containsKey(variableName);
    }

    @Override
    public VariableContext asVariableContext() {
        return this;
    }
}

