/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable.impl.value.builder;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.camunda.bpm.engine.variable.impl.value.FileValueImpl;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.builder.FileValueBuilder;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.commons.utils.IoUtil;
import org.camunda.commons.utils.IoUtilException;

public class FileValueBuilderImpl
implements FileValueBuilder {
    protected FileValueImpl fileValue;

    public FileValueBuilderImpl(String filename) {
        EnsureUtil.ensureNotNull("filename", filename);
        this.fileValue = new FileValueImpl(PrimitiveValueType.FILE, filename);
    }

    @Override
    public FileValue create() {
        return this.fileValue;
    }

    @Override
    public FileValueBuilder mimeType(String mimeType) {
        this.fileValue.setMimeType(mimeType);
        return this;
    }

    @Override
    public FileValueBuilder file(File file) {
        try {
            return this.file(IoUtil.fileAsByteArray(file));
        }
        catch (IoUtilException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileValueBuilder file(InputStream stream) {
        try {
            return this.file(IoUtil.inputStreamAsByteArray(stream));
        }
        catch (IoUtilException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileValueBuilder file(byte[] bytes) {
        this.fileValue.setValue(bytes);
        return this;
    }

    @Override
    public FileValueBuilder encoding(Charset encoding) {
        this.fileValue.setEncoding(encoding);
        return this;
    }

    @Override
    public FileValueBuilder encoding(String encoding) {
        this.fileValue.setEncoding(encoding);
        return this;
    }
}

