/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable;

import java.io.File;
import java.util.Date;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.impl.context.EmptyVariableContext;
import org.camunda.bpm.engine.variable.impl.value.NullValueImpl;
import org.camunda.bpm.engine.variable.impl.value.PrimitiveTypeValueImpl;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.impl.value.builder.FileValueBuilderImpl;
import org.camunda.bpm.engine.variable.impl.value.builder.ObjectVariableBuilderImpl;
import org.camunda.bpm.engine.variable.impl.value.builder.SerializedObjectValueBuilderImpl;
import org.camunda.bpm.engine.variable.value.BooleanValue;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.DateValue;
import org.camunda.bpm.engine.variable.value.DoubleValue;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.NumberValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.ShortValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.engine.variable.value.builder.FileValueBuilder;
import org.camunda.bpm.engine.variable.value.builder.ObjectValueBuilder;
import org.camunda.bpm.engine.variable.value.builder.SerializedObjectValueBuilder;
import org.camunda.bpm.engine.variable.value.builder.TypedValueBuilder;

public class Variables {
    public static VariableMap createVariables() {
        return new VariableMapImpl();
    }

    public static VariableMap fromMap(Map<String, Object> map2) {
        if (map2 instanceof VariableMap) {
            return (VariableMap)map2;
        }
        return new VariableMapImpl(map2);
    }

    public static VariableMap putValue(String name, Object value2) {
        return Variables.createVariables().putValue(name, value2);
    }

    public static VariableMap putValueTyped(String name, TypedValue value2) {
        return Variables.createVariables().putValueTyped(name, value2);
    }

    public static ObjectValueBuilder objectValue(Object value2) {
        return new ObjectVariableBuilderImpl(value2);
    }

    public static SerializedObjectValueBuilder serializedObjectValue() {
        return new SerializedObjectValueBuilderImpl();
    }

    public static SerializedObjectValueBuilder serializedObjectValue(String value2) {
        return Variables.serializedObjectValue().serializedValue(value2);
    }

    public static IntegerValue integerValue(Integer integer) {
        return new PrimitiveTypeValueImpl.IntegerValueImpl(integer);
    }

    public static StringValue stringValue(String stringValue) {
        return new PrimitiveTypeValueImpl.StringValueImpl(stringValue);
    }

    public static BooleanValue booleanValue(Boolean booleanValue) {
        return new PrimitiveTypeValueImpl.BooleanValueImpl(booleanValue);
    }

    public static BytesValue byteArrayValue(byte[] bytes) {
        return new PrimitiveTypeValueImpl.BytesValueImpl(bytes);
    }

    public static DateValue dateValue(Date date) {
        return new PrimitiveTypeValueImpl.DateValueImpl(date);
    }

    public static LongValue longValue(Long longValue) {
        return new PrimitiveTypeValueImpl.LongValueImpl(longValue);
    }

    public static ShortValue shortValue(Short shortValue) {
        return new PrimitiveTypeValueImpl.ShortValueImpl(shortValue);
    }

    public static DoubleValue doubleValue(Double doubleValue) {
        return new PrimitiveTypeValueImpl.DoubleValueImpl(doubleValue);
    }

    public static NumberValue numberValue(Number numberValue) {
        return new PrimitiveTypeValueImpl.NumberValueImpl(numberValue);
    }

    public static TypedValue untypedNullValue() {
        return NullValueImpl.INSTANCE;
    }

    public static TypedValue untypedValue(Object value2) {
        if (value2 == null) {
            return Variables.untypedNullValue();
        }
        if (value2 instanceof TypedValueBuilder) {
            return ((TypedValueBuilder)value2).create();
        }
        if (value2 instanceof TypedValue) {
            return (TypedValue)value2;
        }
        return new UntypedValueImpl(value2);
    }

    public static FileValueBuilder fileValue(String filename) {
        return new FileValueBuilderImpl(filename);
    }

    public static FileValue fileValue(File file) {
        String contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file);
        return (FileValue)new FileValueBuilderImpl(file.getName()).file(file).mimeType(contentType).create();
    }

    public static VariableContext emptyVariableContext() {
        return EmptyVariableContext.INSTANCE;
    }

    public static enum SerializationDataFormats implements SerializationDataFormat
    {
        JAVA("application/x-java-serialized-object"),
        JSON("application/json"),
        XML("application/xml");

        private final String name;

        private SerializationDataFormats(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

