/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable.impl.type;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.type.AbstractValueTypeImpl;
import org.camunda.bpm.engine.variable.type.FileValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.engine.variable.value.builder.FileValueBuilder;

public class FileValueTypeImpl
extends AbstractValueTypeImpl
implements FileValueType {
    private static final long serialVersionUID = 1L;

    public FileValueTypeImpl() {
        super("file");
    }

    @Override
    public TypedValue createValue(Object value2, Map<String, Object> valueInfo) {
        Object filename = valueInfo.get("filename");
        if (filename == null) {
            throw new IllegalArgumentException("Cannot create file without filename! Please set a name into ValueInfo with key filename");
        }
        FileValueBuilder builder = Variables.fileValue(filename.toString());
        if (value2 instanceof File) {
            builder.file((File)value2);
        } else if (value2 instanceof InputStream) {
            builder.file((InputStream)value2);
        } else if (value2 instanceof byte[]) {
            builder.file((byte[])value2);
        } else {
            throw new IllegalArgumentException("Provided value is not of File, InputStream or byte[] type.");
        }
        if (valueInfo.containsKey("mimeType")) {
            Object mimeType = valueInfo.get("mimeType");
            if (mimeType == null) {
                throw new IllegalArgumentException("The provided mime type is null. Set a non-null value info property with key 'filename'");
            }
            builder.mimeType(mimeType.toString());
        }
        if (valueInfo.containsKey("encoding")) {
            Object encoding = valueInfo.get("encoding");
            if (encoding == null) {
                throw new IllegalArgumentException("The provided encoding is null. Set a non-null value info property with key 'encoding'");
            }
            builder.encoding(encoding.toString());
        }
        return builder.create();
    }

    @Override
    public Map<String, Object> getValueInfo(TypedValue typedValue) {
        if (!(typedValue instanceof FileValue)) {
            throw new IllegalArgumentException("Value not of type FileValue");
        }
        FileValue fileValue = (FileValue)typedValue;
        HashMap<String, Object> result2 = new HashMap<String, Object>(2);
        result2.put("filename", fileValue.getFilename());
        if (fileValue.getMimeType() != null) {
            result2.put("mimeType", fileValue.getMimeType());
        }
        if (fileValue.getEncoding() != null) {
            result2.put("encoding", fileValue.getEncoding());
        }
        return result2;
    }

    @Override
    public boolean isPrimitiveValueType() {
        return true;
    }
}

