/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.commons.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class BaseLogger {
    protected Logger delegateLogger;
    protected String projectCode;
    protected String componentId;

    protected BaseLogger() {
    }

    public static <T extends BaseLogger> T createLogger(Class<T> loggerClass, String projectCode, String name, String componentId) {
        try {
            BaseLogger logger = (BaseLogger)loggerClass.newInstance();
            logger.projectCode = projectCode;
            logger.componentId = componentId;
            logger.delegateLogger = LoggerFactory.getLogger(name);
            return (T)logger;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate logger '" + loggerClass.getName() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate logger '" + loggerClass.getName() + "'", e);
        }
    }

    protected void logDebug(String id, String messageTemplate, Object ... parameters2) {
        if (this.delegateLogger.isDebugEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.debug(msg, parameters2);
        }
    }

    protected void logInfo(String id, String messageTemplate, Object ... parameters2) {
        if (this.delegateLogger.isInfoEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.info(msg, parameters2);
        }
    }

    protected void logWarn(String id, String messageTemplate, Object ... parameters2) {
        if (this.delegateLogger.isWarnEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.warn(msg, parameters2);
        }
    }

    protected void logError(String id, String messageTemplate, Object ... parameters2) {
        if (this.delegateLogger.isErrorEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.error(msg, parameters2);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegateLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegateLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegateLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegateLogger.isErrorEnabled();
    }

    protected String formatMessageTemplate(String id, String messageTemplate) {
        return this.projectCode + "-" + this.componentId + id + " " + messageTemplate;
    }

    protected String exceptionMessage(String id, String messageTemplate, Object ... parameters2) {
        String formattedTemplate = this.formatMessageTemplate(id, messageTemplate);
        if (parameters2 == null || parameters2.length == 0) {
            return formattedTemplate;
        }
        return MessageFormatter.arrayFormat(formattedTemplate, parameters2).getMessage();
    }
}

