/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValFunction$;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.package$;
import org.camunda.feel.spi.FunctionProvider;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.Numeric$BigDecimalIsFractional$;
import scala.math.Ordering$BigDecimal$;
import scala.runtime.BoxesRunTime;

public final class BuiltinFunctions$
implements FunctionProvider {
    public static final BuiltinFunctions$ MODULE$;
    private final List<Tuple2<String, ValFunction>> builtinFunctions;
    private final Map<Tuple2<String, Object>, ValFunction> builtinFunctionsByNameAndArgCount;

    static {
        new BuiltinFunctions$();
    }

    public List<Tuple2<String, ValFunction>> builtinFunctions() {
        return this.builtinFunctions;
    }

    public List<Tuple2<String, ValFunction>> conversionFunctions() {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date"), this.dateFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date"), this.dateFunction3()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date_and_time"), this.dateTime()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date_and_time"), this.dateTime2()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("time"), this.timeFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("time"), this.timeFunction3()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("time"), this.timeFunction4()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("number"), this.numberFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("number"), this.numberFunction2()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("number"), this.numberFunction3()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("string"), this.stringFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("duration"), this.durationFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("years_and_months_duration"), this.durationFunction2())}));
    }

    public List<Tuple2<String, ValFunction>> booleanFunctions() {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("not"), this.notFunction())}));
    }

    public List<Tuple2<String, ValFunction>> stringFunctions() {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring"), this.substringFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring"), this.substringFunction3()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("string_length"), this.stringLengthFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("upper_case"), this.upperCaseFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("lower_case"), this.lowerCaseFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring_before"), this.substringBeforeFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring_after"), this.substringAfterFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("replace"), this.replaceFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("contains"), this.containsFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("starts_with"), this.startsWithFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ends_with"), this.endsWithFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("matches"), this.matchesFunction())}));
    }

    public List<Tuple2<String, ValFunction>> listFunctions() {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("list_contains"), this.listContainsFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("count"), this.countFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("min"), this.minFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("max"), this.maxFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sum"), this.sumFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("mean"), this.meanFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("and"), this.andFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("or"), this.orFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sublist"), this.sublistFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sublist"), this.sublistFunction3()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("append"), this.appendFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("concatenate"), this.concatenateFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("insert_before"), this.insertBeforeFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("remove"), this.removeFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("reverse"), this.reverseFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("index_of"), this.indexOfFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("union"), this.unionFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("distinct_values"), this.distinctValuesFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("flatten"), this.flattenFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sort"), this.sortFunction())}));
    }

    public List<Tuple2<String, ValFunction>> numericFunctions() {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("decimal"), this.decimalFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("floor"), this.floorFunction()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ceiling"), this.ceilingFunction())}));
    }

    private Map<Tuple2<String, Object>, ValFunction> builtinFunctionsByNameAndArgCount() {
        return this.builtinFunctionsByNameAndArgCount;
    }

    @Override
    public Option<ValFunction> getFunction(String name, int argCount) {
        return this.builtinFunctionsByNameAndArgCount().get(new Tuple2<String, Integer>(name, BoxesRunTime.boxToInteger(argCount)));
    }

    public ValError org$camunda$feel$interpreter$BuiltinFunctions$$error(List<Val> e) {
        List<Val> list2 = e;
        ValError valError = list2.exists((Function1<Val, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Val x$1) {
                return x$1 instanceof ValError;
            }
        })) ? (ValError)((IterableLike)list2.filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Val x$2) {
                return x$2 instanceof ValError;
            }
        }))).head() : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal arguments: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{e})));
        return valError;
    }

    public ValFunction dateFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$3) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$3;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from2 = valString.value();
                    serializable = new ValDate(package$.MODULE$.stringToDate(from2));
                } else {
                    Val val2;
                    Some<List<Val>> some2 = List$.MODULE$.unapplySeq(list2);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val2;
                        LocalDateTime from3 = valDateTime.value();
                        serializable = new ValDate(from3.toLocalDate());
                    } else {
                        serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                    }
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month", "day"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$4) {
                void var13_15;
                List<Val> list2 = x$4;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal year = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal month = valNumber2.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber3 = (ValNumber)val3;
                                BigDecimal day = valNumber3.value();
                                ValDate valDate = new ValDate(LocalDate.of(year.intValue(), month.intValue(), day.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$5) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$5;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from2 = valString.value();
                    serializable = new ValDateTime(package$.MODULE$.stringToDateTime(from2));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime2() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date", "time"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$6) {
                Some<List<Val>> some;
                void var10_13;
                List<Val> list2 = x$6;
                Some<List<Val>> some2 = List$.MODULE$.unapplySeq(list2);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                    if (val instanceof ValDate) {
                        ValDate valDate = (ValDate)val;
                        LocalDate date = valDate.value();
                        if (val2 instanceof ValTime) {
                            ValTime valTime = (ValTime)val2;
                            LocalTime time = valTime.value();
                            ValDateTime valDateTime = new ValDateTime(date.atTime(time));
                            return var10_13;
                        }
                    }
                }
                if (!(some = List$.MODULE$.unapplySeq(list2)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val;
                        LocalDateTime dateTime3 = valDateTime.value();
                        if (val3 instanceof ValTime) {
                            ValTime valTime = (ValTime)val3;
                            LocalTime time = valTime.value();
                            ValDateTime valDateTime2 = new ValDateTime(dateTime3.toLocalDate().atTime(time));
                            return var10_13;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$7) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$7;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from2 = valString.value();
                    serializable = new ValTime(package$.MODULE$.stringToTime(from2));
                } else {
                    Val val2;
                    Some<List<Val>> some2 = List$.MODULE$.unapplySeq(list2);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val2;
                        LocalDateTime from3 = valDateTime.value();
                        serializable = new ValTime(from3.toLocalTime());
                    } else {
                        serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                    }
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hour", "minute", "second"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$8) {
                void var13_15;
                List<Val> list2 = x$8;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal hour = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal minute = valNumber2.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber3 = (ValNumber)val3;
                                BigDecimal second = valNumber3.value();
                                ValTime valTime = new ValTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction4() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hour", "minute", "second", "offset"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$9) {
                void var16_18;
                List<Val> list2 = x$9;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(4) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(3);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal hour = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal minute = valNumber2.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber3 = (ValNumber)val3;
                                BigDecimal second = valNumber3.value();
                                if (val4 instanceof ValDayTimeDuration) {
                                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                                    Duration offset = valDayTimeDuration.value();
                                    ValTime valTime = new ValTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()).plus(offset));
                                    return var16_18;
                                }
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var16_18;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$10) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$10;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from2 = valString.value();
                    serializable = new ValNumber(package$.MODULE$.stringToNumber(from2));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction2() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "grouping"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$11) {
                Some<List<Val>> some;
                void var10_13;
                List<Val> list2 = x$11;
                Some<List<Val>> some2 = List$.MODULE$.unapplySeq(list2);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString;
                        String grouping;
                        ValString valString2 = (ValString)val;
                        String from2 = valString2.value();
                        if (val2 instanceof ValString && BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$isValidGroupingSeparator(grouping = (valString = (ValString)val2).value())) {
                            ValNumber valNumber = new ValNumber(package$.MODULE$.stringToNumber(from2.replace(grouping, "")));
                            return var10_13;
                        }
                    }
                }
                if (!(some = List$.MODULE$.unapplySeq(list2)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString && val3 instanceof ValString) {
                        ValError valError = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal argument for grouping. Must be one of ' ', ',' or '.'"})).s(Nil$.MODULE$));
                        return var10_13;
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "grouping", "decimal"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$12) {
                Some<List<Val>> some;
                void var14_17;
                List<Val> list2 = x$12;
                Some<List<Val>> some2 = List$.MODULE$.unapplySeq(list2);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some2.get()).apply(2);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String from2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String grouping = valString2.value();
                            if (val3 instanceof ValString) {
                                ValString valString3 = (ValString)val3;
                                String decimal = valString3.value();
                                if (BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$isValidGroupingSeparator(grouping) && BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$isValidDecimalSeparator(decimal)) {
                                    String string2 = grouping;
                                    String string3 = decimal;
                                    if (string2 == null ? string3 != null : !string2.equals(string3)) {
                                        ValNumber valNumber = new ValNumber(package$.MODULE$.stringToNumber(from2.replace(grouping, "").replace(decimal, ".")));
                                        return var14_17;
                                    }
                                }
                            }
                        }
                    }
                }
                if (!(some = List$.MODULE$.unapplySeq(list2)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val5 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValString && val4 instanceof ValString && val5 instanceof ValString) {
                        ValError valError = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal arguments for grouping or decimal. Must be one of ' ' (grouping only), ',' or '.'"})).s(Nil$.MODULE$));
                        return var14_17;
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var14_17;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$camunda$feel$interpreter$BuiltinFunctions$$isValidGroupingSeparator(String separator) {
        String string2 = separator;
        String string3 = " ";
        if (string2 == null) {
            if (string3 == null) return true;
        } else if (string2.equals(string3)) return true;
        String string4 = separator;
        String string5 = ",";
        if (string4 == null) {
            if (string5 == null) return true;
        } else if (string4.equals(string5)) return true;
        String string6 = separator;
        String string7 = ".";
        if (string6 != null) {
            if (!string6.equals(string7)) return false;
            return true;
        }
        if (string7 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$camunda$feel$interpreter$BuiltinFunctions$$isValidDecimalSeparator(String separator) {
        String string2 = separator;
        String string3 = ",";
        if (string2 == null) {
            if (string3 == null) return true;
        } else if (string2.equals(string3)) return true;
        String string4 = separator;
        String string5 = ".";
        if (string4 != null) {
            if (!string4.equals(string5)) return false;
            return true;
        }
        if (string5 == null) return true;
        return false;
    }

    public ValFunction stringFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$13) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$13;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from2 = valString.value();
                    serializable = new ValString(from2);
                } else {
                    Val val2;
                    Some<List<Val>> some2 = List$.MODULE$.unapplySeq(list2);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValBoolean) {
                        ValBoolean valBoolean = (ValBoolean)val2;
                        boolean from3 = valBoolean.value();
                        serializable = new ValString(((Object)BoxesRunTime.boxToBoolean(from3)).toString());
                    } else {
                        Val val3;
                        Some<List<Val>> some3 = List$.MODULE$.unapplySeq(list2);
                        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (val3 = (Val)((LinearSeqOptimized)some3.get()).apply(0)) instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val3;
                            BigDecimal from4 = valNumber.value();
                            serializable = new ValString(from4.toString());
                        } else {
                            Val val4;
                            Some<List<Val>> some4 = List$.MODULE$.unapplySeq(list2);
                            if (!some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && (val4 = (Val)((LinearSeqOptimized)some4.get()).apply(0)) instanceof ValDate) {
                                ValDate valDate = (ValDate)val4;
                                LocalDate from5 = valDate.value();
                                serializable = new ValString(from5.format(package$.MODULE$.dateFormatter()));
                            } else {
                                Val val5;
                                Some<List<Val>> some5 = List$.MODULE$.unapplySeq(list2);
                                if (!some5.isEmpty() && some5.get() != null && ((LinearSeqOptimized)some5.get()).lengthCompare(1) == 0 && (val5 = (Val)((LinearSeqOptimized)some5.get()).apply(0)) instanceof ValTime) {
                                    ValTime valTime = (ValTime)val5;
                                    LocalTime from6 = valTime.value();
                                    serializable = new ValString(from6.format(package$.MODULE$.timeFormatter()));
                                } else {
                                    Val val6;
                                    Some<List<Val>> some6 = List$.MODULE$.unapplySeq(list2);
                                    if (!some6.isEmpty() && some6.get() != null && ((LinearSeqOptimized)some6.get()).lengthCompare(1) == 0 && (val6 = (Val)((LinearSeqOptimized)some6.get()).apply(0)) instanceof ValDateTime) {
                                        ValDateTime valDateTime = (ValDateTime)val6;
                                        LocalDateTime from7 = valDateTime.value();
                                        serializable = new ValString(from7.format(package$.MODULE$.dateTimeFormatter()));
                                    } else {
                                        Val val7;
                                        Some<List<Val>> some7 = List$.MODULE$.unapplySeq(list2);
                                        if (!some7.isEmpty() && some7.get() != null && ((LinearSeqOptimized)some7.get()).lengthCompare(1) == 0 && (val7 = (Val)((LinearSeqOptimized)some7.get()).apply(0)) instanceof ValYearMonthDuration) {
                                            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val7;
                                            Period from8 = valYearMonthDuration.value();
                                            serializable = new ValString(from8.toString());
                                        } else {
                                            Val val8;
                                            Some<List<Val>> some8 = List$.MODULE$.unapplySeq(list2);
                                            if (!some8.isEmpty() && some8.get() != null && ((LinearSeqOptimized)some8.get()).lengthCompare(1) == 0 && (val8 = (Val)((LinearSeqOptimized)some8.get()).apply(0)) instanceof ValDayTimeDuration) {
                                                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val8;
                                                Duration from9 = valDayTimeDuration.value();
                                                serializable = new ValString(from9.toString());
                                            } else {
                                                serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$14) {
                ValString valString;
                String from2;
                Val val;
                List<Val> list2 = x$14;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                Serializable serializable = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString ? (package$.MODULE$.isYearMonthDuration(from2 = (valString = (ValString)val).value()) ? new ValYearMonthDuration(package$.MODULE$.stringToYearMonthDuration(from2)) : new ValDayTimeDuration(package$.MODULE$.stringToDayTimeDuration(from2))) : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction2() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "to"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$15) {
                void var10_12;
                List<Val> list2 = x$15;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValDate) {
                        ValDate valDate = (ValDate)val;
                        LocalDate from2 = valDate.value();
                        if (val2 instanceof ValDate) {
                            ValDate valDate2 = (ValDate)val2;
                            LocalDate to2 = valDate2.value();
                            ValYearMonthDuration valYearMonthDuration = new ValYearMonthDuration(Period.between(from2, to2).withDays(0));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction notFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"negand"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$16) {
                ValBoolean valBoolean;
                boolean negand;
                Val val;
                List<Val> list2 = x$16;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                Serializable serializable = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValBoolean ? new ValBoolean(!(negand = (valBoolean = (ValBoolean)val).value())) : ValNull$.MODULE$;
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "start"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$17) {
                void var10_12;
                List<Val> list2 = x$17;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            ValString valString2 = new ValString(string2.substring(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(string2, start.intValue())));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "start", "length"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$18) {
                void var13_15;
                List<Val> list2 = x$18;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber2 = (ValNumber)val3;
                                BigDecimal length = valNumber2.value();
                                ValString valString2 = new ValString(string2.substring(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(string2, start.intValue()), BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(string2, start.intValue()) + length.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public int org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(String string2, int index2) {
        return index2 > 0 ? index2 - 1 : string2.length() + index2;
    }

    public ValFunction stringLengthFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$19) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$19;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String string2 = valString.value();
                    serializable = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(string2.length()));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction upperCaseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$20) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$20;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String string2 = valString.value();
                    serializable = new ValString(string2.toUpperCase());
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction lowerCaseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$21) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$21;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String string2 = valString.value();
                    serializable = new ValString(string2.toLowerCase());
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringBeforeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$22) {
                void var10_13;
                List<Val> list2 = x$22;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            int index2 = string2.indexOf(m);
                            ValString valString3 = index2 > 0 ? new ValString(string2.substring(0, index2)) : new ValString("");
                            return var10_13;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringAfterFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$23) {
                void var10_13;
                List<Val> list2 = x$23;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            int index2 = string2.indexOf(m);
                            ValString valString3 = index2 > 0 ? new ValString(string2.substring(index2 + m.length())) : new ValString("");
                            return var10_13;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction replaceFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern", "replacement"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$24) {
                void var13_15;
                List<Val> list2 = x$24;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String input2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String pattern = valString2.value();
                            if (val3 instanceof ValString) {
                                ValString valString3 = (ValString)val3;
                                String replacement = valString3.value();
                                ValString valString4 = new ValString(input2.replaceAll(pattern, replacement));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction containsFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$25) {
                void var10_12;
                List<Val> list2 = x$25;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            ValBoolean valBoolean = new ValBoolean(string2.contains(m));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction startsWithFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$26) {
                void var10_12;
                List<Val> list2 = x$26;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            ValBoolean valBoolean = new ValBoolean(string2.startsWith(m));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction endsWithFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$27) {
                void var10_12;
                List<Val> list2 = x$27;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            ValBoolean valBoolean = new ValBoolean(string2.endsWith(m));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction matchesFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$28) {
                void var10_14;
                List<Val> list2 = x$28;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String input2 = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String pattern = valString2.value();
                            Pattern p = Pattern.compile(pattern);
                            Matcher m = p.matcher(input2);
                            ValBoolean valBoolean = new ValBoolean(m.find());
                            return var10_14;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_14;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction listContainsFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "element"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$29) {
                void var8_10;
                List<Val> list2 = x$29;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val element = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        ValBoolean valBoolean = new ValBoolean(list3.contains(element));
                        return var8_10;
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var8_10;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction countFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$30) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$30;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    serializable = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(list3.size()));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction minFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Val apply(List<Val> x$31) {
                void var7_17;
                Val val;
                List<Val> list2 = x$31;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    void var9_10;
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    if (((Object)Nil$.MODULE$).equals(list4)) {
                        ValNull$ valNull$ = ValNull$.MODULE$;
                    } else {
                        if (!(list4 instanceof $colon$colon)) throw new MatchError(list4);
                        $colon$colon $colon$colon = ($colon$colon)list4;
                        Val x = (Val)$colon$colon.head();
                        Val val2 = x;
                        Val val3 = val2 instanceof ValNumber ? BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ValNumber apply(List<BigDecimal> numbers) {
                                return new ValNumber((BigDecimal)numbers.min(Ordering$BigDecimal$.MODULE$));
                            }
                        })) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val2})));
                        Val val4 = val3;
                    }
                    void var7_15 = var9_10;
                    return var7_17;
                } else {
                    ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return var7_17;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction maxFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Val apply(List<Val> x$32) {
                void var7_17;
                Val val;
                List<Val> list2 = x$32;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    void var9_10;
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    if (((Object)Nil$.MODULE$).equals(list4)) {
                        ValNull$ valNull$ = ValNull$.MODULE$;
                    } else {
                        if (!(list4 instanceof $colon$colon)) throw new MatchError(list4);
                        $colon$colon $colon$colon = ($colon$colon)list4;
                        Val x = (Val)$colon$colon.head();
                        Val val2 = x;
                        Val val3 = val2 instanceof ValNumber ? BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ValNumber apply(List<BigDecimal> numbers) {
                                return new ValNumber((BigDecimal)numbers.max(Ordering$BigDecimal$.MODULE$));
                            }
                        })) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val2})));
                        Val val4 = val3;
                    }
                    void var7_15 = var9_10;
                    return var7_17;
                } else {
                    ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return var7_17;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sumFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$33) {
                Val val;
                Val val2;
                List<Val> list2 = x$33;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val2;
                    List<Val> list3 = valList.items();
                    val = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValNumber apply(List<BigDecimal> numbers) {
                            return new ValNumber(numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$));
                        }
                    }));
                } else {
                    val = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return val;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction meanFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$34) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$34;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    Val val2 = ((Object)Nil$.MODULE$).equals(list4) ? ValNull$.MODULE$ : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValNumber apply(List<BigDecimal> numbers) {
                            return new ValNumber(numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$).$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size())));
                        }
                    }));
                    serializable = val2;
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction andFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$35) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$35;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    Val val2 = ((Object)Nil$.MODULE$).equals(list4) ? new ValBoolean(true) : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfBooleans(list3, (Function1<List<Object>, Val>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValBoolean apply(List<Object> numbers) {
                            return new ValBoolean(BoxesRunTime.unboxToBoolean(numbers.reduce(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(boolean x$36, boolean x$37) {
                                    return x$36 && x$37;
                                }
                            })));
                        }
                    }));
                    serializable = val2;
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction orFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$38) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$38;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    Val val2 = ((Object)Nil$.MODULE$).equals(list4) ? new ValBoolean(false) : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfBooleans(list3, (Function1<List<Object>, Val>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValBoolean apply(List<Object> numbers) {
                            return new ValBoolean(BoxesRunTime.unboxToBoolean(numbers.reduce(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(boolean x$39, boolean x$40) {
                                    return x$39 || x$40;
                                }
                            })));
                        }
                    }));
                    serializable = val2;
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sublistFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "start"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$41) {
                void var10_12;
                List<Val> list2 = x$41;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            ValList valList2 = new ValList((List<Val>)list3.slice(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, start.intValue()), list3.length()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sublistFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "start", "length"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$42) {
                void var13_15;
                List<Val> list2 = x$42;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber2 = (ValNumber)val3;
                                BigDecimal length = valNumber2.value();
                                ValList valList2 = new ValList((List<Val>)list3.slice(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, start.intValue()), BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, start.intValue()) + length.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public int org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(List<?> list2, int index2) {
        return index2 > 0 ? index2 - 1 : list2.size() + index2;
    }

    public ValFunction appendFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "item"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$43) {
                void var9_12;
                List<Val> list2 = x$43;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val item = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (item != null) {
                            Val val2;
                            Val val3 = val2 = item;
                            ValList valList2 = new ValList(list3.$plus$plus(Nil$.MODULE$.$colon$colon(val3), List$.MODULE$.canBuildFrom()));
                            return var9_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var9_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction concatenateFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "other"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$45) {
                void var10_12;
                List<Val> list2 = x$45;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValList) {
                            ValList valList2 = (ValList)val2;
                            List<Val> other = valList2.items();
                            ValList valList3 = new ValList(list3.$plus$plus(other, List$.MODULE$.canBuildFrom()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction insertBeforeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "position", "newItem"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$46) {
                void var12_15;
                List<Val> list2 = x$46;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val newItem = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal position = valNumber.value();
                            if (newItem != null) {
                                Val val3;
                                Val val4 = val3 = newItem;
                                ValList valList2 = new ValList(((List)list3.take(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue()))).$plus$plus(Nil$.MODULE$.$colon$colon(val4), List$.MODULE$.canBuildFrom()).$plus$plus(list3.drop(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue())), List$.MODULE$.canBuildFrom()));
                                return var12_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var12_15;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction removeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "position"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$48) {
                void var10_12;
                List<Val> list2 = x$48;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal position = valNumber.value();
                            ValList valList2 = new ValList(((List)list3.take(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue()))).$plus$plus(list3.drop(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue() + 1)), List$.MODULE$.canBuildFrom()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction reverseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$49) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$49;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    serializable = new ValList((List<Val>)list3.reverse());
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction indexOfFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "match"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$50) {
                void var9_11;
                List<Val> list2 = x$50;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val m = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (m != null) {
                            Val val2 = m;
                            ValList valList2 = new ValList(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList(list3, val2, BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$3(), BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$4()).map(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ValNumber apply(int x$51) {
                                    return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(x$51));
                                }
                            }, List$.MODULE$.canBuildFrom()));
                            return var9_11;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var9_11;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public List<Object> org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList(List<Val> list2, Val item, int from2, List<Object> indexList) {
        int index2;
        while ((index2 = list2.indexOf(item, from2)) > 0) {
            indexList = indexList.$plus$plus(List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{index2 + 1})), List$.MODULE$.canBuildFrom());
            from2 = index2 + 1;
        }
        return indexList;
    }

    public int org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$3() {
        return 0;
    }

    public List<Object> org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$4() {
        return Nil$.MODULE$;
    }

    public ValFunction unionFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "other"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$52) {
                void var10_12;
                List<Val> list2 = x$52;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValList) {
                            ValList valList2 = (ValList)val2;
                            List<Val> other = valList2.items();
                            ValList valList3 = new ValList((List)((SeqLike)list3.$plus$plus(other, List$.MODULE$.canBuildFrom())).distinct());
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction distinctValuesFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$53) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$53;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    serializable = new ValList((List)list3.distinct());
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction flattenFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$54) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$54;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    serializable = new ValList(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$flatten(list3));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public List<Val> org$camunda$feel$interpreter$BuiltinFunctions$$flatten(List<Val> list2) {
        List<Val> list3;
        block5: {
            List list4;
            block3: {
                $colon$colon $colon$colon;
                boolean bl;
                block4: {
                    block2: {
                        bl = false;
                        $colon$colon = null;
                        list3 = list2;
                        if (!((Object)Nil$.MODULE$).equals(list3)) break block2;
                        list4 = Nil$.MODULE$;
                        break block3;
                    }
                    if (!(list3 instanceof $colon$colon)) break block4;
                    bl = true;
                    $colon$colon = ($colon$colon)list3;
                    Val val = (Val)$colon$colon.head();
                    List<Val> xs = $colon$colon.tl$1();
                    if (!(val instanceof ValList)) break block4;
                    ValList valList = (ValList)val;
                    List<Val> l = valList.items();
                    list4 = this.org$camunda$feel$interpreter$BuiltinFunctions$$flatten(l).$plus$plus(this.org$camunda$feel$interpreter$BuiltinFunctions$$flatten(xs), List$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!bl) break block5;
                Val x = (Val)$colon$colon.head();
                List<Val> xs = $colon$colon.tl$1();
                Val val = x;
                list4 = this.org$camunda$feel$interpreter$BuiltinFunctions$$flatten(xs).$colon$colon(val);
            }
            return list4;
        }
        throw new MatchError(list3);
    }

    public ValFunction sortFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "precedes"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Val apply(List<Val> x$56) {
                block8: {
                    var2_2 = x$56;
                    var3_3 = List$.MODULE$.unapplySeq(var2_2);
                    if (!var3_3.isEmpty() && var3_3.get() != null && ((LinearSeqOptimized)var3_3.get()).lengthCompare(2) == 0) {
                        var4_4 = (Val)((LinearSeqOptimized)var3_3.get()).apply(0);
                        var5_5 = (Val)((LinearSeqOptimized)var3_3.get()).apply(1);
                        if (var4_4 instanceof ValList) {
                            var6_6 = (ValList)var4_4;
                            list = var6_6.items();
                            if (var5_5 instanceof ValFunction) {
                                var8_8 = (ValFunction)var5_5;
                                params = var8_8.params();
                                f = var8_8.invoke();
                                if (params.size() == 2) {
                                    v0 /* !! */  = new ValList((List)list.sortWith((Function2)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final Function1 f$1;

                                        public final boolean apply(Val x0$1, Val x1$1) {
                                            Tuple2<Val, Val> tuple2 = new Tuple2<Val, Val>(x0$1, x1$1);
                                            if (tuple2 != null) {
                                                Val x = tuple2._1();
                                                Val y = tuple2._2();
                                                boolean bl = ((ValBoolean)this.f$1.apply(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Val[]{x, y})))).value();
                                                return bl;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.f$1 = f$1;
                                        }
                                    }));
                                }
                            }
                        }
                    }
                    if ((var13_11 = List$.MODULE$.unapplySeq(var2_2)).isEmpty() || var13_11.get() == null || ((LinearSeqOptimized)var13_11.get()).lengthCompare(2) != 0) ** GOTO lbl-1000
                    var14_12 = (Val)((LinearSeqOptimized)var13_11.get()).apply(0);
                    var15_13 = (Val)((LinearSeqOptimized)var13_11.get()).apply(1);
                    if (var14_12 instanceof ValList && var15_13 instanceof ValFunction) {
                        var16_14 = (ValFunction)var15_13;
                        params = var16_14.params();
                        var11_16 /* !! */  = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect boolean function with 2 arguments, but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(params.size())})));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var11_16 /* !! */  = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(var2_2);
                    }
                    break block8;
                    catch (Throwable var12_17) {
                        v0 /* !! */  = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to sort list by given precedes function: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{var12_17})));
                    }
                    var11_16 /* !! */  = v0 /* !! */ ;
                }
                return var11_16 /* !! */ ;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction decimalFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "scale"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$57) {
                void var10_12;
                List<Val> list2 = x$57;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal n = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal scale = valNumber2.value();
                            ValNumber valNumber3 = new ValNumber(n.setScale(scale.intValue(), BigDecimal$RoundingMode$.MODULE$.HALF_EVEN()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction floorFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$58) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$58;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal n = valNumber.value();
                    serializable = new ValNumber(n.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR()));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction ceilingFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})), (Function1<List<Val>, Val>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$59) {
                Serializable serializable;
                Val val;
                List<Val> list2 = x$59;
                Some<List<Val>> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal n = valNumber.value();
                    serializable = new ValNumber(n.setScale(0, BigDecimal$RoundingMode$.MODULE$.CEILING()));
                } else {
                    serializable = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return serializable;
            }
        }), ValFunction$.MODULE$.apply$default$3());
    }

    public Val org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(List<Val> list2, Function1<List<BigDecimal>, Val> f) {
        Option<Product> option;
        block4: {
            Val val;
            block3: {
                block2: {
                    option = ((LinearSeqOptimized)list2.map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Product apply(Val x$60) {
                            ValNumber valNumber;
                            Val val = x$60;
                            Serializable serializable = val instanceof ValNumber ? (valNumber = (ValNumber)val) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val})));
                            return serializable;
                        }
                    }, List$.MODULE$.canBuildFrom())).find(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Product x$61) {
                            return x$61 instanceof ValError;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Product e = (Product)some.x();
                    val = (Val)((Object)e);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                val = f.apply(list2.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BigDecimal apply(ValNumber x$62) {
                        return x$62.value();
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
            return val;
        }
        throw new MatchError(option);
    }

    public Val org$camunda$feel$interpreter$BuiltinFunctions$$withListOfBooleans(List<Val> list2, Function1<List<Object>, Val> f) {
        Option<Product> option;
        block4: {
            Val val;
            block3: {
                block2: {
                    option = ((LinearSeqOptimized)list2.map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Product apply(Val x$63) {
                            ValBoolean valBoolean;
                            Val val = x$63;
                            Serializable serializable = val instanceof ValBoolean ? (valBoolean = (ValBoolean)val) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected boolean but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val})));
                            return serializable;
                        }
                    }, List$.MODULE$.canBuildFrom())).find(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Product x$64) {
                            return x$64 instanceof ValError;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Product e = (Product)some.x();
                    val = (Val)((Object)e);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                val = f.apply(list2.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ValBoolean x$65) {
                        return x$65.value();
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
            return val;
        }
        throw new MatchError(option);
    }

    private BuiltinFunctions$() {
        MODULE$ = this;
        this.builtinFunctions = this.conversionFunctions().$plus$plus(this.booleanFunctions(), List$.MODULE$.canBuildFrom()).$plus$plus(this.stringFunctions(), List$.MODULE$.canBuildFrom()).$plus$plus(this.listFunctions(), List$.MODULE$.canBuildFrom()).$plus$plus(this.numericFunctions(), List$.MODULE$.canBuildFrom());
        this.builtinFunctionsByNameAndArgCount = ((TraversableOnce)this.builtinFunctions().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<String, Object>, ValFunction> apply(Tuple2<String, ValFunction> x0$2) {
                Tuple2<String, ValFunction> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = tuple2._1();
                    ValFunction f = tuple2._2();
                    Tuple2<Tuple2<String, Object>, ValFunction> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<String, Integer>(name, BoxesRunTime.boxToInteger(f.params().size()))), f);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

