/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import org.camunda.feel.interpreter.Context;
import org.camunda.feel.interpreter.DefaultContext;
import org.camunda.feel.interpreter.DefaultContext$;
import org.camunda.feel.interpreter.DefaultValueMapper$;
import org.camunda.feel.interpreter.ObjectContext;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValContext;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.interpreter.ValueMapper;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u0017\t\u0011B)\u001a4bk2$h+\u00197vK6\u000b\u0007\u000f]3s\u0015\t\u0019A!A\u0006j]R,'\u000f\u001d:fi\u0016\u0014(BA\u0003\u0007\u0003\u00111W-\u001a7\u000b\u0005\u001dA\u0011aB2b[VtG-\u0019\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0006WC2,X-T1qa\u0016\u0014\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0003\u001c\u0001\u0011\u0005A$A\u0003u_Z\u000bG\u000e\u0006\u0002\u001eAA\u00111CH\u0005\u0003?\t\u00111AV1m\u0011\u0015\t#\u00041\u0001#\u0003\u0005A\bCA\u0007$\u0013\t!cBA\u0002B]fDQA\n\u0001\u0005\u0002\u001d\n\u0011\"\u001e8qC\u000e\\g+\u00197\u0015\u0005\tB\u0003\"B\u0015&\u0001\u0004i\u0012!\u0002<bYV,w!B\u0016\u0003\u0011\u0003a\u0013A\u0005#fM\u0006,H\u000e\u001e,bYV,W*\u00199qKJ\u0004\"aE\u0017\u0007\u000b\u0005\u0011\u0001\u0012\u0001\u0018\u0014\u00055b\u0001\"B\f.\t\u0003\u0001D#\u0001\u0017\t\u000fIj#\u0019!C\u0001g\u0005A\u0011N\\:uC:\u001cW-F\u0001\u001a\u0011\u0019)T\u0006)A\u00053\u0005I\u0011N\\:uC:\u001cW\r\t")
public class DefaultValueMapper
implements ValueMapper {
    public static DefaultValueMapper instance() {
        return DefaultValueMapper$.MODULE$.instance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Val toVal(Object x2) {
        scala.Serializable serializable;
        boolean bl = false;
        float f = 0.0f;
        boolean bl2 = false;
        double d = 0.0;
        Object object = x2;
        if (object instanceof Val) {
            Val val = (Val)object;
            return val;
        }
        if (object == null) {
            return ValNull$.MODULE$;
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(object);
            return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(n));
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            return new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(l));
        }
        if (object instanceof Float) {
            bl = true;
            f = BoxesRunTime.unboxToFloat(object);
            if (Predef$.MODULE$.float2Float(f).isNaN()) return ValNull$.MODULE$;
            if (RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                return ValNull$.MODULE$;
            }
        }
        if (bl) {
            return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(f));
        }
        if (object instanceof Double) {
            bl2 = true;
            d = BoxesRunTime.unboxToDouble(object);
            if (Predef$.MODULE$.double2Double(d).isNaN()) return ValNull$.MODULE$;
            if (RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                return ValNull$.MODULE$;
            }
        }
        if (bl2) {
            return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(d));
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return new ValNumber(bigDecimal);
        }
        if (object instanceof Boolean) {
            boolean bl3 = BoxesRunTime.unboxToBoolean(object);
            return new ValBoolean(bl3);
        }
        if (object instanceof String) {
            String string = (String)object;
            return new ValString(string);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return new ValDate(localDate);
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return new ValLocalTime(localTime);
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            return new ValTime(offsetTime);
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return new ValLocalDateTime(localDateTime);
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return new ValDateTime(offsetDateTime);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return new ValYearMonthDuration(period);
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return new ValDayTimeDuration(duration);
        }
        if (object instanceof List) {
            List list = (List)object;
            return new ValList(list.map((Function1<Object, Val> & Serializable & scala.Serializable)x -> this.toVal(x), List$.MODULE$.canBuildFrom()));
        }
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            return new ValContext(new DefaultContext(map.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object key = tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key.toString()), this.toVal(value));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), DefaultContext$.MODULE$.apply$default$2(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5()));
        }
        if (object instanceof Some) {
            Some some = (Some)object;
            Object x3 = some.value();
            return this.toVal(x3);
        }
        if (None$.MODULE$.equals(object)) {
            return ValNull$.MODULE$;
        }
        if (object instanceof Enumeration.Val) {
            Enumeration.Val val = (Enumeration.Val)object;
            return new ValString(val.toString());
        }
        if (object instanceof java.math.BigDecimal) {
            java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
            return new ValNumber(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new ValDateTime(date.toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime());
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return new ValDateTime(zonedDateTime.toOffsetDateTime());
        }
        if (object instanceof java.util.List) {
            java.util.List list = (java.util.List)object;
            return new ValList(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toList().map((Function1<Object, Val> & Serializable & scala.Serializable)x -> this.toVal(x), List$.MODULE$.canBuildFrom()));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return new ValContext(new DefaultContext(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object key = tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key.toString()), this.toVal(value));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), DefaultContext$.MODULE$.apply$default$2(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5()));
        }
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            return new ValString(enum_.name());
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            return new ValError(throwable.getMessage());
        }
        try {
            serializable = new ValContext(new ObjectContext(object, this));
            return serializable;
        }
        catch (Throwable throwable) {
            serializable = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported object '", "' of class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{object, object.getClass()})));
        }
        return serializable;
    }

    @Override
    public Object unpackVal(Val value2) {
        ValContext valContext;
        Context dc;
        Object object;
        Val val = value2;
        if (ValNull$.MODULE$.equals(val)) {
            object = null;
        } else if (val instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val;
            boolean bl = valBoolean.value();
            object = BoxesRunTime.boxToBoolean(bl);
        } else if (val instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val;
            BigDecimal number2 = valNumber.value();
            object = number2;
        } else if (val instanceof ValString) {
            ValString valString = (ValString)val;
            String string = valString.value();
            object = string;
        } else if (val instanceof ValDate) {
            ValDate valDate = (ValDate)val;
            LocalDate date = valDate.value();
            object = date;
        } else if (val instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val;
            LocalTime time = valLocalTime.value();
            object = time;
        } else if (val instanceof ValTime) {
            ValTime valTime = (ValTime)val;
            OffsetTime time = valTime.value();
            object = time;
        } else if (val instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
            LocalDateTime dateTime = valLocalDateTime.value();
            object = dateTime;
        } else if (val instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val;
            OffsetDateTime dateTime = valDateTime.value();
            object = dateTime;
        } else if (val instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val;
            Period duration = valYearMonthDuration.value();
            object = duration;
        } else if (val instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
            Duration duration = valDayTimeDuration.value();
            object = duration;
        } else if (val instanceof ValList) {
            ValList valList = (ValList)val;
            List<Val> list = valList.items();
            object = list.map((Function1<Val, Object> & Serializable & scala.Serializable)value -> this.unpackVal((Val)value), List$.MODULE$.canBuildFrom());
        } else if (val instanceof ValContext && (dc = (valContext = (ValContext)val).context()) instanceof DefaultContext) {
            DefaultContext defaultContext = (DefaultContext)dc;
            object = defaultContext.variables().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), this.unpackVal(this.toVal(value)));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()).toMap(Predef$.MODULE$.$conforms());
        } else if (val instanceof ValError) {
            ValError valError = (ValError)val;
            String error = valError.error();
            object = new Exception(error);
        } else if (val instanceof ValFunction) {
            ValFunction valFunction = (ValFunction)val;
            object = valFunction;
        } else {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected val '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{value2})));
        }
        return object;
    }
}

