/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.integration;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import org.camunda.feel.interpreter.Context;
import org.camunda.feel.interpreter.DefaultContext;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValContext;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.spi.CustomValueMapper;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001\u0017\t\u00112)Y7v]\u0012\fg+\u00197vK6\u000b\u0007\u000f]3s\u0015\t\u0019A!A\u0006j]R,wM]1uS>t'BA\u0003\u0007\u0003\u00111W-\u001a7\u000b\u0005\u001dA\u0011aB2b[VtG-\u0019\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f\u0011\t1a\u001d9j\u0013\t\tbBA\tDkN$x.\u001c,bYV,W*\u00199qKJDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000ba\u0001A\u0011I\r\u0002\u000bQ|g+\u00197\u0015\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003-Ig\u000e^3saJ,G/\u001a:\n\u0005}a\"a\u0001,bY\")\u0011e\u0006a\u0001E\u0005\t\u0001\u0010\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CEA\u0002B]fDQ!\u000b\u0001\u0005B)\n\u0011\"\u001e8qC\u000e\\g+\u00197\u0015\u0005\tZ\u0003\"\u0002\u0017)\u0001\u0004Q\u0012!\u0002<bYV,\u0007")
public class CamundaValueMapper
extends CustomValueMapper {
    @Override
    public Val toVal(Object x) {
        Val val;
        Object object = x;
        if (object instanceof org.joda.time.LocalDate) {
            org.joda.time.LocalDate localDate = (org.joda.time.LocalDate)object;
            val = new ValDate(LocalDate.of(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth()));
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            val = new ValLocalTime(java.time.LocalTime.of(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute()));
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            val = new ValLocalDateTime(java.time.LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthOfYear(), localDateTime.getDayOfMonth(), localDateTime.getHourOfDay(), localDateTime.getMinuteOfHour(), localDateTime.getSecondOfMinute()));
        } else if (object instanceof Duration) {
            Duration duration = (Duration)object;
            val = new ValDayTimeDuration(java.time.Duration.ofMillis(duration.getMillis()));
        } else if (object instanceof org.joda.time.Period) {
            org.joda.time.Period period = (org.joda.time.Period)object;
            val = new ValYearMonthDuration(Period.of(period.getYears(), period.getMonths(), 0));
        } else {
            val = super.toVal(x);
        }
        return val;
    }

    @Override
    public Object unpackVal(Val value2) {
        ValContext valContext;
        Context dc;
        Object object;
        Val val = value2;
        if (val instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val;
            BigDecimal number2 = valNumber.value();
            object = Predef$.MODULE$.double2Double(number2.doubleValue());
        } else if (val instanceof ValList) {
            ValList valList = (ValList)val;
            List<Val> list = valList.items();
            object = JavaConverters$.MODULE$.seqAsJavaListConverter(list.map((Function1<Val, Object> & Serializable & scala.Serializable)value -> this.unpackVal((Val)value), List$.MODULE$.canBuildFrom())).asJava();
        } else if (val instanceof ValContext && (dc = (valContext = (ValContext)val).context()) instanceof DefaultContext) {
            DefaultContext defaultContext = (DefaultContext)dc;
            object = JavaConverters$.MODULE$.mapAsJavaMapConverter(defaultContext.variables().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), this.unpackVal(this.toVal(value)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()).toMap(Predef$.MODULE$.$conforms())).asJava();
        } else {
            object = super.unpackVal(value2);
        }
        return object;
    }
}

