/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.io.Serializable;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import org.camunda.feel.datatype.ZonedTime;
import org.camunda.feel.datatype.ZonedTime$;
import org.camunda.feel.interpreter.Context;
import org.camunda.feel.interpreter.DefaultContext;
import org.camunda.feel.interpreter.DefaultContext$;
import org.camunda.feel.interpreter.DefaultValueMapper$;
import org.camunda.feel.interpreter.ObjectContext;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValContext;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.interpreter.ValueMapper;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

@ScalaSignature(bytes="\u0006\u0005u2AAC\u0006\u0001)!)q\u0004\u0001C\u0001A!)!\u0005\u0001C\u0001G!)A\u0006\u0001C\u0005[!)!\u0007\u0001C\u0001g\u001d)ag\u0003E\u0001o\u0019)!b\u0003E\u0001q!)qD\u0002C\u0001s!9!H\u0002b\u0001\n\u0003Y\u0004B\u0002\u001f\u0007A\u0003%\u0011E\u0001\nEK\u001a\fW\u000f\u001c;WC2,X-T1qa\u0016\u0014(B\u0001\u0007\u000e\u0003-Ig\u000e^3saJ,G/\u001a:\u000b\u00059y\u0011\u0001\u00024fK2T!\u0001E\t\u0002\u000f\r\fW.\u001e8eC*\t!#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f\u001e\u001b\u0005Y\u0011B\u0001\u0010\f\u0005-1\u0016\r\\;f\u001b\u0006\u0004\b/\u001a:\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u000f\u0001\u0003\u0015!xNV1m)\t!s\u0005\u0005\u0002\u001dK%\u0011ae\u0003\u0002\u0004-\u0006d\u0007\"\u0002\u0015\u0003\u0001\u0004I\u0013!\u0001=\u0011\u0005YQ\u0013BA\u0016\u0018\u0005\r\te._\u0001\u000eSN,e.^7fe\u0006$\u0018n\u001c8\u0015\u00059\n\u0004C\u0001\f0\u0013\t\u0001tCA\u0004C_>dW-\u00198\t\u000b!\u001a\u0001\u0019A\u0015\u0002\u0013Ut\u0007/Y2l-\u0006dGCA\u00155\u0011\u0015)D\u00011\u0001%\u0003\u00151\u0018\r\\;f\u0003I!UMZ1vYR4\u0016\r\\;f\u001b\u0006\u0004\b/\u001a:\u0011\u0005q11C\u0001\u0004\u0016)\u00059\u0014\u0001C5ogR\fgnY3\u0016\u0003\u0005\n\u0011\"\u001b8ti\u0006t7-\u001a\u0011")
public class DefaultValueMapper
implements ValueMapper {
    public static DefaultValueMapper instance() {
        return DefaultValueMapper$.MODULE$.instance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Val toVal(Object x2) {
        Product product;
        boolean bl = false;
        float f = 0.0f;
        boolean bl2 = false;
        double d = 0.0;
        Object object = x2;
        if (object instanceof Val) {
            Val val = (Val)object;
            return val;
        }
        if (object == null) {
            return ValNull$.MODULE$;
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(object);
            return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(n));
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            return new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(l));
        }
        if (object instanceof Float) {
            bl = true;
            f = BoxesRunTime.unboxToFloat(object);
            if (Predef$.MODULE$.float2Float(f).isNaN()) return ValNull$.MODULE$;
            if (RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                return ValNull$.MODULE$;
            }
        }
        if (bl) {
            return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(f));
        }
        if (object instanceof Double) {
            bl2 = true;
            d = BoxesRunTime.unboxToDouble(object);
            if (Predef$.MODULE$.double2Double(d).isNaN()) return ValNull$.MODULE$;
            if (RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                return ValNull$.MODULE$;
            }
        }
        if (bl2) {
            return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(d));
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return new ValNumber(bigDecimal);
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            return new ValNumber(BigDecimal$.MODULE$.apply(bigInt));
        }
        if (object instanceof Boolean) {
            boolean bl3 = BoxesRunTime.unboxToBoolean(object);
            return new ValBoolean(bl3);
        }
        if (object instanceof String) {
            String string = (String)object;
            return new ValString(string);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return new ValDate(localDate);
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return new ValLocalTime(localTime);
        }
        if (object instanceof ZonedTime) {
            ZonedTime zonedTime = (ZonedTime)object;
            return new ValTime(zonedTime);
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return new ValLocalDateTime(localDateTime);
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return new ValDateTime(zonedDateTime);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return new ValYearMonthDuration(period);
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return new ValDayTimeDuration(duration);
        }
        if (object instanceof List) {
            List list = (List)object;
            return new ValList((List<Val>)list.map((Function1<Object, Val> & Serializable)x -> this.toVal(x)));
        }
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            Tuple2 tuple2 = map.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object key = tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key.toString()), this.toVal(value));
                return tuple22;
            }).partition((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(DefaultValueMapper.$anonfun$toVal$3(x0$2)));
            if (tuple2 == null) throw new MatchError(tuple2);
            scala.collection.immutable.Map functions = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map variables = (scala.collection.immutable.Map)tuple2._2();
            Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map> tuple22 = new Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map>(functions, variables);
            Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map> tuple23 = tuple22;
            scala.collection.immutable.Map functions2 = tuple23._1();
            scala.collection.immutable.Map variables2 = tuple23._2();
            return new ValContext(new DefaultContext(variables2, (scala.collection.immutable.Map)functions2.map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String key = (String)tuple2._1();
                Val f = (Val)tuple2._2();
                Tuple2<String, $colon$colon<Nothing$>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), new $colon$colon<Nothing$>((Nothing$)((Object)((ValFunction)f)), Nil$.MODULE$));
                return tuple22;
            }), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5()));
        }
        if (object instanceof Some) {
            Some some = (Some)object;
            Object x3 = some.value();
            return this.toVal(x3);
        }
        if (None$.MODULE$.equals(object)) {
            return ValNull$.MODULE$;
        }
        if (this.isEnumeration(object)) {
            return new ValString(object.toString());
        }
        if (object instanceof java.math.BigDecimal) {
            java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
            return new ValNumber(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return new ValNumber(BigDecimal$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger)));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new ValLocalDateTime(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return new ValDateTime(offsetDateTime.toZonedDateTime());
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            return new ValTime(ZonedTime$.MODULE$.of(offsetTime));
        }
        if (object instanceof java.util.List) {
            java.util.List list = (java.util.List)object;
            return new ValList((List<Val>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toList().map((Function1<Object, Val> & Serializable)x -> this.toVal(x)));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return new ValContext(new DefaultContext(((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1<Tuple2, Tuple2> & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object key = tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key.toString()), this.toVal(value));
                return tuple22;
            }).toMap($less$colon$less$.MODULE$.refl()), DefaultContext$.MODULE$.apply$default$2(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5()));
        }
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            return new ValString(enum_.name());
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            return new ValError(throwable.getMessage());
        }
        try {
            product = new ValContext(new ObjectContext(object, this));
            return product;
        }
        catch (Throwable throwable) {
            product = new ValError(new StringBuilder(33).append("unsupported object '").append(object).append("' of class '").append(object.getClass()).append("'").toString());
        }
        return product;
    }

    private boolean isEnumeration(Object x) {
        return "scala.Enumeration$Val".equals(x.getClass().getName());
    }

    @Override
    public Object unpackVal(Val value2) {
        ValContext valContext;
        Context dc;
        scala.collection.immutable.Map map;
        Val val = value2;
        if (ValNull$.MODULE$.equals(val)) {
            map = null;
        } else if (val instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val;
            boolean bl = valBoolean.value();
            map = BoxesRunTime.boxToBoolean(bl);
        } else if (val instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val;
            BigDecimal number2 = valNumber.value();
            map = number2;
        } else if (val instanceof ValString) {
            ValString valString = (ValString)val;
            String string = valString.value();
            map = string;
        } else if (val instanceof ValDate) {
            ValDate valDate = (ValDate)val;
            LocalDate date = valDate.value();
            map = date;
        } else if (val instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val;
            LocalTime time = valLocalTime.value();
            map = time;
        } else if (val instanceof ValTime) {
            ValTime valTime = (ValTime)val;
            ZonedTime time = valTime.value();
            map = time;
        } else if (val instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
            LocalDateTime dateTime = valLocalDateTime.value();
            map = dateTime;
        } else if (val instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val;
            ZonedDateTime dateTime = valDateTime.value();
            map = dateTime;
        } else if (val instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val;
            Period duration = valYearMonthDuration.value();
            map = duration;
        } else if (val instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
            Duration duration = valDayTimeDuration.value();
            map = duration;
        } else if (val instanceof ValList) {
            ValList valList = (ValList)val;
            List<Val> list = valList.items();
            map = list.map((Function1<Val, Object> & Serializable)value -> this.unpackVal((Val)value));
        } else if (val instanceof ValContext && (dc = (valContext = (ValContext)val).context()) instanceof DefaultContext) {
            DefaultContext defaultContext = (DefaultContext)dc;
            map = ((scala.collection.immutable.Map)defaultContext.variables().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                Tuple2<String, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), this.unpackVal(this.toVal(value)));
                return tuple22;
            })).toMap($less$colon$less$.MODULE$.refl());
        } else if (val instanceof ValError) {
            ValError valError = (ValError)val;
            String error = valError.error();
            map = new Exception(error);
        } else if (val instanceof ValFunction) {
            ValFunction valFunction = (ValFunction)val;
            map = valFunction;
        } else {
            throw new IllegalArgumentException(new StringBuilder(17).append("unexpected val '").append(value2).append("'").toString());
        }
        return map;
    }

    public static final /* synthetic */ boolean $anonfun$toVal$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Val value = (Val)tuple2._2();
        boolean bl = value instanceof ValFunction;
        return bl;
    }
}

