/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.JDKStringConverter;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringConvert {
    public static final StringConvert INSTANCE = new StringConvert();
    private final ConcurrentMap<Class<?>, StringConverter<?>> registered = new ConcurrentHashMap();

    public StringConvert() {
        this(true);
    }

    public StringConvert(boolean bl) {
        if (bl) {
            for (JDKStringConverter jDKStringConverter : JDKStringConverter.values()) {
                this.registered.put(jDKStringConverter.getType(), jDKStringConverter);
            }
            this.registered.put(Boolean.TYPE, JDKStringConverter.BOOLEAN);
            this.registered.put(Byte.TYPE, JDKStringConverter.BYTE);
            this.registered.put(Short.TYPE, JDKStringConverter.SHORT);
            this.registered.put(Integer.TYPE, JDKStringConverter.INTEGER);
            this.registered.put(Long.TYPE, JDKStringConverter.LONG);
            this.registered.put(Float.TYPE, JDKStringConverter.FLOAT);
            this.registered.put(Double.TYPE, JDKStringConverter.DOUBLE);
            this.registered.put(Character.TYPE, JDKStringConverter.CHARACTER);
            this.tryRegister("javax.time.Instant", "parse");
            this.tryRegister("javax.time.Duration", "parse");
            this.tryRegister("javax.time.calendar.LocalDate", "parse");
            this.tryRegister("javax.time.calendar.LocalTime", "parse");
            this.tryRegister("javax.time.calendar.LocalDateTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDate", "parse");
            this.tryRegister("javax.time.calendar.OffsetTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDateTime", "parse");
            this.tryRegister("javax.time.calendar.ZonedDateTime", "parse");
            this.tryRegister("javax.time.calendar.Year", "parse");
            this.tryRegister("javax.time.calendar.YearMonth", "parse");
            this.tryRegister("javax.time.calendar.MonthDay", "parse");
            this.tryRegister("javax.time.calendar.Period", "parse");
            this.tryRegister("javax.time.calendar.ZoneOffset", "of");
            this.tryRegister("javax.time.calendar.ZoneId", "of");
            this.tryRegister("javax.time.calendar.TimeZone", "of");
        }
    }

    private void tryRegister(String string2, String string3) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string2);
            this.registerMethods(clazz, "toString", string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> String convertToString(T t) {
        if (t == null) {
            return null;
        }
        Class<?> clazz = t.getClass();
        StringConverter<?> stringConverter = this.findConverter(clazz);
        return stringConverter.convertToString(t);
    }

    public <T> String convertToString(Class<T> clazz, T t) {
        if (t == null) {
            return null;
        }
        StringConverter<T> stringConverter = this.findConverter(clazz);
        return stringConverter.convertToString(t);
    }

    public <T> T convertFromString(Class<T> clazz, String string2) {
        if (string2 == null) {
            return null;
        }
        StringConverter<T> stringConverter = this.findConverter(clazz);
        return stringConverter.convertFromString(clazz, string2);
    }

    public <T> StringConverter<T> findConverter(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        StringConverter stringConverter = (StringConverter)this.registered.get(clazz);
        if (stringConverter == null) {
            if (clazz == Object.class) {
                throw new IllegalStateException("No registered converter found: " + clazz);
            }
            for (Class<T> clazz2 = clazz.getSuperclass(); clazz2 != null && stringConverter == null; clazz2 = clazz2.getSuperclass()) {
                stringConverter = (StringConverter)this.registered.get(clazz2);
            }
            if (stringConverter == null && (stringConverter = this.findAnnotationConverter(clazz)) == null) {
                throw new IllegalStateException("No registered converter found: " + clazz);
            }
            this.registered.putIfAbsent(clazz, stringConverter);
        }
        return stringConverter;
    }

    private <T> StringConverter<T> findAnnotationConverter(Class<T> clazz) {
        Method method = this.findToStringMethod(clazz);
        if (method == null) {
            return null;
        }
        Constructor<T> constructor = this.findFromStringConstructor(clazz);
        Method method2 = this.findFromStringMethod(clazz, constructor == null);
        if (constructor == null && method2 == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString");
        }
        if (constructor != null && method2 != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString");
        }
        if (constructor != null) {
            return new MethodConstructorStringConverter<T>(clazz, method, constructor);
        }
        return new MethodsStringConverter<T>(clazz, method, method2);
    }

    private Method findToStringMethod(Class<?> clazz) {
        Method method = null;
        for (Class<?> clazz2 = clazz; clazz2 != null && method == null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method2 : methodArray = clazz2.getDeclaredMethods()) {
                ToString toString2 = method2.getAnnotation(ToString.class);
                if (toString2 == null) continue;
                if (method != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString");
                }
                method = method2;
            }
        }
        return method;
    }

    private <T> Constructor<T> findFromStringConstructor(Class<T> clazz) {
        Constructor<FromString> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                constructor = clazz.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
        FromString fromString = constructor.getAnnotation(FromString.class);
        return fromString != null ? constructor : null;
    }

    private Method findFromStringMethod(Class<?> clazz, boolean bl) {
        Method method = null;
        for (Class<?> clazz2 = clazz; clazz2 != null && method == null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method2 : methodArray = clazz2.getDeclaredMethods()) {
                FromString fromString = method2.getAnnotation(FromString.class);
                if (fromString == null) continue;
                if (method != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString");
                }
                method = method2;
            }
            if (!bl) break;
        }
        return method;
    }

    public <T> void register(Class<T> clazz, StringConverter<T> stringConverter) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (stringConverter == null) {
            throw new IllegalArgumentException("StringConverter must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        StringConverter<T> stringConverter2 = this.registered.putIfAbsent(clazz, stringConverter);
        if (stringConverter2 != null) {
            throw new IllegalStateException("Converter already registered for class: " + clazz);
        }
    }

    public <T> void registerMethods(Class<T> clazz, String string2, String string3) {
        Method method;
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string2 == null || string3 == null) {
            throw new IllegalArgumentException("Method names must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method method2 = this.findToStringMethod(clazz, string2);
        MethodsStringConverter<T> methodsStringConverter = new MethodsStringConverter<T>(clazz, method2, method = this.findFromStringMethod(clazz, string3));
        StringConverter stringConverter = this.registered.putIfAbsent(clazz, methodsStringConverter);
        if (stringConverter != null) {
            throw new IllegalStateException("Converter already registered for class: " + clazz);
        }
    }

    public <T> void registerMethodConstructor(Class<T> clazz, String string2) {
        Constructor<T> constructor;
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method method = this.findToStringMethod(clazz, string2);
        MethodConstructorStringConverter<T> methodConstructorStringConverter = new MethodConstructorStringConverter<T>(clazz, method, constructor = this.findFromStringConstructorByType(clazz));
        StringConverter stringConverter = this.registered.putIfAbsent(clazz, methodConstructorStringConverter);
        if (stringConverter != null) {
            throw new IllegalStateException("Converter already registered for class: " + clazz);
        }
    }

    private Method findToStringMethod(Class<?> clazz, String string2) {
        Method method;
        try {
            method = clazz.getMethod(string2, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException);
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method must not be static: " + string2);
        }
        return method;
    }

    private Method findFromStringMethod(Class<?> clazz, String string2) {
        Method method;
        try {
            method = clazz.getMethod(string2, String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getMethod(string2, CharSequence.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalArgumentException("Method not found", noSuchMethodException2);
            }
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method must be static: " + string2);
        }
        return method;
    }

    private <T> Constructor<T> findFromStringConstructorByType(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalArgumentException("Constructor not found", noSuchMethodException2);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

