/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.datatype;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import org.camunda.feel.datatype.ZonedTime$;
import org.camunda.feel.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=d\u0001B\u001c9\u0001\u0006C\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00053\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011B5\t\u000bA\u0004A\u0011A9\t\u000f]\u0004!\u0019!C\u0001q\"1A\u0010\u0001Q\u0001\neDq! \u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002@\u0001!\t!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002>!9\u00111\t\u0001\u0005\u0002\u0005u\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\r\u0005%\u0005\u0001\"\u0001Y\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0018\"I\u0011Q\u0016\u0001\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003g\u0003\u0011\u0013!C\u0001\u0003kC\u0011\"!/\u0001\u0003\u0003%\t%a/\t\u0013\u0005\u001d\u0007!!A\u0005\u0002\u0005u\u0002\"CAe\u0001\u0005\u0005I\u0011AAf\u0011%\t9\u000eAA\u0001\n\u0003\nI\u000eC\u0005\u0002h\u0002\t\t\u0011\"\u0001\u0002j\"I\u0011Q\u001e\u0001\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003g\u0004\u0011\u0011!C!\u0003kD\u0011\"a>\u0001\u0003\u0003%\t%!?\t\u0013\u0005m\b!!A\u0005B\u0005uxa\u0002B\u0001q!\u0005!1\u0001\u0004\u0007oaB\tA!\u0002\t\rALC\u0011\u0001B\t\u0011!\u0011\u0019\"\u000bb\u0001\n\u0003q\bb\u0002B\u000bS\u0001\u0006Ia \u0005\n\u0005/I#\u0019!C\u0001\u00053A\u0001B!\n*A\u0003%!1\u0004\u0005\b\u0005OIC\u0011\u0001B\u0015\u0011\u001d\u0011i#\u000bC\u0001\u0005_AqA!\f*\t\u0003\u0011)\u0004C\u0004\u0003.%\"\tAa\u000f\t\u000f\u0005m\u0013\u0006\"\u0001\u0003B!I!1J\u0015\u0002\u0002\u0013\u0005%Q\n\u0005\n\u0005+J\u0013\u0011!CA\u0005/B\u0011B!\u001a*\u0003\u0003%IAa\u001a\u0003\u0013i{g.\u001a3US6,'BA\u001d;\u0003!!\u0017\r^1usB,'BA\u001e=\u0003\u00111W-\u001a7\u000b\u0005ur\u0014aB2b[VtG-\u0019\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0011%L!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fMB\u00111)S\u0005\u0003\u0015\u0012\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002M):\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0002\u000ba\u0001\u0010:p_Rt\u0014\"A#\n\u0005M#\u0015a\u00029bG.\fw-Z\u0005\u0003+Z\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!a\u0015#\u0002\tQLW.Z\u000b\u00023B\u0011!LX\u0007\u00027*\u0011q\u000b\u0018\u0006\u0002;\u0006!!.\u0019<b\u0013\ty6LA\u0005M_\u000e\fG\u000eV5nK\u0006)A/[7fA\u00051qN\u001a4tKR,\u0012a\u0019\t\u00035\u0012L!!Z.\u0003\u0015i{g.Z(gMN,G/A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\ti|g.Z\u000b\u0002SB\u00191I\u001b7\n\u0005-$%AB(qi&|g\u000e\u0005\u0002[[&\u0011an\u0017\u0002\u00075>tW-\u00133\u0002\u000bi|g.\u001a\u0011\u0002\rqJg.\u001b;?)\u0011\u0011H/\u001e<\u0011\u0005M\u0004Q\"\u0001\u001d\t\u000b];\u0001\u0019A-\t\u000b\u0005<\u0001\u0019A2\t\u000b\u001d<\u0001\u0019A5\u0002\u0017!\f7\u000fV5nKj{g.Z\u000b\u0002sB\u00111I_\u0005\u0003w\u0012\u0013qAQ8pY\u0016\fg.\u0001\u0007iCN$\u0016.\\3[_:,\u0007%A\u0003oC:|7/F\u0001\u0000!\r\u0019\u0015\u0011A\u0005\u0004\u0003\u0007!%\u0001\u0002'p]\u001e\faA\\1o_N\u0004\u0013\u0001\u00029mkN$2A]A\u0006\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001f\t1\"Y7pk:$Hk\\!eIB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016m\u000b\u0001\u0002^3na>\u0014\u0018\r\\\u0005\u0005\u00033\t\u0019B\u0001\bUK6\u0004xN]1m\u00036|WO\u001c;\u0002\u000b5Lg.^:\u0015\u0007I\fy\u0002C\u0004\u0002\u000e5\u0001\r!a\u0004\u0002\u0013\r|W\u000e]1sKR{G\u0003BA\u0013\u0003W\u00012aQA\u0014\u0013\r\tI\u0003\u0012\u0002\u0004\u0013:$\bBBA\u0017\u001d\u0001\u0007!/A\u0003pi\",'/\u0001\u0005jg\n+gm\u001c:f)\rI\u00181\u0007\u0005\u0007\u0003[y\u0001\u0019\u0001:\u0002\u000f%\u001c\u0018I\u001a;feR\u0019\u00110!\u000f\t\r\u00055\u0002\u00031\u0001s\u0003\u001d9W\r\u001e%pkJ,\"!!\n\u0002\u0013\u001d,G/T5okR,\u0017!C4fiN+7m\u001c8e\u0003]9W\r^(gMN,G/\u00138U_R\fGnU3d_:$7/A\u0005hKRTvN\\3JIV\u0011\u0011\u0011\n\t\u0005\u0007*\fY\u0005\u0005\u0003\u0002N\u0005Uc\u0002BA(\u0003#\u0002\"A\u0014#\n\u0007\u0005MC)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\nIF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'\"\u0015a\u00022fi^,WM\u001c\u000b\u0005\u0003?\n)\u0007E\u0002[\u0003CJ1!a\u0019\\\u0005!!UO]1uS>t\u0007BBA\u0017-\u0001\u0007!/\u0001\u0004g_Jl\u0017\r^\u000b\u0003\u0003\u0017\n\u0001b^5uQ\u0012\u000bG/\u001a\u000b\u0005\u0003_\n)\bE\u0002[\u0003cJ1!a\u001d\\\u00055QvN\\3e\t\u0006$X\rV5nK\"9\u0011q\u000f\rA\u0002\u0005e\u0014\u0001\u00023bi\u0016\u00042AWA>\u0013\r\tih\u0017\u0002\n\u0019>\u001c\u0017\r\u001c#bi\u0016\fA\u0002^8PM\u001a\u001cX\r\u001e+j[\u0016,\"!a!\u0011\u0007i\u000b))C\u0002\u0002\bn\u0013!b\u00144gg\u0016$H+[7f\u0003-!x\u000eT8dC2$\u0016.\\3\u0002\t\r|\u0007/\u001f\u000b\be\u0006=\u0015\u0011SAJ\u0011\u001d96\u0004%AA\u0002eCq!Y\u000e\u0011\u0002\u0003\u00071\rC\u0004h7A\u0005\t\u0019A5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0014\u0016\u00043\u0006m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dF)\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0017\u0016\u0004G\u0006m\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003oS3![AN\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111\u0019/\u0002\t1\fgnZ\u0005\u0005\u0003/\n\t-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00171\u001b\t\u0004\u0007\u0006=\u0017bAAi\t\n\u0019\u0011I\\=\t\u0013\u0005U\u0017%!AA\u0002\u0005\u0015\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\\B1\u0011Q\\Ar\u0003\u001bl!!a8\u000b\u0007\u0005\u0005H)\u0001\u0006d_2dWm\u0019;j_:LA!!:\u0002`\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rI\u00181\u001e\u0005\n\u0003+\u001c\u0013\u0011!a\u0001\u0003\u001b\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QXAy\u0011%\t)\u000eJA\u0001\u0002\u0004\t)#\u0001\u0005iCND7i\u001c3f)\t\t)#\u0001\u0005u_N#(/\u001b8h)\t\ti,\u0001\u0004fcV\fGn\u001d\u000b\u0004s\u0006}\b\"CAkO\u0005\u0005\t\u0019AAg\u0003%QvN\\3e)&lW\r\u0005\u0002tSM!\u0011F\u0011B\u0004!\u0011\u0011IAa\u0004\u000e\u0005\t-!b\u0001B\u00079\u0006\u0011\u0011n\\\u0005\u0004+\n-AC\u0001B\u0002\u0003Aq\u0015IT(T?B+%kX*F\u0007>sE)A\tO\u0003:{5k\u0018)F%~\u001bViQ(O\t\u0002\nqb\u001c4gg\u0016$hi\u001c:nCR$XM]\u000b\u0003\u00057\u0001BA!\b\u0003\"5\u0011!q\u0004\u0006\u0004\u0003OZ\u0016\u0002\u0002B\u0012\u0005?\u0011\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003AygMZ:fi\u001a{'/\\1ui\u0016\u0014\b%A\u0003qCJ\u001cX\rF\u0002s\u0005WAaaV\u0018A\u0002\u0005-\u0013AA8g)\u0015\u0011(\u0011\u0007B\u001a\u0011\u00159\u0006\u00071\u0001Z\u0011\u0015\t\u0007\u00071\u0001d)\r\u0011(q\u0007\u0005\b\u0005s\t\u0004\u0019AAB\u0003)ygMZ:fiRKW.\u001a\u000b\u0004e\nu\u0002b\u0002B e\u0001\u0007\u0011qN\u0001\tI\u0006$X\rV5nKR1\u0011q\fB\"\u0005\u000fBaA!\u00124\u0001\u0004\u0011\u0018!\u0001=\t\r\t%3\u00071\u0001s\u0003\u0005I\u0018!B1qa2LHc\u0002:\u0003P\tE#1\u000b\u0005\u0006/R\u0002\r!\u0017\u0005\u0006CR\u0002\ra\u0019\u0005\u0006OR\u0002\r![\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IF!\u0019\u0011\t\rS'1\f\t\u0007\u0007\nu\u0013lY5\n\u0007\t}CI\u0001\u0004UkBdWm\r\u0005\t\u0005G*\u0014\u0011!a\u0001e\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t%\u0004\u0003BA`\u0005WJAA!\u001c\u0002B\n1qJ\u00196fGR\u0004")
public class ZonedTime
implements Product,
Serializable {
    private final LocalTime time;
    private final ZoneOffset offset;
    private final Option<ZoneId> zone;
    private final boolean hasTimeZone;
    private final long nanos;

    public static Option<Tuple3<LocalTime, ZoneOffset, Option<ZoneId>>> unapply(ZonedTime zonedTime) {
        return ZonedTime$.MODULE$.unapply(zonedTime);
    }

    public static ZonedTime apply(LocalTime localTime, ZoneOffset zoneOffset, Option<ZoneId> option) {
        return ZonedTime$.MODULE$.apply(localTime, zoneOffset, option);
    }

    public static ZonedTime of(ZonedDateTime zonedDateTime) {
        return ZonedTime$.MODULE$.of(zonedDateTime);
    }

    public static ZonedTime of(OffsetTime offsetTime) {
        return ZonedTime$.MODULE$.of(offsetTime);
    }

    public static ZonedTime of(LocalTime localTime, ZoneOffset zoneOffset) {
        return ZonedTime$.MODULE$.of(localTime, zoneOffset);
    }

    public static ZonedTime parse(String string) {
        return ZonedTime$.MODULE$.parse(string);
    }

    public static DateTimeFormatter offsetFormatter() {
        return ZonedTime$.MODULE$.offsetFormatter();
    }

    public static long NANOS_PER_SECOND() {
        return ZonedTime$.MODULE$.NANOS_PER_SECOND();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public LocalTime time() {
        return this.time;
    }

    public ZoneOffset offset() {
        return this.offset;
    }

    public Option<ZoneId> zone() {
        return this.zone;
    }

    public boolean hasTimeZone() {
        return this.hasTimeZone;
    }

    public long nanos() {
        return this.nanos;
    }

    public ZonedTime plus(TemporalAmount amountToAdd) {
        LocalTime newTime = this.time().plus(amountToAdd);
        return new ZonedTime(newTime, this.offset(), this.zone());
    }

    public ZonedTime minus(TemporalAmount amountToAdd) {
        LocalTime newTime = this.time().minus(amountToAdd);
        return new ZonedTime(newTime, this.offset(), this.zone());
    }

    public int compareTo(ZonedTime other) {
        return new RichLong(Predef$.MODULE$.longWrapper(this.nanos())).compare((Object)BoxesRunTime.boxToLong((long)other.nanos()));
    }

    public boolean isBefore(ZonedTime other) {
        return this.nanos() < other.nanos();
    }

    public boolean isAfter(ZonedTime other) {
        return this.nanos() > other.nanos();
    }

    public int getHour() {
        return this.time().getHour();
    }

    public int getMinute() {
        return this.time().getMinute();
    }

    public int getSecond() {
        return this.time().getSecond();
    }

    public int getOffsetInTotalSeconds() {
        return this.offset().getTotalSeconds();
    }

    public Option<String> getZoneId() {
        return this.zone().map((Function1 & Serializable)x$1 -> x$1.getId());
    }

    public Duration between(ZonedTime other) {
        long diff = RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this.nanos() - other.nanos()));
        return Duration.ofNanos(diff);
    }

    public String format() {
        String string;
        String localTime = package$.MODULE$.localTimeFormatter().format(this.time());
        if (this.hasTimeZone()) {
            String zoneId = ((ZoneId)this.zone().get()).getId();
            string = new StringBuilder(1).append(localTime).append("@").append(zoneId).toString();
        } else {
            string = new StringBuilder(0).append(localTime).append(ZonedTime$.MODULE$.offsetFormatter().format(this.offset())).toString();
        }
        return string;
    }

    public ZonedDateTime withDate(LocalDate date) {
        LocalDateTime localDateTime = date.atTime(this.time());
        return this.hasTimeZone() ? localDateTime.atZone((ZoneId)this.zone().get()) : localDateTime.atOffset(this.offset()).toZonedDateTime();
    }

    public OffsetTime toOffsetTime() {
        return this.time().atOffset(this.offset());
    }

    public LocalTime toLocalTime() {
        return this.time();
    }

    public ZonedTime copy(LocalTime time, ZoneOffset offset, Option<ZoneId> zone) {
        return new ZonedTime(time, offset, zone);
    }

    public LocalTime copy$default$1() {
        return this.time();
    }

    public ZoneOffset copy$default$2() {
        return this.offset();
    }

    public Option<ZoneId> copy$default$3() {
        return this.zone();
    }

    public String productPrefix() {
        return "ZonedTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.time();
                break;
            }
            case 1: {
                object = this.offset();
                break;
            }
            case 2: {
                object = this.zone();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ZonedTime;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "time";
                break;
            }
            case 1: {
                string = "offset";
                break;
            }
            case 2: {
                string = "zone";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ZonedTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        ZonedTime zonedTime = (ZonedTime)x$1;
        LocalTime localTime = this.time();
        LocalTime localTime2 = zonedTime.time();
        if (localTime == null) {
            if (localTime2 != null) {
                return false;
            }
        } else if (!((Object)localTime).equals(localTime2)) return false;
        ZoneOffset zoneOffset = this.offset();
        ZoneOffset zoneOffset2 = zonedTime.offset();
        if (zoneOffset == null) {
            if (zoneOffset2 != null) {
                return false;
            }
        } else if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
        Option<ZoneId> option = this.zone();
        Option<ZoneId> option2 = zonedTime.zone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!zonedTime.canEqual(this)) return false;
        return true;
    }

    public ZonedTime(LocalTime time, ZoneOffset offset, Option<ZoneId> zone) {
        this.time = time;
        this.offset = offset;
        this.zone = zone;
        Product.$init$((Product)this);
        this.hasTimeZone = zone.isDefined();
        long nod = time.toNanoOfDay();
        long offsetNanos = (long)offset.getTotalSeconds() * ZonedTime$.MODULE$.NANOS_PER_SECOND();
        this.nanos = nod - offsetNanos;
    }
}

