/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.datatype.ZonedTime;
import org.camunda.feel.datatype.ZonedTime$;
import org.camunda.feel.interpreter.Context;
import org.camunda.feel.interpreter.FunctionProvider;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValContext;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValFunction$;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValNumber$;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValString$;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class BuiltinFunctions$
implements FunctionProvider {
    public static final BuiltinFunctions$ MODULE$ = new BuiltinFunctions$();
    private static Pattern dateTimeOffsetZoneIdPattern;
    private static final Map<String, List<ValFunction>> functions;
    private static volatile boolean bitmap$0;

    static {
        FunctionProvider.$init$(MODULE$);
        functions = (Map)((MapOps)((MapOps)((MapOps)((MapOps)MODULE$.conversionFunctions().$plus$plus(MODULE$.booleanFunctions())).$plus$plus(MODULE$.stringFunctions())).$plus$plus(MODULE$.listFunctions())).$plus$plus(MODULE$.numericFunctions())).$plus$plus(MODULE$.contextFunctions());
    }

    @Override
    public Map<String, List<ValFunction>> getFunctions() {
        return FunctionProvider.getFunctions$(this);
    }

    @Override
    public List<ValFunction> getFunctions(String name) {
        return (List)this.functions().getOrElse((Object)name, (Function0 & Serializable)() -> List$.MODULE$.empty());
    }

    @Override
    public Iterable<String> functionNames() {
        return this.functions().keys();
    }

    public Map<String, List<ValFunction>> functions() {
        return functions;
    }

    private Map<String, List<ValFunction>> conversionFunctions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date"), (Object)new .colon.colon((Object)this.dateFunction(), (List)new .colon.colon((Object)this.dateFunction3(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date and time"), (Object)new .colon.colon((Object)this.dateTime(), (List)new .colon.colon((Object)this.dateTime2(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)new .colon.colon((Object)this.timeFunction(), (List)new .colon.colon((Object)this.timeFunction3(), (List)new .colon.colon((Object)this.timeFunction4(), (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)new .colon.colon((Object)this.numberFunction(), (List)new .colon.colon((Object)this.numberFunction2(), (List)new .colon.colon((Object)this.numberFunction3(), (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)new .colon.colon((Object)this.stringFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duration"), (Object)new .colon.colon((Object)this.durationFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"years and months duration"), (Object)new .colon.colon((Object)this.durationFunction2(), (List)Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> booleanFunctions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not"), (Object)new .colon.colon((Object)this.notFunction(), (List)Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> stringFunctions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring"), (Object)new .colon.colon((Object)this.substringFunction(), (List)new .colon.colon((Object)this.substringFunction3(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string length"), (Object)new .colon.colon((Object)this.stringLengthFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper case"), (Object)new .colon.colon((Object)this.upperCaseFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower case"), (Object)new .colon.colon((Object)this.lowerCaseFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring before"), (Object)new .colon.colon((Object)this.substringBeforeFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring after"), (Object)new .colon.colon((Object)this.substringAfterFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replace"), (Object)new .colon.colon((Object)this.replaceFunction(), (List)new .colon.colon((Object)this.replaceFunction4(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"contains"), (Object)new .colon.colon((Object)this.containsFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"starts with"), (Object)new .colon.colon((Object)this.startsWithFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ends with"), (Object)new .colon.colon((Object)this.endsWithFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"matches"), (Object)new .colon.colon((Object)this.matchesFunction(), (List)new .colon.colon((Object)this.matchesFunction3(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"split"), (Object)new .colon.colon((Object)this.splitFunction(), (List)Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> listFunctions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"list contains"), (Object)new .colon.colon((Object)this.listContainsFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)new .colon.colon((Object)this.countFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)new .colon.colon((Object)this.minFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)new .colon.colon((Object)this.maxFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sum"), (Object)new .colon.colon((Object)this.sumFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"product"), (Object)new .colon.colon((Object)this.productFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mean"), (Object)new .colon.colon((Object)this.meanFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"median"), (Object)new .colon.colon((Object)this.medianFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stddev"), (Object)new .colon.colon((Object)this.stddevFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)new .colon.colon((Object)this.modeFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"and"), (Object)new .colon.colon((Object)this.andFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"all"), (Object)new .colon.colon((Object)this.andFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"or"), (Object)new .colon.colon((Object)this.orFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"any"), (Object)new .colon.colon((Object)this.orFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sublist"), (Object)new .colon.colon((Object)this.sublistFunction(), (List)new .colon.colon((Object)this.sublistFunction3(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"append"), (Object)new .colon.colon((Object)this.appendFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"concatenate"), (Object)new .colon.colon((Object)this.concatenateFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert before"), (Object)new .colon.colon((Object)this.insertBeforeFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remove"), (Object)new .colon.colon((Object)this.removeFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reverse"), (Object)new .colon.colon((Object)this.reverseFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index of"), (Object)new .colon.colon((Object)this.indexOfFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"union"), (Object)new .colon.colon((Object)this.unionFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distinct values"), (Object)new .colon.colon((Object)this.distinctValuesFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flatten"), (Object)new .colon.colon((Object)this.flattenFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sort"), (Object)new .colon.colon((Object)this.sortFunction(), (List)Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> numericFunctions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"decimal"), (Object)new .colon.colon((Object)this.decimalFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"floor"), (Object)new .colon.colon((Object)this.floorFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ceiling"), (Object)new .colon.colon((Object)this.ceilingFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"abs"), (Object)new .colon.colon((Object)this.absFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modulo"), (Object)new .colon.colon((Object)this.moduloFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqrt"), (Object)new .colon.colon((Object)this.sqrtFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log"), (Object)new .colon.colon((Object)this.logFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp"), (Object)new .colon.colon((Object)this.expFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"odd"), (Object)new .colon.colon((Object)this.oddFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"even"), (Object)new .colon.colon((Object)this.evenFunction(), (List)Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> contextFunctions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get entries"), (Object)new .colon.colon((Object)this.getEntriesFunction(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get value"), (Object)new .colon.colon((Object)this.getValueFunction(), (List)Nil$.MODULE$))}));
    }

    private Val error(List<Val> e) {
        Product product;
        List<Val> list = e;
        if (list.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BuiltinFunctions$.$anonfun$error$1(x$1)))) {
            product = (ValError)list.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BuiltinFunctions$.$anonfun$error$2(x$2))).head();
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(39).append("Suppressed failure: illegal arguments: ").append(list).toString());
            product = ValNull$.MODULE$;
        }
        return product;
    }

    private Val parseDate(String d) {
        Val val;
        if (package$.MODULE$.isValidDate(d)) {
            val = (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValDate(package$.MODULE$.stringToDate(d))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to parse date from '").append(d).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to parse date from '").append(d).append("'").toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val parseTime(String t) {
        return package$.MODULE$.isOffsetTime(t) ? (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValTime(package$.MODULE$.stringToTime(t))).getOrElse((Function0 & Serializable)() -> {
            package$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to parse time from '").append(t).append("'").toString());
            return ValNull$.MODULE$;
        }) : (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValLocalTime(package$.MODULE$.stringToLocalTime(t))).getOrElse((Function0 & Serializable)() -> {
            package$.MODULE$.logger().warn(new StringBuilder(34).append("Failed to parse local-time from '").append(t).append("'").toString());
            return ValNull$.MODULE$;
        });
    }

    private Val parseDateTime(String dt) {
        Val val;
        if (package$.MODULE$.isValidDate(dt)) {
            val = (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValLocalDateTime(package$.MODULE$.stringToDate(dt).atTime(0, 0))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(35).append("Failed to parse date(-time) from '").append(dt).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else if (package$.MODULE$.isOffsetDateTime(dt)) {
            val = (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValDateTime(package$.MODULE$.stringToDateTime(dt))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(33).append("Failed to parse date-time from '").append(dt).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else if (package$.MODULE$.isLocalDateTime(dt)) {
            val = (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValLocalDateTime(package$.MODULE$.stringToLocalDateTime(dt))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(39).append("Failed to parse local-date-time from '").append(dt).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(33).append("Failed to parse date-time from '").append(dt).append("'").toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val parseDuration(String d) {
        Val val;
        if (package$.MODULE$.isYearMonthDuration(d)) {
            val = (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValYearMonthDuration(package$.MODULE$.stringToYearMonthDuration(d).normalized())).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(43).append("Failed to parse year-month-duration from '").append(d).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else if (package$.MODULE$.isDayTimeDuration(d)) {
            val = (Val)Try$.MODULE$.apply((Function0 & Serializable)() -> new ValDayTimeDuration(package$.MODULE$.stringToDayTimeDuration(d))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(41).append("Failed to parse day-time-duration from '").append(d).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(32).append("Failed to parse duration from '").append(d).append("'").toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    public ValFunction dateFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$3 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            SeqOps seqOps2;
            Val val3;
            SeqOps seqOps3;
            Val val4;
            Val val5;
            SeqOps seqOps4;
            List list = x$3;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof ValString) {
                ValString valString = (ValString)val5;
                String from = valString.value();
                val4 = MODULE$.parseDate(from);
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val3;
                LocalDateTime from = valLocalDateTime.value();
                val4 = new ValDate(from.toLocalDate());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                ZonedDateTime from = valDateTime.value();
                val4 = new ValDate(from.toLocalDate());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValDate) {
                ValDate valDate = (ValDate)val;
                LocalDate from = valDate.value();
                val4 = new ValDate(from);
            } else {
                val4 = MODULE$.error((List<Val>)list);
            }
            return val4;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateFunction3() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"day", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$4 -> {
            List list = x$4;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal year = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal month = valNumber2.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber3 = (ValNumber)val3;
            BigDecimal day = valNumber3.value();
            return Try$.MODULE$.apply((Function0 & Serializable)() -> new ValDate(LocalDate.of(year.intValue(), month.intValue(), day.intValue()))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(46).append("Failed to parse date from: year=").append(year).append(", month=").append(month).append(", day=").append(day).toString());
                return ValNull$.MODULE$;
            });
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$5 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$5;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = MODULE$.parseDateTime(from);
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime2() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"date", (List)new .colon.colon((Object)"time", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$6 -> {
            SeqOps seqOps;
            SeqOps seqOps2;
            SeqOps seqOps3;
            SeqOps seqOps4;
            SeqOps seqOps5;
            List list = x$6;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0);
                Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate date = valDate.value();
                    if (val2 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val2;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(date.atTime(time));
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0);
                Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate date = valDate.value();
                    if (val3 instanceof ValTime) {
                        ValTime valTime = (ValTime)val3;
                        ZonedTime time = valTime.value();
                        return new ValDateTime(time.withDate(date));
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
                Val val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime dateTime = valLocalDateTime.value();
                    if (val4 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val4;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Val val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime dateTime = valLocalDateTime.value();
                    if (val5 instanceof ValTime) {
                        ValTime valTime = (ValTime)val5;
                        ZonedTime time = valTime.value();
                        return new ValDateTime(time.withDate(dateTime.toLocalDate()));
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val6 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime dateTime = valDateTime.value();
                    if (val6 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val6;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps6 = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0);
            Val val7 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1);
            if (!(val instanceof ValDateTime)) return MODULE$.error((List<Val>)list);
            ValDateTime valDateTime = (ValDateTime)val;
            ZonedDateTime dateTime = valDateTime.value();
            if (!(val7 instanceof ValTime)) return MODULE$.error((List<Val>)list);
            ValTime valTime = (ValTime)val7;
            ZonedTime time = valTime.value();
            return new ValDateTime(time.withDate(dateTime.toLocalDate()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$7 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            SeqOps seqOps2;
            Val val3;
            Val val4;
            SeqOps seqOps3;
            List list = x$7;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValString) {
                ValString valString = (ValString)val4;
                String from = valString.value();
                val3 = MODULE$.parseTime(from);
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime from = valLocalDateTime.value();
                val3 = new ValLocalTime(from.toLocalTime());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val;
                ZonedDateTime from = valDateTime.value();
                val3 = new ValTime(ZonedTime$.MODULE$.of(from));
            } else {
                Val val5;
                SeqOps seqOps4;
                val3 = list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof ValDate ? new ValTime(ZonedTime$.MODULE$.of(LocalTime.MIDNIGHT, ZoneOffset.UTC)) : MODULE$.error((List<Val>)list);
            }
            return val3;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction3() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"hour", (List)new .colon.colon((Object)"minute", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$8 -> {
            List list = x$8;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal hour = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal minute = valNumber2.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber3 = (ValNumber)val3;
            BigDecimal second = valNumber3.value();
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                int nanos = second.bigDecimal().remainder(java.math.BigDecimal.ONE).movePointRight(9).intValue();
                return new ValLocalTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), nanos));
            }).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(56).append("Failed to parse local-time from: hour=").append(hour).append(", minute=").append(minute).append(", second=").append(second).toString());
                return ValNull$.MODULE$;
            });
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction4() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"hour", (List)new .colon.colon((Object)"minute", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"offset", (List)Nil$.MODULE$))))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$9 -> {
            SeqOps seqOps;
            List list = x$9;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                Val val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal hour = valNumber.value();
                    if (val2 instanceof ValNumber) {
                        ValNumber valNumber2 = (ValNumber)val2;
                        BigDecimal minute = valNumber2.value();
                        if (val3 instanceof ValNumber) {
                            ValNumber valNumber3 = (ValNumber)val3;
                            BigDecimal second = valNumber3.value();
                            if (val4 instanceof ValDayTimeDuration) {
                                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                                Duration offset = valDayTimeDuration.value();
                                return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                                    int nanos = second.bigDecimal().remainder(java.math.BigDecimal.ONE).movePointRight(9).intValue();
                                    LocalTime localTime = LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), nanos);
                                    ZoneOffset zonedOffset = ZoneOffset.ofTotalSeconds((int)offset.getSeconds());
                                    return new ValTime(ZonedTime$.MODULE$.of(localTime, zonedOffset));
                                }).getOrElse((Function0 & Serializable)() -> {
                                    package$.MODULE$.logger().warn(new StringBuilder(59).append("Failed to parse time from: hour=").append(hour).append(", minute=").append(minute).append(", second=").append(second).append(", offset=").append(offset).toString());
                                    return ValNull$.MODULE$;
                                });
                            }
                        }
                    }
                }
            }
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 4) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            Val val6 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2);
            Val val7 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3);
            if (!(val instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal hour = valNumber.value();
            if (!(val5 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber4 = (ValNumber)val5;
            BigDecimal minute = valNumber4.value();
            if (!(val6 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber5 = (ValNumber)val6;
            BigDecimal second = valNumber5.value();
            if (!ValNull$.MODULE$.equals(val7)) return MODULE$.error((List<Val>)list);
            return Try$.MODULE$.apply((Function0 & Serializable)() -> new ValLocalTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()))).getOrElse((Function0 & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(56).append("Failed to parse local-time from: hour=").append(hour).append(", minute=").append(minute).append(", second=").append(second).toString());
                return ValNull$.MODULE$;
            });
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$10 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$10;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = new ValNumber(package$.MODULE$.stringToNumber(from));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction2() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)new .colon.colon((Object)"grouping separator", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$11 -> {
            SeqOps seqOps;
            List list = x$11;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValString) {
                    ValString valString;
                    String grouping;
                    ValString valString2 = (ValString)val;
                    String from = valString2.value();
                    if (val2 instanceof ValString && MODULE$.isValidGroupingSeparator(grouping = (valString = (ValString)val2).value())) {
                        return new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "")));
                    }
                }
            }
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            if (!(val3 instanceof ValString)) return MODULE$.error((List<Val>)list);
            return new ValError("illegal argument for grouping. Must be one of ' ', ',' or '.'");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction3() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)new .colon.colon((Object)"grouping separator", (List)new .colon.colon((Object)"decimal separator", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$12 -> {
            SeqOps seqOps;
            List list = x$12;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                if (val instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    if (val2 instanceof ValString) {
                        ValString valString2 = (ValString)val2;
                        String grouping = valString2.value();
                        if (val3 instanceof ValString) {
                            ValString valString3 = (ValString)val3;
                            String decimal = valString3.value();
                            if (MODULE$.isValidGroupingSeparator(grouping) && MODULE$.isValidDecimalSeparator(decimal)) {
                                String string = grouping;
                                String string2 = decimal;
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    return new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "").replace(decimal, ".")));
                                }
                            }
                        }
                    }
                }
            }
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            Val val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            if (!(val4 instanceof ValString)) return MODULE$.error((List<Val>)list);
            if (!(val5 instanceof ValString)) return MODULE$.error((List<Val>)list);
            return new ValError("illegal arguments for grouping or decimal. Must be one of ' ' (grouping only), ',' or '.'");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidGroupingSeparator(String separator) {
        String string = separator;
        String string2 = " ";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ",";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = separator;
        String string6 = ".";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidDecimalSeparator(String separator) {
        String string = separator;
        String string2 = ",";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ".";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private Pattern dateTimeOffsetZoneIdPattern$lzycompute() {
        BuiltinFunctions$ builtinFunctions$ = this;
        synchronized (builtinFunctions$) {
            if (!bitmap$0) {
                dateTimeOffsetZoneIdPattern = Pattern.compile("(.*)([+-]\\d{2}:\\d{2}|Z)(@.*)");
                bitmap$0 = true;
            }
        }
        return dateTimeOffsetZoneIdPattern;
    }

    public Pattern dateTimeOffsetZoneIdPattern() {
        return !bitmap$0 ? this.dateTimeOffsetZoneIdPattern$lzycompute() : dateTimeOffsetZoneIdPattern;
    }

    public ValFunction stringFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$13 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            SeqOps seqOps2;
            Val val3;
            SeqOps seqOps3;
            Val val4;
            SeqOps seqOps4;
            Val val5;
            SeqOps seqOps5;
            Val val6;
            SeqOps seqOps6;
            Val val7;
            SeqOps seqOps7;
            Val val8;
            SeqOps seqOps8;
            Val val9;
            SeqOps seqOps9;
            Val val10;
            Val val11;
            SeqOps seqOps10;
            List list = x$13;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps10 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 1) == 0 && (val11 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 0)) instanceof ValString) {
                ValString valString = (ValString)val11;
                String from = valString.value();
                val10 = new ValString(from);
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps9 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 1) == 0 && (val9 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 0)) instanceof ValBoolean) {
                ValBoolean valBoolean = (ValBoolean)val9;
                boolean from = valBoolean.value();
                val10 = new ValString(((Object)BoxesRunTime.boxToBoolean((boolean)from)).toString());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1) == 0 && (val8 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val8;
                BigDecimal from = valNumber.value();
                val10 = new ValString(from.toString());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1) == 0 && (val7 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0)) instanceof ValDate) {
                ValDate valDate = (ValDate)val7;
                LocalDate from = valDate.value();
                val10 = new ValString(from.format(package$.MODULE$.dateFormatter()));
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1) == 0 && (val6 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0)) instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val6;
                LocalTime from = valLocalTime.value();
                val10 = new ValString(from.format(package$.MODULE$.localTimeFormatter()));
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1) == 0 && (val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0)) instanceof ValTime) {
                ValTime valTime = (ValTime)val5;
                ZonedTime from = valTime.value();
                val10 = new ValString(from.format());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val4;
                LocalDateTime from = valLocalDateTime.value();
                val10 = new ValString(from.format(package$.MODULE$.localDateTimeFormatter()));
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val3;
                ZonedDateTime from = valDateTime.value();
                String formattedDateTime = from.format(package$.MODULE$.dateTimeFormatter());
                String dateTimeWithOffsetOrZoneId = MODULE$.dateTimeOffsetZoneIdPattern().matcher(formattedDateTime).replaceAll("$1$3");
                val10 = new ValString(dateTimeWithOffsetOrZoneId);
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period from = valYearMonthDuration.value();
                val10 = new ValString(from.toString());
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
                Duration from = valDayTimeDuration.value();
                val10 = new ValString(from.toString());
            } else {
                val10 = MODULE$.error((List<Val>)list);
            }
            return val10;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$14 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$14;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = MODULE$.parseDuration(from);
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction2() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"from", (List)new .colon.colon((Object)"to", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$15 -> {
            SeqOps seqOps;
            SeqOps seqOps2;
            SeqOps seqOps3;
            SeqOps seqOps4;
            SeqOps seqOps5;
            SeqOps seqOps6;
            SeqOps seqOps7;
            SeqOps seqOps8;
            List list = x$15;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0);
                Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val2 instanceof ValDate) {
                        ValDate valDate2 = (ValDate)val2;
                        LocalDate to = valDate2.value();
                        return new ValYearMonthDuration(Period.between(from, to).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0);
                Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime from = valLocalDateTime.value();
                    if (val3 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime2 = (ValLocalDateTime)val3;
                        LocalDateTime to = valLocalDateTime2.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0);
                Val val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime from = valDateTime.value();
                    if (val4 instanceof ValDateTime) {
                        ValDateTime valDateTime2 = (ValDateTime)val4;
                        ZonedDateTime to = valDateTime2.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0);
                Val val5 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime from = valDateTime.value();
                    if (val5 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val5;
                        LocalDateTime to = valLocalDateTime.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0);
                Val val6 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime from = valLocalDateTime.value();
                    if (val6 instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val6;
                        ZonedDateTime to = valDateTime.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
                Val val7 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val7 instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val7;
                        ZonedDateTime to = valDateTime.value();
                        return new ValYearMonthDuration(Period.between(from, to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Val val8 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val8 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val8;
                        LocalDateTime to = valLocalDateTime.value();
                        return new ValYearMonthDuration(Period.between(from, to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val9 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime from = valDateTime.value();
                    if (val9 instanceof ValDate) {
                        ValDate valDate = (ValDate)val9;
                        LocalDate to = valDate.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to).withDays(0).normalized());
                    }
                }
            }
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps9 = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps9)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 0);
            Val val10 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 1);
            if (!(val instanceof ValLocalDateTime)) return MODULE$.error((List<Val>)list);
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
            LocalDateTime from = valLocalDateTime.value();
            if (!(val10 instanceof ValDate)) return MODULE$.error((List<Val>)list);
            ValDate valDate = (ValDate)val10;
            LocalDate to = valDate.value();
            return new ValYearMonthDuration(Period.between(from.toLocalDate(), to).withDays(0).normalized());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction notFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"negand", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$16 -> {
            Val other;
            SeqOps seqOps;
            ValBoolean valBoolean;
            boolean negand;
            Val val;
            SeqOps seqOps2;
            List list = x$16;
            Product product = list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValBoolean ? new ValBoolean(!(negand = (valBoolean = (ValBoolean)val).value())) : (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (other = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null ? ValNull$.MODULE$ : ValNull$.MODULE$);
            return product;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"start position", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$17 -> {
            List list = x$17;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            return new ValString(string.substring(MODULE$.stringIndex(string, start.intValue())));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction3() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"start position", (List)new .colon.colon((Object)"length", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$18 -> {
            List list = x$18;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber2 = (ValNumber)val3;
            BigDecimal length = valNumber2.value();
            return new ValString(string.substring(MODULE$.stringIndex(string, start.intValue()), MODULE$.stringIndex(string, start.intValue()) + length.intValue()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private int stringIndex(String string, int index) {
        return index > 0 ? index - 1 : string.length() + index;
    }

    public ValFunction stringLengthFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$19 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$19;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(string.length()));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction upperCaseFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$20 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$20;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValString(string.toUpperCase());
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction lowerCaseFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$21 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$21;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValString(string.toLowerCase());
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringBeforeFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"match", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$22 -> {
            List list = x$22;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            int index = string.indexOf(m);
            return index > 0 ? new ValString(string.substring(0, index)) : new ValString("");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringAfterFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"match", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$23 -> {
            List list = x$23;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            int index = string.indexOf(m);
            return index >= 0 ? new ValString(string.substring(index + m.length())) : new ValString("");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction replaceFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"input", (List)new .colon.colon((Object)"pattern", (List)new .colon.colon((Object)"replacement", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$24 -> {
            List list = x$24;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString3 = (ValString)val3;
            String replacement = valString3.value();
            return new ValString(input.replaceAll(pattern, replacement));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction replaceFunction4() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"input", (List)new .colon.colon((Object)"pattern", (List)new .colon.colon((Object)"replacement", (List)new .colon.colon((Object)"flags", (List)Nil$.MODULE$))))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$25 -> {
            List list = x$25;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            Val val4 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString3 = (ValString)val3;
            String replacement = valString3.value();
            if (!(val4 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString4 = (ValString)val4;
            String flags = valString4.value();
            Pattern p = Pattern.compile(pattern, MODULE$.patternFlags(flags));
            Matcher m = p.matcher(input);
            return new ValString(m.replaceAll(replacement));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private int patternFlags(String flags) {
        void var2_2;
        block3: {
            int f = 0;
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            if (flags.contains("i")) {
                f |= 2;
            }
            if (!flags.contains("x")) break block3;
            f |= 4;
        }
        return (int)var2_2;
    }

    public ValFunction containsFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"match", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$26 -> {
            List list = x$26;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.contains(m));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction startsWithFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"match", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$27 -> {
            List list = x$27;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.startsWith(m));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction endsWithFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"match", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$28 -> {
            List list = x$28;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.endsWith(m));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction matchesFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"input", (List)new .colon.colon((Object)"pattern", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$29 -> {
            List list = x$29;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(input);
            return new ValBoolean(m.find());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction matchesFunction3() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"input", (List)new .colon.colon((Object)"pattern", (List)new .colon.colon((Object)"flags", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$30 -> {
            List list = x$30;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString3 = (ValString)val3;
            String flags = valString3.value();
            Pattern p = Pattern.compile(pattern, MODULE$.patternFlags(flags));
            Matcher m = p.matcher(input);
            return new ValBoolean(m.find());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction splitFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"string", (List)new .colon.colon((Object)"delimiter", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$31 -> {
            List list = x$31;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString2 = (ValString)val2;
            String delimiter = valString2.value();
            Pattern p = Pattern.compile(delimiter);
            String[] r = p.split(string, -1);
            return new ValList((List<Val>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])r), (Function1)ValString$.MODULE$, ClassTag$.MODULE$.apply(ValString.class))).toList());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction listContainsFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$32 -> {
            List list = x$32;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val element = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            return new ValBoolean(list2.contains((Object)element));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction countFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$33 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$33;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(list2.size()));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction minFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$34 -> {
            Val val;
            Val l;
            SeqOps seqOps;
            List list = x$34;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (l = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                Object object;
                ValList valList = (ValList)l;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                if (Nil$.MODULE$.equals(list3)) {
                    object = ValNull$.MODULE$;
                } else if (valList.isComparable()) {
                    object = list2.min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else {
                    package$.MODULE$.logger().warn(new StringBuilder(18).append(valList).append(" is not comparable").toString());
                    object = ValNull$.MODULE$;
                }
                val = object;
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    public ValFunction maxFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$35 -> {
            Val val;
            Val l;
            SeqOps seqOps;
            List list = x$35;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (l = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                Object object;
                ValList valList = (ValList)l;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                if (Nil$.MODULE$.equals(list3)) {
                    object = ValNull$.MODULE$;
                } else if (valList.isComparable()) {
                    object = list2.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else {
                    package$.MODULE$.logger().warn(new StringBuilder(18).append(valList).append(" is not comparable").toString());
                    object = ValNull$.MODULE$;
                }
                val = object;
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    public ValFunction sumFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$36 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$36;
            if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1 & Serializable)numbers -> new ValNumber((BigDecimal)numbers.sum((Numeric)Numeric.BigDecimalIsFractional$.MODULE$)));
            } else {
                val2 = MODULE$.error((List<Val>)list2);
            }
            return val2;
        }, true);
    }

    public ValFunction productFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$37 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$37;
            if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1 & Serializable)numbers -> new ValNumber((BigDecimal)numbers.product((Numeric)Numeric.BigDecimalIsFractional$.MODULE$)));
            } else {
                val2 = MODULE$.error((List<Val>)list2);
            }
            return val2;
        }, true);
    }

    public ValFunction meanFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$38 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$38;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                Val val3 = Nil$.MODULE$.equals(list3) ? ValNull$.MODULE$ : MODULE$.withListOfNumbers(list2, (Function1<List<BigDecimal>, Val>)(Function1 & Serializable)numbers -> new ValNumber(((BigDecimal)numbers.sum((Numeric)Numeric.BigDecimalIsFractional$.MODULE$)).$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size()))));
                val = val3;
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    public ValFunction medianFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$39 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$39;
            if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1 & Serializable)numbers -> {
                    ValNumber valNumber;
                    List sortedList = (List)numbers.sorted((Ordering)Ordering.BigDecimal$.MODULE$);
                    if (list3.size() % 2 == 1) {
                        valNumber = new ValNumber((BigDecimal)sortedList.apply(list3.size() / 2));
                    } else {
                        int i = list3.size() / 2;
                        BigDecimal x = (BigDecimal)sortedList.apply(i - 1);
                        BigDecimal y = (BigDecimal)sortedList.apply(i);
                        valNumber = new ValNumber(x.$plus(y).$div(BigDecimal$.MODULE$.int2bigDecimal(2)));
                    }
                    return valNumber;
                });
            } else {
                val2 = MODULE$.error((List<Val>)list2);
            }
            return val2;
        }, true);
    }

    public ValFunction stddevFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$40 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$40;
            if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1 & Serializable)numbers -> {
                    BigDecimal sum = (BigDecimal)numbers.sum((Numeric)Numeric.BigDecimalIsFractional$.MODULE$);
                    BigDecimal mean = sum.$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size()));
                    BigDecimal bigDecimal = BigDecimal$.MODULE$.int2bigDecimal(0);
                    BigDecimal d = (BigDecimal)numbers.$div$colon((Object)bigDecimal, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        BigDecimal dev = (BigDecimal)tuple2._1();
                        BigDecimal n = (BigDecimal)tuple2._2();
                        BigDecimal bigDecimal = dev.$plus(n.$minus(mean).pow(2));
                        return bigDecimal;
                    });
                    double stddev = Math.sqrt(d.$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size() - 1)).toDouble());
                    return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(stddev));
                });
            } else {
                val2 = MODULE$.error((List<Val>)list2);
            }
            return val2;
        }, true);
    }

    public ValFunction modeFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$41 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$41;
            if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = new ValList((List<Val>)List$.MODULE$.empty());
            } else if (list2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1 & Serializable)numbers -> {
                    List sortedList = ((List)numbers.groupBy((Function1 & Serializable)n -> n).map((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        BigDecimal n = (BigDecimal)tuple2._1();
                        List ns = (List)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)BoxesRunTime.boxToInteger((int)ns.size()));
                        return tuple22;
                    }).toList().sortBy((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)BuiltinFunctions$.$anonfun$modeFunction$5(x0$2)), (Ordering)Ordering.Int$.MODULE$)).reverse();
                    int maxCount = ((Tuple2)sortedList.head())._2$mcI$sp();
                    List modeElements = (List)sortedList.takeWhile((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)BuiltinFunctions$.$anonfun$modeFunction$6(maxCount, x0$3))).map((Function1 & Serializable)x$42 -> (BigDecimal)x$42._1()).sorted((Ordering)Ordering.BigDecimal$.MODULE$);
                    return new ValList((List<Val>)modeElements.map((Function1)ValNumber$.MODULE$));
                });
            } else {
                val2 = MODULE$.error((List<Val>)list2);
            }
            return val2;
        }, true);
    }

    public ValFunction andFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$43 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$43;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.all(list2);
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    private Val all(List<Val> xs) {
        ValBoolean valBoolean;
        block4: {
            List list;
            block5: {
                Product product;
                block6: {
                    ValBoolean valBoolean2;
                    boolean bl;
                    List xs2;
                    while (true) {
                        boolean bl2;
                        if (Nil$.MODULE$.equals(list = xs)) {
                            valBoolean = new ValBoolean(true);
                            break block4;
                        }
                        if (!(list instanceof .colon.colon)) break block5;
                        .colon.colon colon2 = (.colon.colon)list;
                        Val x = (Val)colon2.head();
                        xs2 = colon2.next$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean3 = null;
                        Val val = x;
                        if (val instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean3 = (ValBoolean)val;
                            boolean bl4 = valBoolean3.value();
                            if (!bl4) {
                                product = new ValBoolean(false);
                                break block6;
                            }
                        }
                        if (!bl3 || !(bl2 = valBoolean3.value())) break;
                        xs = xs2;
                    }
                    Val val = this.all((List<Val>)xs2);
                    Product product2 = val instanceof ValBoolean && false == (bl = (valBoolean2 = (ValBoolean)val).value()) ? new ValBoolean(false) : ValNull$.MODULE$;
                    product = product2;
                }
                valBoolean = product;
                break block4;
            }
            throw new MatchError(list);
        }
        return valBoolean;
    }

    public ValFunction orFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$44 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$44;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.atLeastOne(list2);
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    private Val atLeastOne(List<Val> xs) {
        ValBoolean valBoolean;
        block4: {
            List list;
            block5: {
                Product product;
                block6: {
                    ValBoolean valBoolean2;
                    boolean bl;
                    List xs2;
                    while (true) {
                        boolean bl2;
                        if (Nil$.MODULE$.equals(list = xs)) {
                            valBoolean = new ValBoolean(false);
                            break block4;
                        }
                        if (!(list instanceof .colon.colon)) break block5;
                        .colon.colon colon2 = (.colon.colon)list;
                        Val x = (Val)colon2.head();
                        xs2 = colon2.next$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean3 = null;
                        Val val = x;
                        if (val instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean3 = (ValBoolean)val;
                            boolean bl4 = valBoolean3.value();
                            if (bl4) {
                                product = new ValBoolean(true);
                                break block6;
                            }
                        }
                        if (!bl3 || (bl2 = valBoolean3.value())) break;
                        xs = xs2;
                    }
                    Val val = this.atLeastOne((List<Val>)xs2);
                    Product product2 = val instanceof ValBoolean && true == (bl = (valBoolean2 = (ValBoolean)val).value()) ? new ValBoolean(true) : ValNull$.MODULE$;
                    product = product2;
                }
                valBoolean = product;
                break block4;
            }
            throw new MatchError(list);
        }
        return valBoolean;
    }

    public ValFunction sublistFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"start", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$45 -> {
            List list = x$45;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            return new ValList((List<Val>)list2.slice(MODULE$.listIndex(list2, start.intValue()), list2.length()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sublistFunction3() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"start", (List)new .colon.colon((Object)"length", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$46 -> {
            List list = x$46;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber2 = (ValNumber)val3;
            BigDecimal length = valNumber2.value();
            return new ValList((List<Val>)list2.slice(MODULE$.listIndex(list2, start.intValue()), MODULE$.listIndex(list2, start.intValue()) + length.intValue()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private int listIndex(List<?> list, int index) {
        return index > 0 ? index - 1 : list.size() + index;
    }

    public ValFunction appendFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"items", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$47 -> {
            List list = x$47;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList2 = (ValList)val2;
            List<Val> items = valList2.items();
            return new ValList((List<Val>)((List)list2.$plus$plus(items)));
        }, true);
    }

    public ValFunction concatenateFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"lists", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$48 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$48;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> lists = valList.items();
                val = new ValList((List<Val>)lists.flatMap((Function1 & Serializable)x$49 -> {
                    List list;
                    Val val = x$49;
                    if (val instanceof ValList) {
                        List list2;
                        ValList valList = (ValList)val;
                        list = list2 = valList.items();
                    } else {
                        list = (List)new .colon.colon((Object)val, (List)Nil$.MODULE$);
                    }
                    return list;
                }).toList());
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    public ValFunction insertBeforeFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"position", (List)new .colon.colon((Object)"newItem", (List)Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$50 -> {
            Val val;
            List list = x$50;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error((List<Val>)list);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val newItem = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val2 instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val2;
            List<Val> list2 = valList.items();
            if (!(val3 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val3;
            BigDecimal position = valNumber.value();
            if (newItem == null) return MODULE$.error((List<Val>)list);
            Val val4 = val = newItem;
            return new ValList((List<Val>)((List)((IterableOps)list2.take(MODULE$.listIndex(list2, position.intValue())).$plus$plus((IterableOnce)Nil$.MODULE$.$colon$colon((Object)val4))).$plus$plus((IterableOnce)list2.drop(MODULE$.listIndex(list2, position.intValue())))));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction removeFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"position", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$51 -> {
            List list = x$51;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal position = valNumber.value();
            return new ValList((List<Val>)((List)list2.take(MODULE$.listIndex(list2, position.intValue())).$plus$plus((IterableOnce)list2.drop(MODULE$.listIndex(list2, position.intValue() + 1)))));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction reverseFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$52 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$52;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList((List<Val>)list2.reverse());
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction indexOfFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"match", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$53 -> {
            List list = x$53;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val m = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (m == null) return MODULE$.error((List<Val>)list);
            Val val2 = m;
            return new ValList((List<Val>)MODULE$.indexOfList(list2, val2, MODULE$.indexOfList$default$3(), MODULE$.indexOfList$default$4()).map((Function1 & Serializable)x$54 -> BuiltinFunctions$.$anonfun$indexOfFunction$2(BoxesRunTime.unboxToInt((Object)x$54))));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private List<Object> indexOfList(List<Val> list, Val item, int from, List<Object> indexList) {
        int index;
        while ((index = list.indexOf((Object)item, from)) >= 0) {
            indexList = (List)indexList.$plus$plus((IterableOnce)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{index + 1})));
            from = index + 1;
        }
        return indexList;
    }

    private int indexOfList$default$3() {
        return 0;
    }

    private List<Object> indexOfList$default$4() {
        return Nil$.MODULE$;
    }

    public ValFunction unionFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"lists", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$55 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$55;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> lists = valList.items();
                val = new ValList((List<Val>)((List)lists.flatMap((Function1 & Serializable)x$56 -> {
                    List list;
                    Val val = x$56;
                    if (val instanceof ValList) {
                        List list2;
                        ValList valList = (ValList)val;
                        list = list2 = valList.items();
                    } else {
                        list = (List)new .colon.colon((Object)val, (List)Nil$.MODULE$);
                    }
                    return list;
                }).toList().distinct()));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, true);
    }

    public ValFunction distinctValuesFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$57 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$57;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList((List<Val>)((List)list2.distinct()));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction flattenFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$58 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$58;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList(MODULE$.flatten(list2));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Val> flatten(List<Val> list) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<Val> list2 = list;
        if (Nil$.MODULE$.equals(list2)) {
            return Nil$.MODULE$;
        }
        if (list2 instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list2;
            Val val = (Val)colon2.head();
            List xs = colon2.next$access$1();
            if (val instanceof ValList) {
                ValList valList = (ValList)val;
                List<Val> l = valList.items();
                return (List)this.flatten(l).$plus$plus(this.flatten((List<Val>)xs));
            }
        }
        if (!bl) throw new MatchError(list2);
        Val x = (Val)colon2.head();
        List xs = colon2.next$access$1();
        Val val = x;
        return this.flatten((List<Val>)xs).$colon$colon((Object)val);
    }

    public ValFunction sortFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"precedes", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$59 -> {
            SeqOps seqOps;
            List list = x$59;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list2 = valList.items();
                    if (val2 instanceof ValFunction) {
                        ValFunction valFunction = (ValFunction)val2;
                        List<String> params = valFunction.params();
                        Function1<List<Val>, Object> f = valFunction.invoke();
                        if (params.size() == 2) {
                            Product product;
                            try {
                                product = new ValList((List<Val>)((List)list2.sortWith((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BuiltinFunctions$.$anonfun$sortFunction$2(f, x0$1, x1$1)))));
                                return product;
                            }
                            catch (Throwable e) {
                                product = new ValError(new StringBuilder(46).append("fail to sort list by given precedes function: ").append(e.getMessage()).toString());
                            }
                            return product;
                        }
                    }
                }
            }
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            if (!(val instanceof ValList)) return MODULE$.error((List<Val>)list);
            if (!(val3 instanceof ValFunction)) return MODULE$.error((List<Val>)list);
            ValFunction valFunction = (ValFunction)val3;
            List<String> params = valFunction.params();
            return new ValError(new StringBuilder(54).append("expect boolean function with 2 arguments, but found '").append(params.size()).append("'").toString());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction decimalFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"n", (List)new .colon.colon((Object)"scale", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$60 -> {
            List list = x$60;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal n = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal scale = valNumber2.value();
            return new ValNumber(n.setScale(scale.intValue(), BigDecimal.RoundingMode$.MODULE$.HALF_EVEN()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction floorFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"n", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$61 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$61;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.setScale(0, BigDecimal.RoundingMode$.MODULE$.FLOOR()));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction ceilingFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"n", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$62 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$62;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING()));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction absFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"number", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$63 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$63;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.abs());
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction moduloFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"dividend", (List)new .colon.colon((Object)"divisor", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$64 -> {
            List list = x$64;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal dividend = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error((List<Val>)list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal divisor = valNumber2.value();
            return new ValNumber(dividend.$percent(divisor));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sqrtFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"number", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$65 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValNumber valNumber;
            BigDecimal n;
            Val val3;
            SeqOps seqOps2;
            List list = x$65;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValNumber && (n = (valNumber = (ValNumber)val3).value()).$less((Object)BigDecimal$.MODULE$.int2bigDecimal(0))) {
                val2 = ValNull$.MODULE$;
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber2 = (ValNumber)val;
                BigDecimal n2 = valNumber2.value();
                val2 = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(Math.sqrt(n2.toDouble())));
            } else {
                val2 = MODULE$.error((List<Val>)list);
            }
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction logFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"number", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$66 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$66;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(Math.log(n.toDouble())));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction expFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"number", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$67 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$67;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(Math.exp(n.toDouble())));
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction oddFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"number", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$68 -> {
            ValNumber valNumber;
            BigDecimal n;
            Val val;
            SeqOps seqOps;
            List list = x$68;
            Val val2 = list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber ? new ValBoolean(BoxesRunTime.equalsNumObject((Number)(n = (valNumber = (ValNumber)val).value()).$percent(BigDecimal$.MODULE$.int2bigDecimal(2)), (Object)BoxesRunTime.boxToInteger((int)1))) : MODULE$.error((List<Val>)list);
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction evenFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"number", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$69 -> {
            ValNumber valNumber;
            BigDecimal n;
            Val val;
            SeqOps seqOps;
            List list = x$69;
            Val val2 = list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber ? new ValBoolean(BoxesRunTime.equalsNumObject((Number)(n = (valNumber = (ValNumber)val).value()).$percent(BigDecimal$.MODULE$.int2bigDecimal(2)), (Object)BoxesRunTime.boxToInteger((int)0))) : MODULE$.error((List<Val>)list);
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction getEntriesFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"context", (List)Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1 & Serializable)x$70 -> {
            Val val;
            ValContext valContext;
            Context c;
            Val val2;
            SeqOps seqOps;
            List list = x$70;
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValContext && (c = (valContext = (ValContext)val2).context()) != null) {
                Context context = c;
                val = ((IterableOnceOps)context.variableProvider().getVariables().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new ValString(key)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), value)}));
                    return map;
                })).toList();
            } else {
                val = MODULE$.error((List<Val>)list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction getValueFunction() {
        return new ValFunction((List<String>)((List)new .colon.colon((Object)"context", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1 & Serializable)x$71 -> {
            List list = x$71;
            if (list == null) return MODULE$.error((List<Val>)list);
            SeqOps seqOps = List$.MODULE$.unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error((List<Val>)list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error((List<Val>)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error((List<Val>)list);
            Val val = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValContext)) return MODULE$.error((List<Val>)list);
            ValContext valContext = (ValContext)val;
            Context c = valContext.context();
            if (!(val2 instanceof ValString)) return MODULE$.error((List<Val>)list);
            ValString valString = (ValString)val2;
            String key = valString.value();
            return c.variableProvider().getVariable(key).getOrElse((Function0 & Serializable)() -> ValNull$.MODULE$);
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private Val withListOfNumbers(List<Val> list, Function1<List<BigDecimal>, Val> f) {
        Val val;
        Option option = list.map((Function1 & Serializable)x$72 -> {
            ValNumber valNumber;
            Val val = x$72;
            Product product = val instanceof ValNumber ? (valNumber = (ValNumber)val) : new ValError(new StringBuilder(28).append("expected number but found '").append(val).append("'").toString());
            return product;
        }).find((Function1 & Serializable)x$73 -> BoxesRunTime.boxToBoolean((boolean)BuiltinFunctions$.$anonfun$withListOfNumbers$2(x$73)));
        if (option instanceof Some) {
            Val e;
            Some some = (Some)option;
            val = e = (Val)some.value();
        } else if (None$.MODULE$.equals(option)) {
            val = (Val)f.apply((Object)list.map((Function1 & Serializable)x$74 -> x$74.value()));
        } else {
            throw new MatchError((Object)option);
        }
        return val;
    }

    public static final /* synthetic */ boolean $anonfun$error$1(Val x$1) {
        return x$1 instanceof ValError;
    }

    public static final /* synthetic */ boolean $anonfun$error$2(Val x$2) {
        return x$2 instanceof ValError;
    }

    public static final /* synthetic */ int $anonfun$modeFunction$5(Tuple2 x0$2) {
        int count;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = count = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$modeFunction$6(int maxCount$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int count = tuple2._2$mcI$sp();
        boolean bl = count == maxCount$1;
        return bl;
    }

    public static final /* synthetic */ ValNumber $anonfun$indexOfFunction$2(int x$54) {
        return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(x$54));
    }

    public static final /* synthetic */ boolean $anonfun$sortFunction$2(Function1 f$1, Val x0$1, Val x1$1) {
        boolean bl;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            boolean isMet;
            Val y;
            Val x = (Val)tuple2._1();
            Object object = f$1.apply((Object)new .colon.colon((Object)x, (List)new .colon.colon((Object)(y = (Val)tuple2._2()), (List)Nil$.MODULE$)));
            if (!(object instanceof ValBoolean)) {
                throw new RuntimeException(new StringBuilder(29).append("expected boolean but found '").append(object).append("'").toString());
            }
            ValBoolean valBoolean = (ValBoolean)object;
            bl = isMet = valBoolean.value();
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$withListOfNumbers$2(Val x$73) {
        return x$73 instanceof ValError;
    }

    private BuiltinFunctions$() {
    }
}

