/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValFunction$;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.package$;
import org.camunda.feel.spi.FunctionProvider;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class BuiltinFunctions$
implements FunctionProvider {
    public static final BuiltinFunctions$ MODULE$;
    private final List<Tuple2<String, ValFunction>> builtinFunctions;
    private final Map<Tuple2<String, Object>, ValFunction> builtinFunctionsByNameAndArgCount;

    static {
        new BuiltinFunctions$();
    }

    public List<Tuple2<String, ValFunction>> builtinFunctions() {
        return this.builtinFunctions;
    }

    public List<Tuple2<String, ValFunction>> conversionFunctions() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date"), (Object)this.dateFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date"), (Object)this.dateFunction3()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date_and_time"), (Object)this.dateTime()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date_and_time"), (Object)this.dateTime2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)this.timeFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)this.timeFunction3()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)this.timeFunction4()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)this.numberFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)this.numberFunction2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)this.numberFunction3()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)this.stringFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duration"), (Object)this.durationFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"years_and_months_duration"), (Object)this.durationFunction2())}));
    }

    public List<Tuple2<String, ValFunction>> booleanFunctions() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not"), (Object)this.notFunction())}));
    }

    public List<Tuple2<String, ValFunction>> stringFunctions() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring"), (Object)this.substringFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring"), (Object)this.substringFunction3()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string_length"), (Object)this.stringLengthFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper_case"), (Object)this.upperCaseFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower_case"), (Object)this.lowerCaseFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring_before"), (Object)this.substringBeforeFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"substring_after"), (Object)this.substringAfterFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replace"), (Object)this.replaceFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"contains"), (Object)this.containsFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"starts_with"), (Object)this.startsWithFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ends_with"), (Object)this.endsWithFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"matches"), (Object)this.matchesFunction())}));
    }

    public List<Tuple2<String, ValFunction>> listFunctions() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"list_contains"), (Object)this.listContainsFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)this.countFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)this.minFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)this.maxFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sum"), (Object)this.sumFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mean"), (Object)this.meanFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"and"), (Object)this.andFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"or"), (Object)this.orFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sublist"), (Object)this.sublistFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sublist"), (Object)this.sublistFunction3()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"append"), (Object)this.appendFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"concatenate"), (Object)this.concatenateFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert_before"), (Object)this.insertBeforeFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remove"), (Object)this.removeFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reverse"), (Object)this.reverseFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index_of"), (Object)this.indexOfFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"union"), (Object)this.unionFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distinct_values"), (Object)this.distinctValuesFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flatten"), (Object)this.flattenFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sort"), (Object)this.sortFunction())}));
    }

    public List<Tuple2<String, ValFunction>> numericFunctions() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"decimal"), (Object)this.decimalFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"floor"), (Object)this.floorFunction()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ceiling"), (Object)this.ceilingFunction())}));
    }

    private Map<Tuple2<String, Object>, ValFunction> builtinFunctionsByNameAndArgCount() {
        return this.builtinFunctionsByNameAndArgCount;
    }

    @Override
    public Option<ValFunction> getFunction(String name, int argCount) {
        return this.builtinFunctionsByNameAndArgCount().get((Object)new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)argCount)));
    }

    public ValError org$camunda$feel$interpreter$BuiltinFunctions$$error(List<Val> e) {
        List<Val> list2 = e;
        ValError valError = list2.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Val x$1) {
                return x$1 instanceof ValError;
            }
        }) ? (ValError)((IterableLike)list2.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Val x$2) {
                return x$2 instanceof ValError;
            }
        })).head() : new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal arguments: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
        return valError;
    }

    public ValFunction dateFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$3) {
                Product product;
                Val val;
                List<Val> list2 = x$3;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    product = new ValDate(package$.MODULE$.stringToDate(from));
                } else {
                    Val val2;
                    Some some2 = List$.MODULE$.unapplySeq(list2);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val2;
                        LocalDateTime from = valDateTime.value();
                        product = new ValDate(from.toLocalDate());
                    } else {
                        product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                    }
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month", "day"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$4) {
                void var13_15;
                List<Val> list2 = x$4;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal year = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal month = valNumber2.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber3 = (ValNumber)val3;
                                BigDecimal day = valNumber3.value();
                                ValDate valDate = new ValDate(LocalDate.of(year.intValue(), month.intValue(), day.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$5) {
                Product product;
                Val val;
                List<Val> list2 = x$5;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    product = new ValDateTime(package$.MODULE$.stringToDateTime(from));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime2() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date", "time"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$6) {
                Some some;
                void var10_13;
                List<Val> list2 = x$6;
                Some some2 = List$.MODULE$.unapplySeq(list2);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                    if (val instanceof ValDate) {
                        ValDate valDate = (ValDate)val;
                        LocalDate date = valDate.value();
                        if (val2 instanceof ValTime) {
                            ValTime valTime = (ValTime)val2;
                            LocalTime time = valTime.value();
                            ValDateTime valDateTime = new ValDateTime(date.atTime(time));
                            return var10_13;
                        }
                    }
                }
                if (!(some = List$.MODULE$.unapplySeq(list2)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val;
                        LocalDateTime dateTime3 = valDateTime.value();
                        if (val3 instanceof ValTime) {
                            ValTime valTime = (ValTime)val3;
                            LocalTime time = valTime.value();
                            ValDateTime valDateTime2 = new ValDateTime(dateTime3.toLocalDate().atTime(time));
                            return var10_13;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$7) {
                Product product;
                Val val;
                List<Val> list2 = x$7;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    product = new ValTime(package$.MODULE$.stringToTime(from));
                } else {
                    Val val2;
                    Some some2 = List$.MODULE$.unapplySeq(list2);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val2;
                        LocalDateTime from = valDateTime.value();
                        product = new ValTime(from.toLocalTime());
                    } else {
                        product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                    }
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hour", "minute", "second"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$8) {
                void var13_15;
                List<Val> list2 = x$8;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal hour = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal minute = valNumber2.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber3 = (ValNumber)val3;
                                BigDecimal second = valNumber3.value();
                                ValTime valTime = new ValTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction4() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hour", "minute", "second", "offset"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$9) {
                void var16_18;
                List<Val> list2 = x$9;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(4) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(3);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal hour = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal minute = valNumber2.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber3 = (ValNumber)val3;
                                BigDecimal second = valNumber3.value();
                                if (val4 instanceof ValDayTimeDuration) {
                                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                                    Duration offset = valDayTimeDuration.value();
                                    ValTime valTime = new ValTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()).plus(offset));
                                    return var16_18;
                                }
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var16_18;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$10) {
                Product product;
                Val val;
                List<Val> list2 = x$10;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    product = new ValNumber(package$.MODULE$.stringToNumber(from));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction2() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "grouping"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$11) {
                Some some;
                void var10_13;
                List<Val> list2 = x$11;
                Some some2 = List$.MODULE$.unapplySeq(list2);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString;
                        String grouping;
                        ValString valString2 = (ValString)val;
                        String from = valString2.value();
                        if (val2 instanceof ValString && BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$isValidGroupingSeparator(grouping = (valString = (ValString)val2).value())) {
                            ValNumber valNumber = new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "")));
                            return var10_13;
                        }
                    }
                }
                if (!(some = List$.MODULE$.unapplySeq(list2)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString && val3 instanceof ValString) {
                        ValError valError = new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal argument for grouping. Must be one of ' ', ',' or '.'"})).s((Seq)Nil$.MODULE$));
                        return var10_13;
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "grouping", "decimal"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$12) {
                Some some;
                void var14_17;
                List<Val> list2 = x$12;
                Some some2 = List$.MODULE$.unapplySeq(list2);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some2.get()).apply(2);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String from = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String grouping = valString2.value();
                            if (val3 instanceof ValString) {
                                ValString valString3 = (ValString)val3;
                                String decimal = valString3.value();
                                if (BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$isValidGroupingSeparator(grouping) && BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$isValidDecimalSeparator(decimal)) {
                                    String string = grouping;
                                    String string2 = decimal;
                                    if (string == null ? string2 != null : !string.equals(string2)) {
                                        ValNumber valNumber = new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "").replace(decimal, ".")));
                                        return var14_17;
                                    }
                                }
                            }
                        }
                    }
                }
                if (!(some = List$.MODULE$.unapplySeq(list2)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val5 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValString && val4 instanceof ValString && val5 instanceof ValString) {
                        ValError valError = new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal arguments for grouping or decimal. Must be one of ' ' (grouping only), ',' or '.'"})).s((Seq)Nil$.MODULE$));
                        return var14_17;
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var14_17;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$camunda$feel$interpreter$BuiltinFunctions$$isValidGroupingSeparator(String separator) {
        String string = separator;
        String string2 = " ";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ",";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = separator;
        String string6 = ".";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$camunda$feel$interpreter$BuiltinFunctions$$isValidDecimalSeparator(String separator) {
        String string = separator;
        String string2 = ",";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ".";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public ValFunction stringFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$13) {
                Product product;
                Val val;
                List<Val> list2 = x$13;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    product = new ValString(from);
                } else {
                    Val val2;
                    Some some2 = List$.MODULE$.unapplySeq(list2);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValBoolean) {
                        ValBoolean valBoolean = (ValBoolean)val2;
                        boolean from = valBoolean.value();
                        product = new ValString(((Object)BoxesRunTime.boxToBoolean((boolean)from)).toString());
                    } else {
                        Val val3;
                        Some some3 = List$.MODULE$.unapplySeq(list2);
                        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (val3 = (Val)((LinearSeqOptimized)some3.get()).apply(0)) instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val3;
                            BigDecimal from = valNumber.value();
                            product = new ValString(from.toString());
                        } else {
                            Val val4;
                            Some some4 = List$.MODULE$.unapplySeq(list2);
                            if (!some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && (val4 = (Val)((LinearSeqOptimized)some4.get()).apply(0)) instanceof ValDate) {
                                ValDate valDate = (ValDate)val4;
                                LocalDate from = valDate.value();
                                product = new ValString(from.format(package$.MODULE$.dateFormatter()));
                            } else {
                                Val val5;
                                Some some5 = List$.MODULE$.unapplySeq(list2);
                                if (!some5.isEmpty() && some5.get() != null && ((LinearSeqOptimized)some5.get()).lengthCompare(1) == 0 && (val5 = (Val)((LinearSeqOptimized)some5.get()).apply(0)) instanceof ValTime) {
                                    ValTime valTime = (ValTime)val5;
                                    LocalTime from = valTime.value();
                                    product = new ValString(from.format(package$.MODULE$.timeFormatter()));
                                } else {
                                    Val val6;
                                    Some some6 = List$.MODULE$.unapplySeq(list2);
                                    if (!some6.isEmpty() && some6.get() != null && ((LinearSeqOptimized)some6.get()).lengthCompare(1) == 0 && (val6 = (Val)((LinearSeqOptimized)some6.get()).apply(0)) instanceof ValDateTime) {
                                        ValDateTime valDateTime = (ValDateTime)val6;
                                        LocalDateTime from = valDateTime.value();
                                        product = new ValString(from.format(package$.MODULE$.dateTimeFormatter()));
                                    } else {
                                        Val val7;
                                        Some some7 = List$.MODULE$.unapplySeq(list2);
                                        if (!some7.isEmpty() && some7.get() != null && ((LinearSeqOptimized)some7.get()).lengthCompare(1) == 0 && (val7 = (Val)((LinearSeqOptimized)some7.get()).apply(0)) instanceof ValYearMonthDuration) {
                                            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val7;
                                            Period from = valYearMonthDuration.value();
                                            product = new ValString(from.toString());
                                        } else {
                                            Val val8;
                                            Some some8 = List$.MODULE$.unapplySeq(list2);
                                            if (!some8.isEmpty() && some8.get() != null && ((LinearSeqOptimized)some8.get()).lengthCompare(1) == 0 && (val8 = (Val)((LinearSeqOptimized)some8.get()).apply(0)) instanceof ValDayTimeDuration) {
                                                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val8;
                                                Duration from = valDayTimeDuration.value();
                                                product = new ValString(from.toString());
                                            } else {
                                                product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$14) {
                ValString valString;
                String from;
                Val val;
                List<Val> list2 = x$14;
                Some some = List$.MODULE$.unapplySeq(list2);
                Product product = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString ? (package$.MODULE$.isYearMonthDuration(from = (valString = (ValString)val).value()) ? new ValYearMonthDuration(package$.MODULE$.stringToYearMonthDuration(from)) : new ValDayTimeDuration(package$.MODULE$.stringToDayTimeDuration(from))) : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction2() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "to"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$15) {
                void var10_12;
                List<Val> list2 = x$15;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValDate) {
                        ValDate valDate = (ValDate)val;
                        LocalDate from = valDate.value();
                        if (val2 instanceof ValDate) {
                            ValDate valDate2 = (ValDate)val2;
                            LocalDate to = valDate2.value();
                            ValYearMonthDuration valYearMonthDuration = new ValYearMonthDuration(Period.between(from, to).withDays(0));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction notFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"negand"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$16) {
                ValBoolean valBoolean;
                boolean negand;
                Val val;
                List<Val> list2 = x$16;
                Some some = List$.MODULE$.unapplySeq(list2);
                Product product = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValBoolean ? new ValBoolean(!(negand = (valBoolean = (ValBoolean)val).value())) : ValNull$.MODULE$;
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "start"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$17) {
                void var10_12;
                List<Val> list2 = x$17;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            ValString valString2 = new ValString(string.substring(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(string, start.intValue())));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "start", "length"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$18) {
                void var13_15;
                List<Val> list2 = x$18;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber2 = (ValNumber)val3;
                                BigDecimal length = valNumber2.value();
                                ValString valString2 = new ValString(string.substring(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(string, start.intValue()), BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(string, start.intValue()) + length.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public int org$camunda$feel$interpreter$BuiltinFunctions$$stringIndex(String string, int index) {
        return index > 0 ? index - 1 : string.length() + index;
    }

    public ValFunction stringLengthFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$19) {
                Product product;
                Val val;
                List<Val> list2 = x$19;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String string = valString.value();
                    product = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(string.length()));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction upperCaseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$20) {
                Product product;
                Val val;
                List<Val> list2 = x$20;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String string = valString.value();
                    product = new ValString(string.toUpperCase());
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction lowerCaseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$21) {
                Product product;
                Val val;
                List<Val> list2 = x$21;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                    ValString valString = (ValString)val;
                    String string = valString.value();
                    product = new ValString(string.toLowerCase());
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringBeforeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$22) {
                void var10_13;
                List<Val> list2 = x$22;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            int index = string.indexOf(m);
                            ValString valString3 = index > 0 ? new ValString(string.substring(0, index)) : new ValString("");
                            return var10_13;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringAfterFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$23) {
                void var10_13;
                List<Val> list2 = x$23;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            int index = string.indexOf(m);
                            ValString valString3 = index > 0 ? new ValString(string.substring(index + m.length())) : new ValString("");
                            return var10_13;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_13;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction replaceFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern", "replacement"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$24) {
                void var13_15;
                List<Val> list2 = x$24;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String input = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String pattern = valString2.value();
                            if (val3 instanceof ValString) {
                                ValString valString3 = (ValString)val3;
                                String replacement = valString3.value();
                                ValString valString4 = new ValString(input.replaceAll(pattern, replacement));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction containsFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$25) {
                void var10_12;
                List<Val> list2 = x$25;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            ValBoolean valBoolean = new ValBoolean(string.contains(m));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction startsWithFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$26) {
                void var10_12;
                List<Val> list2 = x$26;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            ValBoolean valBoolean = new ValBoolean(string.startsWith(m));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction endsWithFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$27) {
                void var10_12;
                List<Val> list2 = x$27;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String string = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String m = valString2.value();
                            ValBoolean valBoolean = new ValBoolean(string.endsWith(m));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction matchesFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$28) {
                void var10_14;
                List<Val> list2 = x$28;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValString) {
                        ValString valString = (ValString)val;
                        String input = valString.value();
                        if (val2 instanceof ValString) {
                            ValString valString2 = (ValString)val2;
                            String pattern = valString2.value();
                            Pattern p = Pattern.compile(pattern);
                            Matcher m = p.matcher(input);
                            ValBoolean valBoolean = new ValBoolean(m.find());
                            return var10_14;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_14;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction listContainsFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "element"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$29) {
                void var8_10;
                List<Val> list2 = x$29;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val element = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        ValBoolean valBoolean = new ValBoolean(list3.contains((Object)element));
                        return var8_10;
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var8_10;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction countFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$30) {
                Product product;
                Val val;
                List<Val> list2 = x$30;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    product = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(list3.size()));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction minFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Val apply(List<Val> x$31) {
                void var7_17;
                Val val;
                List<Val> list2 = x$31;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    void var9_10;
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    if (Nil$.MODULE$.equals(list4)) {
                        ValNull$ valNull$ = ValNull$.MODULE$;
                    } else {
                        if (!(list4 instanceof .colon.colon)) throw new MatchError(list4);
                        .colon.colon colon2 = (.colon.colon)list4;
                        Val x = (Val)colon2.head();
                        Val val2 = x;
                        Val val3 = val2 instanceof ValNumber ? BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ValNumber apply(List<BigDecimal> numbers) {
                                return new ValNumber((BigDecimal)numbers.min((Ordering)Ordering.BigDecimal$.MODULE$));
                            }
                        }) : new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{val2})));
                        Val val4 = val3;
                    }
                    void var7_15 = var9_10;
                    return var7_17;
                } else {
                    ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return var7_17;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction maxFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Val apply(List<Val> x$32) {
                void var7_17;
                Val val;
                List<Val> list2 = x$32;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    void var9_10;
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    if (Nil$.MODULE$.equals(list4)) {
                        ValNull$ valNull$ = ValNull$.MODULE$;
                    } else {
                        if (!(list4 instanceof .colon.colon)) throw new MatchError(list4);
                        .colon.colon colon2 = (.colon.colon)list4;
                        Val x = (Val)colon2.head();
                        Val val2 = x;
                        Val val3 = val2 instanceof ValNumber ? BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ValNumber apply(List<BigDecimal> numbers) {
                                return new ValNumber((BigDecimal)numbers.max((Ordering)Ordering.BigDecimal$.MODULE$));
                            }
                        }) : new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{val2})));
                        Val val4 = val3;
                    }
                    void var7_15 = var9_10;
                    return var7_17;
                } else {
                    ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return var7_17;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sumFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$33) {
                Val val;
                Val val2;
                List<Val> list2 = x$33;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val2;
                    List<Val> list3 = valList.items();
                    val = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValNumber apply(List<BigDecimal> numbers) {
                            return new ValNumber((BigDecimal)numbers.sum((Numeric)Numeric.BigDecimalIsFractional$.MODULE$));
                        }
                    });
                } else {
                    val = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return val;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction meanFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$34) {
                Product product;
                Val val;
                List<Val> list2 = x$34;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    Val val2 = Nil$.MODULE$.equals(list4) ? ValNull$.MODULE$ : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValNumber apply(List<BigDecimal> numbers) {
                            return new ValNumber(((BigDecimal)numbers.sum((Numeric)Numeric.BigDecimalIsFractional$.MODULE$)).$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size())));
                        }
                    });
                    product = val2;
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction andFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$35) {
                Product product;
                Val val;
                List<Val> list2 = x$35;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    Val val2 = Nil$.MODULE$.equals(list4) ? new ValBoolean(true) : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfBooleans(list3, (Function1<List<Object>, Val>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValBoolean apply(List<Object> numbers) {
                            return new ValBoolean(BoxesRunTime.unboxToBoolean((Object)numbers.reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(boolean x$36, boolean x$37) {
                                    return x$36 && x$37;
                                }
                            })));
                        }
                    });
                    product = val2;
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction orFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$38) {
                Product product;
                Val val;
                List<Val> list2 = x$38;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    List<Val> list4 = list3;
                    Val val2 = Nil$.MODULE$.equals(list4) ? new ValBoolean(false) : BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$withListOfBooleans(list3, (Function1<List<Object>, Val>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValBoolean apply(List<Object> numbers) {
                            return new ValBoolean(BoxesRunTime.unboxToBoolean((Object)numbers.reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(boolean x$39, boolean x$40) {
                                    return x$39 || x$40;
                                }
                            })));
                        }
                    });
                    product = val2;
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sublistFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "start"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$41) {
                void var10_12;
                List<Val> list2 = x$41;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            ValList valList2 = new ValList((List<Val>)list3.slice(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, start.intValue()), list3.length()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sublistFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "start", "length"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$42) {
                void var13_15;
                List<Val> list2 = x$42;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal start = valNumber.value();
                            if (val3 instanceof ValNumber) {
                                ValNumber valNumber2 = (ValNumber)val3;
                                BigDecimal length = valNumber2.value();
                                ValList valList2 = new ValList((List<Val>)list3.slice(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, start.intValue()), BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, start.intValue()) + length.intValue()));
                                return var13_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var13_15;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public int org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(List<?> list2, int index) {
        return index > 0 ? index - 1 : list2.size() + index;
    }

    public ValFunction appendFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "item"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$43) {
                void var9_12;
                List<Val> list2 = x$43;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val item = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (item != null) {
                            Val val2;
                            Val val3 = val2 = item;
                            ValList valList2 = new ValList((List<Val>)((List)list3.$plus$plus((GenTraversableOnce)Nil$.MODULE$.$colon$colon((Object)val3), List$.MODULE$.canBuildFrom())));
                            return var9_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var9_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction concatenateFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "other"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$45) {
                void var10_12;
                List<Val> list2 = x$45;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValList) {
                            ValList valList2 = (ValList)val2;
                            List<Val> other = valList2.items();
                            ValList valList3 = new ValList((List<Val>)((List)list3.$plus$plus(other, List$.MODULE$.canBuildFrom())));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction insertBeforeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "position", "newItem"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$46) {
                void var12_15;
                List<Val> list2 = x$46;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    Val newItem = (Val)((LinearSeqOptimized)some.get()).apply(2);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal position = valNumber.value();
                            if (newItem != null) {
                                Val val3;
                                Val val4 = val3 = newItem;
                                ValList valList2 = new ValList((List<Val>)((List)((List)list3.take(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue())).$plus$plus((GenTraversableOnce)Nil$.MODULE$.$colon$colon((Object)val4), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)list3.drop(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue())), List$.MODULE$.canBuildFrom())));
                                return var12_15;
                            }
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var12_15;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction removeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "position"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$48) {
                void var10_12;
                List<Val> list2 = x$48;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber = (ValNumber)val2;
                            BigDecimal position = valNumber.value();
                            ValList valList2 = new ValList((List<Val>)((List)list3.take(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue())).$plus$plus((GenTraversableOnce)list3.drop(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$listIndex(list3, position.intValue() + 1)), List$.MODULE$.canBuildFrom())));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction reverseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$49) {
                Product product;
                Val val;
                List<Val> list2 = x$49;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    product = new ValList((List<Val>)list3.reverse());
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction indexOfFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "match"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$50) {
                void var9_11;
                List<Val> list2 = x$50;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val m = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (m != null) {
                            Val val2 = m;
                            ValList valList2 = new ValList((List<Val>)((List)BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList(list3, val2, BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$3(), BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$4()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ValNumber apply(int x$51) {
                                    return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(x$51));
                                }
                            }, List$.MODULE$.canBuildFrom())));
                            return var9_11;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var9_11;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public List<Object> org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList(List<Val> list2, Val item, int from, List<Object> indexList) {
        int index;
        while ((index = list2.indexOf((Object)item, from)) > 0) {
            indexList = (List)indexList.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{index + 1})), List$.MODULE$.canBuildFrom());
            from = index + 1;
        }
        return indexList;
    }

    public int org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$3() {
        return 0;
    }

    public List<Object> org$camunda$feel$interpreter$BuiltinFunctions$$indexOfList$default$4() {
        return Nil$.MODULE$;
    }

    public ValFunction unionFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "other"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$52) {
                void var10_12;
                List<Val> list2 = x$52;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValList) {
                        ValList valList = (ValList)val;
                        List<Val> list3 = valList.items();
                        if (val2 instanceof ValList) {
                            ValList valList2 = (ValList)val2;
                            List<Val> other = valList2.items();
                            ValList valList3 = new ValList((List<Val>)((List)((SeqLike)list3.$plus$plus(other, List$.MODULE$.canBuildFrom())).distinct()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction distinctValuesFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$53) {
                Product product;
                Val val;
                List<Val> list2 = x$53;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    product = new ValList((List<Val>)((List)list3.distinct()));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction flattenFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$54) {
                Product product;
                Val val;
                List<Val> list2 = x$54;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list3 = valList.items();
                    product = new ValList(BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$flatten(list3));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public List<Val> org$camunda$feel$interpreter$BuiltinFunctions$$flatten(List<Val> list2) {
        List<Val> list3;
        block5: {
            Nil$ nil$;
            block3: {
                .colon.colon colon2;
                boolean bl;
                block4: {
                    block2: {
                        bl = false;
                        colon2 = null;
                        list3 = list2;
                        if (!Nil$.MODULE$.equals(list3)) break block2;
                        nil$ = Nil$.MODULE$;
                        break block3;
                    }
                    if (!(list3 instanceof .colon.colon)) break block4;
                    bl = true;
                    colon2 = (.colon.colon)list3;
                    Val val = (Val)colon2.head();
                    List xs = colon2.tl$1();
                    if (!(val instanceof ValList)) break block4;
                    ValList valList = (ValList)val;
                    List<Val> l = valList.items();
                    nil$ = (List)this.org$camunda$feel$interpreter$BuiltinFunctions$$flatten(l).$plus$plus(this.org$camunda$feel$interpreter$BuiltinFunctions$$flatten((List<Val>)xs), List$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!bl) break block5;
                Val x = (Val)colon2.head();
                List xs = colon2.tl$1();
                Val val = x;
                nil$ = this.org$camunda$feel$interpreter$BuiltinFunctions$$flatten((List<Val>)xs).$colon$colon((Object)val);
            }
            return nil$;
        }
        throw new MatchError(list3);
    }

    public ValFunction sortFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "precedes"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Val apply(List<Val> x$56) {
                block8: {
                    var2_2 = x$56;
                    var3_3 = List$.MODULE$.unapplySeq(var2_2);
                    if (!var3_3.isEmpty() && var3_3.get() != null && ((LinearSeqOptimized)var3_3.get()).lengthCompare(2) == 0) {
                        var4_4 = (Val)((LinearSeqOptimized)var3_3.get()).apply(0);
                        var5_5 = (Val)((LinearSeqOptimized)var3_3.get()).apply(1);
                        if (var4_4 instanceof ValList) {
                            var6_6 = (ValList)var4_4;
                            list = var6_6.items();
                            if (var5_5 instanceof ValFunction) {
                                var8_8 = (ValFunction)var5_5;
                                params = var8_8.params();
                                f = var8_8.invoke();
                                if (params.size() == 2) {
                                    v0 /* !! */  = new ValList((List<Val>)((List)list.sortWith((Function2)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final Function1 f$1;

                                        public final boolean apply(Val x0$1, Val x1$1) {
                                            Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                                            if (tuple2 != null) {
                                                Val x = (Val)tuple2._1();
                                                Val y = (Val)tuple2._2();
                                                boolean bl = ((ValBoolean)this.f$1.apply((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Val[]{x, y})))).value();
                                                return bl;
                                            }
                                            throw new MatchError((Object)tuple2);
                                        }
                                        {
                                            this.f$1 = f$1;
                                        }
                                    })));
                                }
                            }
                        }
                    }
                    if ((var13_11 = List$.MODULE$.unapplySeq(var2_2)).isEmpty() || var13_11.get() == null || ((LinearSeqOptimized)var13_11.get()).lengthCompare(2) != 0) ** GOTO lbl-1000
                    var14_12 = (Val)((LinearSeqOptimized)var13_11.get()).apply(0);
                    var15_13 = (Val)((LinearSeqOptimized)var13_11.get()).apply(1);
                    if (var14_12 instanceof ValList && var15_13 instanceof ValFunction) {
                        var16_14 = (ValFunction)var15_13;
                        params = var16_14.params();
                        var11_16 /* !! */  = new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect boolean function with 2 arguments, but found '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)params.size())})));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var11_16 /* !! */  = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(var2_2);
                    }
                    break block8;
                    catch (Throwable var12_17) {
                        v0 /* !! */  = new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to sort list by given precedes function: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_17})));
                    }
                    var11_16 /* !! */  = v0 /* !! */ ;
                }
                return var11_16 /* !! */ ;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction decimalFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "scale"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Val apply(List<Val> x$57) {
                void var10_12;
                List<Val> list2 = x$57;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
                    Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
                    if (val instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val;
                        BigDecimal n = valNumber.value();
                        if (val2 instanceof ValNumber) {
                            ValNumber valNumber2 = (ValNumber)val2;
                            BigDecimal scale = valNumber2.value();
                            ValNumber valNumber3 = new ValNumber(n.setScale(scale.intValue(), BigDecimal.RoundingMode$.MODULE$.HALF_EVEN()));
                            return var10_12;
                        }
                    }
                }
                ValError valError = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                return var10_12;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction floorFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$58) {
                Product product;
                Val val;
                List<Val> list2 = x$58;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal n = valNumber.value();
                    product = new ValNumber(n.setScale(0, BigDecimal.RoundingMode$.MODULE$.FLOOR()));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction ceilingFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})), (Function1<List<Val>, Val>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Val apply(List<Val> x$59) {
                Product product;
                Val val;
                List<Val> list2 = x$59;
                Some some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal n = valNumber.value();
                    product = new ValNumber(n.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING()));
                } else {
                    product = BuiltinFunctions$.MODULE$.org$camunda$feel$interpreter$BuiltinFunctions$$error(list2);
                }
                return product;
            }
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public Val org$camunda$feel$interpreter$BuiltinFunctions$$withListOfNumbers(List<Val> list2, Function1<List<BigDecimal>, Val> f) {
        Option option;
        block4: {
            Val val;
            block3: {
                block2: {
                    option = ((LinearSeqOptimized)list2.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Product apply(Val x$60) {
                            ValNumber valNumber;
                            Val val = x$60;
                            Product product = val instanceof ValNumber ? (valNumber = (ValNumber)val) : new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{val})));
                            return product;
                        }
                    }, List$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Product x$61) {
                            return x$61 instanceof ValError;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Product e = (Product)some.x();
                    val = (Val)e;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                val = (Val)f.apply(list2.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BigDecimal apply(ValNumber x$62) {
                        return x$62.value();
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
            return val;
        }
        throw new MatchError((Object)option);
    }

    public Val org$camunda$feel$interpreter$BuiltinFunctions$$withListOfBooleans(List<Val> list2, Function1<List<Object>, Val> f) {
        Option option;
        block4: {
            Val val;
            block3: {
                block2: {
                    option = ((LinearSeqOptimized)list2.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Product apply(Val x$63) {
                            ValBoolean valBoolean;
                            Val val = x$63;
                            Product product = val instanceof ValBoolean ? (valBoolean = (ValBoolean)val) : new ValError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected boolean but found '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{val})));
                            return product;
                        }
                    }, List$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Product x$64) {
                            return x$64 instanceof ValError;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Product e = (Product)some.x();
                    val = (Val)e;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                val = (Val)f.apply(list2.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ValBoolean x$65) {
                        return x$65.value();
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
            return val;
        }
        throw new MatchError((Object)option);
    }

    private BuiltinFunctions$() {
        MODULE$ = this;
        this.builtinFunctions = (List)((List)((List)((List)this.conversionFunctions().$plus$plus(this.booleanFunctions(), List$.MODULE$.canBuildFrom())).$plus$plus(this.stringFunctions(), List$.MODULE$.canBuildFrom())).$plus$plus(this.listFunctions(), List$.MODULE$.canBuildFrom())).$plus$plus(this.numericFunctions(), List$.MODULE$.canBuildFrom());
        this.builtinFunctionsByNameAndArgCount = ((TraversableOnce)this.builtinFunctions().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<String, Object>, ValFunction> apply(Tuple2<String, ValFunction> x0$2) {
                Tuple2<String, ValFunction> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    ValFunction f = (ValFunction)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)f.params().size()))), (Object)f);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

