/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.interpreter.FunctionProvider;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValFunction$;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.Numeric$BigDecimalIsFractional$;
import scala.math.Ordering$BigDecimal$;
import scala.runtime.BoxesRunTime;

public final class BuiltinFunctions$
implements FunctionProvider {
    public static BuiltinFunctions$ MODULE$;
    private final Logger logger;
    private final Map<String, List<ValFunction>> functions;

    static {
        new BuiltinFunctions$();
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public List<ValFunction> getFunction(String name) {
        return (List)this.functions().getOrElse(name, (Function0<List> & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
    }

    public Map<String, List<ValFunction>> functions() {
        return this.functions;
    }

    private Map<String, List<ValFunction>> conversionFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.dateFunction(), this.dateFunction3()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date and time"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.dateTime(), this.dateTime2()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("time"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.timeFunction(), this.timeFunction3(), this.timeFunction4()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("number"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.numberFunction(), this.numberFunction2(), this.numberFunction3()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("string"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.stringFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("duration"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.durationFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("years and months duration"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.durationFunction2()})))}));
    }

    private Map<String, List<ValFunction>> booleanFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("not"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.notFunction()})))}));
    }

    private Map<String, List<ValFunction>> stringFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.substringFunction(), this.substringFunction3()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("string length"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.stringLengthFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("upper case"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.upperCaseFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("lower case"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.lowerCaseFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring before"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.substringBeforeFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring after"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.substringAfterFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("replace"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.replaceFunction(), this.replaceFunction4()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("contains"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.containsFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("starts with"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.startsWithFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ends with"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.endsWithFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("matches"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.matchesFunction(), this.matchesFunction3()})))}));
    }

    private Map<String, List<ValFunction>> listFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("list contains"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.listContainsFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("count"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.countFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("min"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.minFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("max"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.maxFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sum"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.sumFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("mean"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.meanFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("and"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.andFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("or"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.orFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sublist"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.sublistFunction(), this.sublistFunction3()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("append"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.appendFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("concatenate"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.concatenateFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("insert before"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.insertBeforeFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("remove"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.removeFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("reverse"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.reverseFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("index of"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.indexOfFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("union"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.unionFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("distinct values"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.distinctValuesFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("flatten"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.flattenFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sort"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.sortFunction()})))}));
    }

    private Map<String, List<ValFunction>> numericFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("decimal"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.decimalFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("floor"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.floorFunction()}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ceiling"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValFunction[]{this.ceilingFunction()})))}));
    }

    private Val error(List<Val> e) {
        scala.Serializable serializable;
        List<Val> list = e;
        if (list.exists((Function1<Val, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$error$1(x$1)))) {
            serializable = (ValError)((IterableLike)list.filter((Function1<Val, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$error$2(x$2)))).head();
        } else {
            this.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressed failure: illegal arguments: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{list})));
            serializable = ValNull$.MODULE$;
        }
        return serializable;
    }

    public ValFunction dateFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$3 -> {
            Val val;
            Val val2;
            List list = x$3;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = new ValDate(package$.MODULE$.stringToDate(from));
            } else {
                Val val3;
                Some<List> some2 = List$.MODULE$.unapplySeq(list);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val3 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val3;
                    LocalDateTime from = valLocalDateTime.value();
                    val = new ValDate(from.toLocalDate());
                } else {
                    Val val4;
                    Some<List> some3 = List$.MODULE$.unapplySeq(list);
                    if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (val4 = (Val)((LinearSeqOptimized)some3.get()).apply(0)) instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val4;
                        OffsetDateTime from = valDateTime.value();
                        val = new ValDate(from.toLocalDate());
                    } else {
                        val = MODULE$.error(list);
                    }
                }
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction dateFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month", "day"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$4 -> {
            List list = x$4;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal year = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal month = valNumber2.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber3 = (ValNumber)val3;
            BigDecimal day = valNumber3.value();
            return new ValDate(LocalDate.of(year.intValue(), month.intValue(), day.intValue()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction dateTime() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$5 -> {
            ValString valString;
            String from;
            Val val;
            List list = x$5;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            Object object = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString ? (package$.MODULE$.isOffsetDateTime(from = (valString = (ValString)val).value()) ? new ValDateTime(package$.MODULE$.stringToDateTime(from)) : new ValLocalDateTime(package$.MODULE$.stringToLocalDateTime(from))) : MODULE$.error(list);
            return object;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction dateTime2() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date", "time"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$6 -> {
            Some<List> some;
            Some<List> some2;
            Some<List> some3;
            Some<List> some4;
            Some<List> some5;
            List list = x$6;
            Some<List> some6 = List$.MODULE$.unapplySeq(list);
            if (!some6.isEmpty() && some6.get() != null && ((LinearSeqOptimized)some6.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some6.get()).apply(0);
                Val val2 = (Val)((LinearSeqOptimized)some6.get()).apply(1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate date = valDate.value();
                    if (val2 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val2;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(date.atTime(time));
                    }
                }
            }
            if (!(some5 = List$.MODULE$.unapplySeq(list)).isEmpty() && some5.get() != null && ((LinearSeqOptimized)some5.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some5.get()).apply(0);
                Val val3 = (Val)((LinearSeqOptimized)some5.get()).apply(1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate date = valDate.value();
                    if (val3 instanceof ValTime) {
                        ValTime valTime = (ValTime)val3;
                        OffsetTime time = valTime.value();
                        return new ValDateTime(date.atTime(time));
                    }
                }
            }
            if (!(some4 = List$.MODULE$.unapplySeq(list)).isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some4.get()).apply(0);
                Val val4 = (Val)((LinearSeqOptimized)some4.get()).apply(1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime dateTime = valLocalDateTime.value();
                    if (val4 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val4;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if (!(some3 = List$.MODULE$.unapplySeq(list)).isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some3.get()).apply(0);
                Val val5 = (Val)((LinearSeqOptimized)some3.get()).apply(1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime dateTime = valLocalDateTime.value();
                    if (val5 instanceof ValTime) {
                        ValTime valTime = (ValTime)val5;
                        OffsetTime time = valTime.value();
                        return new ValDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if (!(some2 = List$.MODULE$.unapplySeq(list)).isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                Val val6 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    OffsetDateTime dateTime = valDateTime.value();
                    if (val6 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val6;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if ((some = List$.MODULE$.unapplySeq(list)).isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val7 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValDateTime)) return MODULE$.error(list);
            ValDateTime valDateTime = (ValDateTime)val;
            OffsetDateTime dateTime = valDateTime.value();
            if (!(val7 instanceof ValTime)) return MODULE$.error(list);
            ValTime valTime = (ValTime)val7;
            OffsetTime time = valTime.value();
            return new ValDateTime(dateTime.toLocalDate().atTime(time));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction timeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$7 -> {
            Val val;
            Val val2;
            List list = x$7;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = package$.MODULE$.isOffsetTime(from) ? new ValTime(package$.MODULE$.stringToTime(from)) : new ValLocalTime(package$.MODULE$.stringToLocalTime(from));
            } else {
                Val val3;
                Some<List> some2 = List$.MODULE$.unapplySeq(list);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val3 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val3;
                    LocalDateTime from = valLocalDateTime.value();
                    val = new ValLocalTime(from.toLocalTime());
                } else {
                    Val val4;
                    Some<List> some3 = List$.MODULE$.unapplySeq(list);
                    if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (val4 = (Val)((LinearSeqOptimized)some3.get()).apply(0)) instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val4;
                        OffsetDateTime from = valDateTime.value();
                        val = new ValTime(from.toOffsetTime());
                    } else {
                        val = MODULE$.error(list);
                    }
                }
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction timeFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hour", "minute", "second"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$8 -> {
            List list = x$8;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal hour = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal minute = valNumber2.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber3 = (ValNumber)val3;
            BigDecimal second = valNumber3.value();
            return new ValLocalTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction timeFunction4() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hour", "minute", "second", "offset"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$9 -> {
            List list = x$9;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(4) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(3);
            if (!(val instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal hour = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal minute = valNumber2.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber3 = (ValNumber)val3;
            BigDecimal second = valNumber3.value();
            if (!(val4 instanceof ValDayTimeDuration)) return MODULE$.error(list);
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
            Duration offset = valDayTimeDuration.value();
            LocalTime localTime = LocalTime.of(hour.intValue(), minute.intValue(), second.intValue());
            ZoneOffset zonedOffset = ZoneOffset.ofTotalSeconds((int)offset.getSeconds());
            return new ValTime(localTime.atOffset(zonedOffset));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction numberFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$10 -> {
            Val val;
            Val val2;
            List list = x$10;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = new ValNumber(package$.MODULE$.stringToNumber(from));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction numberFunction2() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "grouping"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$11 -> {
            Some<List> some;
            List list = x$11;
            Some<List> some2 = List$.MODULE$.unapplySeq(list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                if (val instanceof ValString) {
                    ValString valString;
                    String grouping;
                    ValString valString2 = (ValString)val;
                    String from = valString2.value();
                    if (val2 instanceof ValString && MODULE$.isValidGroupingSeparator(grouping = (valString = (ValString)val2).value())) {
                        return new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "")));
                    }
                }
            }
            if ((some = List$.MODULE$.unapplySeq(list)).isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            return new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal argument for grouping. Must be one of ' ', ',' or '.'"})).s(Nil$.MODULE$));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction numberFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "grouping", "decimal"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$12 -> {
            Some<List> some;
            List list = x$12;
            Some<List> some2 = List$.MODULE$.unapplySeq(list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(3) == 0) {
                Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                Val val3 = (Val)((LinearSeqOptimized)some2.get()).apply(2);
                if (val instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    if (val2 instanceof ValString) {
                        ValString valString2 = (ValString)val2;
                        String grouping = valString2.value();
                        if (val3 instanceof ValString) {
                            ValString valString3 = (ValString)val3;
                            String decimal = valString3.value();
                            if (MODULE$.isValidGroupingSeparator(grouping) && MODULE$.isValidDecimalSeparator(decimal)) {
                                String string = grouping;
                                String string2 = decimal;
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    return new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "").replace(decimal, ".")));
                                }
                            }
                        }
                    }
                }
            }
            if ((some = List$.MODULE$.unapplySeq(list)).isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val5 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            if (!(val4 instanceof ValString)) return MODULE$.error(list);
            if (!(val5 instanceof ValString)) return MODULE$.error(list);
            return new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"illegal arguments for grouping or decimal. Must be one of ' ' (grouping only), ',' or '.'"})).s(Nil$.MODULE$));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidGroupingSeparator(String separator) {
        String string = separator;
        String string2 = " ";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ",";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = separator;
        String string6 = ".";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidDecimalSeparator(String separator) {
        String string = separator;
        String string2 = ",";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ".";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public ValFunction stringFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$13 -> {
            Val val;
            Val val2;
            List list = x$13;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = new ValString(from);
            } else {
                Val val3;
                Some<List> some2 = List$.MODULE$.unapplySeq(list);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val3 = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValBoolean) {
                    ValBoolean valBoolean = (ValBoolean)val3;
                    boolean from = valBoolean.value();
                    val = new ValString(((Object)BoxesRunTime.boxToBoolean(from)).toString());
                } else {
                    Val val4;
                    Some<List> some3 = List$.MODULE$.unapplySeq(list);
                    if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (val4 = (Val)((LinearSeqOptimized)some3.get()).apply(0)) instanceof ValNumber) {
                        ValNumber valNumber = (ValNumber)val4;
                        BigDecimal from = valNumber.value();
                        val = new ValString(from.toString());
                    } else {
                        Val val5;
                        Some<List> some4 = List$.MODULE$.unapplySeq(list);
                        if (!some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && (val5 = (Val)((LinearSeqOptimized)some4.get()).apply(0)) instanceof ValDate) {
                            ValDate valDate = (ValDate)val5;
                            LocalDate from = valDate.value();
                            val = new ValString(from.format(package$.MODULE$.dateFormatter()));
                        } else {
                            Val val6;
                            Some<List> some5 = List$.MODULE$.unapplySeq(list);
                            if (!some5.isEmpty() && some5.get() != null && ((LinearSeqOptimized)some5.get()).lengthCompare(1) == 0 && (val6 = (Val)((LinearSeqOptimized)some5.get()).apply(0)) instanceof ValLocalTime) {
                                ValLocalTime valLocalTime = (ValLocalTime)val6;
                                LocalTime from = valLocalTime.value();
                                val = new ValString(from.format(package$.MODULE$.localTimeFormatter()));
                            } else {
                                Val val7;
                                Some<List> some6 = List$.MODULE$.unapplySeq(list);
                                if (!some6.isEmpty() && some6.get() != null && ((LinearSeqOptimized)some6.get()).lengthCompare(1) == 0 && (val7 = (Val)((LinearSeqOptimized)some6.get()).apply(0)) instanceof ValTime) {
                                    ValTime valTime = (ValTime)val7;
                                    OffsetTime from = valTime.value();
                                    val = new ValString(from.format(package$.MODULE$.timeFormatter()));
                                } else {
                                    Val val8;
                                    Some<List> some7 = List$.MODULE$.unapplySeq(list);
                                    if (!some7.isEmpty() && some7.get() != null && ((LinearSeqOptimized)some7.get()).lengthCompare(1) == 0 && (val8 = (Val)((LinearSeqOptimized)some7.get()).apply(0)) instanceof ValLocalDateTime) {
                                        ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val8;
                                        LocalDateTime from = valLocalDateTime.value();
                                        val = new ValString(from.format(package$.MODULE$.localDateTimeFormatter()));
                                    } else {
                                        Val val9;
                                        Some<List> some8 = List$.MODULE$.unapplySeq(list);
                                        if (!some8.isEmpty() && some8.get() != null && ((LinearSeqOptimized)some8.get()).lengthCompare(1) == 0 && (val9 = (Val)((LinearSeqOptimized)some8.get()).apply(0)) instanceof ValDateTime) {
                                            ValDateTime valDateTime = (ValDateTime)val9;
                                            OffsetDateTime from = valDateTime.value();
                                            val = new ValString(from.format(package$.MODULE$.dateTimeFormatter()));
                                        } else {
                                            Val val10;
                                            Some<List> some9 = List$.MODULE$.unapplySeq(list);
                                            if (!some9.isEmpty() && some9.get() != null && ((LinearSeqOptimized)some9.get()).lengthCompare(1) == 0 && (val10 = (Val)((LinearSeqOptimized)some9.get()).apply(0)) instanceof ValYearMonthDuration) {
                                                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val10;
                                                Period from = valYearMonthDuration.value();
                                                val = new ValString(from.toString());
                                            } else {
                                                Val val11;
                                                Some<List> some10 = List$.MODULE$.unapplySeq(list);
                                                if (!some10.isEmpty() && some10.get() != null && ((LinearSeqOptimized)some10.get()).lengthCompare(1) == 0 && (val11 = (Val)((LinearSeqOptimized)some10.get()).apply(0)) instanceof ValDayTimeDuration) {
                                                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val11;
                                                    Duration from = valDayTimeDuration.value();
                                                    val = new ValString(from.toString());
                                                } else {
                                                    val = MODULE$.error(list);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction durationFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$14 -> {
            ValString valString;
            String from;
            Val val;
            List list = x$14;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            Object object = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString ? (package$.MODULE$.isYearMonthDuration(from = (valString = (ValString)val).value()) ? new ValYearMonthDuration(package$.MODULE$.stringToYearMonthDuration(from)) : new ValDayTimeDuration(package$.MODULE$.stringToDayTimeDuration(from))) : MODULE$.error(list);
            return object;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction durationFunction2() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from", "to"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$15 -> {
            Some<List> some;
            Some<List> some2;
            List list = x$15;
            Some<List> some3 = List$.MODULE$.unapplySeq(list);
            if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some3.get()).apply(0);
                Val val2 = (Val)((LinearSeqOptimized)some3.get()).apply(1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val2 instanceof ValDate) {
                        ValDate valDate2 = (ValDate)val2;
                        LocalDate to = valDate2.value();
                        return new ValYearMonthDuration(Period.between(from, to).withDays(0));
                    }
                }
            }
            if (!(some2 = List$.MODULE$.unapplySeq(list)).isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                Val val3 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime from = valLocalDateTime.value();
                    if (val3 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime2 = (ValLocalDateTime)val3;
                        LocalDateTime to = valLocalDateTime2.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0));
                    }
                }
            }
            if ((some = List$.MODULE$.unapplySeq(list)).isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValDateTime)) return MODULE$.error(list);
            ValDateTime valDateTime = (ValDateTime)val;
            OffsetDateTime from = valDateTime.value();
            if (!(val4 instanceof ValDateTime)) return MODULE$.error(list);
            ValDateTime valDateTime2 = (ValDateTime)val4;
            OffsetDateTime to = valDateTime2.value();
            return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction notFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"negand"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$16 -> {
            Val other;
            Some<List> some;
            ValBoolean valBoolean;
            boolean negand;
            Val val;
            List list = x$16;
            Some<List> some2 = List$.MODULE$.unapplySeq(list);
            scala.Serializable serializable = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (val = (Val)((LinearSeqOptimized)some2.get()).apply(0)) instanceof ValBoolean ? new ValBoolean(!(negand = (valBoolean = (ValBoolean)val).value())) : (!(some = List$.MODULE$.unapplySeq(list)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (other = (Val)((LinearSeqOptimized)some.get()).apply(0)) != null ? ValNull$.MODULE$ : ValNull$.MODULE$);
            return serializable;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction substringFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "start"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$17 -> {
            List list = x$17;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            return new ValString(string.substring(MODULE$.stringIndex(string, start.intValue())));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction substringFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "start", "length"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$18 -> {
            List list = x$18;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val3;
            BigDecimal length = valNumber2.value();
            return new ValString(string.substring(MODULE$.stringIndex(string, start.intValue()), MODULE$.stringIndex(string, start.intValue()) + length.intValue()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    private int stringIndex(String string, int index) {
        return index > 0 ? index - 1 : string.length() + index;
    }

    public ValFunction stringLengthFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$19 -> {
            Val val;
            Val val2;
            List list = x$19;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(string.length()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction upperCaseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$20 -> {
            Val val;
            Val val2;
            List list = x$20;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValString(string.toUpperCase());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction lowerCaseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$21 -> {
            Val val;
            Val val2;
            List list = x$21;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValString(string.toLowerCase());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction substringBeforeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$22 -> {
            List list = x$22;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            int index = string.indexOf(m);
            return index > 0 ? new ValString(string.substring(0, index)) : new ValString("");
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction substringAfterFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$23 -> {
            List list = x$23;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            int index = string.indexOf(m);
            return index >= 0 ? new ValString(string.substring(index + m.length())) : new ValString("");
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction replaceFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern", "replacement"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$24 -> {
            List list = x$24;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            ValString valString3 = (ValString)val3;
            String replacement = valString3.value();
            return new ValString(input.replaceAll(pattern, replacement));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction replaceFunction4() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern", "replacement", "flags"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$25 -> {
            List list = x$25;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(4) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            Val val4 = (Val)((LinearSeqOptimized)some.get()).apply(3);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            ValString valString3 = (ValString)val3;
            String replacement = valString3.value();
            if (!(val4 instanceof ValString)) return MODULE$.error(list);
            ValString valString4 = (ValString)val4;
            String flags = valString4.value();
            Pattern p = Pattern.compile(pattern, MODULE$.patternFlags(flags));
            Matcher m = p.matcher(input);
            return new ValString(m.replaceAll(replacement));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    /*
     * WARNING - void declaration
     */
    private int patternFlags(String flags) {
        void var2_2;
        block3: {
            int f = 0;
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            if (flags.contains("i")) {
                f |= 2;
            }
            if (!flags.contains("x")) break block3;
            f |= 4;
        }
        return (int)var2_2;
    }

    public ValFunction containsFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$26 -> {
            List list = x$26;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.contains(m));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction startsWithFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$27 -> {
            List list = x$27;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.startsWith(m));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction endsWithFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "match"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$28 -> {
            List list = x$28;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.endsWith(m));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction matchesFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$29 -> {
            List list = x$29;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(input);
            return new ValBoolean(m.find());
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction matchesFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input", "pattern", "flags"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$30 -> {
            List list = x$30;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            ValString valString3 = (ValString)val3;
            String flags = valString3.value();
            Pattern p = Pattern.compile(pattern, MODULE$.patternFlags(flags));
            Matcher m = p.matcher(input);
            return new ValBoolean(m.find());
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction listContainsFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "element"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$31 -> {
            List list = x$31;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val element = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            return new ValBoolean(list2.contains(element));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction countFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$32 -> {
            Val val;
            Val val2;
            List list = x$32;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(list2.size()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction minFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$33 -> {
            Val val;
            Val val2;
            List list = x$33;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                Val val3;
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                if (((Object)Nil$.MODULE$).equals(list3)) {
                    val3 = ValNull$.MODULE$;
                } else if (list3 instanceof $colon$colon) {
                    $colon$colon $colon$colon = ($colon$colon)list3;
                    Val x = (Val)$colon$colon.head();
                    Val val4 = x;
                    Val val5 = val4 instanceof ValNumber ? MODULE$.withListOfNumbers(list2, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable & scala.Serializable)numbers -> new ValNumber((BigDecimal)numbers.min(Ordering$BigDecimal$.MODULE$))) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val4})));
                    val3 = val5;
                } else {
                    throw new MatchError(list3);
                }
                val = val3;
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction maxFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$34 -> {
            Val val;
            Val val2;
            List list = x$34;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                Val val3;
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                if (((Object)Nil$.MODULE$).equals(list3)) {
                    val3 = ValNull$.MODULE$;
                } else if (list3 instanceof $colon$colon) {
                    $colon$colon $colon$colon = ($colon$colon)list3;
                    Val x = (Val)$colon$colon.head();
                    Val val4 = x;
                    Val val5 = val4 instanceof ValNumber ? MODULE$.withListOfNumbers(list2, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable & scala.Serializable)numbers -> new ValNumber((BigDecimal)numbers.max(Ordering$BigDecimal$.MODULE$))) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val4})));
                    val3 = val5;
                } else {
                    throw new MatchError(list3);
                }
                val = val3;
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction sumFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$35 -> {
            Val val;
            Val val2;
            List list = x$35;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.withListOfNumbers(list2, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable & scala.Serializable)numbers -> new ValNumber(numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$)));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction meanFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$36 -> {
            Val val;
            Val val2;
            List list = x$36;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                Val val3 = ((Object)Nil$.MODULE$).equals(list3) ? ValNull$.MODULE$ : MODULE$.withListOfNumbers(list2, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable & scala.Serializable)numbers -> new ValNumber(numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$).$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size()))));
                val = val3;
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction andFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$37 -> {
            Val val;
            Val val2;
            List list = x$37;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.all(list2);
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    private Val all(List<Val> xs) {
        ValBoolean valBoolean;
        block4: {
            List<Val> list;
            block5: {
                scala.Serializable serializable;
                block6: {
                    ValBoolean valBoolean2;
                    boolean bl;
                    List<Val> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            valBoolean = new ValBoolean(true);
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Val x = (Val)$colon$colon.head();
                        xs2 = $colon$colon.tl$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean3 = null;
                        Val val = x;
                        if (val instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean3 = (ValBoolean)val;
                            boolean bl4 = valBoolean3.value();
                            if (!bl4) {
                                serializable = new ValBoolean(false);
                                break block6;
                            }
                        }
                        if (!bl3 || !(bl2 = valBoolean3.value())) break;
                        xs = xs2;
                    }
                    Val val = this.all(xs2);
                    scala.Serializable serializable2 = val instanceof ValBoolean && false == (bl = (valBoolean2 = (ValBoolean)val).value()) ? new ValBoolean(false) : ValNull$.MODULE$;
                    serializable = serializable2;
                }
                valBoolean = serializable;
                break block4;
            }
            throw new MatchError(list);
        }
        return valBoolean;
    }

    public ValFunction orFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$38 -> {
            Val val;
            Val val2;
            List list = x$38;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.atLeastOne(list2);
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    private Val atLeastOne(List<Val> xs) {
        ValBoolean valBoolean;
        block4: {
            List<Val> list;
            block5: {
                scala.Serializable serializable;
                block6: {
                    ValBoolean valBoolean2;
                    boolean bl;
                    List<Val> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            valBoolean = new ValBoolean(false);
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Val x = (Val)$colon$colon.head();
                        xs2 = $colon$colon.tl$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean3 = null;
                        Val val = x;
                        if (val instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean3 = (ValBoolean)val;
                            boolean bl4 = valBoolean3.value();
                            if (bl4) {
                                serializable = new ValBoolean(true);
                                break block6;
                            }
                        }
                        if (!bl3 || (bl2 = valBoolean3.value())) break;
                        xs = xs2;
                    }
                    Val val = this.atLeastOne(xs2);
                    scala.Serializable serializable2 = val instanceof ValBoolean && true == (bl = (valBoolean2 = (ValBoolean)val).value()) ? new ValBoolean(true) : ValNull$.MODULE$;
                    serializable = serializable2;
                }
                valBoolean = serializable;
                break block4;
            }
            throw new MatchError(list);
        }
        return valBoolean;
    }

    public ValFunction sublistFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "start"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$39 -> {
            List list = x$39;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            return new ValList((List<Val>)list2.slice(MODULE$.listIndex(list2, start.intValue()), list2.length()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction sublistFunction3() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "start", "length"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$40 -> {
            List list = x$40;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val3;
            BigDecimal length = valNumber2.value();
            return new ValList((List<Val>)list2.slice(MODULE$.listIndex(list2, start.intValue()), MODULE$.listIndex(list2, start.intValue()) + length.intValue()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    private int listIndex(List<?> list, int index) {
        return index > 0 ? index - 1 : list.size() + index;
    }

    public ValFunction appendFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "items"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$41 -> {
            List list = x$41;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValList)) return MODULE$.error(list);
            ValList valList2 = (ValList)val2;
            List<Val> items = valList2.items();
            return new ValList(list2.$plus$plus(items, List$.MODULE$.canBuildFrom()));
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction concatenateFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lists"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$42 -> {
            Val val;
            Val val2;
            List list = x$42;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> lists = valList.items();
                val = new ValList(lists.flatMap((Function1<Val, List> & Serializable & scala.Serializable)x$43 -> {
                    GenTraversable<Val> genTraversable;
                    Val val = x$43;
                    if (val instanceof ValList) {
                        List<Val> list;
                        ValList valList = (ValList)val;
                        genTraversable = list = valList.items();
                    } else {
                        genTraversable = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Val[]{val}));
                    }
                    return genTraversable;
                }, List$.MODULE$.canBuildFrom()).toList());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction insertBeforeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "position", "newItem"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$44 -> {
            Val val;
            List list = x$44;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) return MODULE$.error(list);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            Val newItem = (Val)((LinearSeqOptimized)some.get()).apply(2);
            if (!(val2 instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val2;
            List<Val> list2 = valList.items();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val3;
            BigDecimal position = valNumber.value();
            if (newItem == null) return MODULE$.error(list);
            Val val4 = val = newItem;
            return new ValList(((List)list2.take(MODULE$.listIndex(list2, position.intValue()))).$plus$plus(Nil$.MODULE$.$colon$colon(val4), List$.MODULE$.canBuildFrom()).$plus$plus(list2.drop(MODULE$.listIndex(list2, position.intValue())), List$.MODULE$.canBuildFrom()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction removeFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "position"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$46 -> {
            List list = x$46;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal position = valNumber.value();
            return new ValList(((List)list2.take(MODULE$.listIndex(list2, position.intValue()))).$plus$plus(list2.drop(MODULE$.listIndex(list2, position.intValue() + 1)), List$.MODULE$.canBuildFrom()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction reverseFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$47 -> {
            Val val;
            Val val2;
            List list = x$47;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList((List<Val>)list2.reverse());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction indexOfFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "match"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$48 -> {
            List list = x$48;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val m = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (m == null) return MODULE$.error(list);
            Val val2 = m;
            return new ValList(MODULE$.indexOfList(list2, val2, MODULE$.indexOfList$default$3(), MODULE$.indexOfList$default$4()).map((Function1<Object, ValNumber> & Serializable & scala.Serializable)x$49 -> BuiltinFunctions$.$anonfun$indexOfFunction$2(BoxesRunTime.unboxToInt(x$49)), List$.MODULE$.canBuildFrom()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    private List<Object> indexOfList(List<Val> list, Val item, int from, List<Object> indexList) {
        int index;
        while ((index = list.indexOf(item, from)) > 0) {
            indexList = indexList.$plus$plus(List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{index + 1})), List$.MODULE$.canBuildFrom());
            from = index + 1;
        }
        return indexList;
    }

    private int indexOfList$default$3() {
        return 0;
    }

    private List<Object> indexOfList$default$4() {
        return Nil$.MODULE$;
    }

    public ValFunction unionFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lists"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$50 -> {
            Val val;
            Val val2;
            List list = x$50;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> lists = valList.items();
                val = new ValList((List)lists.flatMap((Function1<Val, List> & Serializable & scala.Serializable)x$51 -> {
                    GenTraversable<Val> genTraversable;
                    Val val = x$51;
                    if (val instanceof ValList) {
                        List<Val> list;
                        ValList valList = (ValList)val;
                        genTraversable = list = valList.items();
                    } else {
                        genTraversable = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Val[]{val}));
                    }
                    return genTraversable;
                }, List$.MODULE$.canBuildFrom()).toList().distinct());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true, ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction distinctValuesFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$52 -> {
            Val val;
            Val val2;
            List list = x$52;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList((List)list2.distinct());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction flattenFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$53 -> {
            Val val;
            Val val2;
            List list = x$53;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList(MODULE$.flatten(list2));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private List<Val> flatten(List<Val> list) {
        void var2_8;
        boolean bl = false;
        $colon$colon $colon$colon = null;
        List<Val> list2 = list;
        if (((Object)Nil$.MODULE$).equals(list2)) {
            Nil$ nil$ = Nil$.MODULE$;
            return var2_8;
        }
        if (list2 instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)list2;
            Val val = (Val)$colon$colon.head();
            List<Val> xs = $colon$colon.tl$access$1();
            if (val instanceof ValList) {
                ValList valList = (ValList)val;
                List<Val> l = valList.items();
                List list3 = this.flatten(l).$plus$plus(this.flatten(xs), List$.MODULE$.canBuildFrom());
                return var2_8;
            }
        }
        if (!bl) throw new MatchError(list2);
        Val x = (Val)$colon$colon.head();
        List<Val> xs = $colon$colon.tl$access$1();
        Val val = x;
        List<Val> list4 = this.flatten(xs).$colon$colon(val);
        return var2_8;
    }

    public ValFunction sortFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list", "precedes"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$55 -> {
            Some<List> some;
            List list = x$55;
            Some<List> some2 = List$.MODULE$.unapplySeq(list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(2) == 0) {
                Val val = (Val)((LinearSeqOptimized)some2.get()).apply(0);
                Val val2 = (Val)((LinearSeqOptimized)some2.get()).apply(1);
                if (val instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list2 = valList.items();
                    if (val2 instanceof ValFunction) {
                        ValFunction valFunction = (ValFunction)val2;
                        List<String> params = valFunction.params();
                        Function1<List<Val>, Val> f = valFunction.invoke();
                        if (params.size() == 2) {
                            scala.Serializable serializable;
                            try {
                                serializable = new ValList((List)list2.sortWith((Function2<Val, Val, Object> & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$sortFunction$2(f, x0$1, x1$1))));
                                return serializable;
                            }
                            catch (Throwable e) {
                                serializable = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to sort list by given precedes function: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{e})));
                            }
                            return serializable;
                        }
                    }
                }
            }
            if ((some = List$.MODULE$.unapplySeq(list)).isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val3 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            if (!(val3 instanceof ValFunction)) return MODULE$.error(list);
            ValFunction valFunction = (ValFunction)val3;
            List<String> params = valFunction.params();
            return new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect boolean function with 2 arguments, but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(params.size())})));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction decimalFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "scale"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$56 -> {
            List list = x$56;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (some.isEmpty()) return MODULE$.error(list);
            if (some.get() == null) return MODULE$.error(list);
            if (((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) return MODULE$.error(list);
            Val val = (Val)((LinearSeqOptimized)some.get()).apply(0);
            Val val2 = (Val)((LinearSeqOptimized)some.get()).apply(1);
            if (!(val instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal n = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal scale = valNumber2.value();
            return new ValNumber(n.setScale(scale.intValue(), BigDecimal$RoundingMode$.MODULE$.HALF_EVEN()));
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction floorFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$57 -> {
            Val val;
            Val val2;
            List list = x$57;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    public ValFunction ceilingFunction() {
        return new ValFunction((List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})), (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)x$58 -> {
            Val val;
            Val val2;
            List list = x$58;
            Some<List> some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (val2 = (Val)((LinearSeqOptimized)some.get()).apply(0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.setScale(0, BigDecimal$RoundingMode$.MODULE$.CEILING()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
    }

    private Val withListOfNumbers(List<Val> list, Function1<List<BigDecimal>, Val> f) {
        Val val;
        Option option = ((LinearSeqOptimized)list.map((Function1<Val, Product> & Serializable & scala.Serializable)x$59 -> {
            ValNumber valNumber;
            Val val = x$59;
            scala.Serializable serializable = val instanceof ValNumber ? (valNumber = (ValNumber)val) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected number but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val})));
            return serializable;
        }, List$.MODULE$.canBuildFrom())).find((Function1<Product, Object> & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$withListOfNumbers$2(x$60)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Product e = (Product)some.value();
            val = (Val)((Object)e);
        } else if (None$.MODULE$.equals(option)) {
            val = f.apply(list.map((Function1<ValNumber, BigDecimal> & Serializable & scala.Serializable)x$61 -> x$61.value(), List$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError(option);
        }
        return val;
    }

    public static final /* synthetic */ boolean $anonfun$error$1(Val x$1) {
        return x$1 instanceof ValError;
    }

    public static final /* synthetic */ boolean $anonfun$error$2(Val x$2) {
        return x$2 instanceof ValError;
    }

    public static final /* synthetic */ ValNumber $anonfun$indexOfFunction$2(int x$49) {
        return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(x$49));
    }

    public static final /* synthetic */ boolean $anonfun$sortFunction$2(Function1 f$1, Val x0$1, Val x1$1) {
        Tuple2<Val, Val> tuple2 = new Tuple2<Val, Val>(x0$1, x1$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Val x = tuple2._1();
        Val y = tuple2._2();
        boolean bl = ((ValBoolean)f$1.apply(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Val[]{x, y})))).value();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$withListOfNumbers$2(Product x$60) {
        return x$60 instanceof ValError;
    }

    private BuiltinFunctions$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger("org.camunda.feel.functions");
        this.functions = this.conversionFunctions().$plus$plus(this.booleanFunctions()).$plus$plus(this.stringFunctions()).$plus$plus(this.listFunctions()).$plus$plus(this.numericFunctions());
    }
}

