/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.interpreter;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.camunda.feel.interpreter.Compareable;
import org.camunda.feel.interpreter.Compareable$;
import org.camunda.feel.interpreter.CompositeContext$;
import org.camunda.feel.interpreter.Context;
import org.camunda.feel.interpreter.DefaultContext;
import org.camunda.feel.interpreter.DefaultContext$;
import org.camunda.feel.interpreter.JavaClassMapper$;
import org.camunda.feel.interpreter.RootContext$;
import org.camunda.feel.interpreter.Val;
import org.camunda.feel.interpreter.ValBoolean;
import org.camunda.feel.interpreter.ValBoolean$;
import org.camunda.feel.interpreter.ValContext;
import org.camunda.feel.interpreter.ValDate;
import org.camunda.feel.interpreter.ValDateTime;
import org.camunda.feel.interpreter.ValDayTimeDuration;
import org.camunda.feel.interpreter.ValError;
import org.camunda.feel.interpreter.ValFunction;
import org.camunda.feel.interpreter.ValFunction$;
import org.camunda.feel.interpreter.ValList;
import org.camunda.feel.interpreter.ValLocalDateTime;
import org.camunda.feel.interpreter.ValLocalTime;
import org.camunda.feel.interpreter.ValNull$;
import org.camunda.feel.interpreter.ValNumber;
import org.camunda.feel.interpreter.ValNumber$;
import org.camunda.feel.interpreter.ValString;
import org.camunda.feel.interpreter.ValTime;
import org.camunda.feel.interpreter.ValYearMonthDuration;
import org.camunda.feel.interpreter.ValueMapper;
import org.camunda.feel.parser.Addition;
import org.camunda.feel.parser.ArithmeticNegation;
import org.camunda.feel.parser.AtLeastOne;
import org.camunda.feel.parser.ClosedIntervalBoundary;
import org.camunda.feel.parser.Conjunction;
import org.camunda.feel.parser.ConstBool;
import org.camunda.feel.parser.ConstContext;
import org.camunda.feel.parser.ConstDate;
import org.camunda.feel.parser.ConstDateTime;
import org.camunda.feel.parser.ConstDayTimeDuration;
import org.camunda.feel.parser.ConstList;
import org.camunda.feel.parser.ConstLocalDateTime;
import org.camunda.feel.parser.ConstLocalTime;
import org.camunda.feel.parser.ConstNull$;
import org.camunda.feel.parser.ConstNumber;
import org.camunda.feel.parser.ConstString;
import org.camunda.feel.parser.ConstTime;
import org.camunda.feel.parser.ConstYearMonthDuration;
import org.camunda.feel.parser.Disjunction;
import org.camunda.feel.parser.Division;
import org.camunda.feel.parser.Equal;
import org.camunda.feel.parser.EveryItem;
import org.camunda.feel.parser.Exp;
import org.camunda.feel.parser.Exponentiation;
import org.camunda.feel.parser.Filter;
import org.camunda.feel.parser.For;
import org.camunda.feel.parser.FunctionDefinition;
import org.camunda.feel.parser.FunctionInvocation;
import org.camunda.feel.parser.FunctionParameters;
import org.camunda.feel.parser.GreaterOrEqual;
import org.camunda.feel.parser.GreaterThan;
import org.camunda.feel.parser.If;
import org.camunda.feel.parser.In;
import org.camunda.feel.parser.InputEqualTo;
import org.camunda.feel.parser.InputGreaterOrEqual;
import org.camunda.feel.parser.InputGreaterThan;
import org.camunda.feel.parser.InputLessOrEqual;
import org.camunda.feel.parser.InputLessThan;
import org.camunda.feel.parser.InstanceOf;
import org.camunda.feel.parser.Interval;
import org.camunda.feel.parser.IntervalBoundary;
import org.camunda.feel.parser.JavaFunctionInvocation;
import org.camunda.feel.parser.LessOrEqual;
import org.camunda.feel.parser.LessThan;
import org.camunda.feel.parser.Multiplication;
import org.camunda.feel.parser.NamedFunctionParameters;
import org.camunda.feel.parser.Not;
import org.camunda.feel.parser.OpenIntervalBoundary;
import org.camunda.feel.parser.PathExpression;
import org.camunda.feel.parser.PositionalFunctionParameters;
import org.camunda.feel.parser.QualifiedFunctionInvocation;
import org.camunda.feel.parser.Ref;
import org.camunda.feel.parser.SomeItem;
import org.camunda.feel.parser.Subtraction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011Ef\u0001B\u0001\u0003\u0001-\u0011qBR3fY&sG/\u001a:qe\u0016$XM\u001d\u0006\u0003\u0007\u0011\t1\"\u001b8uKJ\u0004(/\u001a;fe*\u0011QAB\u0001\u0005M\u0016,GN\u0003\u0002\b\u0011\u000591-Y7v]\u0012\f'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012A\u00027pO\u001e,'/F\u0001\u001b!\tYb$D\u0001\u001d\u0015\ti\u0002\"A\u0003tY\u001a$$.\u0003\u0002 9\t1Aj\\4hKJDa!\t\u0001!\u0002\u0013Q\u0012a\u00027pO\u001e,'\u000f\t\u0005\u0006G\u0001!\t\u0001J\u0001\u0005KZ\fG\u000e\u0006\u0002&]Q\u0011a%\u000b\t\u0003-\u001dJ!\u0001\u000b\u0002\u0003\u0007Y\u000bG\u000eC\u0003+E\u0001\u000f1&A\u0004d_:$X\r\u001f;\u0011\u0005Ya\u0013BA\u0017\u0003\u0005\u001d\u0019uN\u001c;fqRDQa\f\u0012A\u0002A\n!\"\u001a=qe\u0016\u001c8/[8o!\t\tD'D\u00013\u0015\t\u0019D!\u0001\u0004qCJ\u001cXM]\u0005\u0003kI\u00121!\u0012=q\u0011\u00159\u0004\u0001\"\u00039\u0003\u0015)'O]8s)\rIDH\u0010\t\u0003-iJ!a\u000f\u0002\u0003\u0011Y\u000bG.\u0012:s_JDQ!\u0010\u001cA\u0002\u0019\n\u0011\u0001\u001f\u0005\u0006\u007fY\u0002\r\u0001Q\u0001\b[\u0016\u001c8/Y4f!\t\t\u0005J\u0004\u0002C\rB\u00111ID\u0007\u0002\t*\u0011QIC\u0001\u0007yI|w\u000e\u001e \n\u0005\u001ds\u0011A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!a\u0012\b\t\u000b1\u0003A\u0011B'\u0002\u001b]LG\u000f\u001b,bY>\u0013h*\u001e7m)\t1c\nC\u0003>\u0017\u0002\u0007a\u0005C\u0003Q\u0001\u0011%\u0011+\u0001\u0006v]\u0006\u0014\u0018p\u00149B]f$BA\u0015+VAR\u0011ae\u0015\u0005\u0006U=\u0003\u001da\u000b\u0005\u0006{=\u0003\rA\n\u0005\u0006->\u0003\raV\u0001\u0002GB)Q\u0002\u0017.[;&\u0011\u0011L\u0004\u0002\n\rVt7\r^5p]J\u0002\"!D.\n\u0005qs!aA!osB\u0011QBX\u0005\u0003?:\u0011qAQ8pY\u0016\fg\u000eC\u0003b\u001f\u0002\u0007!-A\u0001g!\u0011i1-\u0018\u0014\n\u0005\u0011t!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u00151\u0007\u0001\"\u0003h\u0003\u001d)h.\u0019:z\u001fB$B\u0001\u001b6l}R\u0011a%\u001b\u0005\u0006U\u0015\u0004\u001da\u000b\u0005\u0006{\u0015\u0004\rA\n\u0005\u0006-\u0016\u0004\r\u0001\u001c\t\u0006\u001bak\u00170\u0018\u0019\u0003]N\u00042AF8r\u0013\t\u0001(AA\u0006D_6\u0004\u0018M]3bE2,\u0007C\u0001:t\u0019\u0001!\u0011\u0002^6\u0002\u0002\u0003\u0005)\u0011A;\u0003\u0007}#\u0013'\u0005\u0002w5B\u0011Qb^\u0005\u0003q:\u0011qAT8uQ&tw\r\r\u0002{yB\u0019ac\\>\u0011\u0005IdH!C?l\u0003\u0003\u0005\tQ!\u0001v\u0005\ryFE\r\u0005\u0006C\u0016\u0004\rA\u0019\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003-)h.\u0019:z\u001fB$U/\u00197\u0015\u0015\u0005\u0015\u0011\u0011BA\u0006\u0003\u001f\t)\u0004F\u0002'\u0003\u000fAQAK@A\u0004-BQ!P@A\u0002\u0019Ba!!\u0004\u0000\u0001\u00041\u0013!A=\t\rY{\b\u0019AA\t!)i\u00111CA\f\u0003C\tY#X\u0005\u0004\u0003+q!!\u0003$v]\u000e$\u0018n\u001c84a\u0011\tI\"!\b\u0011\tYy\u00171\u0004\t\u0004e\u0006uAaCA\u0010\u0003\u001f\t\t\u0011!A\u0003\u0002U\u00141a\u0018\u00134a\u0011\t\u0019#a\n\u0011\tYy\u0017Q\u0005\t\u0004e\u0006\u001dBaCA\u0015\u0003\u001f\t\t\u0011!A\u0003\u0002U\u00141a\u0018\u00135a\u0011\ti#!\r\u0011\tYy\u0017q\u0006\t\u0004e\u0006EBaCA\u001a\u0003\u001f\t\t\u0011!A\u0003\u0002U\u00141a\u0018\u00136\u0011\u0015\tw\u00101\u0001c\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\t1b^5uQ:+XNY3sgR9a%!\u0010\u0002@\u0005\u0005\u0003BB\u001f\u00028\u0001\u0007a\u0005C\u0004\u0002\u000e\u0005]\u0002\u0019\u0001\u0014\t\u000f\u0005\f9\u00041\u0001\u0002DA9Q\u0002WA#\u0003\u000b2\u0003\u0003BA$\u00033rA!!\u0013\u0002V9!\u00111JA*\u001d\u0011\ti%!\u0015\u000f\u0007\r\u000by%C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0019\u0011q\u000b\u0003\u0002\u000fA\f7m[1hK&!\u00111LA/\u0005\u0019qU/\u001c2fe*\u0019\u0011q\u000b\u0003\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d\u0005Qq/\u001b;i\u001dVl'-\u001a:\u0015\u000b\u0019\n)'a\u001a\t\ru\ny\u00061\u0001'\u0011\u001d\t\u0017q\fa\u0001\u0003S\u0002R!D2\u0002F\u0019Bq!!\u001c\u0001\t\u0013\ty'A\u0006xSRD'i\\8mK\u0006tG#\u0002\u0014\u0002r\u0005M\u0004BB\u001f\u0002l\u0001\u0007a\u0005\u0003\u0004b\u0003W\u0002\rA\u0019\u0005\b\u0003o\u0002A\u0011BA=\u0003E9\u0018\u000e\u001e5C_>dW-\u00198Pe:+H\u000e\u001c\u000b\u0006M\u0005m\u0014Q\u0010\u0005\u0007{\u0005U\u0004\u0019\u0001\u0014\t\r\u0005\f)\b1\u0001c\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b!c^5uQ\n{w\u000e\\3b]>\u0013h)\u00197tKR)a%!\"\u0002\b\"1Q(a A\u0002\u0019Ba!YA@\u0001\u0004\u0011\u0007bBAF\u0001\u0011%\u0011QR\u0001\u000bo&$\bn\u0015;sS:<G#\u0002\u0014\u0002\u0010\u0006E\u0005BB\u001f\u0002\n\u0002\u0007a\u0005C\u0004b\u0003\u0013\u0003\r!a%\u0011\t5\u0019\u0007I\n\u0005\b\u0003/\u0003A\u0011BAM\u0003%9\u0018\u000e\u001e5ECR,7\u000fF\u0004'\u00037\u000bi*a(\t\ru\n)\n1\u0001'\u0011\u001d\ti!!&A\u0002\u0019Bq!YAK\u0001\u0004\t\t\u000bE\u0004\u000e1\u0006\r\u00161\u0015\u0014\u0011\t\u0005\u001d\u0013QU\u0005\u0005\u0003O\u000biF\u0001\u0003ECR,\u0007bBAV\u0001\u0011%\u0011QV\u0001\to&$\b\u000eR1uKR)a%a,\u00022\"1Q(!+A\u0002\u0019Bq!YAU\u0001\u0004\t\u0019\fE\u0003\u000eG\u0006\rf\u0005C\u0004\u00028\u0002!I!!/\u0002\u0013]LG\u000f\u001b+j[\u0016\u001cHc\u0002\u0014\u0002<\u0006u\u0016q\u0018\u0005\u0007{\u0005U\u0006\u0019\u0001\u0014\t\u000f\u00055\u0011Q\u0017a\u0001M!9\u0011-!.A\u0002\u0005\u0005\u0007cB\u0007Y\u0003\u0007\f\u0019M\n\t\u0005\u0003\u000f\n)-\u0003\u0003\u0002H\u0006u#\u0001\u0002+j[\u0016Dq!a3\u0001\t\u0013\ti-\u0001\bxSRDGj\\2bYRKW.Z:\u0015\u000f\u0019\ny-!5\u0002T\"1Q(!3A\u0002\u0019Bq!!\u0004\u0002J\u0002\u0007a\u0005C\u0004b\u0003\u0013\u0004\r!!6\u0011\u000f5A\u0016q[AlMA!\u0011qIAm\u0013\u0011\tY.!\u0018\u0003\u00131{7-\u00197US6,\u0007bBAp\u0001\u0011%\u0011\u0011]\u0001\u000eo&$\b\u000eT8dC2$\u0016.\\3\u0015\u000b\u0019\n\u0019/!:\t\ru\ni\u000e1\u0001'\u0011\u001d\t\u0017Q\u001ca\u0001\u0003O\u0004R!D2\u0002X\u001aBq!a;\u0001\t\u0013\ti/\u0001\u0005xSRDG+[7f)\u00151\u0013q^Ay\u0011\u0019i\u0014\u0011\u001ea\u0001M!9\u0011-!;A\u0002\u0005M\b#B\u0007d\u0003\u00074\u0003bBA|\u0001\u0011%\u0011\u0011`\u0001\u000eo&$\b\u000eR1uKRKW.Z:\u0015\u000f\u0019\nY0!@\u0002\u0000\"1Q(!>A\u0002\u0019Bq!!\u0004\u0002v\u0002\u0007a\u0005C\u0004b\u0003k\u0004\rA!\u0001\u0011\u000f5A&1\u0001B\u0002MA!\u0011q\tB\u0003\u0013\u0011\u00119!!\u0018\u0003\u0011\u0011\u000bG/\u001a+j[\u0016DqAa\u0003\u0001\t\u0013\u0011i!\u0001\nxSRDGj\\2bY\u0012\u000bG/\u001a+j[\u0016\u001cHc\u0002\u0014\u0003\u0010\tE!1\u0003\u0005\u0007{\t%\u0001\u0019\u0001\u0014\t\u000f\u00055!\u0011\u0002a\u0001M!9\u0011M!\u0003A\u0002\tU\u0001cB\u0007Y\u0005/\u00119B\n\t\u0005\u0003\u000f\u0012I\"\u0003\u0003\u0003\u001c\u0005u#!\u0004'pG\u0006dG)\u0019;f)&lW\rC\u0004\u0003 \u0001!IA!\t\u0002\u0019]LG\u000f\u001b#bi\u0016$\u0016.\\3\u0015\u000b\u0019\u0012\u0019C!\n\t\ru\u0012i\u00021\u0001'\u0011\u001d\t'Q\u0004a\u0001\u0005O\u0001R!D2\u0003\u0004\u0019BqAa\u000b\u0001\t\u0013\u0011i#A\txSRDGj\\2bY\u0012\u000bG/\u001a+j[\u0016$RA\nB\u0018\u0005cAa!\u0010B\u0015\u0001\u00041\u0003bB1\u0003*\u0001\u0007!1\u0007\t\u0006\u001b\r\u00149B\n\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0003Y9\u0018\u000e\u001e5ZK\u0006\u0014Xj\u001c8uQ\u0012+(/\u0019;j_:\u001cHc\u0002\u0014\u0003<\tu\"q\b\u0005\u0007{\tU\u0002\u0019\u0001\u0014\t\u000f\u00055!Q\u0007a\u0001M!9\u0011M!\u000eA\u0002\t\u0005\u0003cB\u0007Y\u0005\u0007\u0012\u0019E\n\t\u0005\u0003\u000f\u0012)%\u0003\u0003\u0003H\u0005u#!E-fCJluN\u001c;i\tV\u0014\u0018\r^5p]\"9!1\n\u0001\u0005\n\t5\u0013\u0001F<ji\"$\u0015-\u001f+j[\u0016$UO]1uS>t7\u000fF\u0004'\u0005\u001f\u0012\tFa\u0015\t\ru\u0012I\u00051\u0001'\u0011\u001d\tiA!\u0013A\u0002\u0019Bq!\u0019B%\u0001\u0004\u0011)\u0006E\u0004\u000e1\n]#q\u000b\u0014\u0011\t\u0005\u001d#\u0011L\u0005\u0005\u00057\niFA\bECf$\u0016.\\3EkJ\fG/[8o\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005C\nQc^5uQf+\u0017M]'p]RDG)\u001e:bi&|g\u000eF\u0003'\u0005G\u0012)\u0007\u0003\u0004>\u0005;\u0002\rA\n\u0005\bC\nu\u0003\u0019\u0001B4!\u0015i1Ma\u0011'\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005[\n1c^5uQ\u0012\u000b\u0017\u0010V5nK\u0012+(/\u0019;j_:$RA\nB8\u0005cBa!\u0010B5\u0001\u00041\u0003bB1\u0003j\u0001\u0007!1\u000f\t\u0006\u001b\r\u00149F\n\u0005\b\u0005o\u0002A\u0011\u0002B=\u0003\u001d9\u0018\u000e\u001e5WC2$RA\nB>\u0005{Ba!\u0010B;\u0001\u00041\u0003bB1\u0003v\u0001\u0007!q\u0010\t\u0005\u001b\r4c\u0005C\u0004\u0003\u0004\u0002!IA!\"\u0002\u0019%\u001c\u0018J\\%oi\u0016\u0014h/\u00197\u0015\t\t\u001d%q\u0015\t\u000b\u001b\u0005M!\u0011\u0012BJ\u0005;k\u0006\u0007\u0002BF\u0005\u001f\u0003BAF8\u0003\u000eB\u0019!Oa$\u0005\u0017\tE%\u0011QA\u0001\u0002\u0003\u0015\t!\u001e\u0002\u0004?\u00122\u0004\u0007\u0002BK\u00053\u0003BAF8\u0003\u0018B\u0019!O!'\u0005\u0017\tm%\u0011QA\u0001\u0002\u0003\u0015\t!\u001e\u0002\u0004?\u0012:\u0004\u0007\u0002BP\u0005G\u0003BAF8\u0003\"B\u0019!Oa)\u0005\u0017\t\u0015&\u0011QA\u0001\u0002\u0003\u0015\t!\u001e\u0002\u0004?\u0012B\u0004\u0002\u0003BU\u0005\u0003\u0003\rAa+\u0002\u0011%tG/\u001a:wC2\u00042!\rBW\u0013\r\u0011yK\r\u0002\t\u0013:$XM\u001d<bY\"9!1\u0017\u0001\u0005\n\tU\u0016AC1u\u0019\u0016\f7\u000f^(oKR1!q\u0017B^\u0005\u001f$2A\nB]\u0011\u0019Q#\u0011\u0017a\u0002W!A!Q\u0018BY\u0001\u0004\u0011y,\u0001\u0002ygB)!\u0011\u0019Bea9!!1\u0019Bd\u001d\r\u0019%QY\u0005\u0002\u001f%\u0019\u0011q\u000b\b\n\t\t-'Q\u001a\u0002\u0005\u0019&\u001cHOC\u0002\u0002X9Aa!\u0019BY\u0001\u0004\u0011\u0007b\u0002BZ\u0001\u0011%!1\u001b\u000b\u0006M\tU'q\u001c\u0005\t\u0005{\u0013\t\u000e1\u0001\u0003XB1!\u0011\u0019Be\u00053\u0004B!\u0004BnM%\u0019!Q\u001c\b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004BB1\u0003R\u0002\u0007!\rC\u0004\u0003d\u0002!IA!:\u0002\u0007\u0005dG\u000e\u0006\u0004\u0003h\n-(Q\u001e\u000b\u0004M\t%\bB\u0002\u0016\u0003b\u0002\u000f1\u0006\u0003\u0005\u0003>\n\u0005\b\u0019\u0001B`\u0011\u0019\t'\u0011\u001da\u0001E\"9!1\u001d\u0001\u0005\n\tEH#\u0002\u0014\u0003t\nU\b\u0002\u0003B_\u0005_\u0004\rAa6\t\r\u0005\u0014y\u000f1\u0001c\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005w\f\u0001\"\u001b8qkR\\U-\u001f\u000b\u0004\u0001\nu\bB\u0002\u0016\u0003x\u0002\u000f1\u0006C\u0004\u0004\u0002\u0001!Iaa\u0001\u0002\u000b%t\u0007/\u001e;\u0015\u0007\u0019\u001a)\u0001\u0003\u0004+\u0005\u007f\u0004\u001da\u000b\u0005\b\u0007\u0013\u0001A\u0011BB\u0006\u00035!W/\u00197Ok6,'/[2PaRQ1QBB\t\u0007'\u0019)ba\u0007\u0015\u0007\u0019\u001ay\u0001\u0003\u0004+\u0007\u000f\u0001\u001da\u000b\u0005\u0007{\r\u001d\u0001\u0019\u0001\u0014\t\u000f\u000551q\u0001a\u0001M!A1qCB\u0004\u0001\u0004\u0019I\"\u0001\u0002paBAQ\u0002WA#\u0003\u000b\n)\u0005C\u0004b\u0007\u000f\u0001\r!!\u001b\t\u000f\r}\u0001\u0001\"\u0003\u0004\"\u0005IA-^1m\u001fB\fe.\u001f\u000b\u000b\u0007G\u00199c!\u000b\u0004,\r5Bc\u0001\u0014\u0004&!1!f!\bA\u0004-Ba!PB\u000f\u0001\u00041\u0003bBA\u0007\u0007;\u0001\rA\n\u0005\u0007-\u000eu\u0001\u0019A,\t\r\u0005\u001ci\u00021\u0001c\u0011\u001d\u0019\t\u0004\u0001C\u0005\u0007g\ta\u0001Z;bY>\u0003HCCB\u001b\u0007s\u0019Yd!\u0010\u0004VQ\u0019aea\u000e\t\r)\u001ay\u0003q\u0001,\u0011\u0019i4q\u0006a\u0001M!9\u0011QBB\u0018\u0001\u00041\u0003b\u0002,\u00040\u0001\u00071q\b\t\b\u001ba\u001b\tea\u0013^a\u0011\u0019\u0019ea\u0012\u0011\tYy7Q\t\t\u0004e\u000e\u001dCaCB%\u0007{\t\t\u0011!A\u0003\u0002U\u00141a\u0018\u0013:a\u0011\u0019ie!\u0015\u0011\tYy7q\n\t\u0004e\u000eECaCB*\u0007{\t\t\u0011!A\u0003\u0002U\u0014Aa\u0018\u00132a!1\u0011ma\fA\u0002\tDqa!\u0017\u0001\t\u0013\u0019Y&A\u0003bI\u0012|\u0005\u000fF\u0003'\u0007;\u001ay\u0006\u0003\u0004>\u0007/\u0002\rA\n\u0005\b\u0003\u001b\u00199\u00061\u0001'\u0011\u001d\u0019\u0019\u0007\u0001C\u0005\u0007K\nQa];c\u001fB$RAJB4\u0007SBa!PB1\u0001\u00041\u0003bBA\u0007\u0007C\u0002\rA\n\u0005\b\u0007[\u0002A\u0011BB8\u0003\u0015iW\u000f\\(q)\u001513\u0011OB:\u0011\u0019i41\u000ea\u0001M!9\u0011QBB6\u0001\u00041\u0003bBB<\u0001\u0011%1\u0011P\u0001\u0006I&4x\n\u001d\u000b\u0006M\rm4Q\u0010\u0005\u0007{\rU\u0004\u0019\u0001\u0014\t\u000f\u000551Q\u000fa\u0001M!91\u0011\u0011\u0001\u0005\n\r\r\u0015\u0001D<ji\"4UO\\2uS>tG#\u0002\u0014\u0004\u0006\u000e\u001d\u0005BB\u001f\u0004\u0000\u0001\u0007a\u0005C\u0004b\u0007\u007f\u0002\ra!#\u0011\u000b5\u001971\u0012\u0014\u0011\u0007Y\u0019i)C\u0002\u0004\u0010\n\u00111BV1m\rVt7\r^5p]\"911\u0013\u0001\u0005\n\rU\u0015AD5om>\\WMR;oGRLwN\u001c\u000b\u0007\u0007/\u001bYja(\u0015\u0007\u0019\u001aI\n\u0003\u0004+\u0007#\u0003\u001da\u000b\u0005\t\u0007;\u001b\t\n1\u0001\u0004\f\u0006Aa-\u001e8di&|g\u000e\u0003\u0005\u0004\"\u000eE\u0005\u0019ABR\u0003\u0019\u0001\u0018M]1ngB\u0019\u0011g!*\n\u0007\r\u001d&G\u0001\nGk:\u001cG/[8o!\u0006\u0014\u0018-\\3uKJ\u001c\bbBBV\u0001\u0011%1QV\u0001\rM&tGMR;oGRLwN\u001c\u000b\bM\r=61WB\\\u0011\u001d\u0019\tl!+A\u0002-\n1a\u0019;y\u0011\u001d\u0019)l!+A\u0002\u0001\u000bAA\\1nK\"A1\u0011UBU\u0001\u0004\u0019\u0019\u000bC\u0004\u0004<\u0002!Ia!0\u0002\u0017\u0005$GMR;oGRLwN\u001c\u000b\t\u0007\u007f\u001b9ma3\u0004NB1\u0011i!1A\u0007\u000bL1aa1K\u0005\ri\u0015\r\u001d\t\u0007\u0005\u0003\u0014Ima#\t\u0011\r%7\u0011\u0018a\u0001\u0007\u007f\u000b\u0011BZ;oGRLwN\\:\t\u000f\rU6\u0011\u0018a\u0001\u0001\"9\u0011m!/A\u0002\r-\u0005bBBi\u0001\u0011%11[\u0001\to&$\b\u000eV=qKR)ae!6\u0004X\"1Qha4A\u0002\u0019Bq!YBh\u0001\u0004\u0019I\u000eE\u0003\u000eG\u0002\u001bY\u000eE\u0002\u0017\u0007;L1aa8\u0003\u0005)1\u0016\r\u001c\"p_2,\u0017M\u001c\u0005\b\u0007G\u0004A\u0011BBs\u0003!9\u0018\u000e\u001e5MSN$H#\u0002\u0014\u0004h\u000e%\bBB\u001f\u0004b\u0002\u0007a\u0005C\u0004b\u0007C\u0004\raa;\u0011\u000b5\u00197Q\u001e\u0014\u0011\u0007Y\u0019y/C\u0002\u0004r\n\u0011qAV1m\u0019&\u001cH\u000fC\u0004\u0004v\u0002!Iaa>\u0002\u0013]LG\u000f\u001b'jgR\u001cHCBB}\u0007{$I\u0001F\u0002'\u0007wDaAKBz\u0001\bY\u0003\u0002CB\u0000\u0007g\u0004\r\u0001\"\u0001\u0002\u000b1L7\u000f^:\u0011\r\t\u0005'\u0011\u001aC\u0002!\u0015iAQ\u0001!'\u0013\r!9A\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u001c\u0019\u00101\u0001\u0005\fA)Qb\u0019C\u0007MA1!\u0011\u0019Be\t\u001f\u0001b!\u0004C\u0003\u0001\u000e5\bb\u0002C\n\u0001\u0011%AQC\u0001\u0015o&$\bnQ1si\u0016\u001c\u0018.\u00198Qe>$Wo\u0019;\u0015\r\u0011]A1\u0004C\u0012)\r1C\u0011\u0004\u0005\u0007U\u0011E\u00019A\u0016\t\u0011\u0011uA\u0011\u0003a\u0001\t?\t\u0011\"\u001b;fe\u0006$xN]:\u0011\r\t\u0005'\u0011\u001aC\u0011!\u0015iAQ\u0001!1\u0011\u001d\tG\u0011\u0003a\u0001\tK\u0001R!D2\u0005(\u0019\u0002bA!1\u0003J\u0012%\u0002#B!\u0004B\u00023\u0003b\u0002C\u0017\u0001\u0011%AqF\u0001\u0013M2\fG\u000f^3o\u0003:$',\u001b9MSN$8\u000f\u0006\u0003\u0005(\u0011E\u0002\u0002CB\u0000\tW\u0001\r\u0001\"\u0004\t\u000f\u0011U\u0002\u0001\"\u0003\u00058\u0005Qa-\u001b7uKJd\u0015n\u001d;\u0015\u000b\u0019\"I\u0004b\u0010\t\u0011\u0011mB1\u0007a\u0001\t{\tA\u0001\\5tiB)!\u0011\u0019BeM!AA\u0011\tC\u001a\u0001\u0004\u0011y(\u0001\u0004gS2$XM\u001d\u0005\b\t\u000b\u0002A\u0011\u0002C$\u0003-9\u0018\u000e\u001e5D_:$X\r\u001f;\u0015\u000b\u0019\"I\u0005b\u0013\t\ru\"\u0019\u00051\u0001'\u0011\u001d\tG1\ta\u0001\t\u001b\u0002R!D2\u0005P\u0019\u00022A\u0006C)\u0013\r!\u0019F\u0001\u0002\u000b-\u0006d7i\u001c8uKb$\bb\u0002C,\u0001\u0011%A\u0011L\u0001\u000eM&dG/\u001a:D_:$X\r\u001f;\u0015\t\u0011mCq\f\u000b\u0004W\u0011u\u0003B\u0002\u0016\u0005V\u0001\u000f1\u0006\u0003\u0004>\t+\u0002\rA\n\u0005\b\tG\u0002A\u0011\u0002C3\u0003\r\u0011XM\u001a\u000b\u0007\tO\"Y\u0007\"\u001c\u0015\u0007\u0019\"I\u0007\u0003\u0004+\tC\u0002\u001da\u000b\u0005\u0007{\u0011\u0005\u0004\u0019\u0001\u0014\t\u0011\u0011=D\u0011\ra\u0001\tc\nQA\\1nKN\u0004RA!1\u0003J\u0002Cq\u0001\"\u001e\u0001\t\u0013!9(\u0001\u0003qCRDG#\u0002\u0014\u0005z\u0011u\u0004b\u0002C>\tg\u0002\rAJ\u0001\u0002m\"9Aq\u0010C:\u0001\u0004\u0001\u0015aA6fs\"9A1\u0011\u0001\u0005\n\u0011\u0015\u0015\u0001E3wC2\u001cuN\u001c;fqR,e\u000e\u001e:z)\u0019!9\tb#\u0005\u000eR\u0019a\u0005\"#\t\r)\"\t\tq\u0001,\u0011\u001d!y\b\"!A\u0002\u0001Cq\u0001b$\u0005\u0002\u0002\u0007\u0001'A\u0002fqBDq\u0001b%\u0001\t\u0013!)*\u0001\nj]Z|7.\u001a&bm\u00064UO\\2uS>tGc\u0003\u0014\u0005\u0018\u0012mEq\u0014CR\tOCq\u0001\"'\u0005\u0012\u0002\u0007\u0001)A\u0005dY\u0006\u001c8OT1nK\"9AQ\u0014CI\u0001\u0004\u0001\u0015AC7fi\"|GMT1nK\"AA\u0011\u0015CI\u0001\u0004!\t(A\u0005be\u001e,X.\u001a8ug\"AAQ\u0015CI\u0001\u0004!i$A\u0006qCJ\fWNV1mk\u0016\u001c\b\u0002\u0003CU\t#\u0003\r\u0001b+\u0002\u0017Y\fG.^3NCB\u0004XM\u001d\t\u0004-\u00115\u0016b\u0001CX\u0005\tYa+\u00197vK6\u000b\u0007\u000f]3s\u0001")
public class FeelInterpreter {
    private final Logger logger = LoggerFactory.getLogger("org.camunda.feel.interpreter");

    public Logger logger() {
        return this.logger;
    }

    public Val eval(Exp expression, Context context) {
        Val val;
        Exp exp = expression;
        if (exp instanceof ConstNumber) {
            ConstNumber constNumber = (ConstNumber)exp;
            BigDecimal x2 = constNumber.value();
            val = new ValNumber(x2);
        } else if (exp instanceof ConstBool) {
            ConstBool constBool = (ConstBool)exp;
            boolean b = constBool.value();
            val = new ValBoolean(b);
        } else if (exp instanceof ConstString) {
            ConstString constString = (ConstString)exp;
            String s = constString.value();
            val = new ValString(s);
        } else if (exp instanceof ConstDate) {
            ConstDate constDate = (ConstDate)exp;
            LocalDate d = constDate.value();
            val = new ValDate(d);
        } else if (exp instanceof ConstLocalTime) {
            ConstLocalTime constLocalTime = (ConstLocalTime)exp;
            LocalTime t = constLocalTime.value();
            val = new ValLocalTime(t);
        } else if (exp instanceof ConstTime) {
            ConstTime constTime = (ConstTime)exp;
            OffsetTime t = constTime.value();
            val = new ValTime(t);
        } else if (exp instanceof ConstLocalDateTime) {
            ConstLocalDateTime constLocalDateTime = (ConstLocalDateTime)exp;
            LocalDateTime dt = constLocalDateTime.value();
            val = new ValLocalDateTime(dt);
        } else if (exp instanceof ConstDateTime) {
            ConstDateTime constDateTime = (ConstDateTime)exp;
            OffsetDateTime dt = constDateTime.value();
            val = new ValDateTime(dt);
        } else if (exp instanceof ConstYearMonthDuration) {
            ConstYearMonthDuration constYearMonthDuration = (ConstYearMonthDuration)exp;
            Period d = constYearMonthDuration.value();
            val = new ValYearMonthDuration(d);
        } else if (exp instanceof ConstDayTimeDuration) {
            ConstDayTimeDuration constDayTimeDuration = (ConstDayTimeDuration)exp;
            Duration d = constDayTimeDuration.value();
            val = new ValDayTimeDuration(d);
        } else if (ConstNull$.MODULE$.equals(exp)) {
            val = ValNull$.MODULE$;
        } else if (exp instanceof ConstList) {
            ConstList constList = (ConstList)exp;
            List<Exp> items = constList.items();
            val = new ValList(items.map((Function1<Exp, Val> & Serializable & scala.Serializable)item -> this.withVal(this.eval((Exp)item, context), (Function1<Val, Val> & Serializable & scala.Serializable)x -> x), List$.MODULE$.canBuildFrom()));
        } else if (exp instanceof ConstContext) {
            ConstContext constContext = (ConstContext)exp;
            List<Tuple2<String, Exp>> entries = constContext.entries();
            DefaultContext dc = entries.foldLeft(new DefaultContext(DefaultContext$.MODULE$.apply$default$1(), DefaultContext$.MODULE$.apply$default$2(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5()), (Function2<DefaultContext, Tuple2, DefaultContext> & Serializable & scala.Serializable)(ctx, entry) -> {
                DefaultContext defaultContext;
                Val val = this.evalContextEntry((String)entry._1(), (Exp)entry._2(), CompositeContext$.MODULE$.ContextComposition((Context)ctx).$plus(context));
                if (val instanceof ValFunction) {
                    ValFunction valFunction = (ValFunction)val;
                    defaultContext = new DefaultContext(ctx.variables(), this.addFunction(ctx.functions(), (String)entry._1(), valFunction), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5());
                } else if (val != null) {
                    Val val2 = val;
                    defaultContext = new DefaultContext(ctx.variables().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry._1()), val2)), ctx.functions(), DefaultContext$.MODULE$.apply$default$3(), DefaultContext$.MODULE$.apply$default$4(), DefaultContext$.MODULE$.apply$default$5());
                } else {
                    throw new MatchError(val);
                }
                return defaultContext;
            });
            val = new ValContext(dc);
        } else if (exp instanceof InputEqualTo) {
            InputEqualTo inputEqualTo = (InputEqualTo)exp;
            Exp x3 = inputEqualTo.x();
            val = this.unaryOpAny(this.eval(x3, context), (Function2<Object, Object, Object> & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$eval$4(x$1, x$2)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputLessThan) {
            InputLessThan inputLessThan = (InputLessThan)exp;
            Exp x4 = inputLessThan.x();
            val = this.unaryOp(this.eval(x4, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean(x$3.$less(x$4)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputLessOrEqual) {
            InputLessOrEqual inputLessOrEqual = (InputLessOrEqual)exp;
            Exp x5 = inputLessOrEqual.x();
            val = this.unaryOp(this.eval(x5, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean(x$5.$less$eq(x$6)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputGreaterThan) {
            InputGreaterThan inputGreaterThan = (InputGreaterThan)exp;
            Exp x6 = inputGreaterThan.x();
            val = this.unaryOp(this.eval(x6, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean(x$7.$greater(x$8)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof InputGreaterOrEqual) {
            InputGreaterOrEqual inputGreaterOrEqual = (InputGreaterOrEqual)exp;
            Exp x7 = inputGreaterOrEqual.x();
            val = this.unaryOp(this.eval(x7, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean(x$9.$greater$eq(x$10)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof Interval) {
            Interval interval = (Interval)exp;
            IntervalBoundary start = interval.start();
            IntervalBoundary end = interval.end();
            val = this.unaryOpDual(this.eval(start.value(), context), this.eval(end.value(), context), this.isInInterval(interval), ValBoolean$.MODULE$, context);
        } else if (exp instanceof Addition) {
            Addition addition = (Addition)exp;
            Exp x8 = addition.x();
            Exp y = addition.y();
            val = this.withValOrNull(this.addOp(this.eval(x8, context), this.eval(y, context)));
        } else if (exp instanceof Subtraction) {
            Subtraction subtraction = (Subtraction)exp;
            Exp x9 = subtraction.x();
            Exp y = subtraction.y();
            val = this.withValOrNull(this.subOp(this.eval(x9, context), this.eval(y, context)));
        } else if (exp instanceof Multiplication) {
            Multiplication multiplication = (Multiplication)exp;
            Exp x10 = multiplication.x();
            Exp y = multiplication.y();
            val = this.withValOrNull(this.mulOp(this.eval(x10, context), this.eval(y, context)));
        } else if (exp instanceof Division) {
            Division division = (Division)exp;
            Exp x11 = division.x();
            Exp y = division.y();
            val = this.withValOrNull(this.divOp(this.eval(x11, context), this.eval(y, context)));
        } else if (exp instanceof Exponentiation) {
            Exponentiation exponentiation = (Exponentiation)exp;
            Exp x12 = exponentiation.x();
            Exp y = exponentiation.y();
            val = this.withValOrNull(this.dualNumericOp(this.eval(x12, context), this.eval(y, context), (Function2<BigDecimal, BigDecimal, BigDecimal> & Serializable & scala.Serializable)(x$11, x$12) -> x$11.pow(x$12.toInt()), ValNumber$.MODULE$, context));
        } else if (exp instanceof ArithmeticNegation) {
            ArithmeticNegation arithmeticNegation = (ArithmeticNegation)exp;
            Exp x13 = arithmeticNegation.x();
            val = this.withValOrNull(this.withNumber(this.eval(x13, context), (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValNumber> & Serializable & scala.Serializable)x -> new ValNumber(x.unary_$minus())));
        } else if (exp instanceof Equal) {
            Equal equal = (Equal)exp;
            Exp x14 = equal.x();
            Exp y = equal.y();
            val = this.dualOpAny(this.eval(x14, context), this.eval(y, context), (Function2<Object, Object, Object> & Serializable & scala.Serializable)(x$13, x$14) -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$eval$11(x$13, x$14)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof LessThan) {
            LessThan lessThan = (LessThan)exp;
            Exp x15 = lessThan.x();
            Exp y = lessThan.y();
            val = this.dualOp(this.eval(x15, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$15, x$16) -> BoxesRunTime.boxToBoolean(x$15.$less(x$16)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof LessOrEqual) {
            LessOrEqual lessOrEqual = (LessOrEqual)exp;
            Exp x16 = lessOrEqual.x();
            Exp y = lessOrEqual.y();
            val = this.dualOp(this.eval(x16, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$17, x$18) -> BoxesRunTime.boxToBoolean(x$17.$less$eq(x$18)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)exp;
            Exp x17 = greaterThan.x();
            Exp y = greaterThan.y();
            val = this.dualOp(this.eval(x17, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$19, x$20) -> BoxesRunTime.boxToBoolean(x$19.$greater(x$20)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof GreaterOrEqual) {
            GreaterOrEqual greaterOrEqual = (GreaterOrEqual)exp;
            Exp x18 = greaterOrEqual.x();
            Exp y = greaterOrEqual.y();
            val = this.dualOp(this.eval(x18, context), this.eval(y, context), (Function2<Compareable, Compareable, Object> & Serializable & scala.Serializable)(x$21, x$22) -> BoxesRunTime.boxToBoolean(x$21.$greater$eq(x$22)), ValBoolean$.MODULE$, context);
        } else if (exp instanceof AtLeastOne) {
            AtLeastOne atLeastOne = (AtLeastOne)exp;
            List<Exp> xs = atLeastOne.xs();
            val = this.atLeastOne(xs, ValBoolean$.MODULE$, context);
        } else if (exp instanceof Not) {
            Not not = (Not)exp;
            Exp x19 = not.x();
            val = this.withBooleanOrNull(this.eval(x19, context), (Function1<Object, Val>)(Function1<Object, ValBoolean> & Serializable & scala.Serializable)x -> FeelInterpreter.$anonfun$eval$16(BoxesRunTime.unboxToBoolean(x)));
        } else if (exp instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)exp;
            Exp x20 = disjunction.x();
            Exp y = disjunction.y();
            Exp exp2 = x20;
            Exp exp3 = y;
            val = this.atLeastOne(Nil$.MODULE$.$colon$colon(exp3).$colon$colon(exp2), ValBoolean$.MODULE$, context);
        } else if (exp instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)exp;
            Exp x21 = conjunction.x();
            Exp y = conjunction.y();
            Exp exp4 = x21;
            Exp exp5 = y;
            val = this.all(Nil$.MODULE$.$colon$colon(exp5).$colon$colon(exp4), ValBoolean$.MODULE$, context);
        } else if (exp instanceof If) {
            If if_ = (If)exp;
            Exp condition = if_.condition();
            Exp statement = if_.statement();
            Exp elseStatement = if_.elseStatement();
            val = this.withBooleanOrFalse(this.eval(condition, context), (Function1<Object, Val> & Serializable & scala.Serializable)isMet -> FeelInterpreter.$anonfun$eval$17(this, context, statement, elseStatement, BoxesRunTime.unboxToBoolean(isMet)));
        } else if (exp instanceof In) {
            In in = (In)exp;
            Exp x22 = in.x();
            Exp test = in.test();
            val = this.withVal(this.eval(x22, context), (Function1<Val, Val> & Serializable & scala.Serializable)x -> this.eval(test, CompositeContext$.MODULE$.ContextComposition(context).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.inputKey(context)), x))));
        } else if (exp instanceof InstanceOf) {
            InstanceOf instanceOf = (InstanceOf)exp;
            Exp x23 = instanceOf.x();
            String typeName = instanceOf.typeName();
            val = this.withVal(this.eval(x23, context), (Function1<Val, Val> & Serializable & scala.Serializable)x -> this.withType((Val)x, (Function1<String, ValBoolean> & Serializable & scala.Serializable)t -> {
                String string = t;
                String string2 = typeName;
                return new ValBoolean(!(string != null ? !string.equals(string2) : string2 != null));
            }));
        } else if (exp instanceof Ref) {
            Ref ref = (Ref)exp;
            List<String> names = ref.names();
            val = this.ref(context.variable(names.head()), (List)names.tail(), context);
        } else if (exp instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)exp;
            Exp exp6 = pathExpression.path();
            String key = pathExpression.key();
            val = this.withVal(this.eval(exp6, context), (Function1<Val, Val> & Serializable & scala.Serializable)v -> this.path((Val)v, key));
        } else if (exp instanceof SomeItem) {
            SomeItem someItem = (SomeItem)exp;
            List<Tuple2<String, Exp>> iterators = someItem.iterators();
            Exp condition = someItem.condition();
            val = this.withCartesianProduct(iterators, (Function1<List<Map<String, Val>>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)p -> this.atLeastOne(p.map((Function1<Map, Function0> & Serializable & scala.Serializable)vars -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval(condition, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus((Map<String, Object>)vars)), List$.MODULE$.canBuildFrom()), ValBoolean$.MODULE$), context);
        } else if (exp instanceof EveryItem) {
            EveryItem everyItem = (EveryItem)exp;
            List<Tuple2<String, Exp>> iterators = everyItem.iterators();
            Exp condition = everyItem.condition();
            val = this.withCartesianProduct(iterators, (Function1<List<Map<String, Val>>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)p -> this.all(p.map((Function1<Map, Function0> & Serializable & scala.Serializable)vars -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval(condition, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus((Map<String, Object>)vars)), List$.MODULE$.canBuildFrom()), ValBoolean$.MODULE$), context);
        } else if (exp instanceof For) {
            For for_ = (For)exp;
            List<Tuple2<String, Exp>> iterators = for_.iterators();
            Exp exp7 = for_.exp();
            val = this.withCartesianProduct(iterators, (Function1<List<Map<String, Val>>, Val>)(Function1<List, ValList> & Serializable & scala.Serializable)p -> new ValList(p.map((Function1<Map, Val> & Serializable & scala.Serializable)vars -> this.eval(exp7, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus((Map<String, Object>)vars)), List$.MODULE$.canBuildFrom())), context);
        } else if (exp instanceof Filter) {
            Filter filter = (Filter)exp;
            Exp list = filter.list();
            Exp filter2 = filter.filter();
            val = this.withList(this.eval(list, context), (Function1<ValList, Val> & Serializable & scala.Serializable)l -> this.filterList(l.items(), (Function1<Val, Val> & Serializable & scala.Serializable)item -> this.eval(filter2, this.filterContext((Val)item, context))));
        } else if (exp instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)exp;
            String name = functionInvocation.function();
            FunctionParameters params = functionInvocation.params();
            val = this.withFunction(this.findFunction(context, name, params), (Function1<ValFunction, Val> & Serializable & scala.Serializable)f -> this.invokeFunction((ValFunction)f, params, context));
        } else if (exp instanceof QualifiedFunctionInvocation) {
            QualifiedFunctionInvocation qualifiedFunctionInvocation = (QualifiedFunctionInvocation)exp;
            Exp path = qualifiedFunctionInvocation.path();
            String name = qualifiedFunctionInvocation.function();
            FunctionParameters params = qualifiedFunctionInvocation.params();
            val = this.withContext(this.eval(path, context), (Function1<ValContext, Val> & Serializable & scala.Serializable)c -> this.withFunction(this.findFunction(c.context(), name, params), (Function1<ValFunction, Val> & Serializable & scala.Serializable)f -> this.invokeFunction((ValFunction)f, params, context)));
        } else if (exp instanceof FunctionDefinition) {
            FunctionDefinition functionDefinition = (FunctionDefinition)exp;
            List<String> params = functionDefinition.parameters();
            Exp body = functionDefinition.body();
            val = new ValFunction(params, (Function1<List<Val>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)paramValues -> {
                Val val;
                Exp exp = body;
                if (exp instanceof JavaFunctionInvocation) {
                    JavaFunctionInvocation javaFunctionInvocation = (JavaFunctionInvocation)exp;
                    String className = javaFunctionInvocation.className();
                    String methodName = javaFunctionInvocation.methodName();
                    List<String> arguments = javaFunctionInvocation.arguments();
                    val = this.invokeJavaFunction(className, methodName, arguments, (List<Val>)paramValues, context.valueMapper());
                } else {
                    val = this.eval(body, CompositeContext$.MODULE$.ContextComposition(context).$plus$plus(((TraversableOnce)params.zip(paramValues, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
                }
                return val;
            }, ValFunction$.MODULE$.apply$default$3(), ValFunction$.MODULE$.apply$default$4());
        } else {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported expression '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{exp})));
        }
        return val;
    }

    private ValError error(Val x, String message) {
        ValError valError;
        Val val = x;
        ValError valError2 = val instanceof ValError ? (valError = (ValError)val) : new ValError(message);
        return valError2;
    }

    private Val withValOrNull(Val x) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValError) {
            ValError valError = (ValError)val2;
            String e = valError.error();
            this.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressed failure: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{e})));
            val = ValNull$.MODULE$;
        } else {
            val = x;
        }
        return val;
    }

    private Val unaryOpAny(Val x, Function2<Object, Object, Object> c, Function1<Object, Val> f, Context context) {
        return this.withVal(this.input(context), (Function1<Val, Val> & Serializable & scala.Serializable)x$27 -> {
            Val val;
            Val val2 = x$27;
            if (ValNull$.MODULE$.equals(val2)) {
                val = this.withVal(x, (Function1<Val, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(ValNull$.MODULE$, x)));
            } else {
                Val val3 = x;
                ValNull$ valNull$ = ValNull$.MODULE$;
                if (!(val3 != null ? !val3.equals(valNull$) : valNull$ != null)) {
                    val = (Val)f.apply(c.apply(val2, ValNull$.MODULE$));
                } else if (val2 instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val2;
                    BigDecimal i = valNumber.value();
                    val = this.withNumber(x, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValBoolean) {
                    ValBoolean valBoolean = (ValBoolean)val2;
                    boolean i = valBoolean.value();
                    val = this.withBoolean(x, (Function1<Object, Val> & Serializable & scala.Serializable)x -> FeelInterpreter.$anonfun$unaryOpAny$4(c, f, i, BoxesRunTime.unboxToBoolean(x)));
                } else if (val2 instanceof ValString) {
                    ValString valString = (ValString)val2;
                    String i = valString.value();
                    val = this.withString(x, (Function1<String, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValDate) {
                    ValDate valDate = (ValDate)val2;
                    LocalDate i = valDate.value();
                    val = this.withDate(x, (Function1<LocalDate, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValLocalTime) {
                    ValLocalTime valLocalTime = (ValLocalTime)val2;
                    LocalTime i = valLocalTime.value();
                    val = this.withLocalTime(x, (Function1<LocalTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValTime) {
                    ValTime valTime = (ValTime)val2;
                    OffsetTime i = valTime.value();
                    val = this.withTime(x, (Function1<OffsetTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                    LocalDateTime i = valLocalDateTime.value();
                    val = this.withLocalDateTime(x, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val2;
                    OffsetDateTime i = valDateTime.value();
                    val = this.withDateTime(x, (Function1<OffsetDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValYearMonthDuration) {
                    ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                    Period i = valYearMonthDuration.value();
                    val = this.withYearMonthDuration(x, (Function1<Period, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else if (val2 instanceof ValDayTimeDuration) {
                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                    Duration i = valDayTimeDuration.value();
                    val = this.withDayTimeDuration(x, (Function1<Duration, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(i, x)));
                } else {
                    val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Boolean, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.input(context)})));
                }
            }
            return val;
        });
    }

    private Val unaryOp(Val x, Function2<Compareable<?>, Compareable<?>, Object> c, Function1<Object, Val> f, Context context) {
        return this.withVal(this.input(context), (Function1<Val, Val> & Serializable & scala.Serializable)x$28 -> {
            Val val;
            Val val2 = x$28;
            if (val2 instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal i = valNumber.value();
                val = this.withNumber(x, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableNumber(i), Compareable$.MODULE$.CompareableNumber((BigDecimal)x))));
            } else if (val2 instanceof ValDate) {
                ValDate valDate = (ValDate)val2;
                LocalDate i = valDate.value();
                val = this.withDate(x, (Function1<LocalDate, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDate(i), Compareable$.MODULE$.CompareableDate((LocalDate)x))));
            } else if (val2 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val2;
                LocalTime i = valLocalTime.value();
                val = this.withLocalTime(x, (Function1<LocalTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalTime(i), Compareable$.MODULE$.CompareableLocalTime((LocalTime)x))));
            } else if (val2 instanceof ValTime) {
                ValTime valTime = (ValTime)val2;
                OffsetTime i = valTime.value();
                val = this.withTime(x, (Function1<OffsetTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableTime(i), Compareable$.MODULE$.CompareableTime((OffsetTime)x))));
            } else if (val2 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime i = valLocalDateTime.value();
                val = this.withLocalDateTime(x, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalDateTime(i), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)x))));
            } else if (val2 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                OffsetDateTime i = valDateTime.value();
                val = this.withDateTime(x, (Function1<OffsetDateTime, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDateTime(i), Compareable$.MODULE$.CompareableDateTime((OffsetDateTime)x))));
            } else if (val2 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period i = valYearMonthDuration.value();
                val = this.withYearMonthDuration(x, (Function1<Period, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableYearMonthDuration(i), Compareable$.MODULE$.CompareableYearMonthDuration((Period)x))));
            } else if (val2 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                Duration i = valDayTimeDuration.value();
                val = this.withDayTimeDuration(x, (Function1<Duration, Val> & Serializable & scala.Serializable)x -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDayTimeDuration(i), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)x))));
            } else {
                val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.input(context)})));
            }
            return val;
        });
    }

    private Val unaryOpDual(Val x, Val y, Function3<Compareable<?>, Compareable<?>, Compareable<?>, Object> c, Function1<Object, Val> f, Context context) {
        return this.withVal(this.input(context), (Function1<Val, Val> & Serializable & scala.Serializable)x$29 -> {
            Val val;
            Val val2 = x$29;
            if (val2 instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal i = valNumber.value();
                val = this.withNumbers(x, y, (Function2<BigDecimal, BigDecimal, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableNumber(i), Compareable$.MODULE$.CompareableNumber((BigDecimal)x), Compareable$.MODULE$.CompareableNumber((BigDecimal)y))));
            } else if (val2 instanceof ValDate) {
                ValDate valDate = (ValDate)val2;
                LocalDate i = valDate.value();
                val = this.withDates(x, y, (Function2<LocalDate, LocalDate, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDate(i), Compareable$.MODULE$.CompareableDate((LocalDate)x), Compareable$.MODULE$.CompareableDate((LocalDate)y))));
            } else if (val2 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val2;
                LocalTime i = valLocalTime.value();
                val = this.withLocalTimes(x, y, (Function2<LocalTime, LocalTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalTime(i), Compareable$.MODULE$.CompareableLocalTime((LocalTime)x), Compareable$.MODULE$.CompareableLocalTime((LocalTime)y))));
            } else if (val2 instanceof ValTime) {
                ValTime valTime = (ValTime)val2;
                OffsetTime i = valTime.value();
                val = this.withTimes(x, y, (Function2<OffsetTime, OffsetTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableTime(i), Compareable$.MODULE$.CompareableTime((OffsetTime)x), Compareable$.MODULE$.CompareableTime((OffsetTime)y))));
            } else if (val2 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime i = valLocalDateTime.value();
                val = this.withLocalDateTimes(x, y, (Function2<LocalDateTime, LocalDateTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalDateTime(i), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)x), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)y))));
            } else if (val2 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                OffsetDateTime i = valDateTime.value();
                val = this.withDateTimes(x, y, (Function2<OffsetDateTime, OffsetDateTime, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDateTime(i), Compareable$.MODULE$.CompareableDateTime((OffsetDateTime)x), Compareable$.MODULE$.CompareableDateTime((OffsetDateTime)y))));
            } else if (val2 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period i = valYearMonthDuration.value();
                val = this.withYearMonthDurations(x, y, (Function2<Period, Period, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableYearMonthDuration(i), Compareable$.MODULE$.CompareableYearMonthDuration((Period)x), Compareable$.MODULE$.CompareableYearMonthDuration((Period)y))));
            } else if (val2 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                Duration i = valDayTimeDuration.value();
                val = this.withDayTimeDurations(x, y, (Function2<Duration, Duration, Val> & Serializable & scala.Serializable)(x, y) -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDayTimeDuration(i), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)x), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)y))));
            } else {
                val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.input(context)})));
            }
            return val;
        });
    }

    private Val withNumbers(Val x2, Val y, Function2<BigDecimal, BigDecimal, Val> f) {
        return this.withNumber(x2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)x -> this.withNumber(y, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((BigDecimal)x, (BigDecimal)y)));
    }

    private Val withNumber(Val x, Function1<BigDecimal, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withBoolean(Val x, Function1<Object, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val2;
            boolean x2 = valBoolean.value();
            val = f.apply(BoxesRunTime.boxToBoolean(x2));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Boolean but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withBooleanOrNull(Val x, Function1<Object, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val2;
            boolean x2 = valBoolean.value();
            val = f.apply(BoxesRunTime.boxToBoolean(x2));
        } else {
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val withBooleanOrFalse(Val x, Function1<Object, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val2;
            boolean x2 = valBoolean.value();
            val = f.apply(BoxesRunTime.boxToBoolean(x2));
        } else {
            this.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressed failure: expected Boolean but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
            val = f.apply(BoxesRunTime.boxToBoolean(false));
        }
        return val;
    }

    private Val withString(Val x, Function1<String, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValString) {
            ValString valString = (ValString)val2;
            String x2 = valString.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected String but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withDates(Val x2, Val y, Function2<LocalDate, LocalDate, Val> f) {
        return this.withDate(x2, (Function1<LocalDate, Val> & Serializable & scala.Serializable)x -> this.withDate(y, (Function1<LocalDate, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((LocalDate)x, (LocalDate)y)));
    }

    private Val withDate(Val x, Function1<LocalDate, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValDate) {
            ValDate valDate = (ValDate)val2;
            LocalDate x2 = valDate.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Date but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withTimes(Val x2, Val y, Function2<OffsetTime, OffsetTime, Val> f) {
        return this.withTime(x2, (Function1<OffsetTime, Val> & Serializable & scala.Serializable)x -> this.withTime(y, (Function1<OffsetTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((OffsetTime)x, (OffsetTime)y)));
    }

    private Val withLocalTimes(Val x2, Val y, Function2<LocalTime, LocalTime, Val> f) {
        return this.withLocalTime(x2, (Function1<LocalTime, Val> & Serializable & scala.Serializable)x -> this.withLocalTime(y, (Function1<LocalTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((LocalTime)x, (LocalTime)y)));
    }

    private Val withLocalTime(Val x, Function1<LocalTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x2 = valLocalTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Local Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withTime(Val x, Function1<OffsetTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            OffsetTime x2 = valTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withDateTimes(Val x2, Val y, Function2<OffsetDateTime, OffsetDateTime, Val> f) {
        return this.withDateTime(x2, (Function1<OffsetDateTime, Val> & Serializable & scala.Serializable)x -> this.withDateTime(y, (Function1<OffsetDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((OffsetDateTime)x, (OffsetDateTime)y)));
    }

    private Val withLocalDateTimes(Val x2, Val y, Function2<LocalDateTime, LocalDateTime, Val> f) {
        return this.withLocalDateTime(x2, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)x -> this.withLocalDateTime(y, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((LocalDateTime)x, (LocalDateTime)y)));
    }

    private Val withDateTime(Val x, Function1<OffsetDateTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val2;
            OffsetDateTime x2 = valDateTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withLocalDateTime(Val x, Function1<LocalDateTime, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x2 = valLocalDateTime.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Local Date Time but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withYearMonthDurations(Val x2, Val y, Function2<Period, Period, Val> f) {
        return this.withYearMonthDuration(x2, (Function1<Period, Val> & Serializable & scala.Serializable)x -> this.withYearMonthDuration(y, (Function1<Period, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((Period)x, (Period)y)));
    }

    private Val withDayTimeDurations(Val x2, Val y, Function2<Duration, Duration, Val> f) {
        return this.withDayTimeDuration(x2, (Function1<Duration, Val> & Serializable & scala.Serializable)x -> this.withDayTimeDuration(y, (Function1<Duration, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((Duration)x, (Duration)y)));
    }

    private Val withYearMonthDuration(Val x, Function1<Period, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x2 = valYearMonthDuration.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withDayTimeDuration(Val x, Function1<Duration, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x2 = valDayTimeDuration.value();
            val = f.apply(x2);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withVal(Val x, Function1<Val, Val> f) {
        ValError valError;
        Val val = x;
        Val val2 = val instanceof ValError ? (valError = (ValError)val) : f.apply(x);
        return val2;
    }

    private Function3<Compareable<?>, Compareable<?>, Compareable<?>, Object> isInInterval(Interval interval) {
        return (Function3<Compareable, Compareable, Compareable, Object> & Serializable & scala.Serializable)(i, x, y) -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$isInInterval$1(interval, i, x, y));
    }

    private Val atLeastOne(List<Exp> xs, Function1<Object, Val> f, Context context) {
        return this.atLeastOne(xs.map((Function1<Exp, Function0> & Serializable & scala.Serializable)x -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval((Exp)x, context), List$.MODULE$.canBuildFrom()), f);
    }

    private Val atLeastOne(List<Function0<Val>> xs, Function1<Object, Val> f) {
        Val val;
        block4: {
            List<Function0<Val>> list;
            block5: {
                Val val2;
                block6: {
                    ValBoolean valBoolean;
                    boolean bl;
                    List<Function0<Val>> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            val = f.apply(BoxesRunTime.boxToBoolean(false));
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Function0 x = (Function0)$colon$colon.head();
                        xs2 = $colon$colon.tl$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean2 = null;
                        Val val3 = (Val)x.apply();
                        if (val3 instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean2 = (ValBoolean)val3;
                            boolean bl4 = valBoolean2.value();
                            if (bl4) {
                                val2 = f.apply(BoxesRunTime.boxToBoolean(true));
                                break block6;
                            }
                        }
                        if (!bl3 || (bl2 = valBoolean2.value())) break;
                        xs = xs2;
                    }
                    Val val4 = this.atLeastOne(xs2, f);
                    Val val5 = val4 instanceof ValBoolean && true == (bl = (valBoolean = (ValBoolean)val4).value()) ? f.apply(BoxesRunTime.boxToBoolean(true)) : ValNull$.MODULE$;
                    val2 = val5;
                }
                val = val2;
                break block4;
            }
            throw new MatchError(list);
        }
        return val;
    }

    private Val all(List<Exp> xs, Function1<Object, Val> f, Context context) {
        return this.all(xs.map((Function1<Exp, Function0> & Serializable & scala.Serializable)x -> (Function0<Val> & Serializable & scala.Serializable)() -> this.eval((Exp)x, context), List$.MODULE$.canBuildFrom()), f);
    }

    private Val all(List<Function0<Val>> xs, Function1<Object, Val> f) {
        Val val;
        block4: {
            List<Function0<Val>> list;
            block5: {
                Val val2;
                block6: {
                    ValBoolean valBoolean;
                    boolean bl;
                    List<Function0<Val>> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            val = f.apply(BoxesRunTime.boxToBoolean(true));
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Function0 x = (Function0)$colon$colon.head();
                        xs2 = $colon$colon.tl$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean2 = null;
                        Val val3 = (Val)x.apply();
                        if (val3 instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean2 = (ValBoolean)val3;
                            boolean bl4 = valBoolean2.value();
                            if (!bl4) {
                                val2 = f.apply(BoxesRunTime.boxToBoolean(false));
                                break block6;
                            }
                        }
                        if (!bl3 || !(bl2 = valBoolean2.value())) break;
                        xs = xs2;
                    }
                    Val val4 = this.all(xs2, f);
                    Val val5 = val4 instanceof ValBoolean && false == (bl = (valBoolean = (ValBoolean)val4).value()) ? f.apply(BoxesRunTime.boxToBoolean(false)) : ValNull$.MODULE$;
                    val2 = val5;
                }
                val = val2;
                break block4;
            }
            throw new MatchError(list);
        }
        return val;
    }

    private String inputKey(Context context) {
        String string;
        Val val = context.variable(RootContext$.MODULE$.inputVariableKey());
        if (val instanceof ValString) {
            String inputVariableName;
            ValString valString = (ValString)val;
            string = inputVariableName = valString.value();
        } else {
            string = RootContext$.MODULE$.defaultInputVariable();
        }
        return string;
    }

    private Val input(Context context) {
        return context.variable(this.inputKey(context));
    }

    private Val dualNumericOp(Val x, Val y2, Function2<BigDecimal, BigDecimal, BigDecimal> op, Function1<BigDecimal, Val> f, Context context) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply((BigDecimal)op.apply(x2, (BigDecimal)y)));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val dualOpAny(Val x, Val y2, Function2<Object, Object, Object> c, Function1<Object, Val> f, Context context) {
        Val val;
        Val val2 = x;
        if (ValNull$.MODULE$.equals(val2)) {
            val = this.withVal(y2, (Function1<Val, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(ValNull$.MODULE$, y)));
        } else {
            Val val3 = y2;
            ValNull$ valNull$ = ValNull$.MODULE$;
            if (!(val3 != null ? !val3.equals(valNull$) : valNull$ != null)) {
                val = f.apply(c.apply(val2, ValNull$.MODULE$));
            } else if (val2 instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal x2 = valNumber.value();
                val = this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x2, y)));
            } else if (val2 instanceof ValBoolean) {
                ValBoolean valBoolean = (ValBoolean)val2;
                boolean x3 = valBoolean.value();
                val = this.withBoolean(y2, (Function1<Object, Val> & Serializable & scala.Serializable)y -> FeelInterpreter.$anonfun$dualOpAny$3(c, f, x3, BoxesRunTime.unboxToBoolean(y)));
            } else if (val2 instanceof ValString) {
                ValString valString = (ValString)val2;
                String x4 = valString.value();
                val = this.withString(y2, (Function1<String, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x4, y)));
            } else if (val2 instanceof ValDate) {
                ValDate valDate = (ValDate)val2;
                LocalDate x5 = valDate.value();
                val = this.withDate(y2, (Function1<LocalDate, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x5, y)));
            } else if (val2 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val2;
                LocalTime x6 = valLocalTime.value();
                val = this.withLocalTime(y2, (Function1<LocalTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x6, y)));
            } else if (val2 instanceof ValTime) {
                ValTime valTime = (ValTime)val2;
                OffsetTime x7 = valTime.value();
                val = this.withTime(y2, (Function1<OffsetTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x7, y)));
            } else if (val2 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime x8 = valLocalDateTime.value();
                val = this.withLocalDateTime(y2, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x8, y)));
            } else if (val2 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                OffsetDateTime x9 = valDateTime.value();
                val = this.withDateTime(y2, (Function1<OffsetDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x9, y)));
            } else if (val2 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period x10 = valYearMonthDuration.value();
                val = this.withYearMonthDuration(y2, (Function1<Period, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x10, y)));
            } else if (val2 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
                Duration x11 = valDayTimeDuration.value();
                val = this.withDayTimeDuration(y2, (Function1<Duration, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(x11, y)));
            } else {
                val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Boolean, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
            }
        }
        return val;
    }

    private Val dualOp(Val x, Val y2, Function2<Compareable<?>, Compareable<?>, Object> c, Function1<Object, Val> f, Context context) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableNumber(x2), Compareable$.MODULE$.CompareableNumber((BigDecimal)y))));
        } else if (val2 instanceof ValDate) {
            ValDate valDate = (ValDate)val2;
            LocalDate x3 = valDate.value();
            val = this.withDate(y2, (Function1<LocalDate, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDate(x3), Compareable$.MODULE$.CompareableDate((LocalDate)y))));
        } else if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x4 = valLocalTime.value();
            val = this.withLocalTime(y2, (Function1<LocalTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalTime(x4), Compareable$.MODULE$.CompareableLocalTime((LocalTime)y))));
        } else if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            OffsetTime x5 = valTime.value();
            val = this.withTime(y2, (Function1<OffsetTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableTime(x5), Compareable$.MODULE$.CompareableTime((OffsetTime)y))));
        } else if (val2 instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x6 = valLocalDateTime.value();
            val = this.withLocalDateTime(y2, (Function1<LocalDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableLocalDateTime(x6), Compareable$.MODULE$.CompareableLocalDateTime((LocalDateTime)y))));
        } else if (val2 instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val2;
            OffsetDateTime x7 = valDateTime.value();
            val = this.withDateTime(y2, (Function1<OffsetDateTime, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDateTime(x7), Compareable$.MODULE$.CompareableDateTime((OffsetDateTime)y))));
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x8 = valYearMonthDuration.value();
            val = this.withYearMonthDuration(y2, (Function1<Period, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableYearMonthDuration(x8), Compareable$.MODULE$.CompareableYearMonthDuration((Period)y))));
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x9 = valDayTimeDuration.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableDayTimeDuration(x9), Compareable$.MODULE$.CompareableDayTimeDuration((Duration)y))));
        } else if (val2 instanceof ValString) {
            ValString valString = (ValString)val2;
            String x10 = valString.value();
            val = this.withString(y2, (Function1<String, Val> & Serializable & scala.Serializable)y -> (Val)f.apply(c.apply(Compareable$.MODULE$.CompareableString(x10), Compareable$.MODULE$.CompareableString((String)y))));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val addOp(Val x, Val y2) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValNumber> & Serializable & scala.Serializable)y -> new ValNumber(x2.$plus((BigDecimal)y)));
        } else if (val2 instanceof ValString) {
            ValString valString = (ValString)val2;
            String x3 = valString.value();
            val = this.withString(y2, (Function1<String, Val>)(Function1<String, ValString> & Serializable & scala.Serializable)y -> new ValString(x3 + y));
        } else if (val2 instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x4 = valLocalTime.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val>)(Function1<Duration, ValLocalTime> & Serializable & scala.Serializable)y -> new ValLocalTime(x4.plus((TemporalAmount)y)));
        } else if (val2 instanceof ValTime) {
            ValTime valTime = (ValTime)val2;
            OffsetTime x5 = valTime.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val>)(Function1<Duration, ValTime> & Serializable & scala.Serializable)y -> new ValTime(x5.plus((TemporalAmount)y)));
        } else if (val2 instanceof ValLocalDateTime) {
            scala.Serializable serializable;
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x6 = valLocalDateTime.value();
            Val val3 = y2;
            if (val3 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val3;
                Period y3 = valYearMonthDuration.value();
                serializable = new ValLocalDateTime(x6.plus(y3));
            } else if (val3 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val3;
                Duration y4 = valDayTimeDuration.value();
                serializable = new ValLocalDateTime(x6.plus(y4));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x6})));
            }
            val = serializable;
        } else if (val2 instanceof ValDateTime) {
            scala.Serializable serializable;
            ValDateTime valDateTime = (ValDateTime)val2;
            OffsetDateTime x7 = valDateTime.value();
            Val val4 = y2;
            if (val4 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val4;
                Period y5 = valYearMonthDuration.value();
                serializable = new ValDateTime(x7.plus(y5));
            } else if (val4 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                Duration y6 = valDayTimeDuration.value();
                serializable = new ValDateTime(x7.plus(y6));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x7})));
            }
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            scala.Serializable serializable;
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x8 = valYearMonthDuration.value();
            Val val5 = y2;
            if (val5 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration2 = (ValYearMonthDuration)val5;
                Period y7 = valYearMonthDuration2.value();
                serializable = new ValYearMonthDuration(x8.plus(y7));
            } else if (val5 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val5;
                LocalDateTime y8 = valLocalDateTime.value();
                serializable = new ValLocalDateTime(y8.plus(x8));
            } else if (val5 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val5;
                OffsetDateTime y9 = valDateTime.value();
                serializable = new ValDateTime(y9.plus(x8));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date-Time, or Year-Month-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x8})));
            }
            val = serializable;
        } else if (val2 instanceof ValDayTimeDuration) {
            scala.Serializable serializable;
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x9 = valDayTimeDuration.value();
            Val val6 = y2;
            if (val6 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration2 = (ValDayTimeDuration)val6;
                Duration y10 = valDayTimeDuration2.value();
                serializable = new ValDayTimeDuration(x9.plus(y10));
            } else if (val6 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val6;
                LocalDateTime y11 = valLocalDateTime.value();
                serializable = new ValLocalDateTime(y11.plus(x9));
            } else if (val6 instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val6;
                OffsetDateTime y12 = valDateTime.value();
                serializable = new ValDateTime(y12.plus(x9));
            } else if (val6 instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val6;
                LocalTime y13 = valLocalTime.value();
                serializable = new ValLocalTime(y13.plus(x9));
            } else if (val6 instanceof ValTime) {
                ValTime valTime = (ValTime)val6;
                OffsetTime y14 = valTime.value();
                serializable = new ValTime(y14.plus(x9));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Date-Time, Time, or Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x9})));
            }
            val = serializable;
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, String, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val subOp(Val x, Val y2) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValNumber> & Serializable & scala.Serializable)y -> new ValNumber(x2.$minus((BigDecimal)y)));
        } else if (val2 instanceof ValLocalTime) {
            scala.Serializable serializable;
            ValLocalTime valLocalTime = (ValLocalTime)val2;
            LocalTime x3 = valLocalTime.value();
            Val val3 = y2;
            if (val3 instanceof ValLocalTime) {
                ValLocalTime valLocalTime2 = (ValLocalTime)val3;
                LocalTime y3 = valLocalTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y3, x3));
            } else if (val3 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val3;
                Duration y4 = valDayTimeDuration.value();
                serializable = new ValLocalTime(x3.minus(y4));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x3})));
            }
            val = serializable;
        } else if (val2 instanceof ValTime) {
            scala.Serializable serializable;
            ValTime valTime = (ValTime)val2;
            OffsetTime x4 = valTime.value();
            Val val4 = y2;
            if (val4 instanceof ValTime) {
                ValTime valTime2 = (ValTime)val4;
                OffsetTime y5 = valTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y5, x4));
            } else if (val4 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                Duration y6 = valDayTimeDuration.value();
                serializable = new ValTime(x4.minus(y6));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x4})));
            }
            val = serializable;
        } else if (val2 instanceof ValLocalDateTime) {
            scala.Serializable serializable;
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
            LocalDateTime x5 = valLocalDateTime.value();
            Val val5 = y2;
            if (val5 instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime2 = (ValLocalDateTime)val5;
                LocalDateTime y7 = valLocalDateTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y7, x5));
            } else if (val5 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val5;
                Period y8 = valYearMonthDuration.value();
                serializable = new ValLocalDateTime(x5.minus(y8));
            } else if (val5 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val5;
                Duration y9 = valDayTimeDuration.value();
                serializable = new ValLocalDateTime(x5.minus(y9));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x5})));
            }
            val = serializable;
        } else if (val2 instanceof ValDateTime) {
            scala.Serializable serializable;
            ValDateTime valDateTime = (ValDateTime)val2;
            OffsetDateTime x6 = valDateTime.value();
            Val val6 = y2;
            if (val6 instanceof ValDateTime) {
                ValDateTime valDateTime2 = (ValDateTime)val6;
                OffsetDateTime y10 = valDateTime2.value();
                serializable = new ValDayTimeDuration(Duration.between(y10, x6));
            } else if (val6 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val6;
                Period y11 = valYearMonthDuration.value();
                serializable = new ValDateTime(x6.minus(y11));
            } else if (val6 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val6;
                Duration y12 = valDayTimeDuration.value();
                serializable = new ValDateTime(x6.minus(y12));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Time, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x6})));
            }
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x7 = valYearMonthDuration.value();
            val = this.withYearMonthDuration(y2, (Function1<Period, Val>)(Function1<Period, ValYearMonthDuration> & Serializable & scala.Serializable)y -> new ValYearMonthDuration(x7.minus((TemporalAmount)y).normalized()));
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x8 = valDayTimeDuration.value();
            val = this.withDayTimeDuration(y2, (Function1<Duration, Val>)(Function1<Duration, ValDayTimeDuration> & Serializable & scala.Serializable)y -> new ValDayTimeDuration(x8.minus((Duration)y)));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, Date, Time or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val mulOp(Val x, Val y2) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValNumber) {
            scala.Serializable serializable;
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal x2 = valNumber.value();
            Val val3 = y2;
            if (val3 instanceof ValNumber) {
                ValNumber valNumber2 = (ValNumber)val3;
                BigDecimal y3 = valNumber2.value();
                serializable = new ValNumber(x2.$times(y3));
            } else if (val3 instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val3;
                Period y4 = valYearMonthDuration.value();
                serializable = new ValYearMonthDuration(y4.multipliedBy(x2.intValue()).normalized());
            } else if (val3 instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val3;
                Duration y5 = valDayTimeDuration.value();
                serializable = new ValDayTimeDuration(y5.multipliedBy(x2.intValue()));
            } else {
                serializable = this.error(y2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Number, or Year-Month-/Day-Time-Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x2})));
            }
            val = serializable;
        } else if (val2 instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
            Period x3 = valYearMonthDuration.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValYearMonthDuration> & Serializable & scala.Serializable)y -> new ValYearMonthDuration(x3.multipliedBy(y.intValue()).normalized()));
        } else if (val2 instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val2;
            Duration x4 = valDayTimeDuration.value();
            val = this.withNumber(y2, (Function1<BigDecimal, Val>)(Function1<BigDecimal, ValDayTimeDuration> & Serializable & scala.Serializable)y -> new ValDayTimeDuration(x4.multipliedBy(y.intValue())));
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val divOp(Val x, Val y2) {
        return this.withNumber(y2, (Function1<BigDecimal, Val> & Serializable & scala.Serializable)y -> {
            scala.Serializable serializable;
            if (BoxesRunTime.equalsNumObject(y, BoxesRunTime.boxToInteger(0))) {
                serializable = new ValError("division by zero");
            } else {
                scala.Serializable serializable2;
                Val val = x;
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal x = valNumber.value();
                    serializable2 = new ValNumber(x.$div((BigDecimal)y));
                } else if (val instanceof ValYearMonthDuration) {
                    ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val;
                    Period x = valYearMonthDuration.value();
                    serializable2 = new ValYearMonthDuration(Period.ofMonths(BigDecimal$.MODULE$.long2bigDecimal(x.toTotalMonths()).$div((BigDecimal)y).intValue()).normalized());
                } else if (val instanceof ValDayTimeDuration) {
                    ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
                    Duration x = valDayTimeDuration.value();
                    serializable2 = new ValDayTimeDuration(Duration.ofMillis(BigDecimal$.MODULE$.long2bigDecimal(x.toMillis()).$div((BigDecimal)y).intValue()));
                } else {
                    serializable2 = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Number, or Duration but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
                }
                serializable = serializable2;
            }
            return serializable;
        });
    }

    private Val withFunction(Val x, Function1<ValFunction, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValFunction) {
            ValFunction valFunction = (ValFunction)val2;
            val = f.apply(valFunction);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Function but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    /*
     * Unable to fully structure code
     */
    private Val invokeFunction(ValFunction function, FunctionParameters params, Context context) {
        block11: {
            block6: {
                block10: {
                    block7: {
                        block9: {
                            block8: {
                                var7_4 = params;
                                if (!(var7_4 instanceof PositionalFunctionParameters)) break block6;
                                var8_5 = (PositionalFunctionParameters)var7_4;
                                params = var8_5.params();
                                if (!function.hasVarArgs() || function.params().size() <= 0) break block7;
                                size = function.params().size() - 1;
                                args = params.take(size).map((Function1<Exp, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$1(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context org.camunda.feel.parser.Exp ), (Lorg/camunda/feel/parser/Exp;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context), List$.MODULE$.canBuildFrom());
                                var13_9 = params.drop(size).map((Function1<Exp, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$2(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context org.camunda.feel.parser.Exp ), (Lorg/camunda/feel/parser/Exp;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context), List$.MODULE$.canBuildFrom());
                                if (!Nil$.MODULE$.equals(var13_9)) break block8;
                                var5_10 = new ValList(Nil$.MODULE$);
                                break block9;
                            }
                            if (!(var13_9 instanceof $colon$colon)) ** GOTO lbl-1000
                            var14_11 = ($colon$colon)var13_9;
                            var15_12 = (Val)var14_11.head();
                            var16_13 = var14_11.tl$access$1();
                            if (!(var15_12 instanceof ValList)) ** GOTO lbl-1000
                            var17_14 = (ValList)var15_12;
                            list = var17_14.items();
                            if (Nil$.MODULE$.equals(var16_13) && size == 0) {
                                var5_10 = new ValList(list);
                            } else lbl-1000:
                            // 3 sources

                            {
                                var5_10 = new ValList(var13_9);
                            }
                        }
                        varArgs = var5_10;
                        v0 = args.$colon$plus(varArgs, List$.MODULE$.canBuildFrom());
                        break block10;
                    }
                    v0 = params.map((Function1<Exp, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$3(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context org.camunda.feel.parser.Exp ), (Lorg/camunda/feel/parser/Exp;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context), List$.MODULE$.canBuildFrom());
                }
                var4_17 = v0;
                break block11;
            }
            if (var7_4 instanceof NamedFunctionParameters) {
                var19_18 = (NamedFunctionParameters)var7_4;
                params = var19_18.params();
                var4_17 = function.params().map((Function1<String, Val> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invokeFunction$4(org.camunda.feel.interpreter.FeelInterpreter org.camunda.feel.interpreter.Context scala.collection.immutable.Map java.lang.String ), (Ljava/lang/String;)Lorg/camunda/feel/interpreter/Val;)((FeelInterpreter)this, (Context)context, params), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(var7_4);
            }
        }
        paramList = var4_17;
        if (function.requireInputVariable()) {
            var21_21 = this.input(context);
            v1 = function.invoke().apply(paramList.$colon$colon(var21_21));
        } else {
            v1 = function.invoke().apply(paramList);
        }
        return v1;
    }

    private Val findFunction(Context ctx, String name, FunctionParameters params) {
        Val val;
        FunctionParameters functionParameters = params;
        if (functionParameters instanceof PositionalFunctionParameters) {
            PositionalFunctionParameters positionalFunctionParameters = (PositionalFunctionParameters)functionParameters;
            List<Exp> params2 = positionalFunctionParameters.params();
            val = ctx.function(name, params2.size());
        } else if (functionParameters instanceof NamedFunctionParameters) {
            NamedFunctionParameters namedFunctionParameters = (NamedFunctionParameters)functionParameters;
            Map<String, Exp> params3 = namedFunctionParameters.params();
            val = ctx.function(name, params3.keySet());
        } else {
            throw new MatchError(functionParameters);
        }
        return val;
    }

    private Map<String, List<ValFunction>> addFunction(Map<String, List<ValFunction>> functions, String name, ValFunction f) {
        List functionsByName = (List)functions.getOrElse(name, (Function0<List> & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        ValFunction valFunction = f;
        return functions.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), functionsByName.$colon$colon(valFunction)));
    }

    private Val withType(Val x, Function1<String, ValBoolean> f) {
        Val val = x;
        Val val2 = val instanceof ValNumber ? (Val)f.apply("number") : (val instanceof ValBoolean ? (Val)f.apply("boolean") : (val instanceof ValString ? (Val)f.apply("string") : (val instanceof ValDate ? (Val)f.apply("date") : (val instanceof ValLocalTime ? (Val)f.apply("time") : (val instanceof ValTime ? (Val)f.apply("time") : (val instanceof ValLocalDateTime ? (Val)f.apply("date time") : (val instanceof ValDateTime ? (Val)f.apply("date time") : (val instanceof ValYearMonthDuration ? (Val)f.apply("year-month-duration") : (val instanceof ValDayTimeDuration ? (Val)f.apply("day-time-duration") : (ValNull$.MODULE$.equals(val) ? (Val)f.apply("null") : (val instanceof ValList ? (Val)f.apply("list") : (val instanceof ValContext ? (Val)f.apply("context") : (val instanceof ValFunction ? (Val)f.apply("function") : this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected type '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x.getClass().getName()}))))))))))))))));
        return val2;
    }

    private Val withList(Val x, Function1<ValList, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValList) {
            ValList valList = (ValList)val2;
            val = f.apply(valList);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect List but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Val withLists(List<Tuple2<String, Val>> lists, Function1<List<Tuple2<String, ValList>>, Val> f, Context context) {
        Val val;
        Val e;
        Some some;
        Tuple2 tuple2;
        Option option = ((LinearSeqOptimized)lists.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Val it = (Val)tuple2._2();
            Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), this.withList(it, (Function1<ValList, Val>)(Function1<ValList, ValList> & Serializable & scala.Serializable)list -> list));
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).find((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean(FeelInterpreter.$anonfun$withLists$3(x$32)));
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null && (e = (Val)tuple2._2()) != null) {
            Val val2;
            val = val2 = e;
        } else if (None$.MODULE$.equals(option)) {
            val = f.apply(lists);
        } else {
            throw new MatchError(option);
        }
        return val;
    }

    private Val withCartesianProduct(List<Tuple2<String, Exp>> iterators, Function1<List<Map<String, Val>>, Val> f, Context context) {
        return this.withLists(iterators.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Exp it = (Exp)tuple2._2();
            Tuple2<String, Val> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), this.eval(it, context));
            return tuple22;
        }, List$.MODULE$.canBuildFrom()), (Function1<List<Tuple2<String, ValList>>, Val>)(Function1<List, Val> & Serializable & scala.Serializable)lists -> (Val)f.apply(this.flattenAndZipLists((List<Tuple2<String, ValList>>)lists)), context);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private List<Map<String, Val>> flattenAndZipLists(List<Tuple2<String, ValList>> lists) {
        void var2_8;
        boolean bl = false;
        $colon$colon $colon$colon = null;
        List<Tuple2<String, ValList>> list = lists;
        if (((Object)Nil$.MODULE$).equals(list)) {
            Nil$ nil$ = Nil$.MODULE$;
            return var2_8;
        }
        if (list instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)list;
            Tuple2 tuple2 = (Tuple2)$colon$colon.head();
            List list2 = $colon$colon.tl$access$1();
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                ValList list3 = (ValList)tuple2._2();
                if (((Object)Nil$.MODULE$).equals(list2)) {
                    List list4 = list3.items().map((Function1<Val, Map> & Serializable & scala.Serializable)v -> (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), v)})), List$.MODULE$.canBuildFrom());
                    return var2_8;
                }
            }
        }
        if (!bl) throw new MatchError(list);
        Tuple2 tuple2 = (Tuple2)$colon$colon.head();
        List tail = $colon$colon.tl$access$1();
        if (tuple2 == null) throw new MatchError(list);
        String name = (String)tuple2._1();
        ValList list5 = (ValList)tuple2._2();
        List list6 = list5.items().flatMap((Function1<Val, List> & Serializable & scala.Serializable)v -> this.flattenAndZipLists(tail).map((Function1<Map, Map> & Serializable & scala.Serializable)values -> values.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), v)), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return var2_8;
    }

    private Val filterList(List<Val> list, Function1<Val, Val> filter) {
        Val val;
        List<Val> list2 = list;
        if (((Object)Nil$.MODULE$).equals(list2)) {
            val = new ValList(Nil$.MODULE$);
        } else if (list2 instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            Val x = (Val)$colon$colon.head();
            List xs = $colon$colon.tl$access$1();
            val = this.withBoolean(filter.apply(x), (Function1<Object, Val> & Serializable & scala.Serializable)x$33 -> FeelInterpreter.$anonfun$filterList$1(this, filter, x, xs, BoxesRunTime.unboxToBoolean(x$33)));
        } else {
            throw new MatchError(list2);
        }
        return val;
    }

    private Val withContext(Val x, Function1<ValContext, Val> f) {
        Val val;
        Val val2 = x;
        if (val2 instanceof ValContext) {
            ValContext valContext = (ValContext)val2;
            val = f.apply(valContext);
        } else {
            val = this.error(x, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect Context but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x})));
        }
        return val;
    }

    private Context filterContext(Val x, Context context) {
        Context context2;
        ValContext valContext;
        Context ctx;
        Val val = x;
        if (val instanceof ValContext && (ctx = (valContext = (ValContext)val).context()) != null) {
            Context context3 = ctx;
            context2 = CompositeContext$.MODULE$.ContextComposition(CompositeContext$.MODULE$.ContextComposition(context).$plus(context3)).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("item"), x));
        } else {
            context2 = CompositeContext$.MODULE$.ContextComposition(context).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("item"), val));
        }
        return context2;
    }

    private Val ref(Val x, List<String> names, Context context) {
        Val val;
        List<String> list = names;
        if (((Object)Nil$.MODULE$).equals(list)) {
            val = x;
        } else if (list instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            String n = (String)$colon$colon.head();
            List ns = $colon$colon.tl$access$1();
            val = this.withContext(x, (Function1<ValContext, Val> & Serializable & scala.Serializable)x0$3 -> {
                Val val;
                ValContext valContext = x0$3;
                if (valContext != null) {
                    Val val2;
                    ValContext valContext2 = valContext;
                    Val val3 = valContext2.context().variable(n);
                    if (val3 instanceof ValError) {
                        val2 = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
                    } else if (val3 != null) {
                        Val val4 = val3;
                        val2 = this.ref(val4, ns, context);
                    } else {
                        val2 = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
                    }
                    val = val2;
                } else {
                    val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
                }
                return val;
            });
        } else {
            throw new MatchError(list);
        }
        return val;
    }

    private Val path(Val v, String key) {
        Val val;
        Val val2 = v;
        if (val2 instanceof ValContext) {
            Val val3;
            ValContext valContext = (ValContext)val2;
            Val val4 = valContext.context().variable(key);
            Val val5 = val4 instanceof ValError ? new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key}))) : (val4 != null ? (val3 = val4) : new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context contains no entry with key '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key}))));
            val = val5;
        } else if (val2 instanceof ValList) {
            ValList valList = (ValList)val2;
            List<Val> list = valList.items();
            val = new ValList(list.map((Function1<Val, Val> & Serializable & scala.Serializable)item -> this.path((Val)item, key), List$.MODULE$.canBuildFrom()));
        } else {
            val = this.error(val2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected Context or List of Contextes but found '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{val2})));
        }
        return val;
    }

    private Val evalContextEntry(String key, Exp exp, Context context) {
        return this.withVal(this.eval(exp, context), (Function1<Val, Val> & Serializable & scala.Serializable)value -> value);
    }

    private Val invokeJavaFunction(String className2, String methodName, List<String> arguments, List<Val> paramValues, ValueMapper valueMapper) {
        Val val;
        try {
            Class<?> clazz = JavaClassMapper$.MODULE$.loadClass(className2);
            List argTypes = arguments.map((Function1<String, Class> & Serializable & scala.Serializable)className -> JavaClassMapper$.MODULE$.loadClass((String)className), List$.MODULE$.canBuildFrom());
            Method method = clazz.getDeclaredMethod(methodName, (Class[])argTypes.toArray(ClassTag$.MODULE$.apply(Class.class)));
            List<?> argValues = paramValues.map((Function1<Val, Object> & Serializable & scala.Serializable)value -> valueMapper.unpackVal((Val)value), List$.MODULE$.canBuildFrom());
            List argJavaObjects = argValues.zip(argTypes, List$.MODULE$.canBuildFrom()).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object obj = tuple2._1();
                Class clazz = (Class)tuple2._2();
                Object object = JavaClassMapper$.MODULE$.asJavaObject(obj, clazz);
                return object;
            }, List$.MODULE$.canBuildFrom());
            Object result = method.invoke(null, (Object[])argJavaObjects.toArray(ClassTag$.MODULE$.Object()));
            val = valueMapper.toVal(result);
        }
        catch (ClassNotFoundException e) {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to load class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{className2})));
        }
        catch (NoSuchMethodException e) {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to get method with name '", "' and arguments '", "' from class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{methodName, arguments, className2})));
        }
        catch (Throwable throwable) {
            val = new ValError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fail to invoke method with name '", "' and arguments '", "' from class '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{methodName, arguments, className2})));
        }
        return val;
    }

    public static final /* synthetic */ boolean $anonfun$eval$4(Object x$1, Object x$2) {
        return BoxesRunTime.equals(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$eval$11(Object x$13, Object x$14) {
        return BoxesRunTime.equals(x$13, x$14);
    }

    public static final /* synthetic */ ValBoolean $anonfun$eval$16(boolean x) {
        return new ValBoolean(!x);
    }

    public static final /* synthetic */ Val $anonfun$eval$17(FeelInterpreter $this, Context context$1, Exp statement$1, Exp elseStatement$1, boolean isMet) {
        return isMet ? $this.eval(statement$1, context$1) : $this.eval(elseStatement$1, context$1);
    }

    public static final /* synthetic */ Val $anonfun$unaryOpAny$4(Function2 c$1, Function1 f$1, boolean i$2, boolean x) {
        return (Val)f$1.apply(c$1.apply(BoxesRunTime.boxToBoolean(i$2), BoxesRunTime.boxToBoolean(x)));
    }

    public static final /* synthetic */ boolean $anonfun$isInInterval$1(Interval interval$1, Compareable i, Compareable x, Compareable y) {
        boolean bl;
        boolean bl2;
        IntervalBoundary intervalBoundary = interval$1.start();
        if (intervalBoundary instanceof OpenIntervalBoundary) {
            bl2 = i.$greater(x);
        } else if (intervalBoundary instanceof ClosedIntervalBoundary) {
            bl2 = i.$greater$eq(x);
        } else {
            throw new MatchError(intervalBoundary);
        }
        boolean inStart = bl2;
        IntervalBoundary intervalBoundary2 = interval$1.end();
        if (intervalBoundary2 instanceof OpenIntervalBoundary) {
            bl = i.$less(y);
        } else if (intervalBoundary2 instanceof ClosedIntervalBoundary) {
            bl = i.$less$eq(y);
        } else {
            throw new MatchError(intervalBoundary2);
        }
        boolean inEnd = bl;
        return inStart && inEnd;
    }

    public static final /* synthetic */ Val $anonfun$dualOpAny$3(Function2 c$4, Function1 f$5, boolean x$41, boolean y) {
        return (Val)f$5.apply(c$4.apply(BoxesRunTime.boxToBoolean(x$41), BoxesRunTime.boxToBoolean(y)));
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$1(FeelInterpreter $this, Context context$9, Exp expression) {
        return $this.eval(expression, context$9);
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$2(FeelInterpreter $this, Context context$9, Exp expression) {
        return $this.eval(expression, context$9);
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$3(FeelInterpreter $this, Context context$9, Exp expression) {
        return $this.eval(expression, context$9);
    }

    public static final /* synthetic */ Val $anonfun$invokeFunction$4(FeelInterpreter $this, Context context$9, Map params$4, String p) {
        return (Val)params$4.get(p).map((Function1<Exp, Val> & Serializable & scala.Serializable)expression -> $this.eval((Exp)expression, context$9)).getOrElse((Function0<ValNull$> & Serializable & scala.Serializable)() -> ValNull$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$withLists$3(Tuple2 x$32) {
        return x$32._2() instanceof ValError;
    }

    public static final /* synthetic */ Val $anonfun$filterList$1(FeelInterpreter $this, Function1 filter$2, Val x$68, List xs$1, boolean x$33) {
        Val val;
        boolean bl = x$33;
        if (!bl) {
            val = $this.filterList(xs$1, filter$2);
        } else if (bl) {
            val = $this.withList($this.filterList(xs$1, filter$2), (Function1<ValList, Val>)(Function1<ValList, ValList> & Serializable & scala.Serializable)l -> {
                Val val = x$68;
                return new ValList(l.items().$colon$colon(val));
            });
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return val;
    }
}

