/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.datatype;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import org.camunda.feel.datatype.ZonedTime$;
import org.camunda.feel.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0001\u0003\u0001.\u0011\u0011BW8oK\u0012$\u0016.\\3\u000b\u0005\r!\u0011\u0001\u00033bi\u0006$\u0018\u0010]3\u000b\u0005\u00151\u0011\u0001\u00024fK2T!a\u0002\u0005\u0002\u000f\r\fW.\u001e8eC*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0019I)\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\b!J|G-^2u!\tia#\u0003\u0002\u0018\u001d\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0004\u0001BK\u0002\u0013\u0005!$\u0001\u0003uS6,W#A\u000e\u0011\u0005q\u0001S\"A\u000f\u000b\u0005eq\"\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cu\u0011\u0011\u0002T8dC2$\u0016.\\3\t\u0011\r\u0002!\u0011#Q\u0001\nm\tQ\u0001^5nK\u0002B\u0001\"\n\u0001\u0003\u0016\u0004%\tAJ\u0001\u0007_\u001a47/\u001a;\u0016\u0003\u001d\u0002\"\u0001\b\u0015\n\u0005%j\"A\u0003.p]\u0016|eMZ:fi\"A1\u0006\u0001B\tB\u0003%q%A\u0004pM\u001a\u001cX\r\u001e\u0011\t\u00115\u0002!Q3A\u0005\u00029\nAA_8oKV\tq\u0006E\u0002\u000eaIJ!!\r\b\u0003\r=\u0003H/[8o!\ta2'\u0003\u00025;\t1!l\u001c8f\u0013\u0012D\u0001B\u000e\u0001\u0003\u0012\u0003\u0006IaL\u0001\u0006u>tW\r\t\u0005\u0006q\u0001!\t!O\u0001\u0007y%t\u0017\u000e\u001e \u0015\tibTH\u0010\t\u0003w\u0001i\u0011A\u0001\u0005\u00063]\u0002\ra\u0007\u0005\u0006K]\u0002\ra\n\u0005\u0006[]\u0002\ra\f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0003-A\u0017m\u001d+j[\u0016TvN\\3\u0016\u0003\t\u0003\"!D\"\n\u0005\u0011s!a\u0002\"p_2,\u0017M\u001c\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\"\u0002\u0019!\f7\u000fV5nKj{g.\u001a\u0011\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006)a.\u00198pgV\t!\n\u0005\u0002\u000e\u0017&\u0011AJ\u0004\u0002\u0005\u0019>tw\r\u0003\u0004O\u0001\u0001\u0006IAS\u0001\u0007]\u0006twn\u001d\u0011\t\u000bA\u0003A\u0011A)\u0002\tAdWo\u001d\u000b\u0003uICQaU(A\u0002Q\u000b1\"Y7pk:$Hk\\!eIB\u0011Q\u000bW\u0007\u0002-*\u0011q+H\u0001\ti\u0016l\u0007o\u001c:bY&\u0011\u0011L\u0016\u0002\u000f)\u0016l\u0007o\u001c:bY\u0006kw.\u001e8u\u0011\u0015Y\u0006\u0001\"\u0001]\u0003\u0015i\u0017N\\;t)\tQT\fC\u0003T5\u0002\u0007A\u000bC\u0003`\u0001\u0011\u0005\u0001-A\u0005d_6\u0004\u0018M]3U_R\u0011\u0011\r\u001a\t\u0003\u001b\tL!a\u0019\b\u0003\u0007%sG\u000fC\u0003f=\u0002\u0007!(A\u0003pi\",'\u000fC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0005jg\n+gm\u001c:f)\t\u0011\u0015\u000eC\u0003fM\u0002\u0007!\bC\u0003l\u0001\u0011\u0005A.A\u0004jg\u00063G/\u001a:\u0015\u0005\tk\u0007\"B3k\u0001\u0004Q\u0004\"B8\u0001\t\u0003\u0001\u0018aB4fi\"{WO]\u000b\u0002C\")!\u000f\u0001C\u0001a\u0006Iq-\u001a;NS:,H/\u001a\u0005\u0006i\u0002!\t\u0001]\u0001\nO\u0016$8+Z2p]\u0012DQA\u001e\u0001\u0005\u0002A\fqcZ3u\u001f\u001a47/\u001a;J]R{G/\u00197TK\u000e|g\u000eZ:\t\u000ba\u0004A\u0011A=\u0002\u0013\u001d,GOW8oK&#W#\u0001>\u0011\u00075\u00014\u0010E\u0002}\u0003\u000fq1!`A\u0002!\tqh\"D\u0001\u0000\u0015\r\t\tAC\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015a\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bq\u0001bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\bE\u0016$x/Z3o)\u0011\t\u0019\"!\u0007\u0011\u0007q\t)\"C\u0002\u0002\u0018u\u0011\u0001\u0002R;sCRLwN\u001c\u0005\u0007K\u00065\u0001\u0019\u0001\u001e\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 \u00051am\u001c:nCR,\u0012a\u001f\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003!9\u0018\u000e\u001e5ECR,G\u0003BA\u0014\u0003[\u00012\u0001HA\u0015\u0013\r\tY#\b\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\t\u0011\u0005=\u0012\u0011\u0005a\u0001\u0003c\tA\u0001Z1uKB\u0019A$a\r\n\u0007\u0005URDA\u0005M_\u000e\fG\u000eR1uK\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012\u0001\u0004;p\u001f\u001a47/\u001a;US6,WCAA\u001f!\ra\u0012qH\u0005\u0004\u0003\u0003j\"AC(gMN,G\u000fV5nK\"1\u0011Q\t\u0001\u0005\u0002i\t1\u0002^8M_\u000e\fG\u000eV5nK\"I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00111J\u0001\u0005G>\u0004\u0018\u0010F\u0004;\u0003\u001b\ny%!\u0015\t\u0011e\t9\u0005%AA\u0002mA\u0001\"JA$!\u0003\u0005\ra\n\u0005\t[\u0005\u001d\u0003\u0013!a\u0001_!I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011qK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIFK\u0002\u001c\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Or\u0011AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003_\u0002\u0011\u0013!C\u0001\u0003c\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002t)\u001aq%a\u0017\t\u0013\u0005]\u0004!%A\u0005\u0002\u0005e\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003wR3aLA.\u0011%\ty\bAA\u0001\n\u0003\n\t)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013s\u0012\u0001\u00027b]\u001eLA!!\u0003\u0002\b\"A\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0001/\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAL\u0003;\u00032!DAM\u0013\r\tYJ\u0004\u0002\u0004\u0003:L\b\"CAP\u0003#\u000b\t\u00111\u0001b\u0003\rAH%\r\u0005\n\u0003G\u0003\u0011\u0011!C!\u0003K\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0003b!!+\u00020\u0006]UBAAV\u0015\r\tiKD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAY\u0003W\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003k\u0003\u0011\u0011!C\u0001\u0003o\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0005\u0006e\u0006BCAP\u0003g\u000b\t\u00111\u0001\u0002\u0018\"I\u0011Q\u0018\u0001\u0002\u0002\u0013\u0005\u0013qX\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011\rC\u0005\u0002D\u0002\t\t\u0011\"\u0011\u0002F\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0004\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00131Z\u0001\u0007KF,\u0018\r\\:\u0015\u0007\t\u000bi\r\u0003\u0006\u0002 \u0006\u001d\u0017\u0011!a\u0001\u0003/;q!!5\u0003\u0011\u0003\t\u0019.A\u0005[_:,G\rV5nKB\u00191(!6\u0007\r\u0005\u0011\u0001\u0012AAl'\u0011\t)\u000eD\u000b\t\u000fa\n)\u000e\"\u0001\u0002\\R\u0011\u00111\u001b\u0005\n\u0003?\f)N1A\u0005\u0002%\u000b\u0001CT!O\u001fN{\u0006+\u0012*`'\u0016\u001buJ\u0014#\t\u0011\u0005\r\u0018Q\u001bQ\u0001\n)\u000b\u0011CT!O\u001fN{\u0006+\u0012*`'\u0016\u001buJ\u0014#!\u0011)\t9/!6C\u0002\u0013\u0005\u0011\u0011^\u0001\u0010_\u001a47/\u001a;G_Jl\u0017\r\u001e;feV\u0011\u00111\u001e\t\u0005\u0003[\f\t0\u0004\u0002\u0002p*\u0019\u0011QD\u000f\n\t\u0005M\u0018q\u001e\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b\"CA|\u0003+\u0004\u000b\u0011BAv\u0003AygMZ:fi\u001a{'/\\1ui\u0016\u0014\b\u0005\u0003\u0005\u0002|\u0006UG\u0011AA\u007f\u0003\u0015\u0001\u0018M]:f)\rQ\u0014q \u0005\u00073\u0005e\b\u0019A>\t\u0011\t\r\u0011Q\u001bC\u0001\u0005\u000b\t!a\u001c4\u0015\u000bi\u00129A!\u0003\t\re\u0011\t\u00011\u0001\u001c\u0011\u0019)#\u0011\u0001a\u0001O!A!1AAk\t\u0003\u0011i\u0001F\u0002;\u0005\u001fA\u0001B!\u0005\u0003\f\u0001\u0007\u0011QH\u0001\u000b_\u001a47/\u001a;US6,\u0007\u0002\u0003B\u0002\u0003+$\tA!\u0006\u0015\u0007i\u00129\u0002\u0003\u0005\u0003\u001a\tM\u0001\u0019AA\u0014\u0003!!\u0017\r^3US6,\u0007\u0002CA\b\u0003+$\tA!\b\u0015\r\u0005M!q\u0004B\u0012\u0011\u001d\u0011\tCa\u0007A\u0002i\n\u0011\u0001\u001f\u0005\b\u0005K\u0011Y\u00021\u0001;\u0003\u0005I\bB\u0003B\u0015\u0003+\f\t\u0011\"!\u0003,\u0005)\u0011\r\u001d9msR9!H!\f\u00030\tE\u0002BB\r\u0003(\u0001\u00071\u0004\u0003\u0004&\u0005O\u0001\ra\n\u0005\u0007[\t\u001d\u0002\u0019A\u0018\t\u0015\tU\u0012Q[A\u0001\n\u0003\u00139$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\te\"\u0011\t\t\u0005\u001bA\u0012Y\u0004\u0005\u0004\u000e\u0005{YreL\u0005\u0004\u0005\u007fq!A\u0002+va2,7\u0007C\u0005\u0003D\tM\u0012\u0011!a\u0001u\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u001d\u0013Q[A\u0001\n\u0013\u0011I%A\u0006sK\u0006$'+Z:pYZ,GC\u0001B&!\u0011\t)I!\u0014\n\t\t=\u0013q\u0011\u0002\u0007\u001f\nTWm\u0019;")
public class ZonedTime
implements Product,
scala.Serializable {
    private final LocalTime time;
    private final ZoneOffset offset;
    private final Option<ZoneId> zone;
    private final boolean hasTimeZone;
    private final long nanos;

    public static Option<Tuple3<LocalTime, ZoneOffset, Option<ZoneId>>> unapply(ZonedTime zonedTime) {
        return ZonedTime$.MODULE$.unapply(zonedTime);
    }

    public static ZonedTime apply(LocalTime localTime, ZoneOffset zoneOffset, Option<ZoneId> option) {
        return ZonedTime$.MODULE$.apply(localTime, zoneOffset, option);
    }

    public static ZonedTime of(ZonedDateTime zonedDateTime) {
        return ZonedTime$.MODULE$.of(zonedDateTime);
    }

    public static ZonedTime of(OffsetTime offsetTime) {
        return ZonedTime$.MODULE$.of(offsetTime);
    }

    public static ZonedTime of(LocalTime localTime, ZoneOffset zoneOffset) {
        return ZonedTime$.MODULE$.of(localTime, zoneOffset);
    }

    public static ZonedTime parse(String string) {
        return ZonedTime$.MODULE$.parse(string);
    }

    public static DateTimeFormatter offsetFormatter() {
        return ZonedTime$.MODULE$.offsetFormatter();
    }

    public static long NANOS_PER_SECOND() {
        return ZonedTime$.MODULE$.NANOS_PER_SECOND();
    }

    public LocalTime time() {
        return this.time;
    }

    public ZoneOffset offset() {
        return this.offset;
    }

    public Option<ZoneId> zone() {
        return this.zone;
    }

    public boolean hasTimeZone() {
        return this.hasTimeZone;
    }

    public long nanos() {
        return this.nanos;
    }

    public ZonedTime plus(TemporalAmount amountToAdd) {
        LocalTime newTime = this.time().plus(amountToAdd);
        return new ZonedTime(newTime, this.offset(), this.zone());
    }

    public ZonedTime minus(TemporalAmount amountToAdd) {
        LocalTime newTime = this.time().minus(amountToAdd);
        return new ZonedTime(newTime, this.offset(), this.zone());
    }

    public int compareTo(ZonedTime other) {
        return new RichLong(Predef$.MODULE$.longWrapper(this.nanos())).compare(BoxesRunTime.boxToLong(other.nanos()));
    }

    public boolean isBefore(ZonedTime other) {
        return this.nanos() < other.nanos();
    }

    public boolean isAfter(ZonedTime other) {
        return this.nanos() > other.nanos();
    }

    public int getHour() {
        return this.time().getHour();
    }

    public int getMinute() {
        return this.time().getMinute();
    }

    public int getSecond() {
        return this.time().getSecond();
    }

    public int getOffsetInTotalSeconds() {
        return this.offset().getTotalSeconds();
    }

    public Option<String> getZoneId() {
        return this.zone().map((Function1<ZoneId, String> & Serializable & scala.Serializable)x$1 -> x$1.getId());
    }

    public Duration between(ZonedTime other) {
        long diff = RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this.nanos() - other.nanos()));
        return Duration.ofNanos(diff);
    }

    public String format() {
        String string;
        String localTime = package$.MODULE$.localTimeFormatter().format(this.time());
        if (this.hasTimeZone()) {
            String zoneId = this.zone().get().getId();
            string = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "@", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{localTime, zoneId}));
        } else {
            string = localTime + ZonedTime$.MODULE$.offsetFormatter().format(this.offset());
        }
        return string;
    }

    public ZonedDateTime withDate(LocalDate date) {
        LocalDateTime localDateTime = date.atTime(this.time());
        return this.hasTimeZone() ? localDateTime.atZone(this.zone().get()) : localDateTime.atOffset(this.offset()).toZonedDateTime();
    }

    public OffsetTime toOffsetTime() {
        return this.time().atOffset(this.offset());
    }

    public LocalTime toLocalTime() {
        return this.time();
    }

    public ZonedTime copy(LocalTime time, ZoneOffset offset, Option<ZoneId> zone) {
        return new ZonedTime(time, offset, zone);
    }

    public LocalTime copy$default$1() {
        return this.time();
    }

    public ZoneOffset copy$default$2() {
        return this.offset();
    }

    public Option<ZoneId> copy$default$3() {
        return this.zone();
    }

    @Override
    public String productPrefix() {
        return "ZonedTime";
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public Object productElement(int x$1) {
        Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.time();
                break;
            }
            case 1: {
                serializable = this.offset();
                break;
            }
            case 2: {
                serializable = this.zone();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return serializable;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof ZonedTime;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ZonedTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        ZonedTime zonedTime = (ZonedTime)x$1;
        LocalTime localTime = this.time();
        LocalTime localTime2 = zonedTime.time();
        if (localTime == null) {
            if (localTime2 != null) {
                return false;
            }
        } else if (!((Object)localTime).equals(localTime2)) return false;
        ZoneOffset zoneOffset = this.offset();
        ZoneOffset zoneOffset2 = zonedTime.offset();
        if (zoneOffset == null) {
            if (zoneOffset2 != null) {
                return false;
            }
        } else if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
        Option<ZoneId> option = this.zone();
        Option<ZoneId> option2 = zonedTime.zone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!zonedTime.canEqual(this)) return false;
        return true;
    }

    public ZonedTime(LocalTime time, ZoneOffset offset, Option<ZoneId> zone) {
        this.time = time;
        this.offset = offset;
        this.zone = zone;
        Product.$init$(this);
        this.hasTimeZone = zone.isDefined();
        long nod = time.toNanoOfDay();
        long offsetNanos = (long)offset.getTotalSeconds() * ZonedTime$.MODULE$.NANOS_PER_SECOND();
        this.nanos = nod - offsetNanos;
    }
}

