/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql;

import javax.servlet.Filter;
import org.camunda.bpm.extension.graphql.auth.JWTAuthenticationFilter;
import org.camunda.bpm.extension.graphql.auth.ProcessEngineAuthenticationFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class FilterConfiguration {
    @Value(value="${JWT.secret}")
    private String secret;
    @Value(value="${JWT.issuer}")
    private String issuer;

    @Bean
    @ConditionalOnProperty(name={"auth.Filter"}, havingValue="JWT")
    public FilterRegistrationBean JWTFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        JWTAuthenticationFilter jwtAuthenticationFilter = new JWTAuthenticationFilter();
        registration.setFilter((Filter)jwtAuthenticationFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.addInitParameter("secret", this.secret);
        registration.addInitParameter("issuer", this.issuer);
        registration.setName("JWT-Auth");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"auth.Filter"}, havingValue="BASIC")
    public FilterRegistrationBean someFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        ProcessEngineAuthenticationFilter graphqlAuth = new ProcessEngineAuthenticationFilter();
        registration.setFilter((Filter)graphqlAuth);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.addInitParameter("authentication-provider", "org.camunda.bpm.extension.graphql.auth.impl.HttpBasicAuthenticationProvider");
        registration.setName("Basic-Auth");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }
}

