/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.extension.graphql.auth.ErrorResponse;

public class JWTAuthenticationFilter
implements Filter {
    private String secret;
    private String issuer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.secret = filterConfig.getInitParameter("secret");
        this.issuer = filterConfig.getInitParameter("issuer");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        ObjectMapper mapper = new ObjectMapper();
        String header = req.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            ErrorResponse error = new ErrorResponse(400, "No JWT token found in request header");
            resp.setStatus(400);
            resp.getWriter().write(mapper.writeValueAsString((Object)error));
        } else {
            String token = header.substring(7);
            try {
                Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(this.issuer).build();
                DecodedJWT jwt = verifier.verify(token);
                System.out.print(jwt);
                chain.doFilter(request, response);
            }
            catch (JWTVerificationException exception) {
                ErrorResponse error = new ErrorResponse(401, exception.getMessage());
                resp.setStatus(401);
                resp.getWriter().write(mapper.writeValueAsString((Object)error));
            }
        }
    }
}

