/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.extension.graphql.auth.AuthenticationProvider;
import org.camunda.bpm.extension.graphql.auth.AuthenticationResult;

public class ProcessEngineAuthenticationFilter
implements Filter {
    public static final String AUTHENTICATION_PROVIDER_PARAM = "authentication-provider";
    protected AuthenticationProvider authenticationProvider;

    public void init(FilterConfig filterConfig) throws ServletException {
        String authenticationProviderClassName = filterConfig.getInitParameter(AUTHENTICATION_PROVIDER_PARAM);
        if (authenticationProviderClassName == null) {
            throw new ServletException("Cannot instantiate authentication filter: no authentication provider set. init-param authentication-provider missing");
        }
        try {
            Class<?> authenticationProviderClass = Class.forName(authenticationProviderClassName);
            this.authenticationProvider = (AuthenticationProvider)authenticationProviderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Cannot instantiate authentication filter: authentication provider not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException("Cannot instantiate authentication filter: cannot instantiate authentication provider", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Cannot instantiate authentication filter: constructor not accessible", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new ServletException("Cannot instantiate authentication filter: authentication provider does not implement interface " + AuthenticationProvider.class.getName(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        ProcessEngine engine = BpmPlatform.getDefaultProcessEngine();
        if (engine == null) {
            engine = ProcessEngines.getDefaultProcessEngine((boolean)false);
        }
        if (engine == null) {
            resp.setStatus(Response.Status.NOT_FOUND.getStatusCode());
            String errMessage = "Default Process engine not available";
            ObjectMapper objectMapper = new ObjectMapper();
            resp.setContentType("application/json");
            objectMapper.writer().writeValue((Writer)resp.getWriter(), (Object)errMessage);
            resp.getWriter().flush();
            return;
        }
        AuthenticationResult authenticationResult = this.authenticationProvider.extractAuthenticatedUser(req, engine);
        if (authenticationResult.isAuthenticated()) {
            try {
                this.setAuthenticatedUser(engine, authenticationResult.getAuthenticatedUser());
                chain.doFilter(request, response);
            }
            finally {
                this.clearAuthentication(engine);
            }
        } else {
            resp.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            this.authenticationProvider.augmentResponseByAuthenticationChallenge(resp, engine);
        }
    }

    public void destroy() {
    }

    protected void setAuthenticatedUser(ProcessEngine engine, String userId) {
        List groupIds = this.getGroupsOfUser(engine, userId);
        List tenantIds = this.getTenantsOfUser(engine, userId);
        engine.getIdentityService().setAuthentication(userId, groupIds, tenantIds);
    }

    protected List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    protected void clearAuthentication(ProcessEngine engine) {
        engine.getIdentityService().clearAuthentication();
    }
}

