/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLRootResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Mutation
implements GraphQLRootResolver {
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    TaskService taskService;
    @Autowired
    RuntimeService runtimeService;

    public Task setAssignee(String taskEntityId, String assignee) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskEntityId).singleResult();
        task.setAssignee(assignee);
        this.taskService.saveTask(task);
        return task;
    }

    public ProcessInstance createProcessInstance(String processDefintionKey, ArrayList<LinkedHashMap> variables) {
        if (variables != null) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(processDefintionKey, this.getVariablesMap(variables));
            return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        }
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(processDefintionKey);
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
    }

    public Task claimTask(String taskId, String userId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        this.taskService.claim(taskId, userId);
        return task;
    }

    public ProcessInstance completeTask(String taskId, ArrayList<LinkedHashMap> variables) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String piId = task.getProcessInstanceId();
        if (variables != null) {
            this.taskService.complete(taskId, this.getVariablesMap(variables));
        } else {
            this.taskService.complete(taskId);
        }
        if (piId != null) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
            return pi;
        }
        return null;
    }

    public ProcessInstance startProcessInstanceByKey(String key) {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(key);
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
    }

    private Map<String, Object> getVariablesMap(ArrayList<LinkedHashMap> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        block16: for (LinkedHashMap i : variables) {
            switch (i.get("valueType").toString()) {
                case "String": {
                    map.put(i.get("key").toString(), i.get("value"));
                    continue block16;
                }
                case "Int": {
                    map.put(i.get("key").toString(), Integer.parseInt(i.get("value").toString()));
                    continue block16;
                }
                case "Long": {
                    map.put(i.get("key").toString(), Long.parseLong(i.get("value").toString()));
                    continue block16;
                }
                case "Float": {
                    map.put(i.get("key").toString(), Float.valueOf(Float.parseFloat(i.get("value").toString())));
                    continue block16;
                }
                case "Double": {
                    map.put(i.get("key").toString(), Double.parseDouble(i.get("value").toString()));
                    continue block16;
                }
                case "Boolean": {
                    map.put(i.get("key").toString(), Boolean.parseBoolean(i.get("value").toString()));
                    continue block16;
                }
            }
            map.put(i.get("key").toString(), i.get("value"));
        }
        return map;
    }
}

