/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import java.util.Collection;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessDefinitionEntityResolver
implements GraphQLResolver<ProcessDefinitionEntity> {
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    RepositoryService repositoryService;

    public String startFormKey(ProcessDefinition processDefinition) {
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinition.getId());
        Collection startEvents = bpmnModelInstance.getModelElementsByType(StartEvent.class);
        StartEvent startEvent = (StartEvent)startEvents.iterator().next();
        String formKey = startEvent.getCamundaFormKey();
        return formKey;
    }

    public String contextPath(ProcessDefinition processDefinition) {
        String pdid = processDefinition.getId();
        if (pdid != null) {
            String contextPath = ApplicationContextPathUtil.getApplicationPathByProcessDefinitionId((ProcessEngine)this.processEngine, (String)pdid);
            return contextPath;
        }
        return null;
    }
}

