/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLRootResolver;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.application.ProcessApplicationContext;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.extension.graphql.resolvers.Util;
import org.camunda.bpm.extension.graphql.types.KeyValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Query
implements GraphQLRootResolver {
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    TaskService taskService;
    @Autowired
    RuntimeService runtimeService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    IdentityService identityService;
    @Autowired
    ProcessEngineConfigurationImpl processEngineConfiguration;

    public List<Task> tasks(String assignee, String name, String nameLike) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        taskQuery = assignee != null ? taskQuery.taskAssignee(assignee) : taskQuery;
        taskQuery = name != null ? taskQuery.taskName(name) : taskQuery;
        taskQuery = nameLike != null ? taskQuery.taskNameLike(nameLike) : taskQuery;
        taskQuery.initializeFormKeys();
        List tasks = taskQuery.list();
        return tasks;
    }

    public Task task(String id) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        taskQuery = taskQuery.taskId(id);
        taskQuery.initializeFormKeys();
        Task task = (Task)taskQuery.singleResult();
        return task;
    }

    public List<ProcessInstance> processInstances(String businessKey) {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        processInstanceQuery = businessKey != null ? processInstanceQuery.processInstanceBusinessKey(businessKey) : processInstanceQuery;
        List processInstances = processInstanceQuery.list();
        return processInstances;
    }

    public List<ProcessDefinition> processDefinitions(Boolean isSuspended, Boolean latest) {
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        processDefinitionQuery = isSuspended != null && isSuspended == true ? processDefinitionQuery.suspended() : processDefinitionQuery;
        processDefinitionQuery = latest != null && latest == true ? processDefinitionQuery.latestVersion() : processDefinitionQuery;
        List processDefinitionList = processDefinitionQuery.list();
        return processDefinitionList;
    }

    public ProcessDefinition processDefinition(String id) {
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.processDefinitionId(id).singleResult();
        return processDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValuePair> taskVariables(String taskId, Collection<String> names) {
        List keyValuePairs;
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String pdid = task.getProcessDefinitionId();
        if (pdid == null) {
            return null;
        }
        try {
            Util.switchContext((RepositoryService)this.repositoryService, (String)pdid, (ProcessEngineConfigurationImpl)this.processEngineConfiguration);
            VariableMap variableMap = this.taskService.getVariablesTyped(taskId, names, true);
            keyValuePairs = Util.getKeyValuePairs((VariableMap)variableMap);
        }
        finally {
            ProcessApplicationContext.clear();
        }
        return keyValuePairs;
    }

    public List<Group> groups(String groupName, String groupNameLike, String groupType) {
        GroupQuery query = this.identityService.createGroupQuery();
        query = groupName != null ? query.groupName(groupName) : query;
        query = groupNameLike != null ? query.groupNameLike(groupNameLike) : query;
        query = groupType != null ? query.groupType(groupType) : query;
        List groups = query.list();
        return groups;
    }

    public Group group(String groupId) {
        if (groupId != null) {
            Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
            return group;
        }
        return null;
    }

    public List<User> users(String firstName, String firstNameLike, String groupId) {
        UserQuery query = this.identityService.createUserQuery();
        query = firstName != null ? query.userFirstName(firstName) : query;
        query = firstNameLike != null ? query.userFirstNameLike(firstNameLike) : query;
        query = groupId != null ? query.memberOfGroup(groupId) : query;
        List users = query.list();
        return users;
    }

    public User user(String userId) {
        if (userId != null) {
            User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
            return user;
        }
        return null;
    }
}

