/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import java.util.List;
import org.camunda.bpm.application.ProcessApplicationContext;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.extension.graphql.resolvers.Util;
import org.camunda.bpm.extension.graphql.types.KeyValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskEntityResolver
implements GraphQLResolver<TaskEntity> {
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    TaskService taskService;
    @Autowired
    RuntimeService runtimeService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    ProcessEngineConfigurationImpl processEngineConfiguration;
    @Autowired
    IdentityService identityService;

    public ProcessDefinition processDefinition(TaskEntity taskEntity) {
        String pdid = taskEntity.getProcessDefinitionId();
        if (pdid == null) {
            return null;
        }
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(pdid);
        return processDefinition;
    }

    public ProcessInstance processInstance(TaskEntity taskEntity) {
        String piId = taskEntity.getProcessInstanceId();
        if (piId == null) {
            return null;
        }
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
        return pi;
    }

    public ExecutionEntity executionEntity(TaskEntity taskEntity) {
        String executionId = taskEntity.getExecutionId();
        if (executionId == null) {
            return null;
        }
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
        return (ExecutionEntity)execution;
    }

    public User assignee(TaskEntity taskEntity) {
        String userId = taskEntity.getAssignee();
        if (userId == null) {
            return null;
        }
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        return user;
    }

    public String contextPath(TaskEntity taskEntity) {
        String pdid = taskEntity.getProcessDefinitionId();
        if (pdid == null) {
            return null;
        }
        String contextPath = ApplicationContextPathUtil.getApplicationPathByProcessDefinitionId((ProcessEngine)this.processEngine, (String)taskEntity.getProcessDefinitionId());
        return contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValuePair> variables(TaskEntity taskEntity) {
        List keyValuePairs;
        String pdid = taskEntity.getProcessDefinitionId();
        if (pdid == null) {
            return null;
        }
        try {
            Util.switchContext((RepositoryService)this.repositoryService, (String)pdid, (ProcessEngineConfigurationImpl)this.processEngineConfiguration);
            VariableMap variableMap = this.taskService.getVariablesTyped(taskEntity.getId(), true);
            keyValuePairs = Util.getKeyValuePairs((VariableMap)variableMap);
        }
        finally {
            ProcessApplicationContext.clear();
        }
        return keyValuePairs;
    }
}

