/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.extension.migration.ProcessDefinitionFinder;
import org.camunda.bpm.extension.migration.plan.MigrationPlan;
import org.camunda.bpm.extension.migration.plan.step.StepExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger log = LoggerFactory.getLogger(Migrator.class);
    private ProcessEngine processEngine;

    public Migrator(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void migrate(MigrationPlan plan) {
        ProcessDefinitionFinder processDefinitionFinder = new ProcessDefinitionFinder(this.processEngine.getRepositoryService());
        ProcessDefinition sourceProcessDefinition = processDefinitionFinder.find(plan.getFrom()).orElseThrow(() -> new RuntimeException("Source process definition not found!"));
        ProcessDefinition targetProcessDefinition = processDefinitionFinder.find(plan.getTo()).orElseThrow(() -> new RuntimeException("Destination process definition not found!"));
        List processInstances = this.processEngine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId()).active().list();
        log.info("migrating {} process instance(s)", (Object)processInstances.size());
        processInstances.stream().map(Execution::getId).peek(processInstanceId -> log.info("migrating process instance ID {}", processInstanceId)).map(processInstanceId -> StepExecutionContext.builder().processEngine(this.processEngine).sourceProcessDefinitionId(sourceProcessDefinition.getId()).targetProcessDefinitionId(targetProcessDefinition.getId()).processInstanceId((String)processInstanceId).build()).forEach(stepExecutionContext -> {
            plan.getSteps().forEach(step -> step.prepare((StepExecutionContext)stepExecutionContext));
            plan.getSteps().forEach(step -> step.perform((StepExecutionContext)stepExecutionContext));
        });
    }
}

