/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.extension.migration.plan.DeploymentSpec;
import org.camunda.bpm.extension.migration.plan.ProcessDefinitionSpec;

public class ProcessDefinitionFinder {
    private final RepositoryService repositoryService;

    public ProcessDefinitionFinder(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Optional<ProcessDefinition> find(ProcessDefinitionSpec spec) {
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        this.add(processDefinitionQuery, ProcessDefinitionQuery::processDefinitionKey, spec.getProcessDefinitionKey());
        this.add(processDefinitionQuery, ProcessDefinitionQuery::versionTag, spec.getVersionTag());
        this.add(processDefinitionQuery, ProcessDefinitionQuery::processDefinitionVersion, spec.getProcessDefinitionVersion());
        if (spec.getDeploymentSpec() != null) {
            Optional<Deployment> deployment = this.findDeployment(spec.getDeploymentSpec());
            if (!deployment.isPresent()) {
                return Optional.empty();
            }
            this.add(processDefinitionQuery, ProcessDefinitionQuery::deploymentId, deployment.get(), Deployment::getId);
        }
        return Optional.ofNullable(processDefinitionQuery.singleResult());
    }

    private Optional<Deployment> findDeployment(DeploymentSpec spec) {
        return Optional.ofNullable(this.createDeploymentQuery(spec).singleResult());
    }

    /*
     * Exception decompiling
     */
    private DeploymentQuery createDeploymentQuery(DeploymentSpec spec) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <S> void add(DeploymentQuery query, BiFunction<DeploymentQuery, S, DeploymentQuery> setter, S specValue) {
        this.add(query, setter, specValue, Function.identity());
    }

    private <S, Q> void add(DeploymentQuery query, BiFunction<DeploymentQuery, Q, DeploymentQuery> setter, S specValue, Function<S, Q> conversion) {
        if (specValue != null) {
            setter.apply(query, conversion.apply(specValue));
        }
    }

    private <S> void add(ProcessDefinitionQuery query, BiFunction<ProcessDefinitionQuery, S, ProcessDefinitionQuery> setter, S specValue) {
        this.add(query, setter, specValue, Function.identity());
    }

    private <S, Q> void add(ProcessDefinitionQuery query, BiFunction<ProcessDefinitionQuery, Q, ProcessDefinitionQuery> setter, S specValue, Function<S, Q> conversion) {
        if (specValue != null) {
            setter.apply(query, conversion.apply(specValue));
        }
    }

    private <A, B, C> Function<A, C> chain(Function<A, B> f1, Function<B, C> f2) {
        return f1.andThen(f2);
    }
}

