/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.camunda.bpm.extension.migration.plan.ProcessDefinitionSpec;
import org.camunda.bpm.extension.migration.plan.step.Step;

public class MigrationPlan {
    @NonNull
    private ProcessDefinitionSpec from;
    @NonNull
    private ProcessDefinitionSpec to;
    @NonNull
    private List<Step> steps;

    MigrationPlan(@NonNull ProcessDefinitionSpec from, @NonNull ProcessDefinitionSpec to, @NonNull List<Step> steps) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (to == null) {
            throw new NullPointerException("to");
        }
        if (steps == null) {
            throw new NullPointerException("steps");
        }
        this.from = from;
        this.to = to;
        this.steps = steps;
    }

    public static MigrationPlanBuilder builder() {
        return new MigrationPlanBuilder();
    }

    @NonNull
    public ProcessDefinitionSpec getFrom() {
        return this.from;
    }

    @NonNull
    public ProcessDefinitionSpec getTo() {
        return this.to;
    }

    @NonNull
    public List<Step> getSteps() {
        return this.steps;
    }

    public void setFrom(@NonNull ProcessDefinitionSpec from) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        this.from = from;
    }

    public void setTo(@NonNull ProcessDefinitionSpec to) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.to = to;
    }

    public void setSteps(@NonNull List<Step> steps) {
        if (steps == null) {
            throw new NullPointerException("steps");
        }
        this.steps = steps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationPlan)) {
            return false;
        }
        MigrationPlan other = (MigrationPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessDefinitionSpec this$from = this.getFrom();
        ProcessDefinitionSpec other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        ProcessDefinitionSpec this$to = this.getTo();
        ProcessDefinitionSpec other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrationPlan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessDefinitionSpec $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        ProcessDefinitionSpec $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }

    public String toString() {
        return "MigrationPlan(from=" + this.getFrom() + ", to=" + this.getTo() + ", steps=" + this.getSteps() + ")";
    }

    public static class MigrationPlanBuilder {
        private ProcessDefinitionSpec from;
        private ProcessDefinitionSpec to;
        private ArrayList<Step> steps;

        MigrationPlanBuilder() {
        }

        public MigrationPlanBuilder from(ProcessDefinitionSpec from) {
            this.from = from;
            return this;
        }

        public MigrationPlanBuilder to(ProcessDefinitionSpec to) {
            this.to = to;
            return this;
        }

        public MigrationPlanBuilder step(Step step) {
            if (this.steps == null) {
                this.steps = new ArrayList();
            }
            this.steps.add(step);
            return this;
        }

        public MigrationPlanBuilder steps(Collection<? extends Step> steps) {
            if (this.steps == null) {
                this.steps = new ArrayList();
            }
            this.steps.addAll(steps);
            return this;
        }

        public MigrationPlanBuilder clearSteps() {
            if (this.steps != null) {
                this.steps.clear();
            }
            return this;
        }

        public MigrationPlan build() {
            List<Step> steps;
            switch (this.steps == null ? 0 : this.steps.size()) {
                case 0: {
                    steps = Collections.emptyList();
                    break;
                }
                case 1: {
                    steps = Collections.singletonList(this.steps.get(0));
                    break;
                }
                default: {
                    steps = Collections.unmodifiableList(new ArrayList<Step>(this.steps));
                }
            }
            return new MigrationPlan(this.from, this.to, steps);
        }

        public String toString() {
            return "MigrationPlan.MigrationPlanBuilder(from=" + this.from + ", to=" + this.to + ", steps=" + this.steps + ")";
        }
    }
}

