/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration.plan.step.variable;

import lombok.NonNull;
import org.camunda.bpm.extension.migration.plan.step.Step;
import org.camunda.bpm.extension.migration.plan.step.StepExecutionContext;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.DeleteStrategy;

public class VariableDeleteStep
implements Step {
    @NonNull
    private DeleteStrategy deleteStrategy;
    @NonNull
    private String variableName;

    @Override
    public void perform(StepExecutionContext context) {
        this.deleteStrategy.remove(context, this.variableName);
    }

    VariableDeleteStep(@NonNull DeleteStrategy deleteStrategy, @NonNull String variableName) {
        if (deleteStrategy == null) {
            throw new NullPointerException("deleteStrategy");
        }
        if (variableName == null) {
            throw new NullPointerException("variableName");
        }
        this.deleteStrategy = deleteStrategy;
        this.variableName = variableName;
    }

    public static VariableDeleteStepBuilder builder() {
        return new VariableDeleteStepBuilder();
    }

    public void setVariableName(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName");
        }
        this.variableName = variableName;
    }

    @NonNull
    public String getVariableName() {
        return this.variableName;
    }

    public static class VariableDeleteStepBuilder {
        private DeleteStrategy deleteStrategy;
        private String variableName;

        VariableDeleteStepBuilder() {
        }

        public VariableDeleteStepBuilder deleteStrategy(DeleteStrategy deleteStrategy) {
            this.deleteStrategy = deleteStrategy;
            return this;
        }

        public VariableDeleteStepBuilder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public VariableDeleteStep build() {
            return new VariableDeleteStep(this.deleteStrategy, this.variableName);
        }

        public String toString() {
            return "VariableDeleteStep.VariableDeleteStepBuilder(deleteStrategy=" + this.deleteStrategy + ", variableName=" + this.variableName + ")";
        }
    }
}

