/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration.plan.step.variable;

import java.util.Optional;
import lombok.NonNull;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.extension.migration.plan.step.Step;
import org.camunda.bpm.extension.migration.plan.step.StepExecutionContext;
import org.camunda.bpm.extension.migration.plan.step.variable.Conversion;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.ReadStrategy;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.WriteStrategy;

public class VariableStep
implements Step {
    @NonNull
    private ReadStrategy readStrategy;
    @NonNull
    private WriteStrategy writeStrategy;
    @NonNull
    private String sourceVariableName;
    private String targetVariableName;
    private Conversion conversion;
    private Optional<TypedValue> originalTypedValue;

    private VariableStep(ReadStrategy readStrategy, WriteStrategy writeStrategy, String sourceVariableName, String targetVariableName, Conversion conversion) {
        this.readStrategy = readStrategy;
        this.writeStrategy = writeStrategy;
        this.sourceVariableName = sourceVariableName;
        this.targetVariableName = targetVariableName;
        this.conversion = conversion;
    }

    @Override
    public void prepare(StepExecutionContext context) {
        this.originalTypedValue = this.readStrategy.read(context, this.sourceVariableName);
    }

    @Override
    public void perform(StepExecutionContext context) {
        this.originalTypedValue.map(this.converter()).ifPresent(value -> this.writeStrategy.write(context, this.targetVariableName(), (TypedValue)value));
        if (this.isRename()) {
            this.readStrategy.remove(context, this.sourceVariableName);
        }
    }

    private Conversion converter() {
        return this.conversion != null ? this.conversion : Conversion.ID;
    }

    private String targetVariableName() {
        return this.isRename() ? this.targetVariableName : this.sourceVariableName;
    }

    private boolean isRename() {
        return this.targetVariableName != null;
    }

    public static VariableStepBuilder builder() {
        return new VariableStepBuilder();
    }

    public void setSourceVariableName(@NonNull String sourceVariableName) {
        if (sourceVariableName == null) {
            throw new NullPointerException("sourceVariableName");
        }
        this.sourceVariableName = sourceVariableName;
    }

    @NonNull
    public String getSourceVariableName() {
        return this.sourceVariableName;
    }

    public void setTargetVariableName(String targetVariableName) {
        this.targetVariableName = targetVariableName;
    }

    public String getTargetVariableName() {
        return this.targetVariableName;
    }

    public void setConversion(Conversion conversion) {
        this.conversion = conversion;
    }

    public Conversion getConversion() {
        return this.conversion;
    }

    public static class VariableStepBuilder {
        private ReadStrategy readStrategy;
        private WriteStrategy writeStrategy;
        private String sourceVariableName;
        private String targetVariableName;
        private Conversion conversion;

        VariableStepBuilder() {
        }

        public VariableStepBuilder readStrategy(ReadStrategy readStrategy) {
            this.readStrategy = readStrategy;
            return this;
        }

        public VariableStepBuilder writeStrategy(WriteStrategy writeStrategy) {
            this.writeStrategy = writeStrategy;
            return this;
        }

        public VariableStepBuilder sourceVariableName(String sourceVariableName) {
            this.sourceVariableName = sourceVariableName;
            return this;
        }

        public VariableStepBuilder targetVariableName(String targetVariableName) {
            this.targetVariableName = targetVariableName;
            return this;
        }

        public VariableStepBuilder conversion(Conversion conversion) {
            this.conversion = conversion;
            return this;
        }

        public VariableStep build() {
            return new VariableStep(this.readStrategy, this.writeStrategy, this.sourceVariableName, this.targetVariableName, this.conversion);
        }

        public String toString() {
            return "VariableStep.VariableStepBuilder(readStrategy=" + this.readStrategy + ", writeStrategy=" + this.writeStrategy + ", sourceVariableName=" + this.sourceVariableName + ", targetVariableName=" + this.targetVariableName + ", conversion=" + this.conversion + ")";
        }
    }
}

