/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration.plan.step.variable.strategy;

import java.util.Optional;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.extension.migration.plan.step.StepExecutionContext;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.AbstractReadWriteStrategy;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.ReadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadProcessVariable
extends AbstractReadWriteStrategy
implements ReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadProcessVariable.class);

    @Override
    public Optional<TypedValue> read(StepExecutionContext stepExecutionContext, String variableName) {
        log.info("reading process variable {}", (Object)variableName);
        return Optional.ofNullable(this.getRuntimeService(stepExecutionContext).getVariableLocalTyped(stepExecutionContext.getProcessInstanceId(), variableName));
    }

    @Override
    public void remove(StepExecutionContext stepExecutionContext, String variableName) {
        log.info("removing process variable {}", (Object)variableName);
        this.getRuntimeService(stepExecutionContext).removeVariable(stepExecutionContext.getProcessInstanceId(), variableName);
    }
}

