/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration.plan.step.variable.strategy;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.NonNull;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.extension.migration.plan.step.StepExecutionContext;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.AbstractReadWriteStrategy;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.ReadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadTaskVariable
extends AbstractReadWriteStrategy
implements ReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadTaskVariable.class);
    @NonNull
    private final String taskDefinitionKey;

    @Override
    public Optional<TypedValue> read(StepExecutionContext stepExecutionContext, String variableName) {
        Optional<String> taskId = this.getTaskId(stepExecutionContext, this.taskDefinitionKey);
        return taskId.map(id -> {
            log.info("reading task variable {} from {} (ID:{})", new Object[]{variableName, this.taskDefinitionKey, id});
            return this.getTaskService(stepExecutionContext).getVariableLocalTyped(id, variableName);
        });
    }

    @Override
    public void remove(StepExecutionContext stepExecutionContext, String variableName) {
        Optional<String> taskId = this.getTaskId(stepExecutionContext, this.taskDefinitionKey);
        taskId.ifPresent(id -> {
            log.info("removing task variable {} from {} (ID:{})", new Object[]{variableName, this.taskDefinitionKey, id});
            this.getTaskService(stepExecutionContext).removeVariable(id, variableName);
        });
    }

    @ConstructorProperties(value={"taskDefinitionKey"})
    public ReadTaskVariable(@NonNull String taskDefinitionKey) {
        if (taskDefinitionKey == null) {
            throw new NullPointerException("taskDefinitionKey");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }
}

