/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.migration.plan.step.variable.strategy;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.NonNull;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.extension.migration.plan.step.StepExecutionContext;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.AbstractReadWriteStrategy;
import org.camunda.bpm.extension.migration.plan.step.variable.strategy.WriteStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteTaskVariable
extends AbstractReadWriteStrategy
implements WriteStrategy {
    private static final Logger log = LoggerFactory.getLogger(WriteTaskVariable.class);
    @NonNull
    private final String taskDefinitionKey;

    @Override
    public void write(StepExecutionContext stepExecutionContext, String variableName, TypedValue value) {
        Optional<String> taskExecutionId = this.getTaskId(stepExecutionContext, this.taskDefinitionKey);
        taskExecutionId.ifPresent(id -> {
            log.info("writing task variable {} with value {} to {} (ID:{})", new Object[]{variableName, value, this.taskDefinitionKey, id});
            this.getTaskService(stepExecutionContext).setVariableLocal(id, variableName, (Object)value);
        });
    }

    @ConstructorProperties(value={"taskDefinitionKey"})
    public WriteTaskVariable(@NonNull String taskDefinitionKey) {
        if (taskDefinitionKey == null) {
            throw new NullPointerException("taskDefinitionKey");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }
}

