/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito;

import java.net.URL;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.extension.mockito.Expressions;
import org.camunda.bpm.extension.mockito.function.NameForType;
import org.camunda.bpm.extension.mockito.function.ParseDelegateExpressions;
import org.camunda.bpm.extension.mockito.mock.FluentExecutionListenerMock;
import org.camunda.bpm.extension.mockito.mock.FluentJavaDelegateMock;
import org.camunda.bpm.extension.mockito.mock.FluentTaskListenerMock;
import org.camunda.bpm.extension.mockito.verify.ExecutionListenerVerification;
import org.camunda.bpm.extension.mockito.verify.JavaDelegateVerification;
import org.camunda.bpm.extension.mockito.verify.MockitoVerification;
import org.camunda.bpm.extension.mockito.verify.TaskListenerVerification;

public final class DelegateExpressions {
    private DelegateExpressions() {
    }

    public static void autoMock(@Nonnull String bpmnFileResource) {
        URL bpmn = DelegateExpressions.class.getResource(bpmnFileResource);
        if (bpmn == null && !bpmnFileResource.startsWith("/")) {
            DelegateExpressions.autoMock("/" + bpmnFileResource);
            return;
        }
        DelegateExpressions.autoMock(bpmn);
    }

    public static void autoMock(@Nonnull URL bpmnFile) {
        for (Pair<ParseDelegateExpressions.ExpressionType, String> pair : new ParseDelegateExpressions().apply(bpmnFile)) {
            ((ParseDelegateExpressions.ExpressionType)((Object)pair.getLeft())).registerMock((String)pair.getRight());
        }
    }

    public static FluentJavaDelegateMock registerJavaDelegateMock(String name) {
        return Expressions.registerInstance(name, new FluentJavaDelegateMock());
    }

    public static FluentJavaDelegateMock registerJavaDelegateMock(Class<? extends JavaDelegate> type) {
        return DelegateExpressions.registerJavaDelegateMock(NameForType.juelNameFor(type));
    }

    public static FluentExecutionListenerMock registerExecutionListenerMock(String name) {
        return Expressions.registerInstance(name, new FluentExecutionListenerMock());
    }

    public static FluentExecutionListenerMock registerExecutionListenerMock(Class<? extends ExecutionListener> type) {
        return DelegateExpressions.registerExecutionListenerMock(NameForType.juelNameFor(type));
    }

    public static FluentTaskListenerMock registerTaskListenerMock(String name) {
        return Expressions.registerInstance(name, new FluentTaskListenerMock());
    }

    public static FluentTaskListenerMock registerTaskListenerMock(Class<? extends TaskListener> type) {
        return DelegateExpressions.registerTaskListenerMock(NameForType.juelNameFor(type));
    }

    public static FluentJavaDelegateMock getJavaDelegateMock(String name) {
        return (FluentJavaDelegateMock)Expressions.getRegistered(name);
    }

    public static FluentJavaDelegateMock getJavaDelegateMock(Class<?> type) {
        return (FluentJavaDelegateMock)Expressions.getRegistered(type);
    }

    public static FluentExecutionListenerMock getExecutionListenerMock(String name) {
        return (FluentExecutionListenerMock)Expressions.getRegistered(name);
    }

    public static FluentExecutionListenerMock getExecutionListenerMock(Class<?> type) {
        return (FluentExecutionListenerMock)Expressions.getRegistered(type);
    }

    public static FluentTaskListenerMock getTaskListenerMock(String name) {
        return (FluentTaskListenerMock)Expressions.getRegistered(name);
    }

    public static FluentTaskListenerMock getTaskListenerMock(Class<?> type) {
        return (FluentTaskListenerMock)Expressions.getRegistered(type);
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(String name) {
        return DelegateExpressions.verifyJavaDelegateMock(DelegateExpressions.getJavaDelegateMock(name));
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(Class<?> type) {
        return DelegateExpressions.verifyJavaDelegateMock(DelegateExpressions.getJavaDelegateMock(type));
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(FluentJavaDelegateMock fluentJavaDelegateMock) {
        return new JavaDelegateVerification((JavaDelegate)fluentJavaDelegateMock.getMock());
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(String name) {
        return DelegateExpressions.verifyExecutionListenerMock(DelegateExpressions.getExecutionListenerMock(name));
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(Class<?> type) {
        return DelegateExpressions.verifyExecutionListenerMock(DelegateExpressions.getExecutionListenerMock(type));
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(FluentExecutionListenerMock fluentExecutionListenerMock) {
        return new ExecutionListenerVerification((ExecutionListener)fluentExecutionListenerMock.getMock());
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(String name) {
        return DelegateExpressions.verifyTaskListenerMock(DelegateExpressions.getTaskListenerMock(name));
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(Class<?> type) {
        return DelegateExpressions.verifyTaskListenerMock(DelegateExpressions.getTaskListenerMock(type));
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(FluentTaskListenerMock fluentTaskListenerMock) {
        return new TaskListenerVerification((TaskListener)fluentTaskListenerMock.getMock());
    }
}

