/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.delegate;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.extension.mockito.delegate.IncidentFake;
import org.camunda.bpm.extension.mockito.delegate.VariableScopeFake;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowElement;

public class DelegateExecutionFake
extends VariableScopeFake<DelegateExecutionFake>
implements DelegateExecution {
    private String processInstanceId;
    private ProcessEngineServices processEngineServices;
    private String processBusinessKey;
    private String processDefinitionId;
    private String parentId;
    private String currentActivityId;
    private String currentActivityName;
    private String activityInstanceId;
    private String parentActivityInstanceId;
    private String currentTransitionId;
    private DelegateExecution processInstance;
    private DelegateExecution superExecution;
    private boolean canceled;
    private String tenantId;
    private String id;
    private String eventName;
    private String businessKey;
    private final Map<String, Incident> incidents = new HashMap<String, Incident>();

    public DelegateExecutionFake() {
        this(null);
    }

    public DelegateExecutionFake(String id) {
        this.id = id;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public DelegateExecutionFake withProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public String getProcessBusinessKey() {
        return this.processBusinessKey;
    }

    public DelegateExecutionFake withProcessBusinessKey(String processBusinessKey) {
        this.processBusinessKey = processBusinessKey;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public DelegateExecutionFake withProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public String getParentId() {
        return this.parentId;
    }

    public DelegateExecutionFake withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String getCurrentActivityId() {
        return this.currentActivityId;
    }

    public DelegateExecutionFake withCurrentActivityId(String currentActivityId) {
        this.currentActivityId = currentActivityId;
        return this;
    }

    public String getCurrentActivityName() {
        return this.currentActivityName;
    }

    public DelegateExecutionFake withCurrentActivityName(String currentActivityName) {
        this.currentActivityName = currentActivityName;
        return this;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public DelegateExecutionFake withActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public String getParentActivityInstanceId() {
        return this.parentActivityInstanceId;
    }

    public DelegateExecutionFake withParentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
        return this;
    }

    public String getCurrentTransitionId() {
        return this.currentTransitionId;
    }

    public DelegateExecutionFake withCurrentTransitionId(String currentTransitionId) {
        this.currentTransitionId = currentTransitionId;
        return this;
    }

    public DelegateExecution getProcessInstance() {
        return this.processInstance;
    }

    public DelegateExecutionFake withProcessInstance(DelegateExecution processInstance) {
        this.processInstance = processInstance;
        return this;
    }

    public DelegateExecution getSuperExecution() {
        return this.superExecution;
    }

    public DelegateExecutionFake withSuperExecution(DelegateExecution superExecution) {
        this.superExecution = superExecution;
        return this;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public DelegateExecutionFake withCanceled(boolean canceled) {
        this.canceled = canceled;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public DelegateExecutionFake withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public void setVariable(String variableName, Object value, String activityId) {
        this.setVariable(variableName, value);
    }

    public Incident createIncident(String incidentType, String configuration) {
        return this.createIncident(incidentType, configuration, null);
    }

    public Incident createIncident(String incidentType, String configuration, String message) {
        IncidentFake incident = new IncidentFake(this, incidentType, configuration, message, this.getCurrentActivityId());
        this.incidents.put(incident.getId(), incident);
        return incident;
    }

    public void resolveIncident(String incidentId) {
        this.incidents.remove(incidentId);
    }

    public String getId() {
        return this.id;
    }

    public DelegateExecutionFake withId(String id) {
        this.id = id;
        return this;
    }

    public String getEventName() {
        return this.eventName;
    }

    public DelegateExecutionFake withEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public DelegateExecutionFake withBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public BpmnModelInstance getBpmnModelInstance() {
        throw new UnsupportedOperationException("not implemented");
    }

    public FlowElement getBpmnModelElementInstance() {
        throw new UnsupportedOperationException("not implemented");
    }

    public ProcessEngineServices getProcessEngineServices() {
        return this.processEngineServices;
    }

    public DelegateExecutionFake withProcessEngineServices(ProcessEngineServices processEngineServices) {
        this.processEngineServices = processEngineServices;
        return this;
    }

    public Map<String, Incident> getIncidents() {
        return this.incidents;
    }

    public static class ProcessInstanceNotSetException
    extends IllegalStateException {
    }
}

